/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.junit;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAException;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public final class ManagedJCas
implements TestWatcher,
BeforeTestExecutionCallback,
AfterAllCallback {
    private final ThreadLocal<JCas> casHolder;
    private static final Set<JCas> managedCases = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public ManagedJCas() {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                JCas cas = JCasFactory.createJCas();
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public ManagedJCas(TypeSystemDescription aTypeSystemDescription) {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                JCas cas = JCasFactory.createJCas((TypeSystemDescription)aTypeSystemDescription);
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public JCas get() {
        return this.casHolder.get();
    }

    public void afterAll(ExtensionContext aContext) throws Exception {
        this.casHolder.set(null);
    }

    public void beforeTestExecution(ExtensionContext aContext) throws Exception {
        managedCases.forEach(cas -> cas.reset());
    }
}

