/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.testing.junit;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAException;
import org.apache.uima.cas.CAS;
import org.apache.uima.fit.factory.CasFactory;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public final class ManagedCas
implements TestWatcher,
BeforeTestExecutionCallback,
AfterAllCallback {
    private final ThreadLocal<CAS> casHolder;
    private static final Set<CAS> managedCases = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public ManagedCas() {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                CAS cas = CasFactory.createCas();
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public ManagedCas(TypeSystemDescription aTypeSystemDescription) {
        this.casHolder = ThreadLocal.withInitial(() -> {
            try {
                CAS cas = CasFactory.createCas((TypeSystemDescription)aTypeSystemDescription);
                managedCases.add(cas);
                return cas;
            }
            catch (UIMAException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CAS get() {
        return this.casHolder.get();
    }

    public void beforeTestExecution(ExtensionContext aContext) throws Exception {
        managedCases.forEach(cas -> cas.reset());
    }

    public void afterAll(ExtensionContext aContext) throws Exception {
        this.casHolder.set(null);
    }
}

