/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server.nodeviz;

import org.apache.uima.ducc.transport.event.common.IDuccTypes;

class JobFragment {
    String user;
    String id;
    int nprocesses;
    int qshares;
    String service_endpoint;
    int mem;
    int quantum;
    String color;
    IDuccTypes.DuccType type;
    String textColor = "white";
    String fillColor = "black";

    JobFragment(String user, IDuccTypes.DuccType type, String id, int mem, int qshares, int quantum, String service_endpoint) {
        this.user = user;
        this.type = type;
        this.id = id;
        this.qshares = qshares;
        this.mem = mem;
        this.quantum = quantum;
        this.nprocesses = 1;
        this.service_endpoint = service_endpoint;
        this.setColors();
    }

    void addShares(int qshares) {
        this.qshares += qshares;
        ++this.nprocesses;
    }

    boolean matches(String id) {
        return this.id.equals(id);
    }

    void setColors() {
        if (this.type == IDuccTypes.DuccType.Undefined) {
            this.fillColor = "0,0,0";
            this.textColor = "255,255,255";
        } else {
            int b;
            int g;
            int color_index = (this.user + " ").hashCode();
            int r = (color_index = Math.abs(color_index) % 512) % 8 * 28 + 44;
            if (r + (g = color_index / 8 % 8 * 28 + 44) + (b = color_index / 64 % 8 * 28 + 44) < 60) {
                r *= 2;
                g *= 2;
                b *= 2;
            }
            int brightness = (int)Math.sqrt((double)(r * r) * 0.241 + (double)(g * g) * 0.691 + (double)(b * b) * 0.068);
            this.fillColor = "rgb(" + r + "," + g + "," + b + ")";
            this.textColor = brightness < 130 ? "white" : "black";
        }
    }

    String getTitle() {
        switch (this.type) {
            case Reservation: {
                return this.id;
            }
            case Undefined: {
                return "";
            }
        }
        return this.id + " " + this.nprocesses + " processes";
    }
}

