/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server.nodeviz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.server.nodeviz.JobFragment;
import org.apache.uima.ducc.ws.server.nodeviz.Markup;
import org.apache.uima.ducc.ws.server.nodeviz.NodeViz;

class VisualizedHost {
    private static DuccLogger logger = DuccLogger.getLogger(VisualizedHost.class);
    private static FragmentSorter sorter = new FragmentSorter();
    String name;
    String ip;
    int mem_total;
    int mem_reserve;
    int mem_free;
    int quantum;
    int shares_reserve;
    int shares_free;
    List<JobFragment> fragments = new ArrayList<JobFragment>();
    float TITLE_ADJUSTMENT = 2.0f;

    VisualizedHost(MachineInfo info, int quantum) {
        this.quantum = quantum;
        this.name = NodeViz.strip(info.getName());
        this.ip = info.getIp();
        this.mem_total = Integer.parseInt(info.getMemTotal());
        this.mem_reserve = Integer.parseInt(info.getMemReserve());
        this.shares_free = this.shares_reserve = this.mem_reserve / quantum;
    }

    int countShares() {
        return this.shares_reserve;
    }

    int countRam() {
        return this.mem_reserve;
    }

    void addWork(IDuccTypes.DuccType type, String user, String duccid, int jobmem, int qshares, String service_endpoint) {
        String methodName = "addWork";
        logger.debug(methodName, null, new Object[]{this.name, "Set", qshares, "qshares for", this.name, type, duccid, ": mem_reserve", this.mem_reserve, "free qshares", this.shares_free, "from OR publication."});
        if (this.shares_free - qshares < 0) {
            logger.warn(methodName, null, new Object[]{this.name, "SHARES FREE WENT NEGATIVE for", type, duccid, user, "qshares", qshares, "mem_reserve", this.mem_reserve, "shares_free", this.shares_free});
            return;
        }
        this.shares_free -= qshares;
        boolean found = false;
        for (JobFragment j : this.fragments) {
            if (!j.matches(duccid)) continue;
            j.addShares(qshares);
            logger.debug(methodName, null, new Object[]{this.name, "Update job fragment for", user, "with", qshares, "qshares", "total qshares", j.qshares});
            found = true;
            break;
        }
        if (!found) {
            logger.debug(methodName, null, new Object[]{this.name, "Create new job fragment for", user, "with", qshares, "qshare, type", type});
            JobFragment j = new JobFragment(user, type, duccid, jobmem, qshares, this.quantum, service_endpoint);
            this.fragments.add(j);
        }
    }

    void toSvg(Markup m) {
        String methodName = "toSvg  ";
        if (this.shares_reserve == 0) {
            return;
        }
        if (this.shares_free > 0) {
            this.addWork(IDuccTypes.DuccType.Undefined, "", "", 0, this.shares_free, null);
        }
        float size = (float)Math.sqrt(this.mem_reserve);
        logger.debug(methodName, null, new Object[]{this.name, "mem =", this.mem_reserve, "size =", Float.valueOf(size)});
        m.divStart(this.name, this.mem_reserve);
        m.svgStart(size + 0.2f, size + this.TITLE_ADJUSTMENT);
        m.rect(0.0f, this.TITLE_ADJUSTMENT, size, size, "black", "none", 0.1f, "");
        m.tooltipStart(this.name + " (" + this.mem_total + "GB)");
        m.nodeLabel(size / 2.0f, this.TITLE_ADJUSTMENT - 0.3f, this.name);
        m.tooltipEnd();
        Collections.sort(this.fragments, sorter);
        float height_one_share = (float)Math.sqrt(this.shares_reserve * this.quantum) / (float)this.shares_reserve;
        float foo = (float)Math.sqrt(this.mem_reserve) / (float)this.shares_reserve;
        logger.debug(methodName, null, new Object[]{this.name, "avail", this.shares_reserve * this.quantum, "height-one-share", Float.valueOf(height_one_share), "foo", Float.valueOf(foo)});
        float top = 0.0f + this.TITLE_ADJUSTMENT;
        logger.debug(methodName, null, new Object[]{this.name, "Draw", this.fragments.size(), "rectangles, box size", Float.valueOf(size), "share height", Float.valueOf(height_one_share)});
        for (JobFragment j : this.fragments) {
            float height = (float)j.qshares * height_one_share;
            logger.debug(methodName, null, new Object[]{this.name, "Draw box at", Float.valueOf(top), "of width", Float.valueOf(size), "height", Float.valueOf(height), "at (0, " + top + ") for", j.type, j.id, "shares", j.qshares});
            if (top > size + this.TITLE_ADJUSTMENT) {
                logger.warn(methodName, null, new Object[]{this.name, "Box overflow. Size", Float.valueOf(size), "top", Float.valueOf(top)});
            }
            String fill = m.patternedFill(j);
            m.hyperlinkStart(this, j);
            m.titleForFragment(this, j);
            switch (j.type) {
                case Undefined: {
                    m.rect(0.0f, top, size, height, "", "black", 0.1f, "");
                    break;
                }
                case Job: {
                    m.rect(0.0f, top, size, height, fill, "black", 0.1f, "");
                    break;
                }
                default: {
                    m.rect(0.0f, top, size, height, j.textColor, "black", 0.1f, "");
                    m.rect(0.0f, top, size, height, fill, "black", 0.1f, "");
                }
            }
            m.rect(0.1f, top, size - 0.1f, 1.2f, j.fillColor, j.fillColor, 0.1f, "");
            m.centeredText(size / 2.0f, top + 1.2f, j.id + " " + j.user, j.textColor, 10);
            m.hyperlinkEnd();
            top += height;
        }
        m.svgEnd();
        m.divEnd();
    }

    private static class FragmentSorter
    implements Comparator<JobFragment> {
        private FragmentSorter() {
        }

        @Override
        public int compare(JobFragment f1, JobFragment f2) {
            if (f1.type == IDuccTypes.DuccType.Undefined && f2.type != IDuccTypes.DuccType.Undefined) {
                return 1;
            }
            if (f1.type != IDuccTypes.DuccType.Undefined && f2.type == IDuccTypes.DuccType.Undefined) {
                return -1;
            }
            return f2.qshares - f1.qshares;
        }
    }
}

