/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccWebSessionManager {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccWebSessionManager.class.getName());
    private static DuccId jobid = null;
    public static DuccWebSessionManager instance = new DuccWebSessionManager();
    private static SecureRandom sr = new SecureRandom();
    public static final String ducc_user_id = "ducc.user.id";
    public static final String ducc_validation_id = "ducc.validation.id";
    private static final int SEGMENTS = 8;
    private ConcurrentHashMap<String, IdSet> map = new ConcurrentHashMap();

    public static DuccWebSessionManager getInstance() {
        return instance;
    }

    private String generateValidationId() {
        StringBuffer sb = new StringBuffer();
        sb.append(sr.nextLong());
        int segments = 8;
        for (int i = 0; i < segments; ++i) {
            sb.append(sr.nextLong());
        }
        return sb.toString();
    }

    private void iRemove(String method, String userId, IdSet idSet) {
        String location = "iRemove." + method;
        if (idSet != null) {
            duccLogger.info(location, jobid, new Object[]{"uid:" + userId});
            duccLogger.info(location, jobid, new Object[]{"sid:" + idSet.sessionId});
            duccLogger.info(location, jobid, new Object[]{"vid:" + idSet.validationId});
        }
    }

    private void iPut(String method, String userId, IdSet idSet) {
        String location = "iPut." + method;
        if (idSet != null) {
            duccLogger.info(location, jobid, new Object[]{"uid:" + userId});
            duccLogger.info(location, jobid, new Object[]{"sid:" + idSet.sessionId});
            duccLogger.info(location, jobid, new Object[]{"vid:" + idSet.validationId});
        }
    }

    public void login(HttpServletRequest request, String userId) {
        String location = "login";
        if (request == null) {
            duccLogger.debug(location, jobid, new Object[]{"request is null"});
            return;
        }
        if (userId == null) {
            duccLogger.debug(location, jobid, new Object[]{"userId is null"});
            return;
        }
        HttpSession session = request.getSession();
        if (session == null) {
            duccLogger.debug(location, jobid, new Object[]{"session is null"});
            return;
        }
        String sessionId = session.getId();
        if (sessionId == null) {
            duccLogger.debug(location, jobid, new Object[]{"sessionId is null"});
            return;
        }
        this.iRemove(location, userId, this.map.get(userId));
        String validationId = this.generateValidationId();
        session.setAttribute(ducc_validation_id, (Object)validationId);
        session.setAttribute(ducc_user_id, (Object)userId);
        IdSet idSet = new IdSet();
        idSet.validationId = validationId;
        idSet.sessionId = sessionId;
        this.map.put(userId, idSet);
        this.iPut(location, userId, this.map.get(userId));
    }

    public boolean logout(HttpServletRequest request) {
        String location = "logout";
        boolean retVal = false;
        if (request == null) {
            duccLogger.debug(location, jobid, new Object[]{"request is null"});
            return retVal;
        }
        HttpSession session = request.getSession();
        if (session == null) {
            duccLogger.debug(location, jobid, new Object[]{"session is null"});
            return retVal;
        }
        String userId = (String)session.getAttribute(ducc_user_id);
        if (userId == null) {
            duccLogger.debug(location, jobid, new Object[]{"userId is null"});
            return retVal;
        }
        String validationId = (String)session.getAttribute(ducc_validation_id);
        if (validationId == null) {
            duccLogger.debug(location, jobid, new Object[]{"validationId is null"});
            return retVal;
        }
        String sessionId = session.getId();
        if (sessionId == null) {
            duccLogger.debug(location, jobid, new Object[]{"sessionId is null"});
            return retVal;
        }
        IdSet idSet = this.map.get(userId);
        if (idSet == null) {
            duccLogger.debug(location, jobid, new Object[]{"idSet is null"});
            return retVal;
        }
        if (!validationId.equals(idSet.validationId)) {
            duccLogger.debug(location, jobid, new Object[]{"given:" + validationId});
            duccLogger.debug(location, jobid, new Object[]{"known:" + idSet.validationId});
            duccLogger.debug(location, jobid, new Object[]{"validation mismatch!"});
            return retVal;
        }
        if (!sessionId.equals(idSet.sessionId)) {
            duccLogger.debug(location, jobid, new Object[]{"given:" + sessionId});
            duccLogger.debug(location, jobid, new Object[]{"known:" + idSet.sessionId});
            duccLogger.debug(location, jobid, new Object[]{"session mismatch!"});
            return retVal;
        }
        session.removeAttribute(ducc_validation_id);
        session.removeAttribute(ducc_user_id);
        this.map.remove(userId);
        this.iRemove(location, userId, idSet);
        retVal = true;
        return retVal;
    }

    public boolean isAuthentic(HttpServletRequest request) {
        String location = "isAuthentic";
        if (request == null) {
            duccLogger.debug(location, jobid, new Object[]{"request is null"});
            return false;
        }
        HttpSession session = request.getSession();
        if (session == null) {
            duccLogger.debug(location, jobid, new Object[]{"session is null"});
            return false;
        }
        String userId = (String)session.getAttribute(ducc_user_id);
        if (userId == null) {
            duccLogger.debug(location, jobid, new Object[]{"userId is null"});
            return false;
        }
        String validationId = (String)session.getAttribute(ducc_validation_id);
        if (validationId == null) {
            duccLogger.debug(location, jobid, new Object[]{"validationId is null"});
            return false;
        }
        String sessionId = session.getId();
        if (sessionId == null) {
            duccLogger.debug(location, jobid, new Object[]{"sessionId is null"});
            return false;
        }
        IdSet idSet = this.map.get(userId);
        if (idSet == null) {
            duccLogger.debug(location, jobid, new Object[]{"idSet is null"});
            return false;
        }
        if (!validationId.equals(idSet.validationId)) {
            duccLogger.debug(location, jobid, new Object[]{"given:" + validationId});
            duccLogger.debug(location, jobid, new Object[]{"known:" + idSet.validationId});
            duccLogger.debug(location, jobid, new Object[]{"validation mismatch!"});
            return false;
        }
        if (!sessionId.equals(idSet.sessionId)) {
            duccLogger.debug(location, jobid, new Object[]{"given:" + sessionId});
            duccLogger.debug(location, jobid, new Object[]{"known:" + idSet.sessionId});
            duccLogger.debug(location, jobid, new Object[]{"session mismatch!"});
            return false;
        }
        return true;
    }

    public String getUserId(HttpServletRequest request) {
        String retVal = null;
        String location = "getUserId";
        if (request == null) {
            duccLogger.debug(location, jobid, new Object[]{"request is null"});
            return retVal;
        }
        HttpSession session = request.getSession();
        if (session == null) {
            duccLogger.debug(location, jobid, new Object[]{"session is null"});
            return retVal;
        }
        retVal = (String)session.getAttribute(ducc_user_id);
        return retVal;
    }

    private class IdSet {
        public String sessionId;
        public String validationId;

        private IdSet() {
        }
    }
}

