/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.authentication;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.authentication.AuthenticationResult;
import org.apache.uima.ducc.common.authentication.IAuthenticationManager;
import org.apache.uima.ducc.common.authentication.IAuthenticationResult;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.ws.authentication.UserAuthenticate;

public class LinuxAuthenticationManager
implements IAuthenticationManager {
    private static IAuthenticationManager instance = new LinuxAuthenticationManager();
    private String version = "ducc linux 1.0";
    private DuccPropertiesResolver duccPropertiesResolver = DuccPropertiesResolver.getInstance();
    private ConcurrentHashMap<String, String[]> userGroupsCache = new ConcurrentHashMap();

    public static IAuthenticationManager getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isPasswordChecked() {
        return true;
    }

    private String getFileProperty(String key) {
        String retVal = this.duccPropertiesResolver.getFileProperty(key);
        return retVal;
    }

    private String getProperty(String key) {
        return this.getFileProperty(key);
    }

    private String removeDelimiters(String string) {
        String retVal = string;
        if (retVal == null) {
            retVal = "";
        } else {
            retVal = retVal.replace(',', ' ');
            retVal = retVal.replace(';', ' ');
            retVal = retVal.replace(':', ' ');
        }
        return retVal.trim();
    }

    private String transform(String string) {
        String retVal = this.removeDelimiters(string);
        return retVal;
    }

    private boolean finder(String rawNeedle, String rawHaystack) {
        boolean retVal = false;
        if (rawNeedle != null && rawHaystack != null) {
            String needle = " " + rawNeedle + " ";
            String haystack = " " + rawHaystack + " ";
            if (haystack.contains(needle)) {
                retVal = true;
            }
        }
        return retVal;
    }

    private IAuthenticationResult checkUserExcluded(String userid) {
        AuthenticationResult retVal = new AuthenticationResult(true);
        if (userid == null) {
            retVal.setFailure();
            retVal.setReason("userid missing");
        } else {
            String uid = this.transform(userid);
            String excludeString = this.transform(this.getProperty("ducc.authentication.users.exclude"));
            if (excludeString.trim().length() > 0 && this.finder(uid, excludeString)) {
                retVal.setFailure();
                retVal.setReason("userid excluded");
            }
        }
        return retVal;
    }

    private IAuthenticationResult checkUserNotIncluded(String userid) {
        AuthenticationResult retVal = new AuthenticationResult(true);
        if (userid == null) {
            retVal.setFailure();
            retVal.setReason("userid missing");
        } else {
            String uid = this.transform(userid);
            String includeString = this.transform(this.getProperty("ducc.authentication.users.include"));
            if (includeString.trim().length() > 0 && !this.finder(uid, includeString)) {
                retVal.setFailure();
                retVal.setReason("userid not included");
            }
        }
        return retVal;
    }

    public IAuthenticationResult isAuthenticate(String userid, String domain, String password) {
        AuthenticationResult ar = new AuthenticationResult(true);
        try {
            ar = this.checkUserExcluded(userid);
            if (ar.isSuccess() && (ar = this.checkUserNotIncluded(userid)).isSuccess()) {
                UserAuthenticate instance = new UserAuthenticate();
                String[] args = new String[]{userid, password};
                String result = instance.launch(args);
                if (result.startsWith("success")) {
                    result = result.trim();
                    result = result.replace("success groups =", "");
                    result = result.replace("[", "");
                    result = result.replace("]", "");
                    String[] groups = (result = result.replace(" ", "")).split(",");
                    if (groups != null) {
                        this.userGroupsCache.put(userid, groups);
                    } else {
                        this.userGroupsCache.remove(userid);
                    }
                } else {
                    ar.setFailure();
                    result = result.replace("failure pam", "pam");
                    ar.setReason(result);
                }
            }
        }
        catch (Exception e) {
            ar.setFailure();
            ar.setException(e);
        }
        return ar;
    }

    private IAuthenticationResult checkUserGroupExcluded(String userid) {
        AuthenticationResult retVal = new AuthenticationResult(true);
        if (userid == null) {
            retVal.setFailure();
            retVal.setReason("userid missing");
        } else {
            String excludeString = this.transform(this.getProperty("ducc.authentication.groups.exclude"));
            if (excludeString.trim().length() > 0) {
                String[] userGroups = this.userGroupsCache.get(userid);
                if (userGroups == null) {
                    retVal.setFailure();
                    retVal.setReason("userid has no groups?");
                } else {
                    for (String userGroup : userGroups) {
                        if (!this.finder(userGroup, excludeString)) continue;
                        retVal.setFailure();
                        retVal.setReason("userid group " + userGroup + " excluded");
                        break;
                    }
                }
            }
        }
        return retVal;
    }

    private IAuthenticationResult checkUserGroupNotIncluded(String userid) {
        AuthenticationResult retVal = new AuthenticationResult(true);
        if (userid == null) {
            retVal.setFailure();
            retVal.setReason("userid missing");
        } else {
            String includeString = this.transform(this.getProperty("ducc.authentication.groups.include"));
            if (includeString.trim().length() > 0) {
                String[] userGroups = this.userGroupsCache.get(userid);
                if (userGroups == null) {
                    retVal.setFailure();
                    retVal.setReason("userid has no groups?");
                } else {
                    retVal.setFailure();
                    retVal.setReason("userid has no group included");
                    for (String userGroup : userGroups) {
                        if (!this.finder(userGroup, includeString)) continue;
                        retVal = new AuthenticationResult(true);
                        break;
                    }
                }
            }
        }
        return retVal;
    }

    public IAuthenticationResult isGroupMember(String userid, String domain, IAuthenticationManager.Role role) {
        AuthenticationResult ar = new AuthenticationResult(true);
        try {
            ar = this.checkUserGroupExcluded(userid);
            if (ar.isSuccess()) {
                ar = this.checkUserGroupNotIncluded(userid);
            }
        }
        catch (Exception e) {
            ar.setFailure();
            ar.setException(e);
        }
        return ar;
    }
}

