/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;
import org.apache.uima.ducc.cli.ws.json.NodePidList;
import org.apache.uima.ducc.common.ConvertSafely;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;
import org.apache.uima.ducc.ws.DuccNodes;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.MachineSummaryInfo;
import org.apache.uima.ducc.ws.WebServerComponent;
import org.apache.uima.ducc.ws.db.DbQuery;
import org.apache.uima.ducc.ws.db.IDbMachine;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.types.Ip;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.apache.uima.ducc.ws.utils.DatedNodeMetricsUpdateDuccEvent;

public class DuccMachinesData {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccMachinesData.class.getName());
    private static DuccId jobid = null;
    private static ConcurrentSkipListMap<MachineInfo, NodeId> sortedMachines = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<NodeId, MachineInfo> unsortedMachines = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<NodeId, MachineSummaryInfo> summaryMachines = new ConcurrentSkipListMap();
    private static AtomicLong memTotal = new AtomicLong(0L);
    private static AtomicLong memFree = new AtomicLong(0L);
    private static AtomicLong swapInuse = new AtomicLong(0L);
    private static AtomicLong swapFree = new AtomicLong(0L);
    private static DuccMachinesData duccMachinesData = new DuccMachinesData();
    private static ConcurrentSkipListMap<Ip, NodeId> ipToNameMap = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<NodeId, Ip> nameToIpMap = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, String> isSwapping = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, TreeMap<String, NodeUsersInfo>> ipToNodeUsersInfoMap = new ConcurrentSkipListMap();
    private static MachineFactsList machineFactsList = new MachineFactsList();
    private long down_fudge = 10L;
    private long DOWN_AFTER_SECONDS = WebServerComponent.updateIntervalSecondsNormal + this.down_fudge;
    private long SECONDS_PER_MILLI = 1000L;
    private volatile String published = null;

    public static DuccMachinesData getInstance() {
        return duccMachinesData;
    }

    public boolean isMachineSwapping(String ip) {
        return isSwapping.containsKey(ip);
    }

    public Map<MachineInfo, NodeId> getMachines() {
        return this.getSortedMachines();
    }

    public Map<MachineInfo, NodeId> getSortedMachines() {
        TreeMap<MachineInfo, NodeId> retVal = new TreeMap<MachineInfo, NodeId>();
        retVal.putAll(sortedMachines);
        return retVal;
    }

    private long getAgentMillisMIA() {
        String location = "getAgentMillisMIA";
        long millisMIA = this.DOWN_AFTER_SECONDS * this.SECONDS_PER_MILLI;
        Properties properties = DuccWebProperties.get();
        String s_tolerance = properties.getProperty("ducc.rm.node.stability");
        String s_rate = properties.getProperty("ducc.agent.node.metrics.publish.rate");
        try {
            long tolerance = Long.parseLong(s_tolerance.trim());
            long rate = Long.parseLong(s_rate.trim());
            long secondsRM = tolerance * rate / this.SECONDS_PER_MILLI;
            logger.trace(location, jobid, new Object[]{"default:" + this.DOWN_AFTER_SECONDS + " " + "secondsRM:" + secondsRM});
            if (this.DOWN_AFTER_SECONDS < secondsRM) {
                millisMIA = secondsRM * this.SECONDS_PER_MILLI;
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return millisMIA;
    }

    private void determineStatus(MachineInfo mi, IDbMachine dbMachine) {
        String location = "determineStatus";
        if (dbMachine != null) {
            Boolean responsive = dbMachine.getResponsive();
            Boolean online = dbMachine.getOnline();
            Boolean blacklisted = dbMachine.getBlacklisted();
            MachineInfo.MachineStatus machineStatus = MachineInfo.MachineStatus.Down;
            if (responsive.booleanValue() && online.booleanValue() && !blacklisted.booleanValue()) {
                machineStatus = MachineInfo.MachineStatus.Up;
            }
            mi.setMachineStatus(machineStatus);
            mi.setResponsive(responsive);
            mi.setOnline(online);
            mi.setBlacklisted(blacklisted);
            StringBuffer sb = new StringBuffer();
            sb.append(mi.getName());
            sb.append(" ");
            sb.append((Object)mi.getMachineStatus());
            sb.append(" ");
            sb.append(mi.getMachineStatusReason());
            sb.append(" ");
            String text = sb.toString().trim();
            logger.trace(location, jobid, new Object[]{text});
            mi.setQuantum(dbMachine.getQuantum());
        } else if (mi.getElapsedSeconds() < 0L) {
            mi.setMachineStatus(MachineInfo.MachineStatus.Defined);
        } else if (mi.isExpired(this.getAgentMillisMIA())) {
            mi.setMachineStatus(MachineInfo.MachineStatus.Down);
        } else {
            mi.setMachineStatus(MachineInfo.MachineStatus.Up);
        }
    }

    private Map<String, IDbMachine> getDbMapMachines() {
        String location = "getDbMapMachines";
        Map<String, IDbMachine> retVal = null;
        try {
            DbQuery dbQuery = DbQuery.getInstance();
            retVal = dbQuery.getMapMachines();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private IDbMachine getDbMachine(Map<String, IDbMachine> dbMapMachines, NodeId nodeId) {
        String location = "getDbMachine";
        IDbMachine retVal = null;
        try {
            if (dbMapMachines != null && nodeId != null) {
                String name = nodeId.getLongName();
                retVal = dbMapMachines.get(name);
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private static void setSortedMachines(ConcurrentSkipListMap<MachineInfo, NodeId> value) {
        sortedMachines = value;
    }

    public void updateSortedMachines() {
        String location = "updateSortedMachines";
        logger.debug(location, jobid, new Object[]{"start"});
        try {
            ConcurrentSkipListMap<MachineInfo, NodeId> map = new ConcurrentSkipListMap<MachineInfo, NodeId>();
            Map<String, IDbMachine> dbMapMachines = this.getDbMapMachines();
            for (Map.Entry<NodeId, MachineInfo> entry : unsortedMachines.entrySet()) {
                NodeId nodeId = entry.getKey();
                IDbMachine dbMachine = this.getDbMachine(dbMapMachines, nodeId);
                MachineInfo machineInfo = entry.getValue();
                this.determineStatus(machineInfo, dbMachine);
                map.put(machineInfo, nodeId);
                logger.debug(location, jobid, new Object[]{"put: " + nodeId});
            }
            DuccMachinesData.setSortedMachines(map);
            this.updateMachineFactsList();
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        logger.debug(location, jobid, new Object[]{"end"});
    }

    private DuccMachinesData() {
        this.initialize();
    }

    private void initialize() {
        String location = "initialize";
        try {
            String fileName = "ducc.nodes";
            String dirResources = IDuccEnv.DUCC_RESOURCES_DIR;
            ArrayList<String> nodes = DuccNodes.getInstance().get(dirResources, fileName);
            for (String nodeName : nodes) {
                String memTotal = "";
                String memReserve = "";
                String memFree = "";
                String swapInuse = "";
                String swapFree = "";
                double cpu = 0.0;
                MachineInfo machineInfo = new MachineInfo(IDuccEnv.DUCC_NODES_FILE_PATH, "", nodeName, memTotal, memReserve, memFree, swapInuse, swapFree, cpu, false, false, null, -1L, 0L);
                this.putMachine(machineInfo);
            }
            this.updateSortedMachines();
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
    }

    private void putMachine(MachineInfo machineInfo) {
        String location = "putMachine";
        try {
            String longName;
            String name;
            if (machineInfo != null && (name = machineInfo.getName()) != null && (longName = name.trim()).length() > 0) {
                NodeId shortId;
                NodeId nodeId = new NodeId(longName);
                unsortedMachines.put(nodeId, machineInfo);
                logger.trace(location, jobid, new Object[]{"add=" + nodeId.toString() + "," + machineInfo.getIp()});
                String shortName = longName.split("\\.")[0];
                if (!shortName.equals(longName) && unsortedMachines.containsKey(shortId = new NodeId(shortName))) {
                    unsortedMachines.remove(shortId);
                    logger.trace(location, jobid, new Object[]{"del=" + shortId.toString()});
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public boolean isPublished() {
        return this.published != null;
    }

    public void setPublished() {
        this.published = TimeStamp.getCurrentMillis();
    }

    public MachineSummaryInfo getTotals() {
        MachineSummaryInfo totals = new MachineSummaryInfo();
        totals.memTotal = memTotal.get();
        totals.memFree = memFree.get();
        totals.swapInuse = swapInuse.get();
        totals.swapFree = swapFree.get();
        return totals;
    }

    private void updateTotals(NodeId nodeId, MachineSummaryInfo newInfo) {
        if (summaryMachines.containsKey(nodeId)) {
            MachineSummaryInfo oldInfo = summaryMachines.get(nodeId);
            summaryMachines.put(nodeId, newInfo);
            memTotal.addAndGet(newInfo.memTotal - oldInfo.memTotal);
            memFree.addAndGet(newInfo.memFree - oldInfo.memFree);
            swapInuse.addAndGet(newInfo.swapInuse - oldInfo.swapInuse);
            swapFree.addAndGet(newInfo.swapFree - oldInfo.swapFree);
        } else {
            summaryMachines.put(nodeId, newInfo);
            memTotal.addAndGet(newInfo.memTotal);
            memFree.addAndGet(newInfo.memFree);
            swapInuse.addAndGet(newInfo.swapInuse);
            swapFree.addAndGet(newInfo.swapFree);
        }
    }

    private double getCpuLoadAvg(Node node) {
        String location = "getCpuLoadAvg";
        double cpu = 0.0;
        try {
            if (node != null) {
                String load = node.getNodeMetrics().getNodeLoadAverage().getLoadAvg1();
                cpu = ConvertSafely.String2Double((String)load);
            }
        }
        catch (Exception e) {
            logger.debug(location, jobid, (Throwable)e, new Object[0]);
        }
        return cpu;
    }

    public void put(DatedNodeMetricsUpdateDuccEvent duccEvent) {
        long lvalMemFree;
        String memTotal;
        long lvalMemTotal;
        String location = "put";
        MachineSummaryInfo msi = new MachineSummaryInfo();
        NodeMetricsUpdateDuccEvent nodeMetrics = duccEvent.getNodeMetricsUpdateDuccEvent();
        Ip ip = new Ip(nodeMetrics.getNodeIdentity().getIp().trim());
        TreeMap map = nodeMetrics.getNodeUsersMap();
        if (map != null) {
            String ipString = ip.toString();
            ipToNodeUsersInfoMap.put(ipString, map);
        }
        String machineName = nodeMetrics.getNodeIdentity().getName().trim();
        NodeId nodeId = new NodeId(machineName);
        ipToNameMap.put(ip, nodeId);
        nameToIpMap.put(nodeId, ip);
        long nodeMemTotal = nodeMetrics.getNodeMemory().getMemTotal();
        logger.debug(location, jobid, new Object[]{"node: " + machineName + " " + "memTotal: " + nodeMemTotal});
        msi.memTotal = lvalMemTotal = (long)(1.0 * (double)nodeMemTotal / 1048576.0 + 0.5);
        String memReserve = memTotal = "" + lvalMemTotal;
        long nodeMemFree = nodeMetrics.getNodeMemory().getMemFree();
        logger.debug(location, jobid, new Object[]{"node: " + machineName + " " + "memFree: " + nodeMemFree});
        msi.memFree = lvalMemFree = (long)(1.0 * (double)nodeMemFree / 1048576.0 + 0.0);
        String memFree = "" + lvalMemFree;
        double dvalSwapTotal = nodeMetrics.getNodeMemory().getSwapTotal();
        long lvalSwapTotal = (long)(dvalSwapTotal / 1048576.0 + 0.5);
        double dvalSwapFree = nodeMetrics.getNodeMemory().getSwapFree();
        long lvalSwapFree = (long)(dvalSwapFree / 1048576.0 + 0.5);
        long lvalSwapInuse = lvalSwapTotal - lvalSwapFree;
        String swapInuse = "" + lvalSwapInuse;
        msi.swapInuse = lvalSwapInuse;
        String swapKey = ip.toString();
        String swapVal = swapInuse;
        if (msi.swapInuse > 0L) {
            isSwapping.put(swapKey, swapVal);
        } else {
            isSwapping.remove(swapKey);
        }
        msi.swapFree = lvalSwapFree;
        String swapFree = "" + lvalSwapFree;
        List alienPids = nodeMetrics.getRogueProcessInfoList();
        Node node = nodeMetrics.getNode();
        double cpu = this.getCpuLoadAvg(node);
        boolean cGroupsEnabled = nodeMetrics.getCgroups();
        boolean cGroupsCpuReportingEnabled = nodeMetrics.getCgroupsCpuReportingEnabled();
        MachineInfo current = new MachineInfo("", ip.toString(), machineName, memTotal, memReserve, memFree, "" + swapInuse, "" + swapFree, cpu, cGroupsEnabled, cGroupsCpuReportingEnabled, alienPids, duccEvent.getMillis(), duccEvent.getEventSize());
        NodeId key = nodeId;
        MachineInfo previous = unsortedMachines.get(key);
        if (previous != null) {
            try {
                long swapPrev = Long.parseLong(previous.getSwapInuse());
                long swapCurr = Long.parseLong(current.getSwapInuse());
                long swapDelta = swapCurr - swapPrev;
                current.setSwapDelta(swapDelta);
            }
            catch (Exception swapPrev) {
                // empty catch block
            }
            long pHbMax = previous.getHeartbeatMax();
            long tod = previous.getHeartbeatMaxTOD();
            long pHbElapsed = previous.getElapsedSeconds();
            if (pHbElapsed > pHbMax) {
                pHbMax = pHbElapsed;
                tod = previous.getHeartbeat();
            }
            current.setHeartbeatMax(pHbMax);
            current.setHeartbeatMaxTOD(tod);
            long pubSizeMax = previous.getPubSizeMax();
            long pubSize = current.getPubSize();
            if (pubSize > pubSizeMax) {
                pubSizeMax = pubSize;
            }
            current.setPubSizeMax(pubSizeMax);
        }
        this.putMachine(current);
        this.updateTotals(nodeId, msi);
        this.setPublished();
    }

    public List<String> getPids(Ip ip, UserId user) {
        String location = "getPids";
        ArrayList<String> retVal = new ArrayList<String>();
        if (ip != null && ip.toString() != null && user != null && user.toString() != null) {
            try {
                NodeUsersInfo nodeUsersInfo;
                TreeMap<String, NodeUsersInfo> map = ipToNodeUsersInfoMap.get(ip.toString());
                if (map != null && (nodeUsersInfo = map.get(user.toString())) != null) {
                    for (NodeUsersInfo.NodeProcess process : nodeUsersInfo.getReserveProcesses()) {
                        retVal.add(process.getPid());
                    }
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    public List<String> getPids(NodeId nodeId, UserId user) {
        Ip ip = new Ip(this.getIpForName(nodeId.toString()));
        return this.getPids(ip, user);
    }

    public List<NodePidList> getUserProcesses(List<String> nodeList, String user) {
        ArrayList<NodePidList> nodePidListList = new ArrayList<NodePidList>();
        for (String node : nodeList) {
            List<String> pids = this.getPids(new NodeId(node), new UserId(user));
            NodePidList nodePidList = new NodePidList(node, pids);
            nodePidListList.add(nodePidList);
        }
        return nodePidListList;
    }

    public int getPidCount(Ip ip, UserId user) {
        int retVal = 0;
        try {
            List<String> pidList = this.getPids(ip, user);
            if (pidList != null) {
                return pidList.size();
            }
        }
        catch (Exception e) {
            retVal = -1;
        }
        return retVal;
    }

    public int getPidCount(NodeId nodeId, UserId user) {
        Ip ip = new Ip(this.getIpForName(nodeId.toString()));
        return this.getPidCount(ip, user);
    }

    public String getNameForIp(String ipString) {
        String retVal = null;
        try {
            Ip ip = new Ip(ipString);
            NodeId nodeId = ipToNameMap.get(ip);
            if (nodeId != null) {
                retVal = nodeId.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public String getIpForName(String name) {
        String retVal = null;
        try {
            NodeId nodeId = new NodeId(name);
            Ip ip = nameToIpMap.get(nodeId);
            if (ip != null) {
                retVal = ip.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public MachineInfo getMachineInfoForNodeid(NodeId nodeId) {
        MachineInfo retVal = unsortedMachines.get(nodeId);
        return retVal;
    }

    private void updateMachineFactsList() {
        String location = "updateMachineFactsList";
        try {
            DbQuery dbQuery = DbQuery.getInstance();
            if (!dbQuery.isEnabled()) {
                this.updateMachineFactsListAgent();
            } else {
                this.updateMachineFactsListDb();
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            System.out.println(e.getMessage());
        }
    }

    private String calculateMem(long quantum, String memParm) {
        String memString;
        String location = "calculateMem";
        String retVal = "0";
        if (memParm != null && (memString = memParm.trim()).length() > 0) {
            try {
                long memRaw = Long.parseLong(memString);
                long memAdj = memRaw / quantum * quantum;
                retVal = "" + memAdj;
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    private long getQuantum() {
        String location = "getQuantum";
        long retVal = 1L;
        try {
            DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
            String quantum = dpr.getFileProperty("ducc.rm.share.quantum");
            retVal = Long.parseLong(quantum.trim());
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private void updateMachineFactsListAgent() {
        MachineFactsList factsList = new MachineFactsList();
        long quantum = this.getQuantum();
        Map<MachineInfo, NodeId> sortedMachines = this.getSortedMachines();
        for (MachineInfo machineInfo : sortedMachines.keySet()) {
            MachineInfo.MachineStatus machineStatus = machineInfo.getMachineStatus();
            String status = machineStatus.getLowerCaseName();
            String statusReason = "";
            String ip = machineInfo.getIp();
            String name = machineInfo.getName();
            String memTotal = this.calculateMem(quantum, machineInfo.getMemTotal());
            String memFree = this.calculateMem(quantum, machineInfo.getMemFree());
            String swapInuse = machineInfo.getSwapInuse();
            String swapDelta = "" + machineInfo.getSwapDelta();
            String swapFree = machineInfo.getSwapFree();
            double cpu = machineInfo.getCpu();
            boolean cGroupsEnabled = machineInfo.getCgroupsEnabled();
            boolean cGroupspuReportingEnabled = machineInfo.getCgroupsCpuReportingEnabled();
            List<String> aliens = machineInfo.getAliens();
            String heartbeat = "" + machineInfo.getElapsed();
            MachineFacts facts = new MachineFacts(status, statusReason, ip, name, memTotal, memFree, swapInuse, swapDelta, swapFree, cpu, cGroupsEnabled, cGroupspuReportingEnabled, aliens, heartbeat);
            facts.memReserve = memTotal;
            factsList.add((Object)facts);
        }
        machineFactsList = factsList;
    }

    private void updateMachineFactsListDb() {
        String location = "updateMachineFactsListDb";
        MachineFactsList mfl = new MachineFactsList();
        TreeMap<MachineInfo, NodeId> dbSortedMachines = new TreeMap<MachineInfo, NodeId>();
        DbQuery dbQuery = DbQuery.getInstance();
        Map<String, IDbMachine> dbMapMachinesLong = dbQuery.getMapMachines();
        HashMap<String, IDbMachine> dbMapMachinesShort = new HashMap<String, IDbMachine>();
        for (Map.Entry<String, IDbMachine> entry : dbMapMachinesLong.entrySet()) {
            String name = entry.getKey();
            NodeId nodeId = new NodeId(name);
            dbMapMachinesShort.put(nodeId.getShortName(), entry.getValue());
            MachineInfo mi = unsortedMachines.get(nodeId);
            IDbMachine dbMachine = entry.getValue();
            if (mi == null) continue;
            int quantum = dbMachine.getQuantum();
            int reserve = quantum * dbMachine.getShareOrder();
            int free = quantum * dbMachine.getSharesLeft();
            mi.setMemReserve("" + reserve);
            mi.setMemFree("" + free);
            dbSortedMachines.put(mi, nodeId);
        }
        ArrayList<String> duccNodes = DuccNodes.getInstance().get();
        TreeMap<String, String> sortedDuccNodes = new TreeMap<String, String>();
        for (String string : duccNodes) {
            NodeId nodeId = new NodeId(string);
            sortedDuccNodes.put(nodeId.getShortName(), nodeId.getLongName());
        }
        for (Map.Entry entry : sortedDuccNodes.entrySet()) {
            String shortName = (String)entry.getKey();
            String longName = (String)entry.getValue();
            if (dbMapMachinesShort.containsKey(shortName) || dbMapMachinesLong.containsKey(longName)) continue;
            String status = "defined";
            String statusReason = "";
            String ip = "";
            String memTotal = "";
            String memFree = "";
            String swapInuse = "";
            String swapDelta = "";
            String swapFree = "";
            double cpu = 0.0;
            boolean cGroupsEnabled = false;
            boolean cGroupsCpuReportingEnabled = false;
            ArrayList aliens = new ArrayList();
            String heartbeat = "";
            MachineFacts facts = new MachineFacts(status, statusReason, ip, longName, memTotal, memFree, swapInuse, swapDelta, swapFree, cpu, cGroupsEnabled, cGroupsCpuReportingEnabled, aliens, heartbeat);
            mfl.add((Object)facts);
        }
        for (Map.Entry entry : dbSortedMachines.entrySet()) {
            MachineInfo machineInfo = (MachineInfo)entry.getKey();
            MachineInfo.MachineStatus machineStatus = machineInfo.getMachineStatus();
            String status = machineStatus.getLowerCaseName();
            String statusReason = machineInfo.getMachineStatusReason();
            String ip = machineInfo.getIp();
            String name = machineInfo.getName();
            String memTotal = machineInfo.getMemTotal();
            String memFree = machineInfo.getMemFree();
            String swapInuse = machineInfo.getSwapInuse();
            String swapDelta = "" + machineInfo.getSwapDelta();
            String swapFree = machineInfo.getSwapFree();
            double cpu = machineInfo.getCpu();
            boolean cGroupsEnabled = machineInfo.getCgroupsEnabled();
            boolean cGroupsCpuReportingEnabled = machineInfo.getCgroupsCpuReportingEnabled();
            List<String> aliens = machineInfo.getAliens();
            String heartbeat = "" + machineInfo.getElapsed();
            MachineFacts facts = new MachineFacts(status, statusReason, ip, name, memTotal, memFree, swapInuse, swapDelta, swapFree, cpu, cGroupsEnabled, cGroupsCpuReportingEnabled, aliens, heartbeat);
            facts.memReserve = machineInfo.getMemTotal();
            facts.quantum = "" + machineInfo.getQuantum();
            logger.trace(location, jobid, new Object[]{facts.status + " " + facts.statusReason});
            mfl.add((Object)facts);
        }
        machineFactsList = mfl;
    }

    public MachineFactsList getMachineFactsList() {
        return machineFactsList;
    }
}

