/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils.alien;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.ducc.common.utils.AlienAbstract;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;
import org.apache.uima.ducc.ws.utils.alien.FileInfo;

public class AlienDirectory
extends AlienAbstract {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)AlienDirectory.class.getName());
    private static DuccId jobid = null;
    private static String newline = "\n";
    private static String whitespace = "\\s+";
    private static String dashdash = "--";
    private static String command_ls = "/bin/ls";
    private static String command_ls_flag1 = "-atl";
    private static String command_ls_flag1R = "-atlR";
    private static String command_ls_flag2 = "--time-style=long-iso";
    private static int indexPermissions = 0;
    private static int indexUser = 2;
    private static int indexGroup = 3;
    private static int indexLength = 4;
    private static int indexDate = 5;
    private static int indexTime = 6;
    private static int indexName = 7;
    protected boolean recursive = false;
    private String directory_name;

    protected void setRecursive(boolean value) {
        this.recursive = value;
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    protected String get_command_ls() {
        return command_ls;
    }

    protected String get_command_ls_flag1() {
        String retVal = command_ls_flag1;
        if (this.isRecursive()) {
            retVal = command_ls_flag1R;
        }
        return retVal;
    }

    protected String get_command_ls_flag2() {
        return command_ls_flag2;
    }

    protected void set_directory_name(String value) {
        this.directory_name = value;
    }

    protected String get_directory_name() {
        return this.directory_name;
    }

    public AlienDirectory(EffectiveUser user, String directory_name, String ducc_ling) {
        this.set_user(user.get());
        this.set_directory_name(directory_name);
        this.set_ducc_ling(ducc_ling);
    }

    public AlienDirectory(EffectiveUser user, String directory_name, String ducc_ling, boolean recursive) {
        this.set_user(user.get());
        this.set_directory_name(directory_name);
        this.set_ducc_ling(ducc_ling);
        this.setRecursive(recursive);
    }

    private String[] getCommand() {
        String[] command_ducc_ling_yes = new String[]{this.ducc_ling, this.q_parameter, this.u_parameter, this.user, dashdash, this.get_command_ls(), this.get_command_ls_flag1(), this.get_command_ls_flag2(), this.get_directory_name()};
        String[] command_ducc_ling_no = new String[]{this.get_command_ls(), this.get_command_ls_flag1(), this.get_command_ls_flag2(), this.get_directory_name()};
        String[] command = command_ducc_ling_yes;
        if (this.ducc_ling == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private String reader() throws Exception {
        String string;
        String data = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        try {
            String line;
            String[] command = this.getCommand();
            this.echo(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            InputStream pOut = p.getInputStream();
            isr = new InputStreamReader(pOut);
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (first) {
                    first = false;
                    continue;
                }
                sb.append(line);
                sb.append("\n");
            }
            string = data = sb.toString();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.closer(br);
                this.closer(isr);
                throw throwable;
            }
        }
        this.closer(br);
        this.closer(isr);
        return string;
    }

    private String getString() throws Exception {
        String methodName = "getString";
        String data = this.reader();
        logger.trace(methodName, this.duccId, new Object[]{"\n" + data});
        return data;
    }

    private void put(Map<String, FileInfo> map, String key, FileInfo value) {
        String location = "put";
        map.put(key, value);
        logger.trace(location, jobid, new Object[]{key});
    }

    private TreeMap<String, FileInfo> transform(String[] lines) {
        String location = "transform";
        TreeMap<String, FileInfo> map = new TreeMap<String, FileInfo>();
        if (lines != null) {
            String type = "p";
            String parent = this.get_directory_name();
            logger.debug(location, jobid, new Object[]{type + " " + 0 + " " + parent});
            for (String line : lines) {
                String[] elements = line.split(whitespace);
                type = "?";
                int count = elements.length;
                if (count == indexName + 1) {
                    if (elements[indexPermissions].startsWith("d")) {
                        type = "d";
                        logger.trace(location, jobid, new Object[]{type + " " + count + " " + line});
                        continue;
                    }
                    type = "f";
                    logger.debug(location, jobid, new Object[]{type + " " + count + " " + line});
                    String reldir = parent.replace(this.get_directory_name(), "");
                    if (reldir.startsWith(File.separator)) {
                        reldir = reldir.replace(File.separator, ".");
                    }
                    String permissions = elements[indexPermissions];
                    String user = elements[indexUser];
                    String group = elements[indexGroup];
                    long length = Long.parseLong(elements[indexLength]);
                    String date = elements[indexDate];
                    String time = elements[indexTime];
                    String name = (parent + File.separator + elements[indexName]).replace(File.separator + File.separator, File.separator);
                    FileInfo fi = new FileInfo(reldir, permissions, user, group, length, date, time, name);
                    this.put(map, name, fi);
                    continue;
                }
                if (count == indexPermissions + 1) {
                    if (elements[indexPermissions].endsWith(":")) {
                        type = "p";
                        logger.debug(location, jobid, new Object[]{type + " " + count + " " + line});
                        parent = elements[indexPermissions].replace(":", "");
                        continue;
                    }
                    type = "o";
                    logger.trace(location, jobid, new Object[]{type + " " + count + " " + line});
                    continue;
                }
                logger.trace(location, jobid, new Object[]{type + " " + count + " " + line});
            }
        }
        return map;
    }

    public TreeMap<String, FileInfo> getMap() {
        String location = "getMap";
        long start = System.currentTimeMillis();
        TreeMap<String, FileInfo> map = new TreeMap();
        String result = null;
        try {
            result = this.getString();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result != null) {
            String[] lines = result.split(newline);
            map = this.transform(lines);
        }
        long end = System.currentTimeMillis();
        logger.debug(location, jobid, new Object[]{"elapsed=" + (end - start)});
        return map;
    }

    protected InputStreamReader getInputStreamReader() throws Exception {
        InputStreamReader isr = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        isr = new InputStreamReader(pOut);
        return isr;
    }

    protected DataInputStream getDataInputStream() throws Exception {
        DataInputStream dis = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        dis = new DataInputStream(pOut);
        return dis;
    }

    public static void main(String[] args) throws Exception {
        AlienDirectory alienDirectory;
        String location = "main";
        logger.trace(location, jobid, new Object[]{"start"});
        String arg_user = args[0];
        logger.trace(location, jobid, new Object[]{"user: " + arg_user});
        String arg_directory = args[1];
        logger.trace(location, jobid, new Object[]{"directory: " + arg_directory});
        EffectiveUser eu = EffectiveUser.create(arg_user);
        if (args.length < 3) {
            alienDirectory = new AlienDirectory(eu, arg_directory, null);
        } else {
            String arg_ducc_ling = args[2];
            alienDirectory = new AlienDirectory(eu, arg_directory, arg_ducc_ling);
        }
        TreeMap<String, FileInfo> map = alienDirectory.getMap();
        for (Map.Entry entry : map.entrySet()) {
            FileInfo fi = (FileInfo)entry.getValue();
            String text = "" + fi.getPermissions() + " " + fi.getName() + " " + fi.getUser() + " " + fi.getGroup() + " " + fi.getLength();
            logger.info(location, jobid, new Object[]{text});
        }
        logger.trace(location, jobid, new Object[]{"end"});
    }
}

