/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.server.DuccAbstractHandler;
import org.apache.uima.ducc.ws.server.DuccHandlerClassic;
import org.apache.uima.ducc.ws.server.DuccWebUtil;
import org.apache.uima.ducc.ws.server.nodeviz.NodeViz;
import org.eclipse.jetty.server.Request;

public class DuccHandlerViz
extends DuccAbstractHandler {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccHandlerClassic.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccId jobid = null;
    public final String vizNodes = "/ducc-servlet/viz-nodes";
    NodeViz viz = new NodeViz();

    DuccHandlerViz() {
    }

    private void handleServletVizNodes(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletVizNodes";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        String data = this.viz.getVisualization();
        duccLogger.debug(methodName, jobid, new Object[]{data});
        response.getWriter().println(data);
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleServletUnknown(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handleServletUnknown";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.info(methodName, jobid, new Object[]{request.toString()});
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    private void handleDuccRequest(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "handleDuccRequest";
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
        duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
        String reqURI = request.getRequestURI() + "";
        if (reqURI.startsWith("/ducc-servlet/viz-nodes")) {
            this.handleServletVizNodes(target, baseRequest, request, response);
        } else {
            this.handleServletUnknown(target, baseRequest, request, response);
        }
        duccLogger.trace(methodName, jobid, new Object[]{messages.fetch("exit")});
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String methodName = "handle";
        try {
            duccLogger.debug(methodName, jobid, new Object[]{request.toString()});
            duccLogger.debug(methodName, jobid, new Object[]{"getRequestURI():" + request.getRequestURI()});
            String reqURI = request.getRequestURI() + "";
            if (reqURI.startsWith("/ducc-servlet/viz")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                baseRequest.setHandled(true);
                this.handleDuccRequest(target, baseRequest, request, response);
                DuccWebUtil.noCache(response);
            }
        }
        catch (Throwable t) {
            if (this.isIgnorable(t)) {
                duccLogger.debug(methodName, jobid, t, new Object[0]);
            }
            duccLogger.info(methodName, jobid, new Object[]{"", t.getMessage(), t});
            duccLogger.error(methodName, jobid, t, new Object[0]);
        }
    }
}

