/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.broker;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.broker.EntityInfo;

public class BrokerHelper {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)BrokerHelper.class.getName());
    private static DuccId jobid = null;
    private static BrokerHelper instance = new BrokerHelper();
    private String host = "?";
    private int port = 1100;
    private JMXServiceURL url;
    private JMXConnector jmxc;
    private MBeanServerConnection mbsc;
    private OperatingSystemMXBean remoteOperatingSystem;
    private ThreadMXBean remoteThread;

    public static BrokerHelper getInstance() {
        return instance;
    }

    private BrokerHelper() {
        this.init();
    }

    private void init() {
        String location = "init";
        try {
            DuccPropertiesResolver duccPropertiesResolver = DuccPropertiesResolver.getInstance();
            String key = "ducc.broker.hostname";
            String value = duccPropertiesResolver.getCachedProperty(key);
            this.setHost(value);
            key = "ducc.broker.jmx.port";
            value = duccPropertiesResolver.getCachedProperty(key);
            this.setPort(value);
            this.url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.getHost() + ":" + this.getPort() + "/jmxrmi");
            this.jmxc = JMXConnectorFactory.connect(this.url, null);
            this.mbsc = this.jmxc.getMBeanServerConnection();
            this.remoteOperatingSystem = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            this.remoteThread = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Threading", ThreadMXBean.class);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    private void setPort(String value) {
        String location = "setPort";
        try {
            this.port = Integer.parseInt(value);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public int getPort() {
        return this.port;
    }

    public Long getMemoryUsed() {
        String location = "getMemoryUsed";
        Long retVal = new Long(0L);
        try {
            Object o = this.mbsc.getAttribute(new ObjectName("java.lang:type=Memory"), "HeapMemoryUsage");
            CompositeData cd = (CompositeData)o;
            retVal = (Long)cd.get("used");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public Long getMemoryMax() {
        String location = "getMemoryMax";
        Long retVal = new Long(0L);
        try {
            Object o = this.mbsc.getAttribute(new ObjectName("java.lang:type=Memory"), "HeapMemoryUsage");
            CompositeData cd = (CompositeData)o;
            retVal = (Long)cd.get("max");
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public int getThreadsLive() {
        String location = "getThreadsLive";
        int retVal = 0;
        try {
            retVal = this.remoteThread.getThreadCount();
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public int getThreadsPeak() {
        String location = "getThreadsPeak";
        int retVal = 0;
        try {
            retVal = this.remoteThread.getPeakThreadCount();
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public double getSystemLoadAverage() {
        String location = "getSystemLoadAverage";
        double retVal = 0.0;
        try {
            retVal = this.remoteOperatingSystem.getSystemLoadAverage();
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private boolean isFrameworkEntity(ObjectName objectName) {
        String location = "isFrameworkEntity";
        boolean retVal = false;
        String key = "Destination";
        String value = objectName.getKeyProperty(key);
        if (value != null && value.startsWith("ducc.")) {
            retVal = true;
            duccLogger.debug(location, jobid, new Object[]{key + "=" + value});
        }
        return retVal;
    }

    private String getName(ObjectName objectName) {
        String value;
        String retVal = "";
        String key = "Destination";
        retVal = value = objectName.getKeyProperty(key);
        return retVal;
    }

    private String getType(ObjectName objectName) {
        String value;
        String retVal = "";
        String key = "Type";
        retVal = value = objectName.getKeyProperty(key);
        return retVal;
    }

    private boolean isBrokerInfo(ObjectName objectName) {
        boolean retVal = false;
        String key = "Type";
        String value = objectName.getKeyProperty(key);
        if (value != null && value.startsWith("Broker")) {
            retVal = true;
        }
        return retVal;
    }

    public String getAttribute(BrokerAttribute qa) {
        String location = "getAttribute";
        String retVal = "";
        try {
            TreeSet<ObjectName> objectNames = new TreeSet<ObjectName>(this.mbsc.queryNames(null, null));
            for (ObjectName objectName : objectNames) {
                if (!this.isBrokerInfo(objectName)) continue;
                String[] attrNames = new String[]{qa.name()};
                AttributeList attributeList = this.mbsc.getAttributes(objectName, attrNames);
                for (Object object : attributeList) {
                    Attribute attribute = (Attribute)object;
                    retVal = "" + attribute.getValue();
                }
                break;
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public TreeMap<String, String> getAttributes(String name, String[] attrNames) {
        String location = "getAttributes";
        TreeMap<String, String> retVal = new TreeMap<String, String>();
        try {
            TreeSet<ObjectName> objectNames = new TreeSet<ObjectName>(this.mbsc.queryNames(null, null));
            for (ObjectName objectName : objectNames) {
                String topicName = this.getName(objectName);
                if (topicName == null || !topicName.equals(name)) continue;
                AttributeList attributeList = this.mbsc.getAttributes(objectName, attrNames);
                for (Object object : attributeList) {
                    Attribute attribute = (Attribute)object;
                    String attrName = attribute.getName();
                    String attrValue = "" + attribute.getValue();
                    retVal.put(attrName, attrValue);
                    duccLogger.debug(location, jobid, new Object[]{attrName + "=" + attrValue});
                }
                break;
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public ArrayList<EntityInfo> getFrameworkEntities() {
        String location = "getFrameworkTopicNames";
        ArrayList list = new ArrayList();
        ArrayList<EntityInfo> retVal = new ArrayList<EntityInfo>();
        try {
            TreeSet<ObjectName> objectNames = new TreeSet<ObjectName>(this.mbsc.queryNames(null, null));
            for (ObjectName objectName : objectNames) {
                String type;
                String name;
                EntityInfo entityInfo;
                String key;
                if (!this.isFrameworkEntity(objectName) || list.contains(key = (entityInfo = new EntityInfo(name = this.getName(objectName), type = this.getType(objectName))).getKey())) continue;
                retVal.add(entityInfo);
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public static enum FrameworkAttribute {
        ConsumerCount,
        QueueSize,
        MaxEnqueueTime,
        AverageEnqueueTime,
        MemoryPercentUsage;

    }

    public static enum BrokerAttribute {
        BrokerVersion,
        MemoryPercentUsage,
        Uptime;

    }
}

