/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.utils.alien;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemState;
import org.apache.uima.ducc.common.jd.files.workitem.WorkItemStateReader;
import org.apache.uima.ducc.common.utils.AlienFile;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;

public class AlienWorkItemStateReader
extends WorkItemStateReader {
    protected DuccLogger logger = DuccLogger.getLogger(AlienWorkItemStateReader.class, null);
    private String user = null;
    private long MaxRecords = 4096L;
    private Type wisType = new TypeToken<WorkItemState>(){}.getType();

    public AlienWorkItemStateReader(EffectiveUser eu, String component, String directory, long wiVersion) {
        super(component, directory, eu.get(), wiVersion);
        this.set_user(eu.get());
    }

    private void set_user(String value) {
        this.user = value;
    }

    public ConcurrentSkipListMap<Long, IWorkItemState> getMap() {
        long lastRecordNo = 0L;
        long maxRecords = this.MaxRecords;
        return this.getMap(lastRecordNo, maxRecords);
    }

    private ConcurrentSkipListMap<Long, IWorkItemState> getMap(long lastRecordNo, long maxRecords) {
        String location = "getMap";
        ConcurrentSkipListMap<Long, IWorkItemState> map = null;
        map = new ConcurrentSkipListMap<Long, IWorkItemState>();
        this.fetch(map, this.fnActiveJson);
        int sizeActive = map.size();
        this.fetch(map, this.fnJson);
        int sizeInactive = map.size() - sizeActive;
        this.logger.debug(location, jobid, new Object[]{"active:" + sizeActive + " " + "inactive:" + sizeInactive});
        return map;
    }

    private IWorkItemState convert(ConcurrentSkipListMap<Long, IWorkItemState> map, String line) {
        StringReader sr = new StringReader(line.trim());
        WorkItemState wis = (WorkItemState)gson.fromJson((Reader)sr, this.wisType);
        Long key = Long.parseLong(wis.getSeqNo());
        WorkItemState value = wis;
        map.put(key, (IWorkItemState)value);
        return wis;
    }

    private void fetch(ConcurrentSkipListMap<Long, IWorkItemState> map, String fn) {
        String location = "fetch";
        AlienFile alienFile = new AlienFile(this.user, fn);
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            isr = alienFile.getInputStreamReader();
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                this.logger.debug(location, jobid, new Object[]{line});
                IWorkItemState wis = this.convert(map, line);
                if (wis == null) continue;
                try {
                    long key = Long.parseLong(wis.getSeqNo());
                    map.put(key, wis);
                }
                catch (Exception e) {
                    this.logger.error(location, jobid, new Object[]{wis.getSeqNo(), e});
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.debug(location, jobid, new Object[]{"File not found"});
        }
        catch (IOException e) {
            this.logger.debug(location, jobid, new Object[]{"File error"});
        }
        catch (Exception e) {
            this.logger.debug(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public double getMin() {
        double retVal = 0.0;
        return retVal;
    }

    public double getMax() {
        double retVal = 0.0;
        return retVal;
    }

    public double getAvg() {
        double retVal = 0.0;
        return retVal;
    }
}

