/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.registry.sort;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMap;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.apache.uima.ducc.ws.registry.sort.IServiceAdapter;
import org.apache.uima.ducc.ws.registry.sort.SortableService;

public class ServicesSortCache {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)ServicesSortCache.class.getName());
    private static DuccId jobid = null;
    private static ServicesSortCache instance = new ServicesSortCache();
    private volatile TreeMap<SortableService, IServiceAdapter> map = new TreeMap();

    public static ServicesSortCache getInstance() {
        return instance;
    }

    public void update(ServicesRegistryMap registryMap) {
        TreeMap<SortableService, SortableService> mapRevised = new TreeMap<SortableService, SortableService>();
        for (Map.Entry entry : registryMap.entrySet()) {
            ServicesRegistryMapPayload payload = (ServicesRegistryMapPayload)entry.getValue();
            Properties meta = payload.meta;
            Properties svc = payload.svc;
            SortableService ss = new SortableService(svc, meta);
            mapRevised.put(ss, ss);
        }
        this.map = mapRevised;
    }

    private void enabled(int id, boolean bool) {
        String location = "enabled";
        try {
            for (Map.Entry<SortableService, IServiceAdapter> entry : this.map.entrySet()) {
                String key;
                IServiceAdapter payload = entry.getValue();
                Properties meta = payload.getMeta();
                String value = meta.getProperty(key = "numeric_id");
                int numeric_id = Integer.parseInt(value);
                if (numeric_id != id) continue;
                meta.setProperty("enabled", Boolean.toString(bool));
                payload.setMeta(meta);
                break;
            }
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    public void setDisabled(int id) {
        this.enabled(id, false);
    }

    public void setEnabled(int id) {
        this.enabled(id, true);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<IServiceAdapter> getSortedCollection() {
        return this.map.values();
    }
}

