/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.history.HistoryFactory;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccPlugins;

public class DuccBoot
extends Thread {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccBoot.class.getName());
    private static Messages messages = Messages.getInstance();
    private static DuccPlugins duccPlugins = DuccPlugins.getInstance();
    private static DuccId jobid = null;
    public static long maxJobs = 4096L;
    public static long maxReservations = 4096L;
    public static long maxServices = 4096L;

    public static void boot(CommonConfiguration commonConfiguration) {
        DuccBoot duccBoot = new DuccBoot();
        duccBoot.initialize(commonConfiguration);
        duccBoot.start();
    }

    @Override
    public void run() {
        String location = "run";
        try {
            logger.info(location, jobid, new Object[]{"booting..."});
            this.restore();
            logger.info(location, jobid, new Object[]{"ready."});
        }
        catch (Throwable t) {
            logger.error(location, jobid, t, new Object[0]);
        }
    }

    private static long getLimit() {
        long limit = 0L;
        try {
            String p_limit = DuccPropertiesResolver.getInstance().getProperty("ducc.ws.max.history.entries");
            if (p_limit != null && !(p_limit = p_limit.trim()).equals("unlimited")) {
                limit = Long.parseLong(p_limit);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return limit;
    }

    private static TreeMap<Integer, String> sort(ArrayList<String> list) {
        String location = "sort";
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            try {
                String value = listIterator.next().trim();
                int index = value.indexOf(46);
                Integer key = Integer.parseInt(value.substring(0, index));
                map.put(key, value);
            }
            catch (Throwable t) {
                logger.warn(location, jobid, t, new Object[0]);
            }
        }
        return map;
    }

    private void restoreReservations(IHistoryPersistenceManager hpm, DuccData duccData) {
        String location = "restoreReservations";
        ArrayList duccWorkReservations = hpm.reservationList();
        logger.info(location, jobid, new Object[]{messages.fetchLabel("Number of Reservations to restore") + duccWorkReservations.size()});
        TreeMap<Integer, String> map = DuccBoot.sort(duccWorkReservations);
        Iterator<Integer> iterator = map.descendingKeySet().iterator();
        int i = 0;
        int restored = 0;
        while (iterator.hasNext() && (long)(++i) < maxReservations) {
            try {
                Integer key = iterator.next();
                logger.debug(location, jobid, new Object[]{messages.fetchLabel("restore") + key});
                String fileName = map.get(key);
                IDuccWorkReservation duccWorkReservation = hpm.reservationRestore(fileName);
                if (duccWorkReservation == null) continue;
                duccData.putIfNotPresent((IDuccWork)duccWorkReservation);
                duccPlugins.restore(duccWorkReservation);
                ++restored;
            }
            catch (Throwable t) {
                logger.warn(location, jobid, t, new Object[0]);
            }
        }
        logger.info(location, jobid, new Object[]{messages.fetch("Reservations restored: " + restored)});
    }

    private void restoreJobs(IHistoryPersistenceManager hpm, DuccData duccData) {
        String location = "restoreJobs";
        ArrayList duccWorkJobs = hpm.jobList();
        logger.info(location, jobid, new Object[]{messages.fetchLabel("Number of Jobs to restore") + duccWorkJobs.size()});
        TreeMap<Integer, String> map = DuccBoot.sort(duccWorkJobs);
        Iterator<Integer> iterator = map.descendingKeySet().iterator();
        int i = 0;
        int restored = 0;
        while (iterator.hasNext() && (long)(++i) < maxJobs) {
            try {
                Integer key = iterator.next();
                logger.debug(location, jobid, new Object[]{messages.fetchLabel("restore") + key});
                String fileName = map.get(key);
                IDuccWorkJob duccWorkJob = hpm.jobRestore(fileName);
                if (duccWorkJob == null) continue;
                duccData.putIfNotPresent((IDuccWork)duccWorkJob);
                duccPlugins.restore(duccWorkJob);
                ++restored;
            }
            catch (Throwable t) {
                logger.warn(location, jobid, t, new Object[0]);
            }
        }
        logger.info(location, jobid, new Object[]{messages.fetch("Jobs restored: " + restored)});
    }

    private void restoreServices(IHistoryPersistenceManager hpm, DuccData duccData) {
        String location = "restoreServices";
        ArrayList duccWorkServices = hpm.serviceList();
        logger.info(location, jobid, new Object[]{messages.fetchLabel("Number of Services to restore") + duccWorkServices.size()});
        TreeMap<Integer, String> map = DuccBoot.sort(duccWorkServices);
        Iterator<Integer> iterator = map.descendingKeySet().iterator();
        int i = 0;
        int restored = 0;
        while (iterator.hasNext() && (long)(++i) < maxServices) {
            try {
                Integer key = iterator.next();
                logger.debug(location, jobid, new Object[]{messages.fetchLabel("restore") + key});
                String fileName = map.get(key);
                IDuccWorkService duccWorkService = hpm.serviceRestore(fileName);
                if (duccWorkService == null) continue;
                duccData.putIfNotPresent((IDuccWork)duccWorkService);
                duccPlugins.restore(duccWorkService);
                ++restored;
            }
            catch (Throwable t) {
                logger.warn(location, jobid, t, new Object[0]);
            }
        }
        logger.info(location, jobid, new Object[]{messages.fetch("Services restored: " + restored)});
    }

    private void initialize(CommonConfiguration commonConfiguration) {
        String location = "initialize";
        long limit = DuccBoot.getLimit();
        if (limit > 0L) {
            logger.info(location, jobid, new Object[]{messages.fetchLabel("max history limit") + limit});
            maxJobs = limit;
            maxReservations = limit;
            maxServices = limit;
        }
    }

    private void restore() {
        String location = "restore";
        logger.info(location, jobid, new Object[]{messages.fetchLabel("History directory") + IDuccEnv.DUCC_HISTORY_DIR});
        IHistoryPersistenceManager hpm = HistoryFactory.getInstance();
        DuccData duccData = DuccData.getInstance();
        this.restoreReservations(hpm, duccData);
        this.restoreJobs(hpm, duccData);
        this.restoreServices(hpm, duccData);
        duccData.report();
    }
}

