/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.jasper.servlet.JspServlet;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.server.DuccHandler;
import org.apache.uima.ducc.ws.server.DuccHandlerClassic;
import org.apache.uima.ducc.ws.server.DuccHandlerJsonFormat;
import org.apache.uima.ducc.ws.server.DuccHandlerProxy;
import org.apache.uima.ducc.ws.server.DuccHandlerUserAuthentication;
import org.apache.uima.ducc.ws.server.DuccWebMonitor;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class DuccWebServer {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccWebServer.class.getName());
    private static Messages messages = Messages.getInstance();
    private DuccId jobid = null;
    private String ducc_web = ".";
    private int port = 42133;
    private String ipaddress = null;
    private int portSsl = -1;
    private String portSslPw = "quackquack";
    private String rootDir = "?";
    private Server server;
    private CommonConfiguration commonConfiguration;

    public DuccWebServer(CommonConfiguration commonConfiguration) {
        this.commonConfiguration = commonConfiguration;
        this.init();
    }

    public String getClusterName() {
        return this.commonConfiguration.clusterName;
    }

    public String getClassDefinitionFile() {
        return this.commonConfiguration.classDefinitionFile;
    }

    public int getPortSsl() {
        return this.portSsl;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    private void init() {
        String methodName = "init";
        logger.trace(methodName, null, new Object[]{messages.fetch("enter")});
        logger.info(methodName, null, new Object[]{messages.fetchLabel("cluster name") + this.getClusterName()});
        logger.info(methodName, null, new Object[]{messages.fetchLabel("class definition file") + this.getClassDefinitionFile()});
        if (this.commonConfiguration.wsIpAddress != null) {
            this.ipaddress = this.commonConfiguration.wsIpAddress;
            logger.info(methodName, null, new Object[]{messages.fetchLabel("IP Address") + this.ipaddress});
        }
        if (this.commonConfiguration.wsPort != null) {
            this.port = Integer.parseInt(this.commonConfiguration.wsPort);
            logger.info(methodName, null, new Object[]{messages.fetchLabel("port") + this.port});
        }
        if (this.commonConfiguration.wsPortSsl != null) {
            this.portSsl = Integer.parseInt(this.commonConfiguration.wsPortSsl);
            logger.info(methodName, null, new Object[]{messages.fetchLabel("SSL port") + this.portSsl});
            if (this.commonConfiguration.wsPortSslPw != null) {
                this.portSslPw = this.commonConfiguration.wsPortSslPw;
                logger.debug(methodName, null, new Object[]{messages.fetchLabel("SSL pw") + this.portSslPw});
            }
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String host = inetAddress.getCanonicalHostName();
            DuccWebMonitor.getInstance().register(host, "" + this.port);
        }
        catch (Exception e) {
            logger.error(methodName, this.jobid, (Throwable)e, new Object[0]);
        }
        String ducc_web_property = System.getProperty("DUCC_WEB");
        String ducc_web_env = System.getenv("DUCC_WEB");
        if (ducc_web_property != null) {
            this.ducc_web = ducc_web_property;
            logger.info(methodName, null, new Object[]{messages.fetchLabel("DUCC_WEB") + this.ducc_web});
        } else if (ducc_web_env != null) {
            this.ducc_web = ducc_web_env;
            logger.info(methodName, null, new Object[]{messages.fetchLabel("DUCC_WEB (default)") + this.ducc_web});
        }
        this.server = new Server();
        SelectChannelConnector connector0 = new SelectChannelConnector();
        connector0.setPort(this.port);
        if (this.ipaddress != null) {
            connector0.setHost(this.ipaddress);
        }
        if (this.portSsl < 0) {
            this.server.setConnectors(new Connector[]{connector0});
        } else {
            SslSelectChannelConnector ssl_connector = new SslSelectChannelConnector();
            ssl_connector.setPort(this.portSsl);
            if (this.ipaddress != null) {
                ssl_connector.setHost(this.ipaddress);
            }
            SslContextFactory cf = ssl_connector.getSslContextFactory();
            cf.setKeyStore(this.ducc_web + File.separator + "etc" + File.separator + "keystore");
            cf.setKeyStorePassword(this.portSslPw);
            this.server.setConnectors(new Connector[]{connector0, ssl_connector});
        }
        ServletContextHandler jspHandler = new ServletContextHandler(1);
        jspHandler.setContextPath("/");
        jspHandler.setResourceBase("root");
        jspHandler.setClassLoader(Thread.currentThread().getContextClassLoader());
        jspHandler.addServlet(DefaultServlet.class, "/");
        ServletHolder jsp = jspHandler.addServlet(JspServlet.class, "*.jsp");
        jsp.setInitParameter("classpath", jspHandler.getClassPath());
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(true);
        resourceHandler.setWelcomeFiles(new String[]{"index.html"});
        this.rootDir = this.ducc_web + File.separator + "root";
        resourceHandler.setResourceBase(this.rootDir);
        try {
            Properties properties = DuccWebProperties.get();
            String ducc_runmode = properties.getProperty("ducc.runmode", "Production");
            logger.debug(methodName, null, new Object[]{"ducc.runmode:" + ducc_runmode});
            logger.debug(methodName, null, new Object[]{"rootdir:" + this.rootDir});
            String $runmode_jsp = this.rootDir + File.separator + "$banner" + File.separator + "$runmode.jsp";
            logger.debug(methodName, null, new Object[]{"$runmode_jsp:" + $runmode_jsp});
            File $runmodeFile = new File($runmode_jsp);
            logger.debug(methodName, null, new Object[]{"path:" + $runmodeFile.getAbsolutePath()});
            $runmodeFile.delete();
            String text = ducc_runmode.equals("Test") ? "<html><%@ include file=\"$runmode.test.jsp\" %></html>" : "<html><%@ include file=\"$runmode.production.jsp\" %></html>";
            PrintWriter out = new PrintWriter($runmodeFile);
            out.println(text);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.info(methodName, null, (Throwable)e, new Object[0]);
        }
        HandlerList handlers = new HandlerList();
        DuccHandler duccHandler = new DuccHandler(this);
        DuccHandlerClassic duccHandlerClassic = new DuccHandlerClassic(this);
        DuccHandlerJsonFormat duccHandlerJson = new DuccHandlerJsonFormat(this);
        DuccHandlerProxy duccHandlerProxy = new DuccHandlerProxy();
        DuccHandlerUserAuthentication duccHandlerUserAuthentication = new DuccHandlerUserAuthentication();
        SessionHandler sessionHandler = new SessionHandler();
        handlers.setHandlers(new Handler[]{sessionHandler, duccHandlerUserAuthentication, duccHandlerJson, duccHandlerProxy, duccHandlerClassic, duccHandler, jspHandler, resourceHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        logger.trace(methodName, null, new Object[]{messages.fetch("exit")});
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void join() throws Exception {
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

