/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.PmStateDuccEvent;
import org.apache.uima.ducc.transport.event.RmStateDuccEvent;
import org.apache.uima.ducc.transport.event.SmStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.ws.CacheManager;
import org.apache.uima.ducc.ws.DuccDaemonsData;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccMachinesData;
import org.apache.uima.ducc.ws.IWebServer;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.server.DuccListeners;
import org.apache.uima.ducc.ws.server.DuccWebServer;
import org.apache.uima.ducc.ws.utils.DatedNodeMetricsUpdateDuccEvent;

public class WebServerComponent
extends AbstractDuccComponent
implements IWebServer {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)WebServerComponent.class.getName());
    private static DuccId jobid = null;
    private DuccWebServer duccWebServer = null;
    private Messages duccMsg = Messages.getInstance();
    private static AtomicInteger jobCount = new AtomicInteger(0);
    private static AtomicInteger serviceCount = new AtomicInteger(0);
    private static AtomicInteger reservationCount = new AtomicInteger(0);

    public WebServerComponent(CamelContext context, CommonConfiguration common) {
        super("WebServer", context);
        String[] propertyNames;
        String methodName = "WebServerComponent";
        duccLogger.info(methodName, jobid, new Object[]{"##### boot #####"});
        for (String property : propertyNames = new String[]{"ducc.broker.url"}) {
            duccLogger.info(methodName, jobid, new Object[]{property + "=" + System.getProperty(property)});
        }
        duccLogger.info(methodName, jobid, new Object[]{System.getProperty("ducc.broker.url")});
        this.duccWebServer = new DuccWebServer(common);
        this.init();
    }

    public void start(DuccService service, String[] args) throws Exception {
        super.start(service, args);
        DuccDaemonRuntimeProperties.getInstance().boot(DuccDaemonRuntimeProperties.DaemonName.Webserver, this.getProcessJmxUrl());
    }

    public DuccLogger getLogger() {
        return duccLogger;
    }

    public void webServerStart() {
        String methodName = "webServerStart";
        try {
            this.duccWebServer.start();
            duccLogger.info(methodName, jobid, new Object[]{"webserver started"});
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
    }

    public void webServerStop() {
        String methodName = "webServerStop";
        try {
            this.duccWebServer.stop();
            duccLogger.info(methodName, jobid, new Object[]{"webserver stopped"});
        }
        catch (Exception e) {
            duccLogger.error(methodName, jobid, (Throwable)e, new Object[0]);
        }
    }

    private void init() {
        String methodName = "init";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        this.webServerStart();
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(OrchestratorStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "OrchestratorStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        DuccWorkMap wm = duccEvent.getWorkMap();
        boolean change = false;
        int count = wm.getJobCount();
        if (count != jobCount.get()) {
            jobCount.set(count);
            change = true;
        }
        if ((count = wm.getReservationCount()) != reservationCount.get()) {
            reservationCount.set(count);
            change = true;
        }
        if ((count = wm.getServiceCount()) != serviceCount.get()) {
            serviceCount.set(count);
            change = true;
        }
        if (change) {
            duccLogger.info(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("jobs") + jobCount.get() + " " + this.duccMsg.fetchLabel("reservations") + reservationCount.get() + " " + this.duccMsg.fetchLabel("services") + serviceCount.get()});
        }
        DuccData.getInstance().put(wm);
        DuccListeners.getInstance().update(duccEvent);
        CacheManager.getInstance().update(wm);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(NodeMetricsUpdateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "NodeMetricsUpdateDuccEvent"});
        DuccMachinesData.getInstance().put(new DatedNodeMetricsUpdateDuccEvent(duccEvent));
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(RmStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "RmStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(SmStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "SmStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        ServicesRegistry.getInstance().update();
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }

    @Override
    public void update(PmStateDuccEvent duccEvent) {
        String methodName = "update";
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("enter")});
        duccLogger.debug(methodName, jobid, new Object[]{this.duccMsg.fetchLabel("received") + "PmStateDuccEvent"});
        DuccDaemonsData.getInstance().put((AbstractDuccEvent)duccEvent);
        duccLogger.trace(methodName, jobid, new Object[]{this.duccMsg.fetch("exit")});
    }
}

