/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.cli.ws.json.MachineFacts;
import org.apache.uima.ducc.cli.ws.json.MachineFactsList;
import org.apache.uima.ducc.cli.ws.json.NodePidList;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.DuccNodes;
import org.apache.uima.ducc.ws.MachineInfo;
import org.apache.uima.ducc.ws.MachineSummaryInfo;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.types.Ip;
import org.apache.uima.ducc.ws.types.NodeId;
import org.apache.uima.ducc.ws.types.UserId;
import org.apache.uima.ducc.ws.utils.DatedNodeMetricsUpdateDuccEvent;

public class DuccMachinesData {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DuccMachinesData.class.getName());
    private static DuccId jobid = null;
    private static ConcurrentSkipListMap<String, MachineInfo> unsortedMachines = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, MachineSummaryInfo> summaryMachines = new ConcurrentSkipListMap();
    private static AtomicLong memoryTotal = new AtomicLong(0L);
    private static AtomicLong memorySwapped = new AtomicLong(0L);
    private static AtomicLong sharesTotal = new AtomicLong(0L);
    private static AtomicLong sharesInuse = new AtomicLong(0L);
    private int shareSize = 15;
    private String domain = "";
    private static DuccMachinesData duccMachinesData = new DuccMachinesData();
    private static ConcurrentSkipListMap<String, String> ipToNameMap = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, String> nameToIpMap = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, String> isSwapping = new ConcurrentSkipListMap();
    private static ConcurrentSkipListMap<String, TreeMap<String, NodeUsersInfo>> ipToNodeUsersInfoMap = new ConcurrentSkipListMap();
    private volatile String published = null;

    public static DuccMachinesData getInstance() {
        return duccMachinesData;
    }

    public boolean isMachineSwapping(String ip) {
        return isSwapping.containsKey(ip);
    }

    public ConcurrentSkipListMap<String, MachineInfo> getMachines() {
        return unsortedMachines;
    }

    public ConcurrentSkipListMap<MachineInfo, String> getSortedMachines() {
        ConcurrentSkipListMap<MachineInfo, String> sortedMachines = new ConcurrentSkipListMap<MachineInfo, String>();
        for (Map.Entry<String, MachineInfo> next : unsortedMachines.entrySet()) {
            MachineInfo machineInfo = next.getValue();
            String name = next.getKey();
            sortedMachines.put(machineInfo, name);
        }
        return sortedMachines;
    }

    private DuccMachinesData() {
        this.initialize();
    }

    private void initialize() {
        String location = "initialize";
        try {
            String fileName = "ducc.nodes";
            String dirResources = IDuccEnv.DUCC_RESOURCES_DIR;
            ArrayList<String> nodes = DuccNodes.getInstance().get(dirResources, fileName);
            for (String nodeName : nodes) {
                MachineInfo machineInfo = new MachineInfo(IDuccEnv.DUCC_NODES_FILE_PATH, "", nodeName, "", "", null, "", "", -1L, 0L);
                unsortedMachines.put(machineInfo.getName(), machineInfo);
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        try {
            this.shareSize = Integer.parseInt(DuccWebProperties.getProperty(DuccWebProperties.key_ducc_rm_share_quantum, DuccWebProperties.val_ducc_rm_share_quantum));
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String chn = ia.getCanonicalHostName();
            int index = chn.indexOf(".");
            if (index > 0) {
                this.domain = chn.substring(index);
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
    }

    public boolean isPublished() {
        return this.published != null;
    }

    public void setPublished() {
        this.published = TimeStamp.getCurrentMillis();
    }

    public MachineSummaryInfo getTotals() {
        MachineSummaryInfo totals = new MachineSummaryInfo();
        totals.memoryTotal = memoryTotal.get();
        totals.memorySwapped = memorySwapped.get();
        totals.sharesTotal = sharesTotal.get();
        totals.sharesInuse = sharesInuse.get();
        return totals;
    }

    private void updateTotals(Ip ip, MachineSummaryInfo newInfo) {
        if (summaryMachines.containsKey(ip.toString())) {
            MachineSummaryInfo oldInfo = summaryMachines.get(ip.toString());
            summaryMachines.put(ip.toString(), newInfo);
            memoryTotal.addAndGet(newInfo.memoryTotal - oldInfo.memoryTotal);
            memorySwapped.addAndGet(newInfo.memorySwapped - oldInfo.memorySwapped);
            sharesTotal.addAndGet(newInfo.sharesTotal - oldInfo.sharesTotal);
            sharesInuse.addAndGet(newInfo.sharesInuse - oldInfo.sharesInuse);
        } else {
            summaryMachines.put(ip.toString(), newInfo);
            memoryTotal.addAndGet(newInfo.memoryTotal);
            memorySwapped.addAndGet(newInfo.memorySwapped);
            sharesTotal.addAndGet(newInfo.sharesTotal);
            sharesInuse.addAndGet(newInfo.sharesInuse);
        }
    }

    private String normalizeMachineName(String machineName) {
        String retVal = machineName;
        try {
            if (!unsortedMachines.containsKey(machineName)) {
                if (machineName.contains(".")) {
                    int index = machineName.indexOf(".");
                    String domainlessMachineName = machineName.substring(0, index);
                    if (unsortedMachines.containsKey(domainlessMachineName)) {
                        retVal = domainlessMachineName;
                    }
                } else {
                    String domainfullMachineName = machineName + this.domain;
                    if (unsortedMachines.containsKey(domainfullMachineName)) {
                        retVal = domainfullMachineName;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public void put(DatedNodeMetricsUpdateDuccEvent duccEvent) {
        long lval;
        String location = "put";
        MachineSummaryInfo msi = new MachineSummaryInfo();
        NodeMetricsUpdateDuccEvent nodeMetrics = duccEvent.getNodeMetricsUpdateDuccEvent();
        Ip ip = new Ip(nodeMetrics.getNodeIdentity().getIp().trim());
        TreeMap map = nodeMetrics.getNodeUsersMap();
        if (map != null) {
            ipToNodeUsersInfoMap.put(ip.toString(), map);
        }
        String machineName = nodeMetrics.getNodeIdentity().getName().trim();
        ipToNameMap.put(ip.toString(), machineName);
        nameToIpMap.put(machineName, ip.toString());
        double dval = nodeMetrics.getNodeMemory().getMemTotal();
        msi.memoryTotal = lval = (long)(dval / 1048576.0 + 0.5);
        msi.sharesTotal = lval / (long)this.shareSize;
        String memTotal = "" + lval;
        String sharesTotal = "" + lval / (long)this.shareSize;
        double dvalT = nodeMetrics.getNodeMemory().getSwapTotal();
        long lvalT = (long)(dvalT / 1048576.0 + 0.5);
        double dvalF = nodeMetrics.getNodeMemory().getSwapFree();
        long lvalF = (long)(dvalF / 1048576.0 + 0.5);
        lval = lvalT - lvalF;
        String memSwap = "" + lval;
        msi.memorySwapped = lval;
        String swapKey = ip.toString();
        String swapVal = ip.toString();
        if (msi.memorySwapped > 0L) {
            isSwapping.put(swapKey, swapVal);
        } else {
            isSwapping.remove(swapKey);
        }
        String sharesInuse = "0";
        Properties shareMap = this.getShareMap(this.shareSize);
        try {
            if (shareMap.containsKey(ip.toString())) {
                msi.sharesInuse += (long)((Integer)shareMap.get(ip.toString())).intValue();
                sharesInuse = "" + msi.sharesInuse;
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        List alienPids = nodeMetrics.getRogueProcessInfoList();
        MachineInfo current = new MachineInfo("", ip.toString(), machineName, memTotal, memSwap, alienPids, sharesTotal, sharesInuse, duccEvent.getMillis(), duccEvent.getEventSize());
        String key = this.normalizeMachineName(machineName);
        MachineInfo previous = unsortedMachines.get(key);
        if (previous != null) {
            long pHbMax = previous.getHeartbeatMax();
            long tod = previous.getHeartbeatMaxTOD();
            long pHbElapsed = previous.getElapsedSeconds();
            if (pHbElapsed > pHbMax) {
                pHbMax = pHbElapsed;
                tod = previous.getHeartbeat();
            }
            current.setHeartbeatMax(pHbMax);
            current.setHeartbeatMaxTOD(tod);
            long pubSizeMax = previous.getPubSizeMax();
            long pubSize = current.getPubSize();
            if (pubSize > pubSizeMax) {
                pubSizeMax = pubSize;
            }
            current.setPubSizeMax(pubSizeMax);
        }
        unsortedMachines.put(key, current);
        this.updateTotals(ip, msi);
        this.setPublished();
    }

    public List<String> getPids(Ip ip, UserId user) {
        String location = "getPids";
        ArrayList<String> retVal = new ArrayList<String>();
        if (ip != null && ip.toString() != null && user != null && user.toString() != null) {
            try {
                NodeUsersInfo nodeUsersInfo;
                TreeMap<String, NodeUsersInfo> map = ipToNodeUsersInfoMap.get(ip.toString());
                if (map != null && (nodeUsersInfo = map.get(user.toString())) != null) {
                    for (NodeUsersInfo.NodeProcess process : nodeUsersInfo.getReserveProcesses()) {
                        retVal.add(process.getPid());
                    }
                }
            }
            catch (Exception e) {
                logger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        }
        return retVal;
    }

    public List<String> getPids(NodeId nodeId, UserId user) {
        Ip ip = new Ip(this.getIpForName(nodeId.toString()));
        return this.getPids(ip, user);
    }

    public List<NodePidList> getUserProcesses(List<String> nodeList, String user) {
        ArrayList<NodePidList> nodePidListList = new ArrayList<NodePidList>();
        for (String node : nodeList) {
            List<String> pids = this.getPids(new NodeId(node), new UserId(user));
            NodePidList nodePidList = new NodePidList(node, pids);
            nodePidListList.add(nodePidList);
        }
        return nodePidListList;
    }

    public int getPidCount(Ip ip, UserId user) {
        int retVal = 0;
        try {
            List<String> pidList = this.getPids(ip, user);
            if (pidList != null) {
                return pidList.size();
            }
        }
        catch (Exception e) {
            retVal = -1;
        }
        return retVal;
    }

    public int getPidCount(NodeId nodeId, UserId user) {
        Ip ip = new Ip(this.getIpForName(nodeId.toString()));
        return this.getPidCount(ip, user);
    }

    public String getNameForIp(String ip) {
        String retVal = null;
        try {
            retVal = ipToNameMap.get(ip);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    public String getIpForName(String name) {
        String retVal = null;
        try {
            retVal = nameToIpMap.get(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    private int toInt(String s, int deflt) {
        int retVal;
        try {
            retVal = Integer.parseInt(s);
        }
        catch (Throwable t) {
            retVal = deflt;
        }
        return retVal;
    }

    private Properties getShareMapJobs(Properties properties, int shareSize) {
        String location = "getShareMapJobs";
        try {
            DuccData duccData = DuccData.getInstance();
            DuccWorkMap duccWorkMap = duccData.getLive();
            for (DuccId jobid : duccWorkMap.getJobKeySet()) {
                IDuccWorkJob job = (IDuccWorkJob)duccWorkMap.findDuccWork(jobid);
                if (!job.isOperational()) continue;
                int pMemSize = this.toInt(job.getSchedulingInfo().getShareMemorySize(), 1 * shareSize);
                long pShareSize = pMemSize / shareSize;
                if (pShareSize <= 0L) {
                    pShareSize = 1L;
                }
                IDuccProcessMap processMap = job.getProcessMap();
                for (DuccId jpid : processMap.keySet()) {
                    IDuccProcess jp = (IDuccProcess)processMap.get((Object)jpid);
                    IProcessState.ProcessState processState = jp.getProcessState();
                    switch (processState) {
                        case Starting: 
                        case Initializing: 
                        case Running: {
                            NodeIdentity nodeIdentity = jp.getNodeIdentity();
                            String key = nodeIdentity.getIp().trim();
                            Integer value = new Integer(0);
                            if (!properties.containsKey(key)) {
                                properties.put(key, value);
                            }
                            value = (Integer)properties.get(key) + (int)pShareSize;
                            properties.put(key, value);
                            break;
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return properties;
    }

    private Properties getShareMapServices(Properties properties, int shareSize) {
        String location = "getShareMapServices";
        try {
            DuccData duccData = DuccData.getInstance();
            DuccWorkMap duccWorkMap = duccData.getLive();
            for (DuccId jobid : duccWorkMap.getServiceKeySet()) {
                IDuccWorkJob service = (IDuccWorkJob)duccWorkMap.findDuccWork(jobid);
                if (!service.isOperational()) continue;
                int pMemSize = this.toInt(service.getSchedulingInfo().getShareMemorySize(), 1 * shareSize);
                long pShareSize = pMemSize / shareSize;
                if (pShareSize <= 0L) {
                    pShareSize = 1L;
                }
                IDuccProcessMap processMap = service.getProcessMap();
                for (DuccId jpid : processMap.keySet()) {
                    IDuccProcess jp = (IDuccProcess)processMap.get((Object)jpid);
                    IProcessState.ProcessState processState = jp.getProcessState();
                    switch (processState) {
                        case Starting: 
                        case Initializing: 
                        case Running: {
                            NodeIdentity nodeIdentity = jp.getNodeIdentity();
                            String key = nodeIdentity.getIp().trim();
                            Integer value = new Integer(0);
                            if (!properties.containsKey(key)) {
                                properties.put(key, value);
                            }
                            value = (Integer)properties.get(key) + (int)pShareSize;
                            properties.put(key, value);
                            break;
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return properties;
    }

    private Properties getShareMapReservations(Properties properties, int shareSize) {
        String location = "getShareMapReservations";
        try {
            DuccData duccData = DuccData.getInstance();
            DuccWorkMap duccWorkMap = duccData.getLive();
            for (DuccId reservationId : duccWorkMap.getReservationKeySet()) {
                IDuccWorkReservation reservation = (IDuccWorkReservation)duccWorkMap.findDuccWork(reservationId);
                if (!reservation.isOperational()) continue;
                IDuccReservationMap reservationMap = reservation.getReservationMap();
                for (DuccId spid : reservationMap.keySet()) {
                    IDuccReservation rs = (IDuccReservation)reservationMap.get((Object)spid);
                    NodeIdentity nodeIdentity = rs.getNodeIdentity();
                    String key = nodeIdentity.getIp().trim();
                    Integer value = new Integer(0);
                    if (!properties.containsKey(key)) {
                        properties.put(key, value);
                    }
                    int shares = rs.getShares();
                    value = (Integer)properties.get(key) + shares;
                    properties.put(key, value);
                }
            }
        }
        catch (Throwable t) {
            logger.warn(location, jobid, t, new Object[0]);
        }
        return properties;
    }

    private Properties getShareMap(int shareSize) {
        Properties properties = new Properties();
        properties = this.getShareMapJobs(properties, shareSize);
        properties = this.getShareMapServices(properties, shareSize);
        properties = this.getShareMapReservations(properties, shareSize);
        return properties;
    }

    private String getReserveSize(MachineInfo machineInfo) {
        long size = 0L;
        String reserveSize = "-";
        try {
            long sharesTotal = Long.parseLong(machineInfo.getSharesTotal());
            String ducc_rm_share_quantum = DuccPropertiesResolver.getInstance().getFileProperty("ducc.rm.share.quantum");
            if (ducc_rm_share_quantum != null && (ducc_rm_share_quantum = ducc_rm_share_quantum.trim()).length() > 0) {
                size = Long.parseLong(ducc_rm_share_quantum) * sharesTotal;
                reserveSize = "" + size;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return reserveSize;
    }

    public MachineFactsList getMachineFactsList() {
        MachineFactsList factsList = new MachineFactsList();
        ConcurrentSkipListMap<MachineInfo, String> sortedMachines = this.getSortedMachines();
        for (MachineInfo machineInfo : sortedMachines.keySet()) {
            String status = machineInfo.getStatus();
            String ip = machineInfo.getIp();
            String name = machineInfo.getName();
            String reserve = this.getReserveSize(machineInfo);
            String memory = machineInfo.getMemTotal();
            String swap = machineInfo.getMemSwap();
            List<String> aliens = machineInfo.getAliensPidsOnly();
            String sharesTotal = machineInfo.getSharesTotal();
            String sharesInuse = machineInfo.getSharesInuse();
            String heartbeat = "" + machineInfo.getElapsed();
            MachineFacts facts = new MachineFacts(status, ip, name, reserve, memory, swap, aliens, sharesTotal, sharesInuse, heartbeat);
            factsList.add((Object)facts);
        }
        return factsList;
    }
}

