/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.ws.DuccData;
import org.apache.uima.ducc.ws.JobInfo;
import org.apache.uima.ducc.ws.JobProcessInfo;
import org.apache.uima.ducc.ws.registry.ServicesRegistry;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMap;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;

public class DuccDataHelper {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccDataHelper.class.getName());
    private static DuccDataHelper duccDataHelper = new DuccDataHelper();

    public static DuccDataHelper getInstance() {
        return duccDataHelper;
    }

    public TreeMap<String, ArrayList<DuccId>> getServiceToJobsUsageMap() {
        TreeMap<String, ArrayList<DuccId>> map = new TreeMap<String, ArrayList<DuccId>>();
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> jobs = duccData.getSortedJobs();
        for (JobInfo jobInfo : jobs.descendingKeySet()) {
            DuccWorkJob job = jobInfo.getJob();
            if (!job.isOperational()) continue;
            DuccId duccId = job.getDuccId();
            String[] dependencies = job.getServiceDependencies();
            if (dependencies == null) continue;
            for (String dependency : dependencies) {
                ArrayList<DuccId> duccIds;
                if (!map.containsKey(dependency)) {
                    map.put(dependency, new ArrayList());
                }
                if ((duccIds = map.get(dependency)).contains(duccId)) continue;
                duccIds.add(duccId);
            }
        }
        return map;
    }

    private String getServiceId(DuccId serviceId) {
        String methodName = "getServiceId";
        DuccId jobid = null;
        duccLogger.trace(methodName, jobid, new Object[]{"enter"});
        String retVal = null;
        ServicesRegistry servicesRegistry = ServicesRegistry.getInstance();
        ServicesRegistryMap map = servicesRegistry.getMap();
        for (Integer key : map.getDescendingKeySet()) {
            String[] implementorsArray;
            String[] arr$;
            int len$;
            int i$;
            ServicesRegistryMapPayload payload = (ServicesRegistryMapPayload)map.get(key);
            Properties meta = payload.meta;
            String implementors = meta.getProperty("implementors");
            if (implementors == null || (i$ = 0) >= (len$ = (arr$ = (implementorsArray = implementors.trim().split(" "))).length)) continue;
            String implementor = arr$[i$];
            if (implementor.trim().equals("" + serviceId.getFriendly())) {
                // empty if block
            }
            retVal = meta.getProperty("numeric_id");
        }
        duccLogger.trace(methodName, jobid, new Object[]{"exit"});
        return retVal;
    }

    public TreeMap<String, ArrayList<String>> getServiceToServicesUsageMap() {
        String methodName = "getServiceToServicesUsageMap";
        DuccId jobid = null;
        duccLogger.trace(methodName, jobid, new Object[]{"enter"});
        TreeMap<String, ArrayList<String>> map = new TreeMap<String, ArrayList<String>>();
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> jobs = duccData.getSortedServices();
        block3: for (JobInfo jobInfo : jobs.descendingKeySet()) {
            IDuccWorkService.ServiceDeploymentType type;
            DuccWorkJob service = jobInfo.getJob();
            if (!service.isOperational() || (type = service.getServiceDeploymentType()) == null) continue;
            switch (type) {
                case uima: 
                case custom: {
                    DuccId duccId = service.getDuccId();
                    String serviceId = this.getServiceId(duccId);
                    if (serviceId == null) break;
                    String[] dependencies = service.getServiceDependencies();
                    if (dependencies == null) continue block3;
                    for (String dependency : dependencies) {
                        ArrayList<String> serviceIds;
                        if (!map.containsKey(dependency)) {
                            map.put(dependency, new ArrayList());
                        }
                        if ((serviceIds = map.get(dependency)).contains(serviceId)) continue;
                        serviceIds.add(serviceId);
                    }
                    continue block3;
                }
            }
        }
        duccLogger.trace(methodName, jobid, new Object[]{"exit"});
        return map;
    }

    public TreeMap<String, ArrayList<DuccId>> getServiceToReservationsUsageMap() {
        TreeMap<String, ArrayList<DuccId>> map = new TreeMap<String, ArrayList<DuccId>>();
        DuccData duccData = DuccData.getInstance();
        ConcurrentSkipListMap<JobInfo, JobInfo> services = duccData.getSortedServices();
        block3: for (JobInfo jobInfo : services.descendingKeySet()) {
            IDuccWorkService.ServiceDeploymentType type;
            DuccWorkJob service = jobInfo.getJob();
            if (!service.isOperational() || (type = service.getServiceDeploymentType()) == null) continue;
            switch (type) {
                case other: {
                    DuccId duccId = service.getDuccId();
                    String[] dependencies = service.getServiceDependencies();
                    if (dependencies == null) break;
                    for (String dependency : dependencies) {
                        ArrayList<DuccId> duccIds;
                        if (!map.containsKey(dependency)) {
                            map.put(dependency, new ArrayList());
                        }
                        if ((duccIds = map.get(dependency)).contains(duccId)) continue;
                        duccIds.add(duccId);
                    }
                    continue block3;
                }
            }
        }
        return map;
    }

    public ArrayList<JobProcessInfo> getJobProcessInfoList(String nodeName) {
        ArrayList<JobProcessInfo> list = new ArrayList<JobProcessInfo>();
        if (nodeName != null) {
            DuccData duccData = DuccData.getInstance();
            ConcurrentSkipListMap<JobInfo, JobInfo> jobs = duccData.getSortedJobs();
            for (JobInfo jobInfo : jobs.descendingKeySet()) {
                DuccWorkJob job = jobInfo.getJob();
                if (!job.isOperational()) continue;
                DuccId jobid = job.getDuccId();
                IDuccProcessMap map = job.getProcessMap();
                for (DuccId procid : map.keySet()) {
                    NodeIdentity nodeIdentity;
                    String procNodeName;
                    IDuccProcess proc = (IDuccProcess)map.get((Object)procid);
                    if (proc.isComplete() || (procNodeName = (nodeIdentity = proc.getNodeIdentity()).getName()) == null || !nodeName.equals(procNodeName)) continue;
                    JobProcessInfo jpi = new JobProcessInfo();
                    jpi.jobId = jobid;
                    jpi.procid = procid;
                    list.add(jpi);
                }
            }
        }
        return list;
    }

    public ArrayList<JobProcessInfo> getJobProcessIds(ArrayList<String> nodes) {
        ArrayList<JobProcessInfo> list = new ArrayList<JobProcessInfo>();
        if (nodes != null) {
            for (String node : nodes) {
                ArrayList<JobProcessInfo> listForNode = this.getJobProcessInfoList(node);
                for (JobProcessInfo jpi : listForNode) {
                    list.add(jpi);
                }
            }
        }
        return list;
    }
}

