/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.common.main;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.ducc.user.common.investment.Investment;
import org.apache.uima.ducc.user.common.main.IServiceWrapper;
import org.apache.uima.ducc.user.common.main.ServiceFactory;

public class DuccJobService {
    boolean DEBUG = false;
    private Investment investment = null;
    private Logger logger = Logger.getLogger(DuccJobService.class.getName());
    private IServiceWrapper service = null;

    public static URLClassLoader create(String classPath) throws MalformedURLException {
        return DuccJobService.create(classPath.split(":"));
    }

    public static URLClassLoader create(String[] classPathElements) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>(classPathElements.length);
        for (String element : classPathElements) {
            if (element.endsWith("*")) {
                File dir = new File(element.substring(0, element.length() - 1));
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    urlList.add(f.toURI().toURL());
                }
                continue;
            }
            File f = new File(element);
            if (!f.exists()) continue;
            urlList.add(f.toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        return new URLClassLoader(urlList.toArray(urls), ClassLoader.getSystemClassLoader().getParent());
    }

    public static void dump(ClassLoader cl, int numLevels) {
        int n = 0;
        for (URLClassLoader ucl = (URLClassLoader)cl; ucl != null && ++n <= numLevels; ucl = (URLClassLoader)ucl.getParent()) {
            System.out.println("Class-loader " + n + " has " + ucl.getURLs().length + " urls:");
            for (URL u : ucl.getURLs()) {
                System.out.println("  " + u);
            }
        }
    }

    private void addUrlsToSystemLoader(URL[] urls) throws IOException {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL url : urls) {
                method.invoke((Object)systemClassLoader, url);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    private URL[] getUrlsFromDuccClasspath(String[] duccClassPath) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>(duccClassPath.length);
        for (String element : duccClassPath) {
            if (element.endsWith("*")) {
                File dir = new File(element.substring(0, element.length() - 1));
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    urlList.add(f.toURI().toURL());
                }
                continue;
            }
            File f = new File(element);
            if (!f.exists()) continue;
            urlList.add(f.toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        return urlList.toArray(urls);
    }

    public void start(String[] args) throws Exception {
        try {
            this.investment = new Investment();
            String duccContainerClasspath = System.getProperty("ducc.deploy.DuccClasspath");
            if (duccContainerClasspath != null) {
                URL[] urls = this.getUrlsFromDuccClasspath(duccContainerClasspath.split(":"));
                this.addUrlsToSystemLoader(urls);
            }
            if (System.getProperty("ducc.debug") != null) {
                this.DEBUG = true;
            }
            if (this.DEBUG) {
                DuccJobService.dump((URLClassLoader)ClassLoader.getSystemClassLoader(), 4);
            }
            this.service = ServiceFactory.newService();
            this.service.initialize(args);
            this.service.start();
            this.logger.log(Level.INFO, "<<<<<<<< Ducc Container ended");
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "<<<<<<<< Exiting Process Due to Unrecoverable Error:", t);
            Runtime.getRuntime().halt(99);
        }
    }

    public void stop() {
        try {
            this.service.stop();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Stop failed");
        }
    }

    public static HashMap<String, String> hideLoggingProperties() {
        String[] propsToSave = new String[]{"log4j.configuration", "java.util.logging.config.file", "java.util.logging.config.class", "org.apache.uima.logger.class"};
        HashMap<String, String> savedPropsMap = new HashMap<String, String>();
        for (String prop : propsToSave) {
            String val = System.getProperty(prop);
            if (val == null) continue;
            savedPropsMap.put(prop, val);
            System.getProperties().remove(prop);
        }
        return savedPropsMap;
    }

    public static void restoreLoggingProperties(HashMap<String, String> savedPropsMap) {
        for (String prop : savedPropsMap.keySet()) {
            System.setProperty(prop, savedPropsMap.get(prop));
        }
    }

    public static void main(String[] args) {
        try {
            DuccJobService service = new DuccJobService();
            service.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

