/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.ducc.ErrorHandlerDirective;
import org.apache.uima.ducc.ErrorHandlerProgrammability;
import org.apache.uima.ducc.IErrorHandler;
import org.apache.uima.ducc.IErrorHandlerDirective;
import org.apache.uima.ducc.logger.ToLog;
import org.apache.uima.ducc.user.error.iface.Transformer;

public class ErrorHandler
implements IErrorHandler {
    private String initializationData = null;
    private ErrorHandlerProgrammability ehp = null;
    private ConcurrentHashMap<String, AtomicLong> retryMap = new ConcurrentHashMap();
    private AtomicInteger jobErrorCount = new AtomicInteger(0);

    public ErrorHandler() {
    }

    public ErrorHandler(String initializationData) {
        this.setInitializationData(initializationData);
    }

    private void setInitializationData(String value) {
        this.initializationData = value;
    }

    private String getInitializationData() {
        return this.initializationData;
    }

    @Override
    public void initialize(String initializationData) {
        this.setInitializationData(initializationData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IErrorHandlerDirective handle(String serializedCAS, Object object) {
        Class<ErrorHandler> clazz = ErrorHandler.class;
        synchronized (ErrorHandler.class) {
            if (this.ehp == null) {
                this.ehp = new ErrorHandlerProgrammability(this.getInitializationData());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ErrorHandlerDirective jdUserDirective = new ErrorHandlerDirective();
            try {
                Throwable userThrowable = null;
                if (serializedCAS != null) {
                    // empty if block
                }
                if (object != null) {
                    if (object instanceof Exception) {
                        userThrowable = (Throwable)object;
                        userThrowable.getClass();
                        ToLog.info(ErrorHandler.class, serializedCAS);
                        ToLog.warning(ErrorHandler.class, userThrowable);
                        if (serializedCAS != null) {
                            this.retryMap.putIfAbsent(serializedCAS, new AtomicLong(0L));
                            AtomicLong retryCount = this.retryMap.get(serializedCAS);
                            long count = retryCount.incrementAndGet();
                            Integer max_timeout_retrys_per_workitem = this.ehp.getInteger(ErrorHandlerProgrammability.Key.max_timeout_retrys_per_workitem);
                            if (count <= (long)max_timeout_retrys_per_workitem.intValue()) {
                                jdUserDirective.resetKillWorkItem();
                                String text = "retry # " + count + " of " + max_timeout_retrys_per_workitem + " for: " + serializedCAS;
                                ToLog.info(ErrorHandler.class, text);
                            } else {
                                this.jobErrorCount.incrementAndGet();
                            }
                        } else {
                            this.jobErrorCount.incrementAndGet();
                        }
                    } else {
                        Object byteArray = object;
                        userThrowable = Transformer.deserialize(byteArray);
                        userThrowable.getClass();
                        this.jobErrorCount.incrementAndGet();
                    }
                } else {
                    this.jobErrorCount.incrementAndGet();
                }
                Integer max_job_errors = this.ehp.getInteger(ErrorHandlerProgrammability.Key.max_job_errors);
                if (this.jobErrorCount.get() > max_job_errors) {
                    jdUserDirective.setKillJob();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("KillJob: ");
            sb.append(jdUserDirective.isKillJob());
            sb.append(" ");
            sb.append("KillProcess: ");
            sb.append(jdUserDirective.isKillProcess());
            sb.append(" ");
            sb.append("KillKillWorkItem: ");
            sb.append(jdUserDirective.isKillWorkItem());
            ToLog.info(ErrorHandler.class, sb.toString());
            return jdUserDirective;
        }
    }
}

