/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jp;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.aae.UimaASApplicationEvent;
import org.apache.uima.aae.UimaAsVersion;
import org.apache.uima.aae.client.UimaASProcessStatus;
import org.apache.uima.aae.client.UimaAsBaseCallbackListener;
import org.apache.uima.aae.monitor.statistics.AnalysisEnginePerformanceMetrics;
import org.apache.uima.adapter.jms.client.BaseUIMAAsynchronousEngine_impl;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.ducc.user.jp.ArgsParser;
import org.apache.uima.ducc.user.jp.DuccAbstractProcessContainer;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UimaASProcessContainer
extends DuccAbstractProcessContainer {
    private String endpointName;
    private String saxonURL = null;
    private String xslTransform = null;
    private static BaseUIMAAsynchronousEngine_impl uimaASClient = null;
    private static final CountDownLatch brokerLatch = new CountDownLatch(1);
    private static Object brokerInstance = null;
    private static Class<?> classToLaunch = null;
    private static volatile boolean brokerRunning = false;
    protected Object initializeMonitor = new Object();
    public volatile boolean initialized = false;
    private static final Class<?> CLASS_NAME = UimaASProcessContainer.class;
    private static final char FS = System.getProperty("file.separator").charAt(0);
    private String[] deploymentDescriptors = null;
    private String[] ids = null;
    private String duccHome = null;
    private volatile boolean threadAffinity = false;
    boolean enablePerformanceBreakdownReporting = false;

    @Override
    public boolean useThreadAffinity() {
        return this.threadAffinity;
    }

    private int generateDescriptorsAndGetScaleout(String[] args) throws Exception {
        this.deploymentDescriptors = this.getDescriptors(args);
        this.ids = new String[this.deploymentDescriptors.length];
        return this.scaleout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doInitialize(Properties props, String[] args) throws Exception {
        this.duccHome = System.getProperty("DUCC_HOME");
        String pid = this.getPID("Queue");
        this.endpointName = System.getenv("NodeName") != null ? System.getenv("NodeName") + pid : InetAddress.getLocalHost().getCanonicalHostName() + pid;
        System.setProperty("queue.name", this.endpointName);
        String jobType = System.getProperty("ducc.deploy.JpType");
        if ("uima-as".equals(jobType)) {
            System.out.println("UIMA-AS Version:" + UimaAsVersion.getFullVersionString());
        }
        if (UimaAsVersion.getMajorVersion() >= 2 && UimaAsVersion.getMinorVersion() >= 6 && UimaAsVersion.getBuildRevision() > 0) {
            this.enablePerformanceBreakdownReporting = true;
        }
        Class<UimaASProcessContainer> clazz = UimaASProcessContainer.class;
        synchronized (UimaASProcessContainer.class) {
            if (!this.initialized) {
                this.generateDescriptorsAndGetScaleout(args);
                this.initialized = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.scaleout;
        }
    }

    public byte[] getLastSerializedError() throws Exception {
        if (this.lastError != null) {
            return super.serialize(this.lastError);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeploy() throws Exception {
        Class<UimaASProcessContainer> clazz = UimaASProcessContainer.class;
        synchronized (UimaASProcessContainer.class) {
            try {
                if (brokerInstance == null) {
                    System.out.println("UIMA-AS Version::" + UimaAsVersion.getFullVersionString());
                    this.deployBroker(this.duccHome);
                    brokerRunning = true;
                    uimaASClient = new BaseUIMAAsynchronousEngine_impl();
                    int i = 0;
                    for (String dd : this.deploymentDescriptors) {
                        this.ids[i] = this.deployService(dd);
                    }
                    this.initializeUimaAsClient(this.endpointName);
                }
            }
            catch (Throwable e) {
                Logger logger = UIMAFramework.getLogger();
                logger.log(Level.WARNING, "UimaProcessContainer", e);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void dump(ClassLoader cl, int numLevels) {
        int n = 0;
        for (URLClassLoader ucl = (URLClassLoader)cl; ucl != null && ++n <= numLevels; ucl = (URLClassLoader)ucl.getParent()) {
            System.out.println("Class-loader " + n + " has " + ucl.getURLs().length + " urls:");
            for (URL u : ucl.getURLs()) {
                System.out.println("  " + u);
            }
        }
    }

    private void deployBroker(String duccHome) throws Exception {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        try {
            String[] brokerClasspath = new String[]{duccHome + File.separator + "apache-uima" + File.separator + "apache-activemq" + File.separator + "lib" + File.separator + "*", duccHome + File.separator + "apache-uima" + File.separator + "apache-activemq" + File.separator + "lib" + File.separator + "optional" + File.separator + "*"};
            URLClassLoader ucl = UimaASProcessContainer.create(brokerClasspath);
            Thread.currentThread().setContextClassLoader(ucl);
            classToLaunch = ucl.loadClass("org.apache.activemq.broker.BrokerService");
            UimaASProcessContainer.dump(ucl, 4);
            brokerInstance = classToLaunch.newInstance();
            Method setDedicatedTaskRunnerMethod = classToLaunch.getMethod("setDedicatedTaskRunner", Boolean.TYPE);
            setDedicatedTaskRunnerMethod.invoke(brokerInstance, false);
            Method setPersistentMethod = classToLaunch.getMethod("setPersistent", Boolean.TYPE);
            setPersistentMethod.invoke(brokerInstance, false);
            int port = 61626;
            String brokerURL = "tcp://localhost:";
            while (true) {
                try {
                    Method addConnectorMethod = classToLaunch.getMethod("addConnector", String.class);
                    addConnectorMethod.invoke(brokerInstance, brokerURL + port);
                    Method startMethod = classToLaunch.getMethod("start", new Class[0]);
                    startMethod.invoke(brokerInstance, new Object[0]);
                    Method waitUntilStartedMethod = classToLaunch.getMethod("waitUntilStarted", new Class[0]);
                    waitUntilStartedMethod.invoke(brokerInstance, new Object[0]);
                    System.setProperty("DefaultBrokerURL", brokerURL + port);
                    System.setProperty("BrokerURI", brokerURL + port);
                    System.setProperty("broker.name", brokerURL + port);
                }
                catch (Exception e) {
                    if (this.isBindException(e)) {
                        ++port;
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
            brokerLatch.countDown();
        }
    }

    private boolean isBindException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof BindException) {
            return true;
        }
        if (e instanceof SocketException && "Address already in use".equals(e.getMessage())) {
            return true;
        }
        if (e.getCause() != null) {
            return this.isBindException(e.getCause());
        }
        return false;
    }

    public static URLClassLoader create(String[] classPathElements) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>(classPathElements.length);
        for (String element : classPathElements) {
            if (element.endsWith("*")) {
                File dir = new File(element.substring(0, element.length() - 1));
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    urlList.add(f.toURI().toURL());
                }
                continue;
            }
            File f = new File(element);
            if (!f.exists()) continue;
            urlList.add(f.toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        return new URLClassLoader(urlList.toArray(urls), ClassLoader.getSystemClassLoader().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        Class<UimaASProcessContainer> clazz = UimaASProcessContainer.class;
        synchronized (UimaASProcessContainer.class) {
            if (brokerRunning) {
                System.out.println("Stopping UIMA_AS Client");
                try {
                    System.setProperty("dontKill", "true");
                    uimaASClient.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("Stopping Broker");
                Method stopMethod = classToLaunch.getMethod("stop", new Class[0]);
                stopMethod.invoke(brokerInstance, new Object[0]);
                Method waitMethod = classToLaunch.getMethod("waitUntilStopped", new Class[0]);
                waitMethod.invoke(brokerInstance, new Object[0]);
                brokerRunning = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
        }
        {
            return;
        }
    }

    @Override
    public List<Properties> doProcess(Object xmi) throws Exception {
        CAS cas = uimaASClient.getCAS();
        try {
            this.lastError = null;
            XmiSerializationSharedData deserSharedData = new XmiSerializationSharedData();
            super.getUimaSerializer().deserializeCasFromXmi((String)xmi, cas, deserSharedData, true, -1);
            ArrayList<Properties> metricsList = new ArrayList<Properties>();
            if (this.enablePerformanceBreakdownReporting) {
                ArrayList perfMetrics = new ArrayList();
                uimaASClient.sendAndReceiveCAS(cas, perfMetrics);
                for (AnalysisEnginePerformanceMetrics metrics : perfMetrics) {
                    Properties p = new Properties();
                    p.setProperty("name", metrics.getName());
                    p.setProperty("uniqueName", metrics.getUniqueName());
                    p.setProperty("analysisTime", String.valueOf(metrics.getAnalysisTime()));
                    p.setProperty("numProcessed", String.valueOf(metrics.getNumProcessed()));
                    System.out.println("... Metrics - AE:" + metrics.getName() + " AE Analysis Time:" + metrics.getAnalysisTime());
                    metricsList.add(p);
                }
            } else {
                uimaASClient.sendAndReceiveCAS(cas);
                Properties p = new Properties();
                p.setProperty("name", "Performance Metrics Not Supported For DD Jobs and UIMA-AS <= v2.6.0 ");
                p.setProperty("uniqueName", "Performance Metrics Not Supported For DD Jobs and UIMA-AS <= v2.6.0 ");
                p.setProperty("analysisTime", "0");
                p.setProperty("numProcessed", "0");
                metricsList.add(p);
            }
            ArrayList<Properties> arrayList = metricsList;
            return arrayList;
        }
        catch (Throwable e) {
            this.lastError = e;
            Logger logger = UIMAFramework.getLogger();
            logger.log(Level.WARNING, "UimaProcessContainer", e);
            e.printStackTrace();
            throw new AnalysisEngineProcessException();
        }
        finally {
            if (cas != null) {
                cas.release();
            }
        }
    }

    private String getPID(String fallback) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pos = name.indexOf(64);
        if (pos < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(name.substring(0, pos)));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    private void initializeUimaAsClient(String endpoint) throws Exception {
        String brokerURL = System.getProperty("DefaultBrokerURL");
        HashMap<String, Object> appCtx = new HashMap<String, Object>();
        appCtx.put("ServerURI", brokerURL);
        appCtx.put("Endpoint", endpoint);
        appCtx.put("CasPoolSize", this.scaleout);
        appCtx.put("Timeout", 0);
        appCtx.put("GetMetaTimeout", 0);
        appCtx.put("CpcTimeout", 1100);
        UimaAsTestCallbackListener listener = new UimaAsTestCallbackListener();
        uimaASClient.addStatusCallbackListener((UimaAsBaseCallbackListener)listener);
        uimaASClient.initialize(appCtx);
        this.waitUntilInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilInitialized() throws Exception {
        Object object = this.initializeMonitor;
        synchronized (object) {
            while (!this.initialized) {
                this.initializeMonitor.wait();
            }
        }
    }

    private String deployService(String aDeploymentDescriptorPath) throws Exception {
        HashMap<String, Object> appCtx = new HashMap<String, Object>();
        appCtx.put("DD2SpringXsltFilePath", this.xslTransform.replace('/', FS));
        appCtx.put("SaxonClasspath", this.saxonURL.replace('/', FS));
        appCtx.put("CasPoolSize", this.scaleout);
        String containerId = null;
        System.out.println("---------------- BROKER URL:::" + System.getProperty("broker.name"));
        ClassLoader duccCl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        containerId = uimaASClient.deploy(aDeploymentDescriptorPath, appCtx);
        Thread.currentThread().setContextClassLoader(duccCl);
        return containerId;
    }

    private String[] getDescriptors(String[] args) throws Exception {
        UIMAFramework.getLogger(CLASS_NAME).log(Level.INFO, "UIMA-AS version " + UimaAsVersion.getFullVersionString());
        int nbrOfArgs = args.length;
        String[] deploymentDescriptors = ArgsParser.getMultipleArg("-d", args);
        if (deploymentDescriptors.length == 0) {
            deploymentDescriptors = ArgsParser.getMultipleArg2("-dd", args);
        }
        this.saxonURL = ArgsParser.getArg("-saxonURL", args);
        this.xslTransform = ArgsParser.getArg("-xslt", args);
        this.endpointName = ArgsParser.getArg("-q", args);
        if (nbrOfArgs < 1 || deploymentDescriptors.length == 0 || this.saxonURL.equals("") || this.xslTransform.equals("")) {
            UimaASProcessContainer.printUsageMessage();
            return null;
        }
        this.parseDD(deploymentDescriptors[0]);
        return deploymentDescriptors;
    }

    public void parseDD(String ddPath) throws Exception {
        SAXParserFactory parserFactor = SAXParserFactory.newInstance();
        SAXParser parser = parserFactor.newSAXParser();
        SAXHandler handler = new SAXHandler();
        parser.parse(new File(ddPath), (DefaultHandler)handler);
    }

    protected void finalize() {
        System.err.println(this + " finalized");
    }

    private static void printUsageMessage() {
        System.out.println(" Arguments to the program are as follows : \n-d path-to-UIMA-Deployment-Descriptor [-d path-to-UIMA-Deployment-Descriptor ...] \n-saxon path-to-saxon.jar \n-q top level service queue name \n-xslt path-to-dd2spring-xslt\n   or\npath to Spring XML Configuration File which is the output of running dd2spring\n");
    }

    protected class UimaAsTestCallbackListener
    extends UimaAsBaseCallbackListener {
        protected UimaAsTestCallbackListener() {
        }

        public void onBeforeProcessCAS(UimaASProcessStatus status, String nodeIP, String pid) {
        }

        public synchronized void onBeforeMessageSend(UimaASProcessStatus status) {
        }

        public void onUimaAsServiceExit(UimaASApplicationEvent.EventTrigger cause) {
            System.out.println("runTest: Received onUimaAsServiceExit() Notification With Cause:" + cause.name());
        }

        public synchronized void entityProcessComplete(CAS aCAS, EntityProcessStatus aProcessStatus, List<AnalysisEnginePerformanceMetrics> componentMetricsList) {
        }

        public synchronized void entityProcessComplete(CAS aCAS, EntityProcessStatus aProcessStatus) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initializationComplete(EntityProcessStatus aStatus) {
            Object object = UimaASProcessContainer.this.initializeMonitor;
            synchronized (object) {
                UimaASProcessContainer.this.initialized = true;
                UimaASProcessContainer.this.initializeMonitor.notifyAll();
            }
        }

        public void collectionProcessComplete(EntityProcessStatus aStatus) {
        }
    }

    class SAXHandler
    extends DefaultHandler {
        String content = null;

        SAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("inputQueue")) {
                UimaASProcessContainer.this.endpointName = attributes.getValue("endpoint");
            } else if (qName.equals("scaleout")) {
                UimaASProcessContainer.this.scaleout = Integer.parseInt(attributes.getValue("numberOfInstances"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }
}

