/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.dispatcher;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class ProcessStateDispatcher {
    private Socket connectWithAgent() throws Exception {
        InetAddress host = null;
        int statusUpdatePort = -1;
        host = InetAddress.getLocalHost();
        String port = System.getenv("DUCC_STATE_UPDATE_PORT");
        if (port != null) {
            try {
                statusUpdatePort = Integer.valueOf(port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String localhost = null;
        return new Socket(localhost, statusUpdatePort);
    }

    public void sendStateUpdate(String state) throws Exception {
        FilterOutputStream out = null;
        Socket socket = null;
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("DUCC_PROCESS_UNIQUEID=").append(System.getenv("DUCC_PROCESS_UNIQUEID")).append(",");
            sb.append("DUCC_PROCESS_STATE=").append(state);
            socket = this.connectWithAgent();
            out = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)out).writeUTF(sb.toString());
            ((DataOutputStream)out).flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (socket != null) {
                socket.close();
            }
        }
    }
}

