/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.service;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.component.IJobProcessor;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.configuration.jp.AgentSession;
import org.apache.uima.ducc.transport.configuration.service.ServiceConfiguration;
import org.apache.uima.ducc.transport.event.common.IProcessState;

public class ServiceComponent
extends AbstractDuccComponent
implements IJobProcessor {
    private static final String SERVICE_JMX_PORT = "SERVICE_JMX_PORT=";
    private static final String SERVICE_UNIQUE_ID = "DUCC_PROCESS_UNIQUEID=";
    private static final String SERVICE_STATE = "DUCC_PROCESS_STATE=";
    private static final String SERVICE_DATA = "SERVICE_DATA=";
    private static final String SEPARATOR = ",";
    ScheduledThreadPoolExecutor executor = null;
    private String jmxConnectString = "";
    protected IProcessState.ProcessState currentState = IProcessState.ProcessState.Undefined;
    protected IProcessState.ProcessState previousState = IProcessState.ProcessState.Undefined;
    protected static DuccLogger logger = new DuccLogger(ServiceComponent.class);
    protected String saxonJarPath;
    protected String dd2SpringXslPath;
    protected String dd;
    private Object processorInstance = null;
    private CountDownLatch exitLatch = new CountDownLatch(1);
    private Lock stateLock = new ReentrantLock();

    public ServiceComponent(String componentName, CamelContext ctx, ServiceConfiguration jpc) {
        super(componentName, ctx);
        this.jmxConnectString = super.getProcessJmxUrl();
    }

    public void setProcessor(Object pc, String[] args) {
        this.processorInstance = pc;
    }

    public void setState(IProcessState.ProcessState state) {
        try {
            this.stateLock.lock();
            if (this.currentState.name().equals(IProcessState.ProcessState.FailedInitialization.name())) {
                return;
            }
            if (!state.name().equals(this.currentState.name())) {
                this.currentState = state;
                this.sendStateUpdate(state.name(), new Properties());
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private Socket connect() throws IOException {
        int statusUpdatePort = -1;
        String port = System.getenv("DUCC_STATE_UPDATE_PORT");
        try {
            statusUpdatePort = Integer.valueOf(port);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        logger.info("connect", null, new Object[]{"Service Connecting Socket to localhost Monitor on port:" + statusUpdatePort + " service jmx url:" + super.getProcessJmxUrl()});
        String localhost = null;
        return new Socket(localhost, statusUpdatePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateUpdate(String state, Properties additionalData) {
        FilterOutputStream out = null;
        Socket socket = null;
        if (System.getenv("DUCC_STATE_UPDATE_PORT") == null) {
            return;
        }
        try {
            socket = this.connect();
            if (socket == null) {
                return;
            }
            if (additionalData == null) {
                additionalData = new Properties();
            }
            StringBuilder sb = new StringBuilder().append(SERVICE_UNIQUE_ID).append(System.getenv("DUCC_PROCESS_UNIQUEID")).append(SEPARATOR).append(SERVICE_STATE).append(state);
            if (super.getProcessJmxUrl() != null && !super.getProcessJmxUrl().trim().isEmpty()) {
                sb.append(SEPARATOR).append(SERVICE_JMX_PORT).append(super.getProcessJmxUrl().trim());
            }
            out = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)out).writeUTF(sb.toString());
            ((DataOutputStream)out).flush();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void setDD(String dd) {
        this.dd = dd;
    }

    public void setDd2SpringXslPath(String dd2SpringXslPath) {
        this.dd2SpringXslPath = dd2SpringXslPath;
    }

    public void setSaxonJarPath(String saxonJarPath) {
        this.saxonJarPath = saxonJarPath;
    }

    protected void setAgentSession(AgentSession session) {
    }

    public String getProcessJmxUrl() {
        return this.jmxConnectString;
    }

    public DuccLogger getLogger() {
        return logger;
    }

    public void start(DuccService service, String[] args) throws Exception {
        super.start(service, args);
        if (args == null || args.length == 0 || args[0] == null || args[0].trim().length() == 0) {
            logger.warn("start", null, new Object[]{"Missing Deployment Descriptor - Service Requires argument. Add DD for UIMA-AS job"});
            throw new RuntimeException("Missing Deployment Descriptor - Service Requires argument. Add DD for UIMA-AS job");
        }
        String processJmxUrl = super.getProcessJmxUrl();
        this.sendStateUpdate(IProcessState.ProcessState.Initializing.name(), new Properties());
        try {
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.prestartAllCoreThreads();
            String[] jpArgs = new String[]{"-dd", args[0], "-saxonURL", this.saxonJarPath, "-xslt", this.dd2SpringXslPath};
            Properties props = new Properties();
            Method initMethod = this.processorInstance.getClass().getSuperclass().getDeclaredMethod("initialize", Properties.class, String[].class);
            initMethod.invoke(this.processorInstance, props, jpArgs);
            System.out.println("JMX Connect String:" + processJmxUrl);
            Method deployMethod = this.processorInstance.getClass().getSuperclass().getDeclaredMethod("deploy", new Class[0]);
            deployMethod.invoke(this.processorInstance, new Object[0]);
            this.getLogger().info("start", null, new Object[]{".... Deployed Processing Container - Initialization Successful - Thread " + Thread.currentThread().getId()});
            if (!this.currentState.equals((Object)IProcessState.ProcessState.FailedInitialization)) {
                this.currentState = IProcessState.ProcessState.Running;
                this.sendStateUpdate(this.currentState.name(), new Properties());
                this.exitLatch.await();
            }
        }
        catch (Exception ee) {
            this.getLogger().error("start", null, (Throwable)ee, new Object[0]);
            this.currentState = IProcessState.ProcessState.FailedInitialization;
            this.getLogger().info("start", null, new Object[]{">>> Failed to Deploy UIMA Service. Check UIMA Log for Details"});
            this.sendStateUpdate(IProcessState.ProcessState.FailedInitialization.name(), new Properties());
            Runtime.getRuntime().halt(0);
        }
    }

    public void setRunning() {
        this.currentState = IProcessState.ProcessState.Running;
    }

    public boolean isRunning() {
        return this.currentState.equals((Object)IProcessState.ProcessState.Running);
    }

    public void stop() {
        this.currentState = IProcessState.ProcessState.Stopping;
        this.sendStateUpdate(this.currentState.name(), new Properties());
        if (super.isStopping()) {
            return;
        }
        this.getLogger().info("stop", null, new Object[]{"... ServiceComponent - Stopping Service Adapter"});
        try {
            this.exitLatch.countDown();
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
        catch (Exception e) {
            this.getLogger().error("stop", null, (Throwable)e, new Object[0]);
        }
        finally {
            try {
                Method stopMethod = this.processorInstance.getClass().getSuperclass().getDeclaredMethod("stop", new Class[0]);
                stopMethod.invoke(this.processorInstance, new Object[0]);
                super.stop();
            }
            catch (Exception exception) {}
        }
    }

    public void resetInvestment(String key) throws Exception {
    }
}

