/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.user.common.QuotedOptions;

class ServiceInstance
implements SmConstants {
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    long numeric_id = -1L;
    long share_id;
    int instance_id = 0;
    String host;
    ServiceSet sset;
    IDuccState.JobState state = IDuccState.JobState.Undefined;
    String user = null;
    boolean stopped;
    String ducc_home = System.getProperty(IDuccUser.EnvironmentVariable.DUCC_HOME.value());
    String api_classpath = this.ducc_home + "/lib/uima-ducc-cli.jar:" + System.getProperty("java.class.path");
    ArrayList<String> stdout_lines = new ArrayList();
    ArrayList<String> stderr_lines = new ArrayList();

    ServiceInstance(ServiceSet sset) {
        this.sset = sset;
        this.stopped = true;
        this.share_id = -1L;
        this.host = "<unknown>";
    }

    public int getInstanceId() {
        return this.instance_id;
    }

    public void setInstanceId(int id) {
        this.instance_id = id;
    }

    public long getId() {
        return this.numeric_id;
    }

    void setId(long id) {
        this.numeric_id = id;
    }

    public long getShareId() {
        return this.share_id;
    }

    public String getHost() {
        return this.host;
    }

    void setUser(String user) {
        this.user = user;
    }

    public void setState(IDuccState.JobState state) {
        this.state = state;
    }

    public IDuccState.JobState getState() {
        return this.state;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized boolean isRunning() {
        switch (this.state) {
            case Completing: 
            case Completed: {
                return false;
            }
        }
        return !this.isStopped();
    }

    synchronized void update(long share_id, String host) {
        this.share_id = share_id;
        this.host = host;
    }

    synchronized void setStopped(boolean s) {
        this.stopped = s;
    }

    String[] genArgs(DuccProperties props) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(System.getProperty("ducc.agent.launcher.ducc_spawn_path"));
        args.add("-u");
        args.add(this.user);
        args.add("--");
        args.add(System.getProperty("ducc.jvm"));
        args.add("-cp");
        args.add(this.api_classpath);
        args.add("org.apache.uima.ducc.cli.DuccServiceSubmit");
        args.add("--service_id");
        args.add(this.sset.getId().toString());
        Enumeration keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            String v = (String)props.get((Object)k);
            args.add("--" + k);
            if (k.equals("debug")) continue;
            args.add(v);
        }
        return args.toArray(new String[args.size()]);
    }

    long start(DuccProperties svc_props, DuccProperties meta_props) {
        List<String> envList;
        Map envMap;
        String umask;
        String methodName = "start";
        this.logger.info(methodName, this.sset.getId(), new Object[]{"START INSTANCE"});
        this.setStopped(false);
        this.user = meta_props.getProperty(IStateServices.SvcMetaProps.user.pname());
        String[] args = this.genArgs(svc_props);
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && args[i - 1].equals("-cp")) {
                this.logger.debug(methodName, this.sset.getId(), new Object[]{"Args[", i, "]: <CLASSPATH>"});
                continue;
            }
            this.logger.debug(methodName, this.sset.getId(), new Object[]{"Args[", i, "]:", args[i]});
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        StdioListener sin_listener = null;
        StdioListener ser_listener = null;
        Map<String, String> env = pb.environment();
        env.put(IDuccUser.EnvironmentVariable.DUCC_HOME.value(), System.getProperty(IDuccUser.EnvironmentVariable.DUCC_HOME.value()));
        env.put(IDuccUser.EnvironmentVariable.DUCC_ID_SERVICE.value(), Integer.toString(this.instance_id));
        String runmode = DuccPropertiesResolver.get((String)"ducc.runmode");
        if (runmode != null && runmode.equals("Test")) {
            env.put(IDuccUser.EnvironmentVariable.USER.value(), this.user);
        }
        String umaskKey = "DUCC_UMASK";
        String envValue = svc_props.getProperty(IStateServices.SvcRegProps.environment.pname());
        if (envValue != null && (umask = (String)(envMap = QuotedOptions.parseAssignments(envList = Arrays.asList(envValue.split("\\s+")), (int)0)).get("DUCC_UMASK")) != null) {
            env.put("DUCC_UMASK", umask);
        }
        try {
            Process p = pb.start();
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            sin_listener = new StdioListener(1, stdout);
            ser_listener = new StdioListener(2, stderr);
            Thread sol = new Thread(sin_listener);
            Thread sel = new Thread(ser_listener);
            sol.start();
            sel.start();
            int rc = p.waitFor();
            this.logger.debug(methodName, null, new Object[]{"DuccServiceSubmit returns with rc", rc});
            sin_listener.stop();
            ser_listener.stop();
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), t, new Object[0]);
            try {
                this.sset.setErrorString(t.toString());
            }
            catch (Exception e) {
                this.logger.warn(methodName, this.sset.getId(), new Object[]{"Error updating meta properties:", e});
            }
            return -1L;
        }
        for (String s : this.stderr_lines) {
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Start stderr:", s});
        }
        boolean inhibit_cp = false;
        boolean started = false;
        StringBuffer submit_buffer = new StringBuffer();
        boolean recording = false;
        for (String s : this.stdout_lines) {
            if (inhibit_cp) {
                inhibit_cp = false;
                this.logger.info(methodName, this.sset.getId(), new Object[]{"<INHIBITED CP>"});
            } else {
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Start stdout:", s});
            }
            if (s.indexOf("-cp") >= 0) {
                inhibit_cp = true;
            }
            if (recording) {
                submit_buffer.append(s.trim());
                submit_buffer.append(";");
            }
            if (s.startsWith("1001 Command launching...")) {
                recording = true;
                continue;
            }
            if (!s.startsWith("Service") || !s.endsWith("submitted")) continue;
            String[] toks = s.split("\\s");
            try {
                this.numeric_id = Long.parseLong(toks[2]);
                started = true;
                this.logger.info(methodName, null, new Object[]{"Request to start service " + this.sset.getId().toString() + " accepted as service instance ", this.numeric_id});
            }
            catch (NumberFormatException e) {
                try {
                    this.sset.setErrorString("Request to start service " + this.sset.getId().toString() + " failed, can't interpret submit response.: " + s);
                }
                catch (Exception ee) {
                    this.logger.warn(methodName, this.sset.getId(), new Object[]{"Error updating meta properties:", ee});
                }
                this.logger.warn(methodName, null, new Object[]{"Request to start service " + this.sset.getId().toString() + " failed, can't interpret response.: " + s});
            }
        }
        if (!started) {
            this.logger.warn(methodName, this.sset.getId(), new Object[]{"Request to start service " + this.sset.getId().toString() + " failed."});
            meta_props.put((Object)IStateServices.SvcMetaProps.submit_error.pname(), (Object)submit_buffer.toString());
            this.sset.log_errors(this.stdout_lines, this.stderr_lines);
        } else {
            meta_props.remove((Object)IStateServices.SvcMetaProps.submit_error.pname());
            this.state = IDuccState.JobState.Received;
        }
        this.logger.info(methodName, this.sset.getId(), new Object[]{"START INSTANCE COMPLETE"});
        this.stdout_lines.clear();
        this.stderr_lines.clear();
        return this.numeric_id;
    }

    void stop() {
        String methodName = "stop";
        String service_id = this.sset.getId().toString();
        String service_endpoint = this.sset.getEndpoint();
        this.setStopped(true);
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "--", System.getProperty("ducc.jvm"), "-cp", this.api_classpath, "org.apache.uima.ducc.cli.DuccServiceCancel", "--id", Long.toString(this.numeric_id), "--service_id", service_id, "--service_request_endpoint", service_endpoint};
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && args[i - 1].equals("-cp")) {
                this.logger.debug(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "Args[", i, "]: <CLASSPATH>"});
                continue;
            }
            this.logger.debug(methodName, this.sset.getId(), new Object[]{"Instance", this.numeric_id, "Args[", i, "]:", args[i]});
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put(IDuccUser.EnvironmentVariable.DUCC_HOME.value(), System.getProperty(IDuccUser.EnvironmentVariable.DUCC_HOME.value()));
        String runmode = DuccPropertiesResolver.get((String)"ducc.runmode");
        if (runmode != null && runmode.equals("Test")) {
            env.put(IDuccUser.EnvironmentVariable.USER.value(), this.user);
        }
        pb.redirectOutput(new File("/dev/null"));
        pb.redirectError(new File("/dev/null"));
        int rc = 0;
        try {
            Process p = pb.start();
            rc = p.waitFor();
            this.logger.info(methodName, this.sset.getId(), new Object[]{"DuccServiceCancel returns with rc", rc});
        }
        catch (Throwable t) {
            this.logger.error(methodName, null, t, new Object[0]);
        }
    }

    class StdioListener
    implements Runnable {
        InputStream in;
        String tag;
        boolean done = false;
        int which = 0;
        boolean ignore = false;

        StdioListener(int which, InputStream in, boolean ignore) {
            this.in = in;
            this.which = which;
            switch (which) {
                case 1: {
                    this.tag = "STDOUT: ";
                    break;
                }
                case 2: {
                    this.tag = "STDERR: ";
                }
            }
            this.ignore = ignore;
            this.ignore = ignore;
        }

        StdioListener(int which, InputStream in) {
            this(which, in, false);
        }

        void stop() {
            this.done = true;
        }

        @Override
        public void run() {
            long tid = Thread.currentThread().getId();
            String methodName = "SvcSubmit[" + tid + "]";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                while (true) {
                    if (this.done) {
                        return;
                    }
                    String s = br.readLine();
                    if (ServiceInstance.this.logger.isTrace()) {
                        ServiceInstance.this.logger.trace(methodName, ServiceInstance.this.sset.getId(), new Object[]{"[]", this.tag, s});
                    }
                    if (s == null) {
                        String msg = this.tag + "closed, listener returns";
                        ServiceInstance.this.logger.info(methodName, ServiceInstance.this.sset.getId(), new Object[]{msg});
                        return;
                    }
                    if (this.ignore) continue;
                    switch (this.which) {
                        case 1: {
                            ServiceInstance.this.stdout_lines.add(s);
                            break;
                        }
                        case 2: {
                            ServiceInstance.this.stderr_lines.add(s);
                        }
                    }
                }
            }
            catch (Exception e) {
                ServiceInstance.this.logger.error(methodName, ServiceInstance.this.sset.getId(), (Throwable)e, new Object[0]);
                return;
            }
        }
    }
}

