/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm.config;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.model.RouteDefinition;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.event.ServiceManagerEventListener;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.event.AServiceRequest;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class ServiceManagerConfiguration {
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration serviceManagerTransport;
    private DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"SM");

    public ServiceManagerEventListener serviceManagerDelegateListener(ServiceManagerComponent sm) {
        ServiceManagerEventListener smel = new ServiceManagerEventListener(sm);
        smel.setEndpoint(this.common.pmRequestEndpoint);
        return smel;
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String endpoint, final ServiceManagerEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(endpoint).process((Processor)new TransportProcessor())).bean((Object)delegate);
            }
        };
    }

    private RouteBuilder routeBuilderForJetty(final CamelContext context, final ServiceManagerEventListener delegate) throws Exception {
        return new RouteBuilder(){

            public void configure() {
                JettyHttpComponent jettyComponent = new JettyHttpComponent();
                String port = System.getProperty("ducc.sm.http.port");
                context.addComponent("jetty", (Component)jettyComponent);
                this.onException(Throwable.class).maximumRedeliveries(0).handled(false).process((Processor)new ErrorProcessor());
                ((RouteDefinition)((RouteDefinition)this.from("jetty://http://0.0.0.0:" + port + "/sm").unmarshal().xstream().bean((Object)delegate)).process((Processor)new SmReplyProcessor())).process((Processor)new JettyReplyProcessor());
            }
        };
    }

    @Bean
    public ServiceManagerComponent serviceManager() throws Exception {
        ServiceManagerComponent sm = new ServiceManagerComponent(this.common.camelContext());
        ServiceManagerEventListener delegateListener = this.serviceManagerDelegateListener(sm);
        sm.setTransportConfiguration(this.serviceManagerTransport.duccEventDispatcher(this.common.smStateUpdateEndpoint, sm.getContext()), this.common.smStateUpdateEndpoint);
        sm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.orchestratorStateUpdateEndpoint, delegateListener));
        sm.getContext().addRoutes((RoutesBuilder)this.routeBuilderForJetty(sm.getContext(), delegateListener));
        return sm;
    }

    public class TransportProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            try {
                ServiceManagerConfiguration.this.logger.error("ErrorProcessor.process", null, caused, new Object[0]);
                exchange.getOut().setBody((Object)XStreamUtils.marshall((Object)caused));
            }
            catch (Throwable t) {
                ServiceManagerConfiguration.this.logger.error("ErrorProcessor.process", null, t, new Object[0]);
            }
        }
    }

    private class JettyReplyProcessor
    implements Processor {
        private JettyReplyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)200);
            exchange.getOut().setHeader("content-type", (Object)"text/xml");
            Object o = exchange.getIn().getBody();
            if (o != null) {
                String body = XStreamUtils.marshall((Object)o);
                exchange.getOut().setBody((Object)body);
                exchange.getOut().setHeader("content-length", (Object)body.length());
            } else {
                ServiceManagerConfiguration.this.logger.warn("RouteBuilder.configure", null, (Throwable)new DuccRuntimeException("No reply object was provided."), new Object[0]);
                exchange.getOut().setHeader("CamelHttpResponseCode", (Object)500);
            }
        }
    }

    private class SmReplyProcessor
    implements Processor {
        private SmReplyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String methodName = "process";
            try {
                ServiceManagerConfiguration.this.logger.info(methodName, null, new Object[]{"Replying"});
                AServiceRequest incoming = (AServiceRequest)exchange.getIn().getBody();
                ServiceReplyEvent reply = incoming.getReply();
                exchange.getIn().setBody((Object)reply);
            }
            catch (Throwable t) {
                ServiceManagerConfiguration.this.logger.error(methodName, null, t, new Object[0]);
            }
        }
    }
}

