/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.UimaAsPing;
import org.apache.uima.ducc.cli.UimaAsServiceMonitor;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.TcpStreamHandler;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.sm.IServiceMeta;
import org.apache.uima.ducc.sm.PingDriver;
import org.apache.uima.ducc.sm.PingOnlyServiceInstance;
import org.apache.uima.ducc.sm.ServiceHandler;
import org.apache.uima.ducc.sm.ServiceInstance;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceDescription;
import org.apache.uima.ducc.transport.event.sm.ServiceDescription;
import org.apache.uima.util.Level;

public class ServiceSet
implements SmConstants {
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    private ServiceHandler handler;
    Map<Long, ServiceInstance> implementors = new HashMap<Long, ServiceInstance>();
    TreeMap<Integer, Integer> available_instance_ids = new TreeMap();
    Map<Long, Integer> pending_instances = new HashMap<Long, Integer>();
    Map<DuccId, DuccId> references = new HashMap<DuccId, DuccId>();
    DuccId id;
    HashMap<Long, DuccId> friendly_ids = new HashMap();
    String history_key = "work-instances";
    String implementors_key = "implementors";
    List<ServiceSet> predecessors = new ArrayList<ServiceSet>();
    List<ServiceSet> successors = new ArrayList<ServiceSet>();
    String key;
    String endpoint;
    String broker;
    String broker_host;
    int broker_port;
    int broker_jmx_port = 1099;
    String[] independentServices = null;
    String user;
    boolean autostart = false;
    boolean enabled = true;
    boolean started = false;
    boolean reference_start = false;
    boolean ping_only = false;
    boolean process_debug = false;
    long last_use = 0L;
    long last_ping = 0L;
    long last_runnable = 0L;
    int instances = 1;
    int registered_instances;
    IServiceMeta serviceMeta = null;
    private DuccProperties job_props = null;
    String props_filename = null;
    String props_filename_temp = null;
    File props_file;
    File props_file_temp;
    private DuccProperties meta_props = null;
    String meta_filename = null;
    String meta_filename_temp = null;
    File meta_file;
    File meta_file_temp;
    boolean deregistered = false;
    IService.ServiceType service_type = IService.ServiceType.Undefined;
    IService.ServiceClass service_class = IService.ServiceClass.Undefined;
    IService.ServiceState service_state = IService.ServiceState.Stopped;
    Timer timer = null;
    LingerTask linger = null;
    long linger_time = 60000L;
    int init_failure_max = ServiceManagerComponent.init_failure_max;
    int init_failures = 0;
    int ping_failure_max = ServiceManagerComponent.failure_max;
    int ping_failures = 0;
    int run_failures = 0;
    boolean excessiveRunFailures = false;
    boolean inShutdown = false;
    String[] coOwners = null;
    Map<Long, ServiceInstance> pendingImplementors = new HashMap<Long, ServiceInstance>();

    public ServiceSet(ServiceHandler handler, DuccId id, String props_filename, String meta_filename, DuccProperties props, DuccProperties meta) {
        String adm;
        this.handler = handler;
        this.job_props = props;
        this.meta_props = meta;
        this.id = id;
        this.props_filename = props_filename;
        this.props_filename_temp = props_filename + ".tmp";
        this.props_file = new File(props_filename);
        this.props_file_temp = new File(this.props_filename_temp);
        this.meta_filename = meta_filename;
        this.meta_filename_temp = meta_filename + ".tmp";
        this.meta_file = new File(meta_filename);
        this.meta_file_temp = new File(this.meta_filename_temp);
        this.service_state = IService.ServiceState.Stopped;
        this.linger_time = props.getLongProperty(IUiOptions.UiOption.ServiceLinger.pname(), this.linger_time);
        this.key = meta.getProperty("endpoint");
        this.parseEndpoint(this.key);
        this.user = meta.getProperty("user");
        this.registered_instances = this.instances = meta.getIntProperty("instances", 1);
        this.autostart = meta.getBooleanProperty("autostart", false);
        this.ping_only = meta.getBooleanProperty("ping-only", false);
        this.enabled = meta.getBooleanProperty("enabled", this.enabled);
        this.service_class = IService.ServiceClass.Registered;
        this.init_failure_max = props.getIntProperty("instance_init_failures_limit", this.init_failure_max);
        this.reference_start = meta.getBooleanProperty("reference", this.reference_start);
        if (props.containsKey((Object)IUiOptions.UiOption.ProcessDebug.pname())) {
            this.process_debug = true;
        }
        if (props.containsKey((Object)IUiOptions.UiOption.Administrators.pname()) && (adm = props.getProperty(IUiOptions.UiOption.Administrators.pname())) != null) {
            this.coOwners = adm.split("\\s+");
        }
        this.parseIndependentServices();
        this.meta_props.remove((Object)"references");
        this.meta_props.remove((Object)"stopped");
        this.meta_props.put((Object)"service-class", (Object)("" + this.service_class.decode()));
        this.meta_props.put((Object)"service-type", (Object)("" + this.service_type.decode()));
        this.meta_props.put((Object)"enabled", (Object)("" + this.enabled));
        this.meta_props.put((Object)"service-state", (Object)("" + this.getState()));
        this.meta_props.put((Object)"ping-active", (Object)"false");
        this.meta_props.put((Object)"service-alive", (Object)"false");
        this.meta_props.put((Object)"service-healthy", (Object)"false");
        this.meta_props.put((Object)"service-statistics", (Object)"N/A");
        this.setReferenced(this.reference_start);
        this.setLastUse(this.meta_props.getLongProperty("last-use", 0L));
        this.setLastPing(this.meta_props.getLongProperty("last-ping", 0L));
        this.setLastRunnable(this.meta_props.getLongProperty("last-runnable", 0L));
        if (!this.job_props.containsKey((Object)IUiOptions.UiOption.ProcessExecutable.pname()) && this.service_type != IService.ServiceType.UimaAs) {
            this.meta_props.put((Object)"ping-only", (Object)"true");
            this.ping_only = true;
        } else {
            this.meta_props.put((Object)"ping-only", (Object)"false");
            this.ping_only = false;
        }
        this.savePendingInstanceIds();
        UIMAFramework.getLogger().setLevel(Level.OFF);
    }

    DuccId getId() {
        return this.id;
    }

    void savePendingInstanceIds() {
        String[] tmp;
        String ids = this.meta_props.getProperty(this.implementors_key);
        if (ids == null) {
            return;
        }
        if (ids.indexOf(".") <= 0) {
            this.meta_props.remove((Object)this.implementors_key);
            return;
        }
        for (String s : tmp = ids.split("\\s+")) {
            String[] id_inst = s.split("\\.");
            this.pending_instances.put(Long.parseLong(id_inst[0]), Integer.parseInt(id_inst[1]));
        }
    }

    void parseEndpoint(String ep) {
        if (ep.startsWith(IService.ServiceType.UimaAs.decode())) {
            int ndx = ep.indexOf(":");
            ep = ep.substring(ndx + 1);
            ndx = ep.indexOf(":");
            this.endpoint = ep.substring(0, ndx).trim();
            this.broker = ep.substring(ndx + 1).trim();
            this.service_type = IService.ServiceType.UimaAs;
            URL url = null;
            try {
                url = new URL(null, this.broker, (URLStreamHandler)new TcpStreamHandler());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid broker URL: " + this.broker);
            }
            this.broker_host = url.getHost();
            this.broker_port = url.getPort();
            if (this.endpoint.equals("") || this.broker.equals("")) {
                throw new IllegalArgumentException("The endpoint cannot be parsed.  Expecting UIMA-AS:Endpoint:Broker, received " + this.key);
            }
        } else {
            this.service_type = IService.ServiceType.Custom;
            int ndx = ep.indexOf(":");
            this.endpoint = ep.substring(ndx + 1);
        }
    }

    synchronized void deleteProperties() {
        String history = this.meta_props.getStringProperty(this.history_key, "");
        for (Long id : this.friendly_ids.keySet()) {
            history = history + " " + id.toString();
        }
        this.meta_props.put((Object)this.history_key, (Object)history);
        this.meta_props.remove((Object)this.implementors_key);
        ServiceManagerComponent.deleteProperties(this.id.toString(), this.meta_filename, (Properties)this.meta_props, this.props_filename, (Properties)this.job_props);
        this.meta_filename = null;
        this.props_filename = null;
    }

    synchronized Long[] getImplementors() {
        return this.implementors.keySet().toArray(new Long[this.implementors.size()]);
    }

    synchronized String getHostFor(Long implid) {
        return this.implementors.get(implid).getHost();
    }

    synchronized long getShareFor(Long implid) {
        return this.implementors.get(implid).getShareId();
    }

    synchronized DuccId[] getReferences() {
        return this.references.keySet().toArray(new DuccId[this.references.size()]);
    }

    void setIncoming(ServiceSet sset) {
        this.predecessors.add(sset);
    }

    void clearEdges() {
        this.predecessors.clear();
        this.successors.clear();
    }

    boolean hasPredecessor() {
        return this.predecessors.size() != 0;
    }

    List<ServiceSet> getPredecessors() {
        return this.predecessors;
    }

    void removePredecessor(ServiceSet pred) {
        this.predecessors.remove(pred);
    }

    void setOutgoing(ServiceSet sset) {
        this.successors.add(sset);
    }

    List<ServiceSet> getSuccessors() {
        return new ArrayList<ServiceSet>(this.successors);
    }

    void removeSuccessor(ServiceSet succ) {
        this.successors.remove(succ);
    }

    boolean hasSuccessor() {
        return this.successors.size() != 0;
    }

    String[] getIndependentServices() {
        return this.independentServices;
    }

    void setIndependentServices(String[] ind) {
        this.independentServices = ind;
    }

    void deleteJobProperty(String k) {
        this.job_props.remove((Object)k);
    }

    void setJobProperty(String k, String v) {
        this.job_props.put((Object)k, (Object)v);
    }

    void setMetaProperty(String k, String v) {
        this.meta_props.put((Object)k, (Object)v);
    }

    boolean isDebug() {
        return this.process_debug;
    }

    boolean isAuthorized(String user) {
        if (this.coOwners == null) {
            return false;
        }
        for (String s : this.coOwners) {
            if (!s.equals(user)) continue;
            return true;
        }
        return false;
    }

    void parseAdministrators(String admins) {
        if (admins != null) {
            this.coOwners = admins.split("\\s+");
        }
    }

    private void parseIndependentServices() {
        String depstr = this.job_props.getProperty(IUiOptions.UiOption.ServiceDependency.pname());
        String[] result = null;
        if (depstr != null) {
            result = depstr.split("\\s+");
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].trim();
            }
        }
        this.independentServices = result;
    }

    void bootImplementor(DuccId id, IDuccState.JobState state) {
        ServiceInstance si = new ServiceInstance(this);
        si.setState(state);
        si.setId(id.getFriendly());
        si.setStopped(false);
        si.setUser(this.user);
        si.setInstanceId(this.pending_instances.get(id.getFriendly()));
        this.handler.addInstance(this, si);
        this.pendingImplementors.put(id.getFriendly(), si);
    }

    void bootComplete() {
        String methodName = "bootComplete";
        if (this.isPingOnly() && this.enabled()) {
            this.start();
            return;
        }
        this.implementors = this.pendingImplementors;
        String old_impls = this.meta_props.getProperty(this.implementors_key);
        this.logger.info(methodName, this.id, new Object[]{"Old implementors :", old_impls});
        if (old_impls != null) {
            String[] keys;
            HashMap<String, String> ip = new HashMap<String, String>();
            for (String k : keys = old_impls.split("\\s+")) {
                ip.put(k, k);
            }
            String history = this.meta_props.getProperty(this.history_key);
            HashMap<String, String> hp = new HashMap<String, String>();
            if (history != null) {
                for (String k : keys = history.split("\\s+")) {
                    hp.put(k, k);
                }
            }
            for (String k : ip.keySet()) {
                Long iid = Long.parseLong(k);
                if (this.implementors.containsKey(iid)) continue;
                hp.put(k, k);
            }
            if (hp.size() > 0) {
                StringBuffer sb = new StringBuffer();
                for (String s : hp.keySet()) {
                    sb.append(s);
                    sb.append(" ");
                }
                this.meta_props.setProperty(this.history_key, sb.toString().trim());
            }
        }
        if (this.pending_instances.size() != 0) {
            TreeMap<Integer, Integer> nst = new TreeMap<Integer, Integer>();
            for (int i : this.pending_instances.values()) {
                nst.put(i, i);
            }
            int ndx = 0;
            while (nst.size() > 0) {
                if (nst.containsKey(ndx)) {
                    nst.remove(ndx);
                } else {
                    this.available_instance_ids.put(ndx, ndx);
                }
                ++ndx;
            }
        }
        this.pending_instances = null;
        if (this.isReferencedStart() && this.countImplementors() == 0) {
            this.reference_start = false;
        }
        this.saveMetaProperties();
    }

    synchronized void enforceAutostart() {
        String methodName = "enforceAutostart";
        if (!this.autostart) {
            return;
        }
        if (!this.enabled()) {
            return;
        }
        if (this.init_failures >= this.init_failure_max) {
            return;
        }
        if (this.ping_failures >= this.ping_failure_max) {
            return;
        }
        int needed = Math.max(0, this.instances - this.countImplementors());
        if (needed > 0) {
            this.logger.info(methodName, this.id, new Object[]{"Autostarting", needed, "instance" + (needed > 1 ? "s" : ""), "already have", this.countImplementors()});
            this.start();
        }
    }

    boolean isUimaAs() {
        return this.service_type == IService.ServiceType.UimaAs;
    }

    boolean isCustom() {
        return this.service_type == IService.ServiceType.Custom;
    }

    DuccProperties getJobProperties() {
        return this.job_props;
    }

    DuccProperties getMetaProperties() {
        return this.meta_props;
    }

    boolean isPingOnly() {
        return this.ping_only;
    }

    long getLastUse() {
        return this.last_use;
    }

    long getLastPing() {
        return this.last_ping;
    }

    long getLastRunnable() {
        return this.last_runnable;
    }

    synchronized void setLastUse(long lu) {
        this.last_use = lu;
        this.meta_props.put((Object)"last-use", (Object)Long.toString(lu));
        if (this.last_use == 0L) {
            this.meta_props.put((Object)"last-use-readable", (Object)"Unknown");
        } else {
            this.meta_props.put((Object)"last-use-readable", (Object)new Date(lu).toString());
        }
    }

    synchronized void setLastPing(long lp) {
        this.last_ping = lp;
        this.meta_props.put((Object)"last-ping", (Object)Long.toString(lp));
        if (this.last_ping == 0L) {
            this.meta_props.put((Object)"last-ping-readable", (Object)"Unknown");
        } else {
            this.meta_props.put((Object)"last-ping-readable", (Object)new Date(lp).toString());
        }
    }

    synchronized void setLastRunnable(long lr) {
        this.last_runnable = lr;
        this.meta_props.put((Object)"last-runnable", (Object)Long.toString(lr));
        if (this.last_runnable == 0L) {
            this.meta_props.put((Object)"last-runnable-readable", (Object)"Unknown");
        } else {
            this.meta_props.put((Object)"last-runnable-readable", (Object)new Date(lr).toString());
        }
    }

    synchronized void resetRuntimeErrors() {
        this.run_failures = 0;
        this.ping_failures = 0;
        this.init_failures = 0;
        this.meta_props.remove((Object)"submit-error");
        this.excessiveRunFailures = false;
    }

    synchronized void setAutostart(boolean auto) {
        this.meta_props.setProperty("autostart", auto ? "true" : "false");
        this.autostart = auto;
        if (auto) {
            this.cancelLinger();
            this.setReferenced(false);
            this.init_failures = 0;
            this.resetRuntimeErrors();
        }
    }

    synchronized void restartPinger() {
        this.stopPingThread();
        this.resetRuntimeErrors();
    }

    synchronized void setStarted() {
        this.started = true;
        this.init_failures = 0;
    }

    synchronized boolean isStopped() {
        switch (this.service_state) {
            case Stopping: 
            case Stopped: {
                return true;
            }
        }
        return false;
    }

    synchronized void ignoreReferences() {
        this.setReferenced(false);
        this.cancelLinger();
    }

    synchronized void observeReferences() {
        this.setReferenced(true);
        if (this.countReferences() == 0) {
            this.lingeringStop();
        }
    }

    synchronized void disable(String reason) {
        this.meta_props.put((Object)"disable-reason", (Object)reason);
        this.enabled = false;
    }

    synchronized void enable() {
        this.meta_props.remove((Object)"disable-reason");
        this.resetRuntimeErrors();
        this.enabled = true;
    }

    synchronized boolean enabled() {
        return this.enabled;
    }

    synchronized String getDisableReason() {
        return this.meta_props.getStringProperty("disable-reason", "Unknown");
    }

    synchronized boolean isStarted() {
        return this.started;
    }

    synchronized boolean isReferencedStart() {
        return this.reference_start;
    }

    synchronized boolean isAutostart() {
        return this.autostart;
    }

    String getUser() {
        return this.user;
    }

    boolean isDeregistered() {
        return this.deregistered;
    }

    void deregister() {
        this.deregistered = true;
    }

    String getMetaFilename() {
        return this.meta_filename;
    }

    String getPropsFilename() {
        return this.props_filename;
    }

    synchronized int getNInstancesRegistered() {
        return this.registered_instances;
    }

    /*
     * Exception decompiling
     */
    private boolean writeProperties(DuccProperties props, File pfile, File pfile_tmp, String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void saveProperties(DuccProperties props, File pfile, File pfile_tmp, String type) {
        String methodName = "saveProperties";
        int max = 5;
        for (int i = 0; i < max; ++i) {
            if (!this.writeProperties(props, pfile, pfile_tmp, type)) continue;
            return;
        }
        this.logger.error(methodName, this.id, new Object[]{"Cannot write", pfile, "after", max, "tries.  The service may not be viable after restart or in web server status."});
    }

    synchronized void saveMetaProperties() {
        IServiceStatistics ss;
        String methodName = "saveMetaProperties";
        if (this.isDeregistered()) {
            return;
        }
        if (this.meta_filename == null) {
            this.logger.error(methodName, this.id, new Object[]{"Meta properties is deleted, bypassing attempt to save."});
            return;
        }
        if (this.implementors.size() == 0) {
            this.meta_props.remove((Object)this.implementors_key);
        } else {
            StringBuffer sb_ducc_id = new StringBuffer();
            for (Long l : this.implementors.keySet()) {
                ServiceInstance inst = this.implementors.get(l);
                sb_ducc_id.append(Long.toString(l));
                sb_ducc_id.append(".");
                sb_ducc_id.append(Integer.toString(inst.getInstanceId()));
                sb_ducc_id.append(" ");
            }
            String s = sb_ducc_id.toString().trim();
            this.meta_props.setProperty(this.implementors_key, s);
        }
        this.meta_props.put((Object)"reference", (Object)(this.isReferencedStart() ? "true" : "false"));
        this.meta_props.put((Object)"autostart", (Object)(this.isAutostart() ? "true" : "false"));
        this.meta_props.put((Object)"enabled", (Object)("" + this.enabled));
        this.meta_props.put((Object)"service-state", (Object)("" + this.getState()));
        this.meta_props.put((Object)"ping-active", (Object)("" + (this.serviceMeta != null)));
        this.meta_props.put((Object)"service-alive", (Object)"false");
        this.meta_props.put((Object)"service-healthy", (Object)"false");
        if (this.excessiveFailures()) {
            this.meta_props.put((Object)"submit-error", (Object)("Service stopped by exessive failures.  Initialization failures[" + this.init_failures + "], Runtime failures[" + this.run_failures + "]"));
        } else {
            this.meta_props.put((Object)"service-statistics", (Object)"N/A");
        }
        if (this.serviceMeta != null && (ss = this.serviceMeta.getServiceStatistics()) != null) {
            this.meta_props.put((Object)"service-alive", (Object)("" + ss.isAlive()));
            this.meta_props.put((Object)"service-healthy", (Object)("" + ss.isHealthy()));
            this.meta_props.put((Object)"service-statistics", (Object)("" + ss.getInfo()));
            if (ss.isAlive()) {
                this.setLastPing(System.currentTimeMillis());
            }
        }
        this.saveProperties(this.meta_props, this.meta_file, this.meta_file_temp, "Meta");
    }

    void saveServiceProperties() {
        this.saveProperties(this.job_props, this.props_file, this.props_file_temp, "Service");
    }

    synchronized void updateInstance(long iid, long share_id, String host) {
        String methodName = "updateInstance";
        ServiceInstance inst = this.implementors.get(iid);
        if (inst == null) {
            this.logger.warn(methodName, this.id, new Object[]{"Cannot find instance", iid, "for update:", host + ":" + share_id});
            return;
        }
        inst.update(share_id, host);
    }

    synchronized void updateRegisteredInstances(int n) {
        this.meta_props.setProperty("instances", Integer.toString(n));
        this.registered_instances = n;
    }

    synchronized void updateInstances(int n) {
        if (n >= 0) {
            this.instances = n;
            int running = this.countImplementors();
            int diff = n - running;
            if (diff > 0) {
                this.start();
            } else if (diff < 0) {
                this.stop(-diff);
            }
        }
    }

    synchronized void updateDebug(String val) {
        if (val.equals("off")) {
            this.job_props.remove((Object)IUiOptions.UiOption.ProcessDebug.pname());
            this.process_debug = false;
        } else {
            this.job_props.put((Object)IUiOptions.UiOption.ProcessDebug.pname(), (Object)val);
            this.process_debug = true;
        }
    }

    synchronized void updateLinger(String val) {
        String methodName = "updateLinger";
        try {
            this.linger_time = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            this.logger.error(methodName, this.id, new Object[]{"Cannot update linger, not numeric:", val});
        }
    }

    synchronized void updateInitFailureLimit(String val) {
        String methodName = "updateInitFailureLimit";
        try {
            this.init_failure_max = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            this.logger.error(methodName, this.id, new Object[]{"Cannot update init failure max, not numeric:", val});
        }
    }

    synchronized void persistReferences() {
        if (this.references.size() == 0) {
            this.meta_props.remove((Object)"references");
        } else {
            StringBuffer sb = new StringBuffer();
            for (DuccId id : this.references.keySet()) {
                sb.append(id.toString());
                sb.append(" ");
            }
            String s = sb.toString().trim();
            this.meta_props.setProperty("references", s);
        }
        this.saveMetaProperties();
    }

    void clearQueue() {
        String methodName = "clearQueue";
        if (!this.deregistered) {
            this.logger.info(methodName, this.id, new Object[]{"Not clearing queue because service is still registered."});
            return;
        }
        if (this.implementors.size() != 0) {
            this.logger.info(methodName, this.id, new Object[]{"Not clearing queue because", this.implementors.size(), "implementors are still alive (", this.key, ")."});
            return;
        }
        this.handler.removeService(this);
        this.deleteProperties();
        if (this.service_type != IService.ServiceType.UimaAs) {
            this.logger.info(methodName, this.id, new Object[]{"Deleting unregistered service; not clearing queue because this is not a UIMA-AS service:", this.key});
            return;
        }
        if (this.isPingOnly()) {
            this.logger.info(methodName, this.id, new Object[]{"Deleting unregistered service; not clearing queue for ping-only service", this.key});
            return;
        }
        String pingclass = this.job_props.getStringProperty(IUiOptions.UiOption.ServicePingClass.pname(), UimaAsPing.class.getName());
        if (!pingclass.equals(UimaAsPing.class.getName())) {
            this.logger.info(methodName, this.id, new Object[]{"Deleting unregistered service: not clearing queue because not using the default UIMA-AS pinger:", pingclass, "(", this.key, ")"});
            return;
        }
        UimaAsServiceMonitor monitor = new UimaAsServiceMonitor(this.endpoint, this.broker_host, this.broker_jmx_port);
        this.logger.info(methodName, this.id, new Object[]{"Deleting unregistered service and clearing queues for", this.key, "at [" + this.broker_host + ":" + this.broker_jmx_port + "]"});
        try {
            monitor.init(null);
            monitor.clearQueues();
            monitor.stop();
        }
        catch (Throwable e) {
            this.logger.info(methodName, this.id, new Object[]{e.toString()});
        }
    }

    public synchronized int countImplementors() {
        return this.implementors.size();
    }

    public synchronized int countReferences() {
        return this.references.size();
    }

    public synchronized Long[] getActiveInstances() {
        ArrayList<Long> instIds = new ArrayList<Long>();
        for (ServiceInstance inst : this.implementors.values()) {
            if (!inst.isRunning()) continue;
            instIds.add(inst.getId());
        }
        return instIds.toArray(new Long[instIds.size()]);
    }

    synchronized void cancelLinger() {
        String methodName = "cancelLinger";
        if (this.linger != null) {
            this.logger.debug(methodName, this.id, new Object[]{" ---------------- Canceling linger task"});
            this.linger.cancel();
            this.linger = null;
        }
    }

    public void setErrorString(String s) {
        this.meta_props.put((Object)"submit-error", (Object)s);
        this.saveMetaProperties();
    }

    public String getErrorString() {
        return this.meta_props.getProperty("submit-error");
    }

    void setReferenced(boolean r) {
        this.reference_start = r;
        this.meta_props.put((Object)"reference", (Object)Boolean.toString(this.reference_start));
    }

    public synchronized void reference(DuccId id) {
        String methodName = "reference";
        this.logger.info(methodName, this.id, new Object[]{"Reference start requested by ", id});
        if (!this.enabled()) {
            this.logger.warn(methodName, this.id, new Object[]{"Not reference starting new service instances because service is disabled."});
            return;
        }
        if (this.excessiveFailures()) {
            this.logger.warn(methodName, this.id, new Object[]{"Reference start fails, excessive failures: init[" + this.init_failures + "], run[" + this.run_failures + "]"});
            return;
        }
        this.cancelLinger();
        this.references.put(id, id);
        this.logger.info(methodName, this.id, new Object[]{" References job/service", id, "count[" + this.references.size() + "] implementors [" + this.implementors.size() + "]"});
        boolean idle = true;
        for (ServiceInstance si : this.implementors.values()) {
            this.logger.debug(methodName, this.id, new Object[]{"Implementor", si.getId(), "state:", si.getState()});
            if (!si.isRunning()) continue;
            idle = false;
            break;
        }
        if (idle) {
            this.logger.info(methodName, this.id, new Object[]{"Reference starting new service instances."});
            this.init_failures = 0;
            this.resetRuntimeErrors();
            this.setReferenced(true);
            this.start();
        }
        this.persistReferences();
    }

    public synchronized void dereference(DuccId id) {
        String methodName = "dereference";
        if (this.references.remove(id) == null) {
            this.logger.error(methodName, this.id, new Object[]{"Dereference job/service", id, "not found in map for", this.getKey()});
            return;
        }
        if (this.references.size() == 0 && this.isReferencedStart()) {
            this.lingeringStop();
        }
        this.logger.info(methodName, this.id, new Object[]{" Dereferences job/service", id, "count[" + this.references.size() + "]"});
        this.persistReferences();
    }

    boolean containsImplementor(DuccId id) {
        return this.implementors.containsKey(id.getFriendly());
    }

    synchronized void signalRebalance(int nadditions, Long[] deletions, int ndeletions, boolean isExcessiveFailures) {
        String methodName = "signalRebalance";
        this.logger.info(methodName, this.id, new Object[]{"PING: Additions:", nadditions, "deletions:", ndeletions, "excessive failures:", isExcessiveFailures, "implementors", this.countImplementors(), "references", this.countReferences()});
        this.ping_failures = 0;
        this.excessiveRunFailures = isExcessiveFailures;
        if (nadditions > 0) {
            this.start();
        }
        for (int i = 0; i < ndeletions; ++i) {
            this.instances = Math.max(0, this.instances - 1);
            this.stop(deletions[i]);
        }
        this.saveMetaProperties();
    }

    boolean canDeleteInstance(DuccWorkJob dwj) {
        switch (dwj.getJobState()) {
            case Completing: 
            case Completed: {
                return true;
            }
        }
        return false;
    }

    boolean needNextStart(IDuccState.JobState old, IDuccState.JobState current) {
        switch (old) {
            case Received: 
            case WaitingForDriver: 
            case WaitingForServices: 
            case WaitingForResources: {
                switch (current) {
                    case Assigned: 
                    case Initializing: 
                    case Running: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    void removeImplementor(ServiceInstance si) {
        String methodName = "removeImplementor";
        this.logger.info(methodName, this.id, new Object[]{"Removing implementor", si.getId()});
        this.implementors.remove(si.getId());
    }

    synchronized void signalUpdate(DuccWorkJob dwj) {
        String methodName = "signalUpdate";
        ServiceInstance inst = this.implementors.get(dwj.getDuccId().getFriendly());
        if (inst == null) {
            this.logger.warn(methodName, this.id, new Object[]{"Process", dwj.getDuccId(), "is no longer an implementor.  Perhaps it exited earlier."});
            return;
        }
        IDuccState.JobState old_state = inst.getState();
        IDuccState.JobState state = dwj.getJobState();
        DuccId inst_id = dwj.getDuccId();
        long fid = inst_id.getFriendly();
        if (state == IDuccState.JobState.Running && old_state != IDuccState.JobState.Running) {
            this.logger.info(methodName, this.id, new Object[]{"Resetting init error counter from", this.init_failures, "to 0 on transition from", old_state, "to", state});
            this.init_failures = 0;
        }
        boolean save_meta = false;
        if (this.needNextStart(old_state, state)) {
            this.start();
        }
        if (this.canDeleteInstance(dwj)) {
            IDuccCompletionType.JobCompletionType jct = dwj.getCompletionType();
            ServiceInstance stoppedInstance = null;
            this.logger.info(methodName, this.id, new Object[]{"Removing implementor", fid, "(", this.key, ") completion", jct});
            stoppedInstance = this.implementors.remove(fid);
            this.conditionally_stash_instance_id(stoppedInstance.getInstanceId());
            String history = this.meta_props.getStringProperty(this.history_key, "");
            history = history + " " + fid;
            this.meta_props.put((Object)this.history_key, (Object)history);
            save_meta = true;
            this.logger.info(methodName, this.id, new Object[]{"Removing stopped instance", inst_id, "from maps: state[", state, "] completion[", jct, "] service-enabled", this.enabled()});
            this.clearQueue();
            if (this.instances > this.countImplementors()) {
                if (stoppedInstance.isStopped()) {
                    this.logger.info(methodName, this.id, new Object[]{"Instance", inst_id, "is manually stopped.  Not restarting."});
                } else {
                    switch (old_state) {
                        case Assigned: 
                        case Initializing: 
                        case WaitingForServices: 
                        case WaitingForResources: {
                            ++this.init_failures;
                            this.logger.info(methodName, this.id, new Object[]{"Tally initialization failure:", this.init_failures});
                            break;
                        }
                        case Running: {
                            ++this.run_failures;
                            this.logger.info(methodName, this.id, new Object[]{"Tally runtime failure", this.run_failures});
                            break;
                        }
                        default: {
                            this.logger.info(methodName, this.id, new Object[]{"Instance stopped unexpectedly: prior state[", old_state, " completion[", jct, "]"});
                        }
                    }
                    if (this.excessiveFailures()) {
                        String disable_reason = null;
                        if (this.excessiveRunFailures) {
                            this.logger.warn(methodName, this.id, new Object[]{"Instance", inst_id, "Monitor signals excessive terminations. Not restarting."});
                            disable_reason = "Excessive runtime errors";
                        } else {
                            this.logger.warn(methodName, this.id, new Object[]{"Instance", inst_id, "Excessive initialization failures. Total failures[" + this.init_failures + "]", "allowed [" + this.init_failure_max + "], not restarting."});
                            disable_reason = "Excessive initialization errors";
                        }
                        this.disable(disable_reason);
                        save_meta = true;
                    } else {
                        this.logger.warn(methodName, this.id, new Object[]{"Instance", inst_id + ": Uunsolicited termination, not yet excessive.  Restarting instance."});
                        this.start();
                        return;
                    }
                }
            }
        }
        if (save_meta) {
            this.saveMetaProperties();
        }
        inst.setState(state);
        this.signal(inst);
    }

    private IService.ServiceState translateJobState(IDuccState.JobState js) {
        switch (js) {
            case Assigned: 
            case Received: 
            case WaitingForDriver: 
            case WaitingForServices: 
            case WaitingForResources: {
                return IService.ServiceState.Starting;
            }
            case Initializing: {
                return IService.ServiceState.Initializing;
            }
            case Running: {
                return IService.ServiceState.Available;
            }
            case Completing: {
                return IService.ServiceState.Stopping;
            }
            case Completed: {
                return IService.ServiceState.Stopped;
            }
        }
        return IService.ServiceState.NotAvailable;
    }

    private IService.ServiceState cumulativeJobState() {
        String methodName = "cumulativeJobState";
        IService.ServiceState response = IService.ServiceState.Stopped;
        for (ServiceInstance si : this.implementors.values()) {
            IDuccState.JobState js = si.getState();
            IService.ServiceState translated = this.translateJobState(js);
            if (translated.ordinality() <= response.ordinality()) continue;
            response = translated;
        }
        if (this.serviceMeta == null) {
            response = response.ordinality() < IService.ServiceState.Waiting.ordinality() ? response : IService.ServiceState.Waiting;
        } else if (this.serviceMeta != null) {
            this.logger.trace(methodName, this.id, new Object[]{"Cumulative before checking monitor/pinger:", response, ".  Monitor state:", this.serviceMeta.getServiceState()});
            if (this.serviceMeta.getServiceState().ordinality() <= response.ordinality()) {
                response = this.serviceMeta.getServiceState();
            }
        }
        return response;
    }

    synchronized IService.ServiceState getState() {
        return this.service_state;
    }

    synchronized void setState(IService.ServiceState new_state, IService.ServiceState cumulative, ServiceInstance si) {
        String methodName = "setState";
        String tail = "";
        tail = si == null ? "none/none" : si.getId() + "/" + si.getState();
        IService.ServiceState prev = this.service_state;
        this.service_state = new_state;
        if (prev != new_state) {
            this.logger.info(methodName, this.id, new Object[]{"State update from[" + prev + "] to[" + new_state + "] via[" + cumulative + "] Inst[" + tail + "]"});
            this.saveMetaProperties();
        }
        switch (new_state) {
            case Available: {
                this.setLastRunnable(System.currentTimeMillis());
                this.startPingThread();
                break;
            }
            case Initializing: {
                break;
            }
            case Starting: {
                break;
            }
            case Waiting: {
                this.setLastRunnable(System.currentTimeMillis());
                this.startPingThread();
                break;
            }
            case Stopping: {
                this.stopPingThread();
                break;
            }
            case Stopped: {
                this.setReferenced(false);
                this.stopPingThread();
                break;
            }
            default: {
                this.setReferenced(false);
                this.stopPingThread();
            }
        }
    }

    public synchronized void signal(ServiceInstance si) {
        String methodName = "signal";
        IService.ServiceState cumulative = this.cumulativeJobState();
        this.logger.trace(methodName, this.id, new Object[]{"serviceState", this.getState(), "cumulativeState", cumulative});
        block0 : switch (this.getState()) {
            case Available: {
                switch (cumulative) {
                    case Starting: {
                        this.logger.warn(methodName, this.id, new Object[]{"STATE REGRESSION:", this.getState(), "->", cumulative});
                        this.setState(IService.ServiceState.Starting, cumulative, si);
                        break block0;
                    }
                    case Initializing: {
                        this.logger.warn(methodName, this.id, new Object[]{"STATE REGRESSION:", this.getState(), "->", cumulative});
                        this.setState(IService.ServiceState.Initializing, cumulative, si);
                        break block0;
                    }
                    case Available: {
                        this.setState(IService.ServiceState.Available, cumulative, si);
                        break block0;
                    }
                    case Stopping: {
                        this.setState(IService.ServiceState.Stopping, cumulative, si);
                        break block0;
                    }
                    case Stopped: {
                        this.setState(IService.ServiceState.Stopped, cumulative, si);
                        break block0;
                    }
                    case Waiting: {
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break block0;
                    }
                }
                this.stopPingThread();
                this.logger.warn(methodName, this.id, new Object[]{"ILLEGAL STATE TRANSITION:", this.getState(), "->", cumulative});
                break;
            }
            case Initializing: {
                switch (cumulative) {
                    case Starting: {
                        this.logger.warn(methodName, this.id, new Object[]{"STATE REGRESSION:", this.getState(), "->", cumulative});
                        this.setState(IService.ServiceState.Starting, cumulative, si);
                        break block0;
                    }
                    case Initializing: {
                        this.setState(IService.ServiceState.Initializing, cumulative, si);
                        break block0;
                    }
                    case Available: {
                        this.logger.warn(methodName, this.id, new Object[]{"UNEXPECTED STATE TRANSITION:", this.getState(), "->", cumulative});
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break block0;
                    }
                    case Stopping: {
                        this.setState(IService.ServiceState.Stopping, cumulative, si);
                        break block0;
                    }
                    case Stopped: {
                        this.setState(IService.ServiceState.Stopped, cumulative, si);
                        break block0;
                    }
                    case Waiting: {
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break block0;
                    }
                }
                this.logger.warn(methodName, this.id, new Object[]{"ILLEGAL STATE TRANSITION:", this.getState(), "->", cumulative});
                break;
            }
            case Starting: {
                switch (cumulative) {
                    case Starting: {
                        this.setState(IService.ServiceState.Starting, cumulative, si);
                        break;
                    }
                    case Initializing: {
                        this.setState(IService.ServiceState.Initializing, cumulative, si);
                        break;
                    }
                    case Available: {
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break;
                    }
                    case Stopping: {
                        this.logger.info(methodName, this.id, new Object[]{"RETRY RETRY RETRY prevents state regression from Initializing"});
                        break;
                    }
                    case Stopped: {
                        this.setState(IService.ServiceState.Stopped, cumulative, si);
                        break;
                    }
                    case Waiting: {
                        this.logger.warn(methodName, this.id, new Object[]{"ILLEGAL STATE TRANSITION:", this.getState(), "->", cumulative});
                    }
                }
                break;
            }
            case Waiting: {
                switch (cumulative) {
                    case Starting: {
                        this.logger.warn(methodName, this.id, new Object[]{"STATE REGRESSION:", this.getState(), "->", cumulative});
                        this.setState(IService.ServiceState.Starting, cumulative, si);
                        break block0;
                    }
                    case Initializing: {
                        this.logger.warn(methodName, this.id, new Object[]{"STATE REGRESSION:", this.getState(), "->", cumulative});
                        this.setState(IService.ServiceState.Initializing, cumulative, si);
                        break block0;
                    }
                    case Available: {
                        this.setState(IService.ServiceState.Available, cumulative, si);
                        break block0;
                    }
                    case Stopping: {
                        this.setState(IService.ServiceState.Stopping, cumulative, si);
                        break block0;
                    }
                    case Stopped: {
                        this.setState(IService.ServiceState.Stopped, cumulative, si);
                        break block0;
                    }
                    case Waiting: {
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break block0;
                    }
                }
                this.logger.warn(methodName, this.id, new Object[]{"ILLEGAL STATE TRANSITION:", this.getState(), "->", cumulative});
                break;
            }
            case Stopping: {
                switch (cumulative) {
                    case Starting: {
                        this.setState(IService.ServiceState.Starting, cumulative, si);
                        break block0;
                    }
                    case Initializing: {
                        this.setState(IService.ServiceState.Initializing, cumulative, si);
                        break block0;
                    }
                    case Available: {
                        this.setState(IService.ServiceState.Available, cumulative, si);
                        break block0;
                    }
                    case Stopped: {
                        this.setState(IService.ServiceState.Stopped, cumulative, si);
                        break block0;
                    }
                    case Stopping: {
                        this.setState(IService.ServiceState.Stopping, cumulative, si);
                        break block0;
                    }
                }
                this.logger.warn(methodName, this.id, new Object[]{"ILLEGAL STATE TRANSITION:", this.getState(), "->", cumulative});
                break;
            }
            case Stopped: {
                switch (cumulative) {
                    case Starting: {
                        this.setState(IService.ServiceState.Starting, cumulative, si);
                        break;
                    }
                    case Initializing: {
                        this.setState(IService.ServiceState.Initializing, cumulative, si);
                        break;
                    }
                    case Available: {
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break;
                    }
                    case Waiting: {
                        this.setState(IService.ServiceState.Waiting, cumulative, si);
                        break;
                    }
                    case Stopped: {
                        this.setState(IService.ServiceState.Stopped, cumulative, si);
                        break;
                    }
                    case Stopping: {
                        this.setState(IService.ServiceState.Stopping, cumulative, si);
                        this.logger.warn(methodName, this.id, new Object[]{"UNEXPECTED STATE:", this.getState(), "->", cumulative});
                        break;
                    }
                    case NotAvailable: {
                        this.logger.warn(methodName, this.id, new Object[]{"UNEXPECTED STATE:", this.getState(), "->", cumulative});
                    }
                }
                break;
            }
            case NotAvailable: 
            case Undefined: {
                this.logger.warn(methodName, this.id, new Object[]{"Illiegal state", this.getState(), "Ignored."});
            }
        }
    }

    synchronized String getKey() {
        return this.key;
    }

    synchronized int getRunFailures() {
        return this.run_failures;
    }

    synchronized boolean excessiveFailures() {
        String methodName = "excessiveFailures";
        if (this.init_failures >= this.init_failure_max) {
            this.logger.trace(methodName, this.id, new Object[]{"INIT FAILURES EXCEEDED"});
            return true;
        }
        if (this.excessiveRunFailures) {
            this.logger.trace(methodName, this.id, new Object[]{"EXCESSIVE RUN FAILURES SIGNALLED FROM SERVICE MONITOR."});
            return true;
        }
        return false;
    }

    private void startPingThread() {
        String methodName = "startPingThread";
        if (this.serviceMeta != null) {
            return;
        }
        if (this.inShutdown) {
            return;
        }
        if (this.ping_failures > this.ping_failure_max) {
            this.logger.warn(methodName, this.id, new Object[]{"Not restarting pinger due to excessiver errors:", this.ping_failures});
            return;
        }
        try {
            this.logger.info(methodName, this.id, new Object[]{"Starting service monitor."});
            this.serviceMeta = new PingDriver(this);
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.id, new Object[]{"Cannot instantiate service pinger.", t});
            return;
        }
        Thread t = new Thread(this.serviceMeta);
        t.start();
    }

    synchronized void pingExited(int rc, PingDriver which_meta) {
        String methodName = "pingExited";
        this.logger.info(methodName, this.id, new Object[]{"Service Monitor/Pinger exits, rc", rc});
        if (which_meta == this.serviceMeta) {
            this.serviceMeta = null;
        }
        if (rc != 0) {
            ++this.ping_failures;
            this.logger.warn(methodName, this.id, new Object[]{"Ping exited with failure, total failures:", this.ping_failures});
            if (this.isPingOnly() && this.ping_failures > this.ping_failure_max) {
                this.logger.warn(methodName, this.id, new Object[]{"Stopping ping-only service due to excessive falutes:", this.ping_failure_max});
                this.meta_props.put((Object)"submit-error", (Object)("Stopping ping-only service due to excessive falutes: " + this.ping_failure_max));
                this.stop(-1L);
                this.implementors.remove(-1L);
            }
        }
    }

    synchronized void stopMonitor() {
        String methodName = "stopMonitor";
        this.logger.info(methodName, this.id, new Object[]{"Stopping pinger due to shutdown"});
        this.inShutdown = true;
        this.stopPingThread();
    }

    public synchronized void stopPingThread() {
        String methodName = "stopPingThread";
        if (this.serviceMeta != null) {
            this.logger.info(methodName, this.id, new Object[]{"Stopping monitor/ping thread for", this.key});
            this.serviceMeta.stop();
            this.serviceMeta = null;
        }
        if (!this.inShutdown) {
            this.saveMetaProperties();
        }
    }

    void log_text(String logdir, String text) {
        String methodName = "log_text";
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "-f", logdir + "/service.err.log", "-a", "--", text};
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            Process p = pb.start();
            int rc = p.waitFor();
            if (rc != 0) {
                this.logger.warn(methodName, this.id, new Object[]{"Attempt to update user's service.err.log returns with rc ", rc});
            }
        }
        catch (Throwable t) {
            this.logger.warn(methodName, this.id, new Object[]{"Cannot update user's service.err.log:", t});
        }
    }

    void log_errors(List<String> outlines, List<String> errlines) {
        Date date = new Date();
        String ts = new Timestamp(date.getTime()).toString();
        String logdir = this.job_props.getProperty(IUiOptions.UiOption.LogDirectory.pname());
        StringBuffer buf = new StringBuffer();
        buf.append("==========");
        buf.append(" Instance Startup Failure (stdout) ");
        buf.append(ts);
        buf.append(" ========================================\n");
        for (String s : outlines) {
            buf.append(s);
            buf.append("\n");
        }
        this.log_text(logdir, buf.toString());
        buf = new StringBuffer();
        buf.append("----------");
        buf.append("(stderr) ");
        buf.append(ts);
        buf.append(" ----------------------------------------\n");
        for (String s : errlines) {
            buf.append(s);
            buf.append("\n");
        }
        buf.append("==========");
        buf.append(" End Startup Failure ");
        buf.append(ts);
        buf.append(" ========================================\n");
        this.log_text(logdir, buf.toString());
    }

    synchronized int find_next_instance() {
        int ret = this.implementors.size();
        if (this.available_instance_ids.size() > 0) {
            ret = this.available_instance_ids.firstKey();
            this.available_instance_ids.remove(ret);
        }
        return ret;
    }

    synchronized void stash_instance_id(int instid) {
        String methodName = "stash_intance_id";
        if (this.available_instance_ids.containsKey(instid)) {
            try {
                throw new Exception("Duplicate instance id found: " + instid);
            }
            catch (Exception e) {
                this.logger.warn(methodName, this.id, (Throwable)e, new Object[0]);
                return;
            }
        }
        this.available_instance_ids.put(instid, instid);
    }

    synchronized void conditionally_stash_instance_id(int instid) {
        if (this.available_instance_ids.containsKey(instid)) {
            return;
        }
        this.stash_instance_id(instid);
    }

    synchronized void start() {
        String methodName = "start";
        if (this.countImplementors() >= this.instances) {
            return;
        }
        if (this.isPingOnly()) {
            if (this.implementors.containsKey(-1L)) {
                this.logger.info(methodName, this.id, new Object[]{"PING_ONLY: already started."});
                return;
            }
            PingOnlyServiceInstance si = new PingOnlyServiceInstance(this);
            si.setId(-1L);
            si.setUser(this.user);
            this.implementors.put(-1L, si);
            this.handler.addInstance(this, si);
            ((ServiceInstance)si).start(null, null);
            this.signal(si);
        } else {
            if (this.isDebug() && this.countImplementors() > 0) {
                this.logger.warn(methodName, this.id, new Object[]{"Ignoring start of additional instances because process_debug is set."});
                return;
            }
            ServiceInstance si = new ServiceInstance(this);
            si.setInstanceId(this.find_next_instance());
            long inst_ducc_id = -1L;
            this.logger.info(methodName, this.id, new Object[]{"Starting instance. Current count", this.countImplementors(), "needed", this.instances});
            inst_ducc_id = si.start(this.props_filename, this.meta_props);
            if (inst_ducc_id >= 0L) {
                this.implementors.put(inst_ducc_id, si);
                this.handler.addInstance(this, si);
                this.signal(si);
                this.logger.info(methodName, this.id, new Object[]{"Instance[", this.countImplementors(), "] ducc_id ", inst_ducc_id});
            } else {
                this.logger.info(methodName, this.id, new Object[]{"Instance[", this.countImplementors(), "] ducc_id ", inst_ducc_id, "Failed to start."});
                this.disable("Cannot submit service process");
                this.signal(si);
            }
        }
        this.saveMetaProperties();
    }

    synchronized void stop(Long iid) {
        String methodName = "stop(id)";
        this.logger.info(methodName, this.id, new Object[]{"Stopping specific instance", iid});
        ServiceInstance si = this.implementors.get(iid);
        if (si == null) {
            this.logger.warn(methodName, this.id, new Object[]{"Can't find instance", iid, ", perhaps it's already gone."});
        } else {
            si.stop();
            this.stash_instance_id(si.getInstanceId());
            this.signal(si);
        }
    }

    synchronized void stop(int count) {
        String methodName = "stop(count)";
        this.logger.info(methodName, this.id, new Object[]{"Stopping", count, "implementors"});
        Object[] keys = this.implementors.keySet().toArray(new Long[this.implementors.size()]);
        Arrays.sort(keys);
        int i = 0;
        int j = keys.length - 1;
        while (i < count) {
            Stopper s = new Stopper(this.implementors.get(keys[j]));
            new Thread(s).start();
            ++i;
            --j;
        }
    }

    synchronized void stopAll() {
        this.stop(this.implementors.size());
    }

    synchronized void disableAndStop(String reason) {
        this.disable(reason);
        this.stopAll();
    }

    void lingeringStop() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.linger = new LingerTask();
        this.timer.schedule((TimerTask)this.linger, this.linger_time);
    }

    IServiceDescription query() {
        ServiceDescription sd = new ServiceDescription();
        ArrayList<Long> impls = new ArrayList<Long>();
        ArrayList<Integer> instids = new ArrayList<Integer>();
        for (Long id : this.implementors.keySet()) {
            ServiceInstance inst = this.implementors.get(id);
            impls.add(id);
            instids.add(inst.getInstanceId());
        }
        sd.setImplementors(impls, instids);
        ArrayList<Long> ref = new ArrayList<Long>();
        ref.clear();
        for (DuccId id : this.references.keySet()) {
            ref.add(id.getFriendly());
        }
        sd.setReferences(ref);
        sd.setInstances(this.getNInstancesRegistered());
        sd.setType(this.service_type);
        sd.setSubclass(this.service_class);
        sd.setEndpoint(this.endpoint);
        sd.setBroker(this.broker);
        sd.setServiceState(this.getState());
        sd.setActive(this.serviceMeta != null);
        sd.setEnabled(this.enabled());
        sd.setAutostart(this.isAutostart());
        sd.setLinger(this.linger_time);
        sd.setId(Long.valueOf(this.id.getFriendly()));
        sd.setUser(this.user);
        sd.setDisableReason(this.meta_props.getStringProperty("disable-reason", null));
        sd.setLastUse(this.last_use);
        sd.setLastPing(this.last_ping);
        sd.setLastRunnable(this.last_runnable);
        sd.setRegistrationDate(this.meta_props.getStringProperty("registration-date", ""));
        sd.setReferenceStart(this.reference_start);
        sd.setErrorString(this.meta_props.getStringProperty("submit-error", null));
        if (this.serviceMeta != null) {
            sd.setQueueStatistics(this.serviceMeta.getServiceStatistics());
        }
        return sd;
    }

    public String toString() {
        return this.endpoint;
    }

    class Stopper
    implements Runnable {
        ServiceInstance si;

        Stopper(ServiceInstance si) {
            this.si = si;
        }

        @Override
        public void run() {
            this.si.stop();
            ServiceSet.this.stash_instance_id(this.si.getInstanceId());
        }
    }

    class Starter
    implements Runnable {
        ServiceInstance si;

        Starter(ServiceInstance si) {
            this.si = si;
        }

        @Override
        public void run() {
            this.si.start(ServiceSet.this.props_filename, ServiceSet.this.meta_props);
        }
    }

    private class LingerTask
    extends TimerTask {
        LingerTask() {
            String methodName = "LingerTask.init";
            ServiceSet.this.logger.debug(methodName, ServiceSet.this.id, new Object[]{"Linger starts", ServiceSet.this.linger_time});
        }

        @Override
        public void run() {
            String methodName = "LingerTask.run";
            ServiceSet.this.logger.debug(methodName, ServiceSet.this.id, new Object[]{"Lingering stop completes."});
            ServiceSet.this.linger = null;
            ServiceSet.this.setReferenced(false);
            ServiceSet.this.stopAll();
        }
    }
}

