/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.UimaAsPing;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.crypto.Crypto;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccCollectionUtils;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.LinuxUtils;
import org.apache.uima.ducc.common.utils.MissingPropertyException;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.sm.CliVersion;
import org.apache.uima.ducc.sm.IServiceManager;
import org.apache.uima.ducc.sm.ServiceHandler;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.AServiceRequest;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.ServiceDisableEvent;
import org.apache.uima.ducc.transport.event.ServiceEnableEvent;
import org.apache.uima.ducc.transport.event.ServiceIgnoreEvent;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceObserveEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryEvent;
import org.apache.uima.ducc.transport.event.ServiceRegisterEvent;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.SmStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.ServiceMap;

public class ServiceManagerComponent
extends AbstractDuccComponent
implements IServiceManager,
SmConstants,
Runnable {
    private static DuccLogger logger = DuccLogger.getLogger((String)ServiceManagerComponent.class.getName(), (String)"SM");
    DuccWorkMap localMap = null;
    private DuccEventDispatcher eventDispatcher;
    private String stateEndpoint;
    private ServiceHandler handler = null;
    static int meta_ping_rate = 60000;
    static int meta_ping_stability = 5;
    static int meta_ping_timeout = 500;
    static String default_ping_class;
    static int init_failure_max;
    static int failure_max;
    static int failure_window;
    private String state_dir = null;
    private String state_file = null;
    private String descriptor_dir = null;
    private DuccProperties sm_props = null;
    private String service_seqno = "service.seqno";
    private DuccIdFactory idFactory = new DuccIdFactory();
    private boolean signature_required = true;
    private boolean initialized = false;
    private boolean testmode = false;
    private boolean orchestrator_alive = false;
    Map<String, String> administrators = new HashMap<String, String>();
    String version = "2.0.0";
    int epochCounter = 0;
    IDuccWorkMap incomingMap = null;
    Object idSync = new Object();

    public ServiceManagerComponent(CamelContext context) {
        super("ServiceManager", context);
        this.localMap = new DuccWorkMap();
        this.handler = new ServiceHandler(this);
    }

    public DuccLogger getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws Exception {
        String methodName = "init";
        try {
            String[] desclist;
            File histdir;
            File descdir = new File(ServiceManagerComponent.serviceFileLocation());
            if (!descdir.exists()) {
                descdir.mkdirs();
            }
            if (!(histdir = new File(ServiceManagerComponent.serviceHistoryLocation())).exists()) {
                histdir.mkdirs();
            }
            for (String d : desclist = descdir.list()) {
                if (!d.endsWith(".svc")) continue;
                int ndx = d.lastIndexOf(".");
                String stem = d.substring(0, ndx);
                DuccProperties props = new DuccProperties();
                String props_filename = this.serviceFileKey(d);
                props.load(props_filename);
                DuccProperties metaprops = new DuccProperties();
                String meta_filename = this.serviceFileKey(stem + ".meta");
                metaprops.load(meta_filename);
                int friendly = 0;
                String uuid = "";
                try {
                    friendly = metaprops.getIntProperty("numeric_id");
                    uuid = metaprops.getStringProperty("uuid");
                }
                catch (MissingPropertyException e1) {
                    logger.error(methodName, null, new Object[]{"Cannot restore DuccId for", d, "Friendly id:", friendly, "uuid:", uuid});
                    continue;
                }
                DuccId id = new DuccId((long)friendly);
                id.setUUID(UUID.fromString(uuid));
                logger.debug(methodName, id, new Object[]{"Unique:", id.getUnique()});
                try {
                    this.handler.register(id, props_filename, meta_filename, props, metaprops);
                }
                catch (IllegalStateException e) {
                    logger.error(methodName, id, new Object[]{e.getMessage()});
                }
            }
        }
        catch (Throwable e) {
            logger.error(methodName, null, new Object[]{"Cannot initialize service manger: ", e.getMessage()});
            System.exit(1);
        }
        this.state_dir = System.getProperty("DUCC_HOME") + "/state";
        this.state_file = this.state_dir + "/sm.properties";
        this.descriptor_dir = this.state_dir + "/services";
        File ddir = new File(this.descriptor_dir);
        if (ddir.exists()) {
            if (!ddir.isDirectory()) {
                throw new IllegalStateException("Service descriptor location is not a directory: " + this.descriptor_dir);
            }
        } else {
            ddir.mkdirs();
        }
        this.sm_props = new DuccProperties();
        File sf = new File(this.state_file);
        int seq = 0;
        if (sf.exists()) {
            try (FileInputStream fos = new FileInputStream(this.state_file);){
                this.sm_props.load((InputStream)fos);
                String s = this.sm_props.getProperty(this.service_seqno);
                seq = Integer.parseInt(s) + 1;
            }
        }
        this.idFactory = new DuccIdFactory((long)seq);
        ServiceManagerComponent serviceManagerComponent = this;
        synchronized (serviceManagerComponent) {
            this.initialized = true;
        }
    }

    static ServiceReplyEvent makeResponse(boolean rc, String message, String endpoint, long id) {
        ServiceReplyEvent ret = new ServiceReplyEvent();
        ret.setReturnCode(rc);
        ret.setMessage(message);
        ret.setEndpoint(endpoint);
        ret.setId(id);
        return ret;
    }

    void readAdministrators() {
        String methodName = "readAdministrators";
        File adminfile = new File(System.getProperty("DUCC_HOME") + "/resources/ducc.administrators");
        if (!adminfile.exists()) {
            logger.info(methodName, null, new Object[]{"No ducc administrators found."});
            return;
        }
        Properties props = null;
        try {
            FileInputStream fis = new FileInputStream(adminfile);
            props = new Properties();
            props.load(fis);
        }
        catch (Exception e) {
            logger.warn(methodName, null, new Object[]{"Cannot read administroators file:", e.toString()});
            return;
        }
        for (Object k : props.keySet()) {
            String adm = ((String)k).trim();
            this.administrators.put(adm, adm);
            logger.info(methodName, null, new Object[]{"DUCC Administrator registered:", adm});
        }
    }

    public void start(DuccService service, String[] args) throws Exception {
        String methodName = "start";
        super.start(service, args);
        DuccDaemonRuntimeProperties.getInstance().boot(DuccDaemonRuntimeProperties.DaemonName.ServiceManager, this.getProcessJmxUrl());
        init_failure_max = SystemPropertyResolver.getIntProperty((String)"ducc.sm.init.failure.limit", (int)init_failure_max);
        failure_max = SystemPropertyResolver.getIntProperty((String)"ducc.sm.instance.failure.limit", (int)failure_max);
        failure_window = SystemPropertyResolver.getIntProperty((String)"ducc.sm.instance.failure.window", (int)failure_window);
        meta_ping_rate = SystemPropertyResolver.getIntProperty((String)"ducc.sm.meta.ping.rate", (int)meta_ping_rate);
        meta_ping_timeout = SystemPropertyResolver.getIntProperty((String)"ducc.sm.meta.ping.timeout", (int)meta_ping_timeout);
        meta_ping_stability = SystemPropertyResolver.getIntProperty((String)"ducc.sm.meta.ping.stability", (int)meta_ping_stability);
        default_ping_class = SystemPropertyResolver.getStringProperty((String)"ducc.sm.default.monitor.class", (String)UimaAsPing.class.getName());
        String rm = SystemPropertyResolver.getStringProperty((String)"ducc.runmode", (String)"");
        if (rm.equals("Test")) {
            this.testmode = true;
        }
        String sig = SystemPropertyResolver.getStringProperty((String)"ducc.signature.required", (String)"on");
        this.signature_required = true;
        if (sig.equals("on")) {
            this.signature_required = true;
        } else if (sig.equals("off")) {
            this.signature_required = false;
        } else {
            logger.warn(methodName, null, new Object[]{"Incorrect value for property ducc.signature.required: " + sig + ". Setting to default of \"on\""});
        }
        logger.info(methodName, null, new Object[]{"---------------------------- NEW -----------------------------------------------------"});
        logger.info(methodName, null, new Object[]{"Service Manager starting:"});
        logger.info(methodName, null, new Object[]{"    DUCC home               : ", System.getProperty("DUCC_HOME")});
        logger.info(methodName, null, new Object[]{"    ActiveMQ URL            : ", System.getProperty("ducc.broker.url")});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    JVM                     : ", System.getProperty("java.vendor") + " " + System.getProperty("java.version")});
        logger.info(methodName, null, new Object[]{"    JAVA_HOME               : ", System.getProperty("java.home")});
        logger.info(methodName, null, new Object[]{"    JVM Path                : ", System.getProperty("ducc.jvm")});
        logger.info(methodName, null, new Object[]{"    JMX URL                 : ", System.getProperty("ducc.jmx.url")});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    OS Architecture         : ", System.getProperty("os.arch")});
        logger.info(methodName, null, new Object[]{"    Crypto enabled          : ", this.signature_required});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    Test mode enabled       : ", this.testmode});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    Service ping rate       : ", meta_ping_rate});
        logger.info(methodName, null, new Object[]{"    Service ping timeout    : ", meta_ping_timeout});
        logger.info(methodName, null, new Object[]{"    Service ping stability  : ", meta_ping_stability});
        logger.info(methodName, null, new Object[]{"    Default ping class      : ", default_ping_class});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    Init Failure Max        : ", init_failure_max});
        logger.info(methodName, null, new Object[]{"    Instance Failure Max    : ", failure_max});
        logger.info(methodName, null, new Object[]{"    Instance Failure Window : ", failure_window});
        logger.info(methodName, null, new Object[]{""});
        logger.info(methodName, null, new Object[]{"    DUCC Version            : ", Version.version()});
        logger.info(methodName, null, new Object[]{"    SM Version              : ", this.version});
        logger.info(methodName, null, new Object[]{"------------------------------------------------------------------------------------"});
        this.readAdministrators();
        Thread smThread = new Thread(this);
        smThread.setDaemon(true);
        smThread.start();
        Thread handlerThread = new Thread(this.handler);
        handlerThread.setDaemon(true);
        handlerThread.start();
    }

    @Override
    public void run() {
        String methodName = "run";
        logger.info(methodName, null, new Object[]{"Starting Service Manager"});
        try {
            this.init();
            this.runSm();
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        logger.info(methodName, null, new Object[]{"Service Manger returns."});
    }

    @Override
    public boolean isAdministrator(AServiceRequest ev) {
        return this.administrators.containsKey(ev.getUser()) && ev.asAdministrator();
    }

    public synchronized void bootHandler(IDuccWorkMap work) {
        HashMap<DuccId, DuccWorkJob> services = new HashMap<DuccId, DuccWorkJob>();
        for (Object o : work.values()) {
            DuccWorkJob j;
            IDuccWork w = (IDuccWork)o;
            if (w.getDuccType() != IDuccTypes.DuccType.Service || !(j = (DuccWorkJob)w).isActive()) continue;
            services.put(j.getDuccId(), j);
        }
        this.handler.bootImplementors(services);
    }

    void diffCommon(IDuccWork l, IDuccWork r, HashMap<DuccId, IDuccWork> modifiedJobs, HashMap<DuccId, IDuccWork> modifiedServices) {
        String methodName = "diffCommon";
        if (l.getDuccType() == IDuccTypes.DuccType.Reservation) {
            return;
        }
        if (l.getDuccType() == IDuccTypes.DuccType.Pop) {
            logger.trace(methodName, l.getDuccId(), new Object[]{"BOTH: GOT A POP:", l.getDuccId()});
        }
        if (l.getStateObject() != r.getStateObject()) {
            String serviceType = "/ Job";
            switch (l.getDuccType()) {
                case Service: 
                case Pop: {
                    switch (((IDuccWorkService)l).getServiceDeploymentType()) {
                        case uima: 
                        case custom: {
                            serviceType = "/ Service";
                            break;
                        }
                        case other: {
                            serviceType = "/ ManagedReservation";
                        }
                    }
                    break;
                }
            }
            logger.trace(methodName, l.getDuccId(), new Object[]{"Reconciling", l.getDuccType(), serviceType, "incoming state = ", l.getStateObject(), " my state = ", r.getStateObject()});
        }
        switch (l.getDuccType()) {
            case Job: {
                modifiedJobs.put(l.getDuccId(), l);
                this.localMap.addDuccWork(l);
                break;
            }
            case Service: {
                this.localMap.addDuccWork(l);
                switch (((IDuccWorkService)l).getServiceDeploymentType()) {
                    case uima: 
                    case custom: {
                        modifiedServices.put(l.getDuccId(), l);
                        break;
                    }
                    case other: {
                        modifiedJobs.put(l.getDuccId(), l);
                    }
                }
                break;
            }
        }
    }

    @Override
    public synchronized void processIncoming(IDuccWorkMap workMap) {
        IDuccWork l;
        IDuccWork r;
        String methodName = "processIncoming";
        HashMap<DuccId, IDuccWork> newJobs = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> newServices = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> deletedJobs = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> deletedServices = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> modifiedJobs = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> modifiedServices = new HashMap<DuccId, IDuccWork>();
        logger.info(methodName, null, new Object[]{"===== Orchestrator State Arrives ====="});
        if (workMap.size() == 0) {
            logger.debug(methodName, null, new Object[]{"OR state is empty"});
            return;
        }
        DuccCollectionUtils.DuccMapDifference diffmap = DuccCollectionUtils.difference((Map)workMap, (Map)this.localMap);
        for (Object o : workMap.values()) {
            IDuccWork w = (IDuccWork)o;
            logger.trace(methodName, w.getDuccId(), new Object[]{w.getDuccType(), "Arrives in state =", w.getStateObject()});
        }
        Map work = diffmap.getLeft();
        for (IDuccWork w : work.values()) {
            logger.trace(methodName, w.getDuccId(), new Object[]{"Calculating diffs on left side.", w.getDuccId()});
            if (w.getDuccType() == IDuccTypes.DuccType.Reservation) continue;
            if (w.getDuccType() == IDuccTypes.DuccType.Pop) {
                logger.trace(methodName, w.getDuccId(), new Object[]{"NEW: GOT A POP:", w.getDuccId()});
            }
            if (!((DuccWorkJob)w).isActive()) continue;
            logger.trace(methodName, w.getDuccId(), new Object[]{"Reconciling, adding", w.getDuccType()});
            block0 : switch (w.getDuccType()) {
                case Job: {
                    this.localMap.addDuccWork(w);
                    newJobs.put(w.getDuccId(), w);
                    break;
                }
                case Service: {
                    this.localMap.addDuccWork(w);
                    switch (((IDuccWorkService)w).getServiceDeploymentType()) {
                        case uima: 
                        case custom: {
                            newServices.put(w.getDuccId(), w);
                            break block0;
                        }
                        case other: {
                            newJobs.put(w.getDuccId(), w);
                        }
                    }
                    break;
                }
            }
        }
        work = diffmap.getRight();
        for (IDuccWork w : work.values()) {
            logger.trace(methodName, w.getDuccId(), new Object[]{"Doing diffs on right"});
            if (w.getDuccType() == IDuccTypes.DuccType.Reservation) continue;
            if (w.getDuccType() == IDuccTypes.DuccType.Pop) {
                logger.trace(methodName, w.getDuccId(), new Object[]{"DELETED: GOT A POP:", w.getDuccId()});
            }
            logger.debug(methodName, w.getDuccId(), new Object[]{"Reconciling, deleting instance of type ", w.getDuccType()});
            block8 : switch (w.getDuccType()) {
                case Job: {
                    this.localMap.removeDuccWork(w.getDuccId());
                    deletedJobs.put(w.getDuccId(), w);
                    break;
                }
                case Service: {
                    this.localMap.removeDuccWork(w.getDuccId());
                    switch (((IDuccWorkService)w).getServiceDeploymentType()) {
                        case uima: 
                        case custom: {
                            deletedServices.put(w.getDuccId(), w);
                            break block8;
                        }
                        case other: {
                            deletedJobs.put(w.getDuccId(), w);
                        }
                    }
                    break;
                }
            }
        }
        for (DuccCollectionUtils.DuccMapValueDifference jd : diffmap) {
            r = (IDuccWork)jd.getRight();
            l = (IDuccWork)jd.getLeft();
            logger.trace(methodName, r.getDuccId(), new Object[]{"Doing diffs on middle A:", r.getDuccId(), l.getDuccId()});
            this.diffCommon(l, r, modifiedJobs, modifiedServices);
        }
        work = diffmap.getCommon();
        for (DuccId k : work.keySet()) {
            r = (IDuccWork)this.localMap.get((Object)k);
            l = (IDuccWork)workMap.get((Object)k);
            logger.trace(methodName, r.getDuccId(), new Object[]{"Doing diffs on middle B:", r.getDuccId(), l.getDuccId()});
            this.diffCommon(l, r, modifiedJobs, modifiedServices);
        }
        this.handler.signalUpdates(newJobs, newServices, deletedJobs, deletedServices, modifiedJobs, modifiedServices);
    }

    @Override
    public void publish(ServiceMap map) {
        String methodName = "publish";
        try {
            SmStateDuccEvent ev = new SmStateDuccEvent();
            logger.info(methodName, null, new Object[]{"Publishing State, active job count =", map.size()});
            if (logger.isDebug()) {
                logger.info(methodName, null, new Object[]{map.toPrint()});
            }
            ev.setServiceMap(map);
            this.eventDispatcher.dispatch(this.stateEndpoint, (DuccEvent)ev, "");
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void setTransportConfiguration(DuccEventDispatcher eventDispatcher, String endpoint) {
        this.eventDispatcher = eventDispatcher;
        this.stateEndpoint = endpoint;
    }

    public synchronized void runSm() {
        String methodName = "runSm";
        boolean first_update = true;
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.info(methodName, null, new Object[]{"SM wait interrupted, executing out-of-band epoch."});
            }
            try {
                if (first_update) {
                    this.bootHandler(this.incomingMap);
                    first_update = false;
                }
                this.processIncoming(this.incomingMap);
                continue;
            }
            catch (Throwable e1) {
                logger.fatal(methodName, null, e1, new Object[0]);
                continue;
            }
            break;
        }
    }

    @Override
    public synchronized void orchestratorStateArrives(IDuccWorkMap map) {
        String methodName = "orchestratorStateArrives";
        if (!this.initialized) {
            logger.info(methodName, null, new Object[]{"SM not initialized, ignoring Orchestrator state update."});
            return;
        }
        if (!map.isJobDriverNodeAssigned()) {
            logger.info(methodName, null, new Object[]{"Orchestrator JD node not assigned, ignoring Orchestrator state update."});
            return;
        }
        this.orchestrator_alive = true;
        ++this.epochCounter;
        this.incomingMap = map;
        this.notify();
    }

    static String serviceFileLocation() {
        return System.getProperty("DUCC_HOME") + "/state/services";
    }

    static String serviceHistoryLocation() {
        return System.getProperty("DUCC_HOME") + "/history/services-registry/";
    }

    private String serviceFileKey(String fn) {
        return ServiceManagerComponent.serviceFileLocation() + "/" + fn;
    }

    private boolean check_signature(String user, byte[] auth_block) throws Throwable {
        String userHome = null;
        userHome = this.testmode ? System.getProperty("user.home") : LinuxUtils.getUserHome((String)user);
        Crypto crypto = new Crypto(user, userHome, Crypto.AccessType.READER);
        String signature = (String)crypto.decrypt(auth_block);
        return user.equals(signature);
    }

    private boolean validate_user(String action, AServiceRequest req) {
        String methodName = "validate_user";
        if (req.getCliVersion() != CliVersion.getVersion()) {
            String reason = "Incompatible CLI request using version " + req.getCliVersion() + " while DUCC expects version " + CliVersion.getVersion();
            logger.warn(methodName, null, new Object[]{action + " rejected. " + reason});
            req.setReply(ServiceManagerComponent.makeResponse(false, reason, action, -1L));
            return false;
        }
        String user = req.getUser();
        byte[] auth_block = req.getAuth();
        boolean validated = false;
        if (!this.signature_required) {
            return true;
        }
        try {
            validated = this.check_signature(user, auth_block);
        }
        catch (Throwable t) {
            logger.error(methodName, null, new Object[]{"Crypto failure:", t.toString()});
        }
        if (!validated) {
            logger.warn(methodName, null, new Object[]{"User", user, "cannot be validated.", action, "rejected."});
            req.setReply(ServiceManagerComponent.makeResponse(false, "User " + user + " cannot be validated. " + action + " rejected.", action, -1L));
            return false;
        }
        return true;
    }

    public boolean orchestratorAlive(String action, AServiceRequest req) {
        String methodName = "orchestratorAlive";
        if (this.orchestrator_alive) {
            return true;
        }
        logger.warn(methodName, null, new Object[]{action, "rejected: orchestrator is not yet active"});
        req.setReply(ServiceManagerComponent.makeResponse(false, action + " rejected, DUCC is still initializing.", action, -1L));
        return false;
    }

    @Override
    public synchronized void register(ServiceRegisterEvent ev) {
        String methodName = "register";
        DuccProperties props = ev.getDescriptor();
        String endpoint = ev.getEndpoint();
        int instances = ev.getNinstances();
        IService.Trinary autostart = ev.getAutostart();
        String user = ev.getUser();
        long regdate = System.currentTimeMillis();
        String regdate_readable = new Date(regdate).toString();
        if (!this.validate_user("Register", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Register", (AServiceRequest)ev)) {
            return;
        }
        DuccId id = null;
        try {
            id = this.newId();
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
            ev.setReply(ServiceManagerComponent.makeResponse(false, "Internal error; unable to generate id", endpoint, -1L));
            return;
        }
        logger.debug(methodName, id, new Object[]{"Unique:", id.getUnique()});
        String logdir = props.getProperty(IUiOptions.UiOption.LogDirectory.pname());
        if (!logdir.endsWith("/")) {
            logdir = logdir + "/";
        }
        logdir = logdir + "S-" + id.toString();
        props.put((Object)IUiOptions.UiOption.LogDirectory.pname(), (Object)logdir);
        DuccProperties meta = new DuccProperties();
        meta.setProperty("user", user);
        meta.setProperty("instances", "" + instances);
        meta.setProperty("endpoint", endpoint);
        meta.setProperty("numeric_id", id.toString());
        meta.setProperty("uuid", id.getUnique());
        meta.setProperty("registration-date-millis", Long.toString(regdate));
        meta.setProperty("registration-date", regdate_readable);
        if (autostart == IService.Trinary.True) {
            meta.setProperty("autostart", "true");
        } else {
            meta.setProperty("autostart", "false");
        }
        String desc_name = this.descriptor_dir + "/" + id + ".svc";
        String meta_name = this.descriptor_dir + "/" + id + ".meta";
        ServiceReplyEvent reply = this.handler.register(id, desc_name, meta_name, props, meta);
        ev.setReply(reply);
        if (reply.getReturnCode()) {
            logger.info(methodName, id, new Object[]{ev.toString()});
        } else {
            logger.warn(methodName, id, new Object[]{ev.toString()});
        }
    }

    @Override
    public synchronized void unregister(ServiceUnregisterEvent ev) {
        String methodName = "unregister";
        long id = ev.getFriendly();
        if (!this.validate_user("Unregister", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Unregister", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"De-registering service", id});
        ServiceReplyEvent reply = this.handler.unregister(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void start(ServiceStartEvent ev) {
        String methodName = "start";
        if (!this.validate_user("Start", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Start", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Starting service", ev.toString()});
        ServiceReplyEvent reply = this.handler.start(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void stop(ServiceStopEvent ev) {
        String methodName = "stop";
        if (!this.validate_user("Stop", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Stop", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Stopping service", ev.toString()});
        ServiceReplyEvent reply = this.handler.stop(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void enable(ServiceEnableEvent ev) {
        String methodName = "enable";
        if (!this.validate_user("Enable", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Enable", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Enabling service", ev.toString()});
        ServiceReplyEvent reply = this.handler.enable(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void disable(ServiceDisableEvent ev) {
        String methodName = "disable";
        if (!this.validate_user("Disable", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Disable", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Disabling service", ev.toString()});
        ServiceReplyEvent reply = this.handler.disable(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void observe(ServiceObserveEvent ev) {
        String methodName = "observe";
        if (!this.validate_user("Observe", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Observe", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Observing references for service", ev.toString()});
        ServiceReplyEvent reply = this.handler.observe(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void ignore(ServiceIgnoreEvent ev) {
        String methodName = "ignore";
        if (!this.validate_user("Ignore", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Ignore", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Ignoring references for service", ev.toString()});
        ServiceReplyEvent reply = this.handler.ignore(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void query(ServiceQueryEvent ev) {
        String methodName = "query";
        if (!this.validate_user("Query", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Query", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Query", ev.toString()});
        ServiceReplyEvent reply = this.handler.query(ev);
        ev.setReply(reply);
    }

    @Override
    public synchronized void modify(ServiceModifyEvent ev) {
        String methodName = "modify";
        if (!this.validate_user("Modify", (AServiceRequest)ev)) {
            return;
        }
        if (!this.orchestratorAlive("Modify", (AServiceRequest)ev)) {
            return;
        }
        logger.info(methodName, null, new Object[]{"Modify", ev.toString()});
        ServiceReplyEvent reply = this.handler.modify(ev);
        ev.setReply(reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuccId newId() throws Exception {
        DuccId id = null;
        Object object = this.idSync;
        synchronized (object) {
            id = this.idFactory.next();
            this.sm_props.setProperty(this.service_seqno, id.toString());
            FileOutputStream fos = new FileOutputStream(this.state_file);
            this.sm_props.store((OutputStream)fos, "Service Manager Properties");
            fos.close();
        }
        return id;
    }

    static void deleteProperties(String id, String meta_filename, Properties meta_props, String props_filename, Properties job_props) {
        FileOutputStream fos;
        String methodName = "deleteProperties";
        String history_dir = ServiceManagerComponent.serviceHistoryLocation();
        if (meta_filename != null) {
            File mfh = new File(history_dir + id + ".meta");
            try {
                fos = new FileOutputStream(mfh);
                meta_props.store(fos, "Archived meta descriptor");
                fos.close();
            }
            catch (Exception e) {
                logger.warn(methodName, null, new Object[]{id + ": Unable to save history to \"" + mfh.toString(), ": ", e.toString() + "\""});
            }
            File mf = new File(meta_filename);
            mf.delete();
        }
        meta_filename = null;
        if (props_filename != null) {
            File pfh = new File(history_dir + id + ".svc");
            try {
                fos = new FileOutputStream(pfh);
                job_props.store(fos, "Archived meta descriptor");
                fos.close();
            }
            catch (Exception e) {
                logger.warn(methodName, null, new Object[]{id + ":Unable to save history to \"" + pfh.toString(), ": ", e.toString() + "\""});
            }
            File pf = new File(props_filename);
            pf.delete();
        }
        props_filename = null;
    }

    static {
        init_failure_max = 1;
        failure_max = 5;
        failure_window = 30;
    }
}

