/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.sm.ServiceInstance;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.transport.event.common.IDuccState;

class PingOnlyServiceInstance
extends ServiceInstance {
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    private PingOnlyDriver driver = null;
    private PingOnlyServiceInstance me = this;

    PingOnlyServiceInstance(ServiceSet sset) {
        super(sset);
    }

    @Override
    long start(String spec, DuccProperties meta_props) {
        String methodName = "start";
        this.logger.info(methodName, this.sset.getId(), new Object[]{"START PING-ONLY INSTANCE"});
        this.state = IDuccState.JobState.Running;
        this.setStopped(false);
        this.driver = new PingOnlyDriver();
        Thread driver_thread = new Thread(this.driver);
        driver_thread.start();
        return this.numeric_id;
    }

    @Override
    void stop() {
        String methodName = "stop";
        this.logger.info(methodName, this.sset.getId(), new Object[]{"STOP PING-ONLY INSTANCE"});
        this.state = IDuccState.JobState.Completed;
        this.sset.signal(this.me);
        this.sset.removeImplementor(this);
        this.driver.stop();
        this.setStopped(true);
    }

    class PingOnlyDriver
    implements Runnable {
        boolean stopped = false;

        PingOnlyDriver() {
        }

        public synchronized void stop() {
            this.stopped = true;
        }

        @Override
        public void run() {
            String methodName = "PingOnlyDriver.run()";
            int delay = SystemPropertyResolver.getIntProperty((String)"ducc.orchestrator.state.publish.rate", (int)30000);
            while (!this.stopped) {
                try {
                    PingOnlyServiceInstance.this.logger.info(methodName, PingOnlyServiceInstance.this.sset.getId(), new Object[]{"Starts Wait of", delay});
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                PingOnlyServiceInstance.this.sset.signal(PingOnlyServiceInstance.this.me);
            }
            return;
        }
    }
}

