/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm.event;

import org.apache.camel.Body;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.sm.IServiceManager;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.OrchestratorAbbreviatedStateDuccEvent;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.ServiceDisableEvent;
import org.apache.uima.ducc.transport.event.ServiceEnableEvent;
import org.apache.uima.ducc.transport.event.ServiceIgnoreEvent;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceObserveEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryEvent;
import org.apache.uima.ducc.transport.event.ServiceRegisterEvent;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.delegate.DuccEventDelegateListener;

public class ServiceManagerEventListener
implements DuccEventDelegateListener {
    private IServiceManager serviceManager;
    private static DuccLogger logger = DuccLogger.getLogger((String)ServiceManagerEventListener.class.getName(), (String)"SM");

    public ServiceManagerEventListener(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void setDuccEventDispatcher(DuccEventDispatcher eventDispatcher) {
    }

    public void setEndpoint(String endpoint) {
    }

    private ServiceReplyEvent failureEvent(String message) {
        return new ServiceReplyEvent(false, message, "no.endpoint", -1L);
    }

    private ServiceReplyEvent failureEvent() {
        return this.failureEvent("Internal error, check SM logs.");
    }

    public void onServiceRegisterEvent(@Body ServiceRegisterEvent duccEvent) throws Exception {
        String methodName = "onServiceRegisterEvent";
        try {
            this.serviceManager.register(duccEvent);
        }
        catch (IllegalStateException e) {
            duccEvent.setReply(this.failureEvent(e.getMessage()));
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceUnregisterEvent(@Body ServiceUnregisterEvent duccEvent) throws Exception {
        String methodName = "onServiceUnregisterEvent";
        try {
            this.serviceManager.unregister(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceStartEvent(@Body ServiceStartEvent duccEvent) throws Exception {
        String methodName = "onServiceStartEvent";
        try {
            logger.info(methodName, null, new Object[]{"-------------- Start ----------", duccEvent.toString()});
            this.serviceManager.start(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceStopEvent(@Body ServiceStopEvent duccEvent) throws Exception {
        String methodName = "onServiceStopEvent";
        try {
            this.serviceManager.stop(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceEnableEvent(@Body ServiceEnableEvent duccEvent) throws Exception {
        String methodName = "onServiceEnableEvent";
        try {
            this.serviceManager.enable(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceDisableEvent(@Body ServiceDisableEvent duccEvent) throws Exception {
        String methodName = "onServiceDisableEvent";
        try {
            this.serviceManager.disable(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceIgnoreEvent(@Body ServiceIgnoreEvent duccEvent) throws Exception {
        String methodName = "onServiceIgnoreEvent";
        try {
            this.serviceManager.ignore(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceObserveEvent(@Body ServiceObserveEvent duccEvent) throws Exception {
        String methodName = "onServiceObserveEvent";
        try {
            this.serviceManager.observe(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceModifyEvent(@Body ServiceModifyEvent duccEvent) throws Exception {
        String methodName = "onServiceModifyEvent";
        try {
            logger.info(methodName, null, new Object[]{"-------------- Modify ----------", duccEvent.toString()});
            this.serviceManager.modify(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onServiceQueryEvent(@Body ServiceQueryEvent duccEvent) throws Exception {
        String methodName = "onServiceQueryEvent";
        try {
            this.serviceManager.query(duccEvent);
        }
        catch (Throwable t) {
            duccEvent.setReply(this.failureEvent());
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    public void onOrchestratorStateDuccEvent(@Body OrchestratorStateDuccEvent duccEvent) throws Exception {
    }

    public void onOrchestratorAbbreviatedStateDuccEvent(@Body OrchestratorAbbreviatedStateDuccEvent duccEvent) throws Exception {
        String methodName = "onOrchestratorAbbreviatedStateDuccEvent";
        try {
            this.serviceManager.orchestratorStateArrives(duccEvent.getWorkMap());
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
    }
}

