/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.cli.IServiceApi;
import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.cli.UimaAsPing;
import org.apache.uima.ducc.cli.UimaAsServiceMonitor;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.TcpStreamHandler;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.ADuccId;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.sm.IServiceMeta;
import org.apache.uima.ducc.sm.PingDriver;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceDescription;
import org.apache.uima.ducc.transport.event.sm.ServiceDescription;
import org.apache.uima.util.Level;

public class ServiceSet
implements SmConstants {
    private static final long serialVersionUID = 1L;
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    HashMap<DuccId, IDuccState.JobState> implementors = new HashMap();
    HashMap<DuccId, DuccId> references = new HashMap();
    DuccId id;
    HashMap<Long, DuccId> friendly_ids = new HashMap();
    String history_key = "work-instances";
    List<ServiceSet> predecessors = new ArrayList<ServiceSet>();
    List<ServiceSet> successors = new ArrayList<ServiceSet>();
    String key;
    String endpoint;
    String broker;
    String broker_host;
    int broker_port;
    int broker_jmx_port = 1099;
    String[] independentServices = null;
    String user;
    boolean autostart = false;
    boolean stopped = false;
    boolean referenced_start = false;
    int instances = 1;
    IServiceMeta serviceMeta = null;
    IServiceMeta residualMeta = null;
    DuccProperties job_props = null;
    DuccProperties meta_props = null;
    String props_filename = null;
    String meta_filename = null;
    boolean deregistered = false;
    IService.ServiceType service_type = IService.ServiceType.Undefined;
    IService.ServiceClass service_class = IService.ServiceClass.Undefined;
    IService.ServiceState service_state = IService.ServiceState.Undefined;
    Timer timer = null;
    LingerTask linger = null;
    long linger_time = 5000L;
    int failure_max = ServiceManagerComponent.failure_max;
    int failure_run = 0;

    public ServiceSet(String key, DuccId id) {
        this.key = key;
        this.id = id;
        this.parseEndpoint(key);
        if (this.service_type == IService.ServiceType.Custom) {
            throw new IllegalStateException("Custom services may not be referenced as Implicit services.");
        }
        this.service_type = IService.ServiceType.UimaAs;
        this.service_class = IService.ServiceClass.Implicit;
        String state_dir = System.getProperty("DUCC_HOME") + "/state";
        this.job_props = new DuccProperties();
        this.props_filename = state_dir + "/services/" + id.toString() + ".svc";
        this.saveServiceProperties();
        this.meta_props = new DuccProperties();
        this.meta_props.put((Object)"user", (Object)System.getProperty("user.name"));
        this.meta_props.put((Object)"endpoint", (Object)key);
        this.meta_props.put((Object)"service-class", (Object)("" + this.service_class.decode()));
        this.meta_props.put((Object)"service-type", (Object)("" + this.service_type.decode()));
        this.meta_props.put((Object)"stopped", (Object)("" + this.stopped));
        this.meta_props.put((Object)"service-state", (Object)("" + this.getServiceState()));
        this.meta_props.put((Object)"ping-active", (Object)"false");
        this.meta_props.put((Object)"service-alive", (Object)"false");
        this.meta_props.put((Object)"service-healthy", (Object)"false");
        this.meta_props.put((Object)"service-statistics", (Object)"N/A");
        this.meta_props.put((Object)"ping-only", (Object)"true");
        this.meta_filename = state_dir + "/services/" + id.toString() + ".meta";
        this.saveMetaProperties();
    }

    public ServiceSet(DuccId id, DuccId first_implementor, String key, String[] independentServices) {
        this.key = key;
        this.id = id;
        this.friendly_ids.put(first_implementor.getFriendly(), null);
        this.independentServices = independentServices;
        this.service_class = IService.ServiceClass.Submitted;
        this.parseEndpoint(key);
        String state_dir = System.getProperty("DUCC_HOME") + "/state";
        this.job_props = new DuccProperties();
        this.props_filename = state_dir + "/services/" + id.toString() + ".svc";
        this.saveServiceProperties();
        this.meta_props = new DuccProperties();
        this.meta_props.put((Object)"user", (Object)System.getProperty("user.name"));
        this.meta_props.put((Object)"endpoint", (Object)key);
        this.meta_props.put((Object)"service-class", (Object)("" + this.service_class.decode()));
        this.meta_props.put((Object)"service-type", (Object)("" + this.service_type.decode()));
        this.meta_props.put((Object)"stopped", (Object)("" + this.stopped));
        this.meta_props.put((Object)"service-state", (Object)("" + this.getServiceState()));
        this.meta_props.put((Object)"ping-active", (Object)"false");
        this.meta_props.put((Object)"service-alive", (Object)"false");
        this.meta_props.put((Object)"service-healthy", (Object)"false");
        this.meta_props.put((Object)"service-statistics", (Object)"N/A");
        this.meta_props.put((Object)"implementors", (Object)("" + id.getFriendly()));
        this.meta_props.put((Object)"ping-only", (Object)"false");
        this.meta_filename = state_dir + "/services/" + id.toString() + ".meta";
        this.saveMetaProperties();
    }

    public ServiceSet(DuccId id, String props_filename, String meta_filename, DuccProperties props, DuccProperties meta) {
        this.job_props = props;
        this.meta_props = meta;
        this.id = id;
        this.props_filename = props_filename;
        this.meta_filename = meta_filename;
        this.service_state = IService.ServiceState.NotAvailable;
        this.linger_time = props.getLongProperty(IServiceApi.RegistrationOption.ServiceLinger.decode(), 5000L);
        this.key = meta.getProperty("endpoint");
        this.failure_max = props.getIntProperty(IUiOptions.UiOption.InstanceFailuresLimit.pname(), ServiceManagerComponent.failure_max);
        this.parseEndpoint(this.key);
        this.user = meta.getProperty("user");
        this.instances = meta.getIntProperty("instances", 1);
        this.autostart = meta.getBooleanProperty("autostart", false);
        String idprop = meta.getProperty("implementors", null);
        if (idprop != null) {
            String[] ids;
            for (String i : ids = idprop.split("\\s")) {
                this.friendly_ids.put(Long.parseLong(i), null);
            }
        }
        this.service_class = IService.ServiceClass.Registered;
        this.parseIndependentServices();
        if (!this.job_props.containsKey((Object)"service_ping_dolog")) {
            this.job_props.put((Object)"service_ping_dolog", (Object)"false");
        }
        if (!this.job_props.containsKey((Object)"service_ping_timeout")) {
            this.job_props.put((Object)"service_ping_timeout", (Object)("" + ServiceManagerComponent.meta_ping_timeout));
        }
        this.meta_props.put((Object)"service-class", (Object)("" + this.service_class.decode()));
        this.meta_props.put((Object)"service-type", (Object)("" + this.service_type.decode()));
        this.meta_props.put((Object)"stopped", (Object)("" + this.stopped));
        this.meta_props.put((Object)"service-state", (Object)("" + this.getServiceState()));
        this.meta_props.put((Object)"ping-active", (Object)"false");
        this.meta_props.put((Object)"service-alive", (Object)"false");
        this.meta_props.put((Object)"service-healthy", (Object)"false");
        this.meta_props.put((Object)"service-statistics", (Object)"N/A");
        if (this.isStartable()) {
            this.meta_props.put((Object)"ping-only", (Object)"false");
        } else {
            this.meta_props.put((Object)"ping-only", (Object)"true");
        }
        UIMAFramework.getLogger().setLevel(Level.OFF);
    }

    DuccId getId() {
        return this.id;
    }

    protected void parseEndpoint(String ep) {
        if (ep.startsWith(IService.ServiceType.UimaAs.decode())) {
            int ndx = ep.indexOf(":");
            ep = ep.substring(ndx + 1);
            ndx = ep.indexOf(":");
            this.endpoint = ep.substring(0, ndx).trim();
            this.broker = ep.substring(ndx + 1).trim();
            this.service_type = IService.ServiceType.UimaAs;
            URL url = null;
            try {
                url = new URL(null, this.broker, (URLStreamHandler)new TcpStreamHandler());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid broker URL: " + this.broker);
            }
            this.broker_host = url.getHost();
            this.broker_port = url.getPort();
            if (this.endpoint.equals("") || this.broker.equals("")) {
                throw new IllegalArgumentException("The endpoint cannot be parsed.  Expecting UIMA-AS:Endpoint:Broker, received " + this.key);
            }
        } else {
            this.service_type = IService.ServiceType.Custom;
            int ndx = ep.indexOf(":");
            this.endpoint = ep.substring(ndx + 1);
        }
    }

    synchronized void deleteProperties() {
        String history = this.meta_props.getStringProperty(this.history_key, "");
        for (Long id : this.friendly_ids.keySet()) {
            history = history + " " + id.toString();
        }
        this.meta_props.put((Object)this.history_key, (Object)history);
        this.meta_props.remove((Object)"implementors");
        ServiceManagerComponent.deleteProperties(this.id.toString(), this.meta_filename, (Properties)this.meta_props, this.props_filename, (Properties)this.job_props);
        this.meta_filename = null;
        this.props_filename = null;
    }

    void setIncoming(ServiceSet sset) {
        this.predecessors.add(sset);
    }

    void clearEdges() {
        this.predecessors.clear();
        this.successors.clear();
    }

    boolean isStopped() {
        return this.stopped;
    }

    boolean hasPredecessor() {
        return this.predecessors.size() != 0;
    }

    List<ServiceSet> getPredecessors() {
        return this.predecessors;
    }

    void removePredecessor(ServiceSet pred) {
        this.predecessors.remove(pred);
    }

    void setOutgoing(ServiceSet sset) {
        this.successors.add(sset);
    }

    List<ServiceSet> getSuccessors() {
        return new ArrayList<ServiceSet>(this.successors);
    }

    void removeSuccessor(ServiceSet succ) {
        this.successors.remove(succ);
    }

    boolean hasSuccessor() {
        return this.successors.size() != 0;
    }

    String[] getIndependentServices() {
        return this.independentServices;
    }

    void setIndependentServices(String[] ind) {
        this.independentServices = ind;
    }

    private void parseIndependentServices() {
        String depstr = this.job_props.getProperty(IServiceApi.RegistrationOption.ServiceDependency.decode());
        String[] result = null;
        if (depstr != null) {
            result = depstr.split("\\s");
            for (int i = 0; i < result.length; ++i) {
                result[i] = result[i].trim();
            }
        }
        this.independentServices = result;
    }

    boolean isStartable() {
        switch (this.service_type) {
            case UimaAs: {
                return true;
            }
            case Custom: {
                return this.job_props.containsKey((Object)"process_executable");
            }
        }
        return false;
    }

    void synchronizeImplementors(Map<DuccId, IDuccState.JobState> work) {
        HashMap<Long, DuccId> newmap = new HashMap<Long, DuccId>();
        for (DuccId id : work.keySet()) {
            long fid = id.getFriendly();
            if (!this.friendly_ids.containsKey(fid)) continue;
            IDuccState.JobState js = work.get(id);
            this.implementors.put(id, js);
            newmap.put(fid, id);
        }
        String history = this.meta_props.getStringProperty(this.history_key, "");
        for (Long friendly : this.friendly_ids.keySet()) {
            DuccId id = (DuccId)newmap.get(friendly);
            if (id != null) continue;
            history = history + " " + friendly;
        }
        this.meta_props.put((Object)this.history_key, (Object)history);
        this.friendly_ids = newmap;
        this.persistImplementors();
    }

    void enforceAutostart() {
        if (!this.autostart) {
            return;
        }
        if (this.stopped) {
            return;
        }
        if (this.failure_run >= this.failure_max) {
            return;
        }
        if (!this.isStartable() && this.serviceMeta == null) {
            this.start();
            return;
        }
        int needed = Math.max(0, this.instances - this.countImplementors());
        while (needed-- > 0 && this.start()) {
        }
    }

    public void addImplementor(DuccId id, IDuccState.JobState js) {
        if (this.isSubmitted()) {
            this.friendly_ids.put(id.getFriendly(), id);
        }
        this.implementors.put(id, js);
        this.persistImplementors();
    }

    void promote() {
        String methodName = "promote";
        this.logger.debug(methodName, null, new Object[]{"Promoting", this.key});
        switch (this.service_class) {
            case Implicit: {
                this.service_class = IService.ServiceClass.Submitted;
                break;
            }
            case Submitted: {
                break;
            }
            default: {
                throw new IllegalStateException("Trying to promote a Registered service!");
            }
        }
    }

    boolean isUimaAs() {
        return this.service_type == IService.ServiceType.UimaAs;
    }

    boolean isCustom() {
        return this.service_type == IService.ServiceType.Custom;
    }

    Map<DuccId, IDuccState.JobState> getImplementors() {
        return this.implementors;
    }

    DuccProperties getJobProperties() {
        return this.job_props;
    }

    DuccProperties getMetaProperties() {
        return this.meta_props;
    }

    boolean isImplicit() {
        return this.service_class == IService.ServiceClass.Implicit;
    }

    boolean isSubmitted() {
        return this.service_class == IService.ServiceClass.Submitted;
    }

    boolean isPingOnly() {
        return this.meta_props.containsKey((Object)"ping-only");
    }

    boolean isRegistered() {
        return this.service_class == IService.ServiceClass.Registered && !this.deregistered;
    }

    void setReferencedStart(boolean val) {
        this.referenced_start = val;
    }

    boolean isReferencedStart() {
        return this.referenced_start;
    }

    String getUser() {
        return this.user;
    }

    boolean isDeregistered() {
        return this.service_class == IService.ServiceClass.Registered && this.deregistered;
    }

    void deregister() {
        this.deregistered = true;
    }

    String getMetaFilename() {
        return this.meta_filename;
    }

    String getPropsFilename() {
        return this.props_filename;
    }

    synchronized int getNInstances() {
        return this.instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void saveMetaProperties() {
        IServiceStatistics ss;
        String methodName = "saveMetaProperties";
        if (this.meta_filename == null) {
            this.logger.warn(methodName, this.id, new Object[]{"Meta properties is deleted, bypassing attempt to save."});
            return;
        }
        this.meta_props.put((Object)"stopped", (Object)("" + this.stopped));
        this.meta_props.put((Object)"service-state", (Object)("" + this.getServiceState()));
        this.meta_props.put((Object)"ping-active", (Object)("" + (this.serviceMeta != null)));
        this.meta_props.put((Object)"service-alive", (Object)"false");
        this.meta_props.put((Object)"service-healthy", (Object)"false");
        this.meta_props.put((Object)"service-statistics", (Object)"N/A");
        if (this.serviceMeta != null && (ss = this.serviceMeta.getServiceStatistics()) != null) {
            this.meta_props.put((Object)"service-alive", (Object)("" + ss.isAlive()));
            this.meta_props.put((Object)"service-healthy", (Object)("" + ss.isHealthy()));
            this.meta_props.put((Object)"service-statistics", (Object)("" + ss.getInfo()));
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.meta_filename);
            this.meta_props.store((OutputStream)fos, "Meta descriptor");
        }
        catch (FileNotFoundException e) {
            this.logger.warn(methodName, this.id, new Object[]{"Cannot save meta properties, file does not exist."});
        }
        catch (IOException e) {
            this.logger.warn(methodName, this.id, new Object[]{"I/O Error saving meta properties:", e});
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveServiceProperties() {
        String methodName = "saveServiceProperties";
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.props_filename);
            this.job_props.store((OutputStream)fos, "Service descriptor");
        }
        catch (FileNotFoundException e) {
            this.logger.warn(methodName, this.id, new Object[]{"Cannot save service properties, file does not exist."});
        }
        catch (IOException e) {
            this.logger.warn(methodName, this.id, new Object[]{"I/O Error saving service properties:", e});
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    synchronized void setNInstances(int n) {
        if (n != this.meta_props.getIntProperty("instances")) {
            this.meta_props.setProperty("instances", Integer.toString(n));
            this.instances = n;
            this.saveMetaProperties();
        }
    }

    synchronized void setAutostart(boolean auto) {
        this.meta_props.setProperty("autostart", auto ? "true" : "false");
        this.autostart = auto;
        this.saveMetaProperties();
        if (auto) {
            this.failure_run = 0;
        }
    }

    synchronized boolean isAutostart() {
        return this.autostart;
    }

    synchronized void persistImplementors() {
        if (this.isImplicit()) {
            return;
        }
        if (this.friendly_ids.size() == 0) {
            this.meta_props.remove((Object)"implementors");
        } else {
            StringBuffer sb = new StringBuffer();
            for (Long l : this.friendly_ids.keySet()) {
                sb.append(Long.toString(l));
                sb.append(" ");
            }
            String s = sb.toString().trim();
            this.meta_props.setProperty("implementors", s);
        }
        this.saveMetaProperties();
    }

    synchronized void persistReferences() {
        if (this.references.size() == 0) {
            this.meta_props.remove((Object)"references");
        } else {
            StringBuffer sb = new StringBuffer();
            for (DuccId id : this.references.keySet()) {
                sb.append(id.toString());
                sb.append(" ");
            }
            String s = sb.toString().trim();
            this.meta_props.setProperty("references", s);
        }
        this.saveMetaProperties();
    }

    boolean matches(DuccId did) {
        if (!this.isRegistered()) {
            return false;
        }
        if (this.friendly_ids.containsKey(did.getFriendly())) {
            this.friendly_ids.put(did.getFriendly(), did);
            return true;
        }
        return false;
    }

    boolean containsImplementor(DuccId id) {
        return this.friendly_ids.containsKey(id.getFriendly());
    }

    public void removeImplementor(DuccId id) {
        String pingclass;
        String methodName = "removeImplementors";
        if (!this.implementors.containsKey(id)) {
            return;
        }
        this.logger.debug(methodName, this.id, new Object[]{"Removing implementor", id});
        this.implementors.remove(id);
        this.friendly_ids.remove(id.getFriendly());
        if (this.implementors.size() == 0) {
            this.stopPingThread();
        }
        String history = this.meta_props.getStringProperty(this.history_key, "");
        history = history + " " + id.toString();
        this.meta_props.put((Object)this.history_key, (Object)history);
        this.persistImplementors();
        this.logger.debug(methodName, id, new Object[]{"implementors.size()", this.implementors.size(), "service_class", this.service_class, "isStartable()", this.isStartable(), "isSubmitted()", this.isSubmitted(), "service_type", this.service_type, "ping_class", this.job_props.getStringProperty("service_ping_class", UimaAsPing.class.getName())});
        if (this.implementors.size() == 0 && (this.service_class == IService.ServiceClass.Registered && this.isStartable() || this.isSubmitted()) && this.service_type == IService.ServiceType.UimaAs && (pingclass = this.job_props.getStringProperty("service_ping_class", UimaAsPing.class.getName())).equals(UimaAsPing.class.getName())) {
            UimaAsServiceMonitor monitor = new UimaAsServiceMonitor(this.endpoint, this.broker_host, this.broker_jmx_port);
            this.logger.debug(methodName, id, new Object[]{"Clearing queues"});
            try {
                monitor.init(null);
                monitor.clearQueues();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized int countImplementors() {
        return this.friendly_ids.size();
    }

    public synchronized int reference(DuccId id) {
        String methodName = "reference";
        this.logger.debug(methodName, this.id, new Object[]{" ---------------- Service ", this.id, "references", id});
        if (this.linger != null) {
            this.logger.debug(methodName, this.id, new Object[]{" ---------------- Canceling linger task"});
            this.linger.cancel();
            this.linger = null;
        }
        this.references.put(id, id);
        this.persistReferences();
        return this.references.size();
    }

    public synchronized int dereference(DuccId id) {
        if (this.references.remove(id) == null) {
            throw new IllegalStateException("Id " + id + " not found in map for " + this.getKey());
        }
        if (this.references.size() == 0 && (this.isImplicit() || this.isCustom() && !this.isStartable())) {
            this.stopPingThread();
        }
        this.persistReferences();
        return this.references.size();
    }

    public synchronized int countReferences() {
        return this.references.size();
    }

    private IService.ServiceState translateJobState(IDuccState.JobState js) {
        switch (js) {
            case Received: 
            case WaitingForDriver: 
            case WaitingForServices: {
                return IService.ServiceState.Waiting;
            }
            case WaitingForResources: 
            case Initializing: {
                return IService.ServiceState.Initializing;
            }
            case Running: {
                return IService.ServiceState.Available;
            }
        }
        return IService.ServiceState.NotAvailable;
    }

    private IService.ServiceState cumulativeJobState() {
        IService.ServiceState current;
        IService.ServiceState response = IService.ServiceState.NotAvailable;
        for (IDuccState.JobState s : this.implementors.values()) {
            IService.ServiceState translated = this.translateJobState(s);
            if (translated.ordinality() <= response.ordinality()) continue;
            response = translated;
        }
        if (this.isStopped() && (current = this.getServiceState()).ordinality() < response.ordinality()) {
            response = current;
        }
        return response;
    }

    public synchronized void establish() {
        String methodName = "establish.0";
        this.logger.debug(methodName, this.id, new Object[]{"service_class", this.service_class, "nimplementors", this.implementors.size(), "instances", this.instances});
        switch (this.service_class) {
            case Implicit: {
                this.startPingThread();
                break;
            }
            case Submitted: {
                for (DuccId id : this.implementors.keySet()) {
                    this.establish(id, this.implementors.get(id));
                }
                break;
            }
            case Registered: {
                if (this.friendly_ids.size() > 0) {
                    for (DuccId id : this.implementors.keySet()) {
                        this.establish(id, this.implementors.get(id));
                    }
                } else {
                    if (this.service_type == IService.ServiceType.Custom) {
                        this.startPingThread();
                        break;
                    }
                    int needed = Math.max(0, this.instances - this.friendly_ids.size());
                    while (needed-- > 0) {
                        this.start();
                    }
                }
                break;
            }
        }
    }

    public synchronized void establish(DuccId id, IDuccState.JobState job_state) {
        String methodName = "establish.1";
        if (this.service_class == IService.ServiceClass.Implicit) {
            this.startPingThread();
            return;
        }
        if (this.service_class == IService.ServiceClass.Submitted && !this.implementors.containsKey(id)) {
            this.logger.debug(methodName, id, new Object[]{"Submitted service: Skipping state machine because the service set has no implemetor for", id});
            return;
        }
        this.implementors.put(id, job_state);
        IService.ServiceState cumulative = this.cumulativeJobState();
        this.logger.debug(methodName, id, new Object[]{"serviceState", this.getServiceState(), "cumulativeState", cumulative});
        block0 : switch (this.getServiceState()) {
            case Undefined: {
                switch (cumulative) {
                    case Initializing: {
                        this.setServiceState(IService.ServiceState.Initializing);
                        break block0;
                    }
                    case Available: {
                        this.startPingThread();
                        break block0;
                    }
                    case Waiting: {
                        this.setServiceState(IService.ServiceState.Waiting);
                        break block0;
                    }
                }
                break;
            }
            case Initializing: {
                switch (cumulative) {
                    case Available: {
                        this.startPingThread();
                        break;
                    }
                    case Initializing: {
                        break;
                    }
                    case Waiting: {
                        this.setServiceState(IService.ServiceState.Initializing);
                        break;
                    }
                    case NotAvailable: {
                        if (this.failure_run >= this.failure_max) {
                            this.setServiceState(IService.ServiceState.NotAvailable);
                            this.stopPingThread();
                            break;
                        }
                        this.logger.info(methodName, id, new Object[]{"RETRY RETRY RETRY prevents state regression from Initializing"});
                    }
                }
                break;
            }
            case NotAvailable: {
                switch (cumulative) {
                    case Available: {
                        this.startPingThread();
                        this.setServiceState(IService.ServiceState.Available);
                        break block0;
                    }
                    case Initializing: {
                        this.setServiceState(IService.ServiceState.Initializing);
                        break block0;
                    }
                    case Waiting: {
                        this.setServiceState(IService.ServiceState.Waiting);
                        break block0;
                    }
                }
                break;
            }
            case Available: {
                switch (cumulative) {
                    case Available: {
                        this.startPingThread();
                        break;
                    }
                    case Initializing: {
                        this.logger.warn(methodName, id, new Object[]{"STATE REGRESSION:", this.getServiceState(), "->", cumulative});
                        this.setServiceState(IService.ServiceState.Initializing);
                        break;
                    }
                    case NotAvailable: {
                        if (this.failure_run >= this.failure_max) {
                            this.setServiceState(IService.ServiceState.NotAvailable);
                            this.stopPingThread();
                            break;
                        }
                        this.logger.info(methodName, id, new Object[]{"RETRY RETRY RETRY prevents state regression from Available"});
                    }
                }
                break;
            }
            case Waiting: {
                switch (cumulative) {
                    case Available: {
                        break;
                    }
                    case Initializing: {
                        this.logger.warn(methodName, id, new Object[]{"STATE REGRESSION:", this.getServiceState(), "->", cumulative});
                        this.setServiceState(IService.ServiceState.Initializing);
                        break;
                    }
                    case Waiting: {
                        break;
                    }
                    case NotAvailable: {
                        if (this.failure_run >= this.failure_max) {
                            this.setServiceState(IService.ServiceState.NotAvailable);
                        } else {
                            this.logger.info(methodName, id, new Object[]{"RETRY RETRY RETRY prevents state regression from Waiting"});
                        }
                        this.stopPingThread();
                    }
                }
                break;
            }
            case Stopping: {
                switch (cumulative) {
                    case Initializing: 
                    case Available: 
                    case Waiting: {
                        break block0;
                    }
                    case NotAvailable: {
                        this.setServiceState(IService.ServiceState.NotAvailable);
                    }
                }
            }
        }
    }

    synchronized IService.ServiceState getServiceState() {
        return this.service_state;
    }

    synchronized void setServiceState(IService.ServiceState ss) {
        this.service_state = ss;
        this.saveMetaProperties();
    }

    synchronized String getKey() {
        return this.key;
    }

    void resetRunFailures() {
        this.failure_run = 0;
    }

    synchronized boolean excessiveRunFailures() {
        String methodName = "runFailures";
        if (++this.failure_run >= this.failure_max) {
            this.logger.debug(methodName, this.id, new Object[]{"RUN FAILURES EXCEEDED"});
            return true;
        }
        this.logger.debug(methodName, this.id, new Object[]{"RUN FAILURES NOT EXCEEDED YET", this.failure_run});
        return false;
    }

    private void startPingThread() {
        String methodName = "startPingThread";
        if (this.serviceMeta != null) {
            return;
        }
        try {
            this.logger.info(methodName, this.id, new Object[]{"Starting ping/monitor."});
            this.serviceMeta = new PingDriver(this);
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.id, new Object[]{"Cannot instantiate ping/monitor.", t});
            return;
        }
        this.setServiceState(IService.ServiceState.Waiting);
        Thread t = new Thread(this.serviceMeta);
        t.start();
    }

    synchronized void pingExited() {
        String methodName = "pingExited";
        if (this.serviceMeta != null) {
            this.logger.warn(methodName, this.id, new Object[]{"Pinger exited voluntarily, setting state to Undefined. Endpoint", this.endpoint});
            this.setServiceState(IService.ServiceState.Undefined);
            this.residualMeta = this.serviceMeta;
            this.serviceMeta = null;
        } else if (!this.isStopped()) {
            this.setServiceState(IService.ServiceState.NotAvailable);
        }
        if (this.isImplicit()) {
            this.deleteProperties();
        } else {
            this.saveMetaProperties();
        }
    }

    public synchronized void stopPingThread() {
        String methodName = "stopPingThread";
        if (this.serviceMeta != null) {
            this.logger.debug(methodName, this.id, new Object[]{"Stopping ping thread, endpoint", this.endpoint});
            this.serviceMeta.stop();
            this.residualMeta = this.serviceMeta;
            this.serviceMeta = null;
        }
        if (!this.isRegistered()) {
            this.deleteProperties();
        } else {
            this.saveMetaProperties();
        }
    }

    synchronized void setResponsive() {
        this.setServiceState(IService.ServiceState.Available);
        this.saveMetaProperties();
    }

    synchronized void setUnresponsive() {
        this.setServiceState(IService.ServiceState.NotAvailable);
        this.saveMetaProperties();
    }

    synchronized void setWaiting() {
        switch (this.getServiceState()) {
            case Available: 
            case NotAvailable: 
            case Undefined: {
                this.setServiceState(IService.ServiceState.Waiting);
                break;
            }
        }
    }

    void log_text(String logdir, String text) {
        String methodName = "log_text";
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "-f", logdir + "/service.err.log", "-a", "--", text};
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            Process p = pb.start();
            int rc = p.waitFor();
            this.logger.debug(methodName, null, new Object[]{"Log start errors returns with rc", rc});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void log_errors(List<String> outlines, List<String> errlines) {
        Date date = new Date();
        String ts = new Timestamp(date.getTime()).toString();
        String logdir = this.job_props.getProperty(IUiOptions.UiOption.LogDirectory.pname());
        StringBuffer buf = new StringBuffer();
        buf.append("==========");
        buf.append(" Instance Startup Failure (stdout) ");
        buf.append(ts);
        buf.append(" ========================================\n");
        for (String s : outlines) {
            buf.append(s);
            buf.append("\n");
        }
        this.log_text(logdir, buf.toString());
        buf = new StringBuffer();
        buf.append("----------");
        buf.append("(stderr) ");
        buf.append(ts);
        buf.append(" ----------------------------------------\n");
        for (String s : errlines) {
            buf.append(s);
            buf.append("\n");
        }
        buf.append("==========");
        buf.append(" End Startup Failure ");
        buf.append(ts);
        buf.append(" ========================================\n");
        this.log_text(logdir, buf.toString());
    }

    boolean start() {
        String methodName = "start";
        this.logger.debug(methodName, null, new Object[]{"START START START START START START START START"});
        this.stopped = false;
        if (!this.isStartable()) {
            this.establish();
            return true;
        }
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "--", System.getProperty("ducc.jvm"), "-cp", System.getProperty("java.class.path"), "org.apache.uima.ducc.cli.DuccServiceSubmit", "--specification", this.props_filename};
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && args[i - 1].equals("-cp")) {
                this.logger.debug(methodName, null, new Object[]{"Args[", i, "]: <CLASSPATH>"});
                continue;
            }
            this.logger.debug(methodName, null, new Object[]{"Args[", i, "]:", args[i]});
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put("DUCC_HOME", System.getProperty("DUCC_HOME"));
        ArrayList<String> stdout_lines = new ArrayList<String>();
        ArrayList<String> stderr_lines = new ArrayList<String>();
        try {
            Process p = pb.start();
            int rc = p.waitFor();
            this.logger.debug(methodName, null, new Object[]{"DuccServiceSubmit returns with rc", rc});
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            BufferedReader stdout_reader = new BufferedReader(new InputStreamReader(stdout));
            BufferedReader stderr_reader = new BufferedReader(new InputStreamReader(stderr));
            String line = null;
            while ((line = stdout_reader.readLine()) != null) {
                stdout_lines.add(line);
            }
            line = null;
            while ((line = stderr_reader.readLine()) != null) {
                stderr_lines.add(line);
            }
        }
        catch (Throwable t) {
            this.logger.error(methodName, null, t, new Object[0]);
        }
        for (String s : stderr_lines) {
            this.logger.info(methodName, this.id, new Object[]{"Start stderr:", s});
        }
        boolean inhibit_cp = false;
        boolean started = false;
        StringBuffer submit_buffer = new StringBuffer();
        boolean recording = false;
        for (String s : stdout_lines) {
            if (inhibit_cp) {
                inhibit_cp = false;
                this.logger.info(methodName, this.id, new Object[]{"<INHIBITED CP>"});
            } else {
                this.logger.info(methodName, this.id, new Object[]{"Start stdout:", s});
            }
            if (s.indexOf("-cp") >= 0) {
                inhibit_cp = true;
            }
            if (recording) {
                submit_buffer.append(s.trim());
                submit_buffer.append(";");
            }
            if (s.startsWith("1001 Command launching...")) {
                recording = true;
                continue;
            }
            if (!s.startsWith("Service") || !s.endsWith("submitted")) continue;
            String[] toks = s.split("\\s");
            long friendly = 0L;
            try {
                friendly = Long.parseLong(toks[1]);
                this.friendly_ids.put(friendly, null);
                this.persistImplementors();
                started = true;
                this.logger.info(methodName, null, new Object[]{"Request to start service " + this.id.toString() + " accepted as job ", friendly});
            }
            catch (NumberFormatException e) {
                this.logger.warn(methodName, null, new Object[]{"Request to start service " + this.id.toString() + " failed, can't interpret response.: " + s});
            }
        }
        boolean rc = true;
        if (!started) {
            this.logger.warn(methodName, null, new Object[]{"Request to start service " + this.id.toString() + " failed."});
            this.meta_props.put((Object)"submit_error", (Object)submit_buffer.toString());
            this.setAutostart(false);
            this.log_errors(stdout_lines, stderr_lines);
        } else {
            this.meta_props.remove((Object)"submit_error");
            this.setServiceState(IService.ServiceState.Initializing);
        }
        this.saveMetaProperties();
        this.logger.debug(methodName, null, new Object[]{"ENDSTART ENDSTART ENDSTART ENDSTART ENDSTART ENDSTART"});
        return rc;
    }

    void stopOneProcess(DuccId id) {
        String methodName = "stop";
        String[] args = new String[]{System.getProperty("ducc.agent.launcher.ducc_spawn_path"), "-u", this.user, "--", System.getProperty("ducc.jvm"), "-cp", System.getProperty("java.class.path"), "org.apache.uima.ducc.cli.DuccServiceCancel", "--id", id.toString()};
        for (int i = 0; i < args.length; ++i) {
            if (i > 0 && args[i - 1].equals("-cp")) {
                this.logger.debug(methodName, null, new Object[]{"Args[", i, "]: <CLASSPATH>"});
                continue;
            }
            this.logger.debug(methodName, null, new Object[]{"Args[", i, "]:", args[i]});
        }
        ProcessBuilder pb = new ProcessBuilder(args);
        Map<String, String> env = pb.environment();
        env.put("DUCC_HOME", System.getProperty("DUCC_HOME"));
        ArrayList<String> stdout_lines = new ArrayList<String>();
        ArrayList<String> stderr_lines = new ArrayList<String>();
        try {
            Process p = pb.start();
            int rc = p.waitFor();
            this.logger.debug(methodName, null, new Object[]{"DuccServiceCancel returns with rc", rc});
            InputStream stdout = p.getInputStream();
            InputStream stderr = p.getErrorStream();
            BufferedReader stdout_reader = new BufferedReader(new InputStreamReader(stdout));
            BufferedReader stderr_reader = new BufferedReader(new InputStreamReader(stderr));
            String line = null;
            while ((line = stdout_reader.readLine()) != null) {
                stdout_lines.add(line);
            }
            line = null;
            while ((line = stderr_reader.readLine()) != null) {
                stderr_lines.add(line);
            }
        }
        catch (Throwable t) {
            this.logger.error(methodName, null, t, new Object[0]);
        }
        boolean inhibit_cp = false;
        for (String s : stdout_lines) {
            if (inhibit_cp) {
                inhibit_cp = false;
                this.logger.info(methodName, id, new Object[]{"<INHIBITED CP>"});
            } else {
                this.logger.info(methodName, id, new Object[]{"Stop stdout:", s});
            }
            if (s.indexOf("-cp") < 0) continue;
            inhibit_cp = true;
        }
        for (String s : stderr_lines) {
            this.logger.info(methodName, id, new Object[]{"Stop stderr:", s});
        }
    }

    void stop() {
        String methodName = "stop";
        this.logger.debug(methodName, this.id, new Object[]{"Stopping all implementors"});
        this.stopped = true;
        this.stopPingThread();
        this.setServiceState(IService.ServiceState.Stopping);
        if (!this.isStartable()) {
            return;
        }
        for (DuccId id : this.implementors.keySet()) {
            this.stopOneProcess(id);
        }
        this.saveMetaProperties();
    }

    void stop(int count) {
        String methodName = "stop(count)";
        if (!this.isStartable()) {
            this.stop();
            return;
        }
        this.logger.debug(methodName, this.id, new Object[]{"Stopping", count, "implementors"});
        for (DuccId id : this.implementors.keySet()) {
            if (count-- <= 0) break;
            this.stopOneProcess(id);
        }
        this.saveMetaProperties();
    }

    void lingeringStop() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        this.linger = new LingerTask(this);
        this.timer.schedule((TimerTask)this.linger, this.linger_time);
    }

    IServiceDescription query() {
        ServiceDescription sd = new ServiceDescription();
        ArrayList<DuccId> imp = new ArrayList<DuccId>();
        for (DuccId id : this.implementors.keySet()) {
            imp.add(id);
        }
        sd.setImplementors(imp);
        ArrayList<DuccId> ref = new ArrayList<DuccId>();
        ref.clear();
        for (DuccId id : this.references.keySet()) {
            ref.add(id);
        }
        sd.setReferences(ref);
        sd.setInstances(this.getNInstances());
        sd.setType(this.service_type);
        sd.setSubclass(this.service_class);
        sd.setEndpoint(this.endpoint);
        sd.setBroker(this.broker);
        sd.setServiceState(this.getServiceState());
        sd.setActive(this.serviceMeta != null);
        sd.setStopped(this.stopped);
        sd.setAutostart(this.autostart);
        sd.setLinger(this.linger_time);
        sd.setId((ADuccId)this.id);
        sd.setUser(this.user);
        sd.setDeregistered(this.isDeregistered());
        if (this.serviceMeta != null) {
            sd.setQueueStatistics(this.serviceMeta.getServiceStatistics());
        }
        return sd;
    }

    public String toString() {
        return this.endpoint;
    }

    private class LingerTask
    extends TimerTask {
        ServiceSet sset;

        LingerTask(ServiceSet sset) {
            String methodName = "LingerTask.init";
            ServiceSet.this.logger.debug(methodName, ServiceSet.this.id, new Object[]{"Linger starts", ServiceSet.this.linger_time});
            this.sset = sset;
        }

        @Override
        public void run() {
            String methodName = "LingerTask.run";
            ServiceSet.this.logger.debug(methodName, ServiceSet.this.id, new Object[]{"Lingering stop completes."});
            this.sset.setReferencedStart(false);
            ServiceSet.this.linger = null;
            this.sset.stop();
        }
    }
}

