/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.ServiceStatistics;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.sm.SmConstants;

public class ServicePingMain
implements SmConstants {
    private static final long serialVersionUID = 1L;
    boolean debug = false;
    int error_max = 10;
    int error_count = 0;

    private void addOptions(Options options) {
        OptionBuilder.withLongOpt((String)SmConstants.ServicePing.Class.decode());
        OptionBuilder.withDescription((String)SmConstants.ServicePing.Class.description());
        OptionBuilder.withArgName((String)SmConstants.ServicePing.Class.argname());
        OptionBuilder.hasOptionalArg();
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SmConstants.ServicePing.Endpoint.decode());
        OptionBuilder.withDescription((String)SmConstants.ServicePing.Endpoint.description());
        OptionBuilder.withArgName((String)SmConstants.ServicePing.Endpoint.argname());
        OptionBuilder.hasArg((boolean)true);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SmConstants.ServicePing.Port.decode());
        OptionBuilder.withDescription((String)SmConstants.ServicePing.Port.description());
        OptionBuilder.withArgName((String)SmConstants.ServicePing.Port.argname());
        OptionBuilder.hasArg((boolean)true);
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SmConstants.ServicePing.Port.decode());
        OptionBuilder.withDescription((String)SmConstants.ServicePing.Port.description());
        OptionBuilder.withArgName((String)SmConstants.ServicePing.Port.argname());
        OptionBuilder.hasArg((boolean)true);
        options.addOption(OptionBuilder.create());
    }

    static void appendStackTrace(StringBuffer s, Throwable t) {
        StackTraceElement[] stacktrace;
        s.append("\nAt:\n");
        for (StackTraceElement ste : stacktrace = t.getStackTrace()) {
            s.append("\t");
            s.append(ste.toString());
            s.append("\n");
        }
    }

    public static void print(Object ... args) {
        StringBuffer s = new StringBuffer();
        for (Object a : args) {
            if (a == null) {
                a = "<null>";
            }
            s.append(" ");
            if (a instanceof Throwable) {
                Throwable t = (Throwable)a;
                s.append(t.toString());
                s.append("\n");
                ServicePingMain.appendStackTrace(s, t);
                continue;
            }
            s.append(a.toString());
        }
        System.err.println(s.toString());
    }

    AServicePing resolve(String cl, String args, String ep) {
        ServicePingMain.print("ServicePingMain.resolve:", cl, "ep", ep);
        AServicePing pinger = null;
        try {
            Class<?> cls = Class.forName(cl);
            pinger = (AServicePing)cls.newInstance();
            pinger.init(args, ep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pinger;
    }

    void handleError(Throwable t) {
        t.printStackTrace();
        if (++this.error_count >= this.error_max) {
            System.out.println("Exceeded error count. Exiting.");
            System.exit(1);
        }
    }

    protected void start(String[] args) {
        ObjectOutputStream oos;
        Options options = new Options();
        this.addOptions(options);
        PosixParser parser = new PosixParser();
        CommandLine commandLine = null;
        ServiceStatistics default_statistics = new ServiceStatistics(false, false, "<N/A>");
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ServicePingMain.print(new Object[]{"Cannot parse command line:", e});
            return;
        }
        String arguments = commandLine.getOptionValue(SmConstants.ServicePing.Arguments.decode());
        String pingClass = commandLine.getOptionValue(SmConstants.ServicePing.Class.decode());
        String endpoint = commandLine.getOptionValue(SmConstants.ServicePing.Endpoint.decode());
        String port = commandLine.getOptionValue(SmConstants.ServicePing.Port.decode());
        Socket sock = null;
        try {
            sock = new Socket("localhost", Integer.parseInt(port));
        }
        catch (NumberFormatException e2) {
            e2.printStackTrace();
            return;
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        ServicePingMain.print("ServicePingMain listens on port", sock.getLocalPort());
        InputStream sock_in = null;
        OutputStream sock_out = null;
        try {
            sock_in = sock.getInputStream();
            sock_out = sock.getOutputStream();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        try {
            oos = new ObjectOutputStream(sock_out);
            oos.flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        AServicePing custom = this.resolve(pingClass, arguments, endpoint);
        if (custom == null) {
            ServicePingMain.print("bad_pinger:", pingClass, endpoint);
            return;
        }
        while (true) {
            if (this.debug) {
                ServicePingMain.print("ServicePingMeta starts ping.");
            }
            byte[] cmd = new byte[]{0};
            int eof = 0;
            try {
                eof = sock_in.read(cmd);
            }
            catch (IOException e) {
                this.handleError(e);
            }
            if (this.debug) {
                ServicePingMain.print("Read cmd", new String(cmd), "eof", eof);
            }
            if (eof == -1) {
                ServicePingMain.print("EOF on input pipe.  Exiting");
                custom.stop();
                return;
            }
            try {
                if (cmd[0] == 80) {
                    IServiceStatistics ss = custom.getStatistics();
                    if (ss == null) {
                        ss = default_statistics;
                    }
                    oos.writeObject(ss);
                    oos.flush();
                    oos.reset();
                    continue;
                }
                if (cmd[0] == 81) {
                    custom.stop();
                    return;
                }
                System.err.println("Invalid command recieved: " + Byte.toString(cmd[0]));
                continue;
            }
            catch (Throwable e) {
                this.handleError(e);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        ServicePingMain wrapper = new ServicePingMain();
        wrapper.start(args);
    }
}

