/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.sm.ApiHandler;
import org.apache.uima.ducc.sm.IServiceManager;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryEvent;
import org.apache.uima.ducc.transport.event.ServiceQueryReplyEvent;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.sm.IService;
import org.apache.uima.ducc.transport.event.sm.IServiceDescription;
import org.apache.uima.ducc.transport.event.sm.ServiceDependency;
import org.apache.uima.ducc.transport.event.sm.ServiceMap;

public class ServiceHandler
implements SmConstants,
Runnable {
    private static final long serialVersionUID = 1L;
    private DuccLogger logger = DuccLogger.getLogger((String)ServiceHandler.class.getName(), (String)"SM");
    private IServiceManager serviceManager;
    private ServiceStateHandler serviceStateHandler = new ServiceStateHandler();
    private ServiceMap serviceMap = new ServiceMap();
    private Map<DuccId, IDuccWork> newJobs = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> newServices = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> deletedJobs = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> deletedServices = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> modifiedJobs = new HashMap<DuccId, IDuccWork>();
    private Map<DuccId, IDuccWork> modifiedServices = new HashMap<DuccId, IDuccWork>();
    private List<ApiHandler> pendingRequests = new LinkedList<ApiHandler>();
    private Object stateUpdateLock = new Object();

    public ServiceHandler(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public synchronized void run() {
        String methodName = "run";
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.logger.error(methodName, null, (Throwable)e, new Object[0]);
            }
            try {
                this.runCommands();
                this.processUpdates();
                continue;
            }
            catch (Throwable t) {
                this.logger.error(methodName, null, t, new Object[0]);
                continue;
            }
            break;
        }
    }

    void synchronizeImplementors(Map<DuccId, IDuccState.JobState> servicemap) {
        ArrayList<String> keys = this.serviceStateHandler.getServiceNames();
        for (String k : keys) {
            ServiceSet sset = this.serviceStateHandler.getServiceByName(k);
            sset.synchronizeImplementors(servicemap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processUpdates() {
        String methodName = "processUpdates";
        this.logger.info(methodName, null, new Object[]{"Processing updates."});
        HashMap<DuccId, IDuccWork> deletedJobsMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> modifiedJobsMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> newJobsMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> deletedServicesMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> modifiedServicesMap = new HashMap<DuccId, IDuccWork>();
        HashMap<DuccId, IDuccWork> newServicesMap = new HashMap<DuccId, IDuccWork>();
        Object object = this.stateUpdateLock;
        synchronized (object) {
            deletedJobsMap.putAll(this.deletedJobs);
            this.deletedJobs.clear();
            modifiedJobsMap.putAll(this.modifiedJobs);
            this.modifiedJobs.clear();
            deletedServicesMap.putAll(this.deletedServices);
            this.deletedServices.clear();
            modifiedServicesMap.putAll(this.modifiedServices);
            this.modifiedServices.clear();
            newServicesMap.putAll(this.newServices);
            this.newServices.clear();
            newJobsMap.putAll(this.newJobs);
            this.newJobs.clear();
        }
        this.handleNewServices(newServicesMap);
        this.handleModifiedServices(modifiedServicesMap);
        this.handleDeletedServices(deletedServicesMap);
        this.handleImplicitServices();
        this.handleNewJobs(newJobsMap);
        this.handleModifiedJobs(modifiedJobsMap);
        this.handleDeletedJobs(deletedJobsMap);
        this.serviceManager.publish(this.serviceMap);
        List<ServiceSet> regsvcs = this.serviceStateHandler.getRegisteredServices();
        for (ServiceSet sset : regsvcs) {
            sset.enforceAutostart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalUpdates(HashMap<DuccId, IDuccWork> newJobs, HashMap<DuccId, IDuccWork> newServices, HashMap<DuccId, IDuccWork> deletedJobs, HashMap<DuccId, IDuccWork> deletedServices, HashMap<DuccId, IDuccWork> modifiedJobs, HashMap<DuccId, IDuccWork> modifiedServices) {
        Object object = this.stateUpdateLock;
        synchronized (object) {
            this.newJobs.putAll(newJobs);
            this.newServices.putAll(newServices);
            this.deletedJobs.putAll(deletedJobs);
            this.deletedServices.putAll(deletedServices);
            this.modifiedJobs.putAll(modifiedJobs);
            this.modifiedServices.putAll(modifiedServices);
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCommands() {
        String methodName = "runCommands";
        LinkedList<ApiHandler> tmp = new LinkedList<ApiHandler>();
        List<ApiHandler> list = this.pendingRequests;
        synchronized (list) {
            tmp.addAll(this.pendingRequests);
            this.pendingRequests.clear();
        }
        this.logger.info(methodName, null, new Object[]{"Running", tmp.size(), "API Tasks."});
        for (ApiHandler apih : tmp) {
            apih.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addApiTask(ApiHandler apih) {
        List<ApiHandler> list = this.pendingRequests;
        synchronized (list) {
            this.pendingRequests.add(apih);
        }
    }

    protected void resolveState(DuccId id, ServiceDependency dep) {
        String methodName = "resolveState";
        Map<String, ServiceSet> services = this.serviceStateHandler.getServicesForJob(id);
        if (services == null) {
            dep.setState(IService.ServiceState.NotAvailable);
            return;
        }
        IService.ServiceState state = IService.ServiceState.Available;
        for (ServiceSet sset : services.values()) {
            if (sset.getServiceState().ordinality() < state.ordinality()) {
                state = sset.getServiceState();
            }
            dep.setIndividualState(sset.getKey(), sset.getServiceState());
            this.logger.debug(methodName, id, new Object[]{"Set individual state", sset.getServiceState()});
        }
        dep.setState(state);
    }

    protected Map<String, ServiceSet> resolveDependencies(DuccWorkJob w, ServiceDependency s) {
        String methodName = "resolveDependencies";
        DuccId id = w.getDuccId();
        String[] deps = w.getServiceDependencies();
        boolean fatal = false;
        HashMap<String, ServiceSet> jobServices = new HashMap<String, ServiceSet>();
        for (String dep : deps) {
            ServiceSet sset = this.serviceStateHandler.getServiceByName(dep);
            if (sset == null) {
                try {
                    sset = new ServiceSet(dep, this.serviceManager.newId());
                    this.serviceStateHandler.putServiceByName(dep, sset);
                }
                catch (Exception e) {
                    s.addMessage(dep, e.getMessage());
                    s.setState(IService.ServiceState.NotAvailable);
                    fatal = true;
                    continue;
                }
            }
            if (sset.isDeregistered()) {
                s.addMessage(dep, "Independent registered service [" + dep + "] has been deregistered and is terminating.");
                s.setState(IService.ServiceState.NotAvailable);
                fatal = true;
                continue;
            }
            if (fatal) continue;
            if (sset.isRegistered() && sset.countImplementors() == 0 && sset.isStartable()) {
                int ninstances = sset.getNInstances();
                this.logger.debug(methodName, sset.getId(), new Object[]{"Reference-starting registered service, instances =", ninstances});
                if (!sset.isAutostart()) {
                    sset.setReferencedStart(true);
                }
                for (int i = 0; i < ninstances; ++i) {
                    if (sset.start()) continue;
                    s.addMessage(dep, "Can't start independent service.");
                    s.setState(IService.ServiceState.NotAvailable);
                    break;
                }
            }
            jobServices.put(dep, sset);
            sset.reference(id);
            this.serviceStateHandler.putServiceForJob(w.getDuccId(), sset);
            this.logger.debug(methodName, id, new Object[]{"Service init ok. Ref[", dep, "] incr to", sset.countReferences()});
        }
        if (fatal) {
            jobServices.clear();
        }
        return jobServices;
    }

    protected void handleNewJobs(Map<DuccId, IDuccWork> work) {
        String methodName = "handleNewJobs";
        HashMap<DuccId, ServiceDependency> updates = new HashMap<DuccId, ServiceDependency>();
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            if (!w.isActive()) {
                this.logger.info(methodName, id, new Object[]{"Bypassing inactive job, state =", w.getStateObject()});
                continue;
            }
            ServiceDependency s = new ServiceDependency();
            updates.put(id, s);
            String[] deps = w.getServiceDependencies();
            if (deps == null) {
                s.setState(IService.ServiceState.Available);
                this.logger.info(methodName, id, new Object[]{"Added to map, no service dependencies."});
                continue;
            }
            Map<String, ServiceSet> jobServices = this.resolveDependencies(w, s);
            for (ServiceSet sset : jobServices.values()) {
                sset.establish();
            }
            this.resolveState(id, s);
            this.logger.info(methodName, id, new Object[]{"Added job to map, with service dependency state.", s.getState()});
        }
        this.serviceMap.putAll(updates);
    }

    protected void stopDependentServices(DuccId id) {
        String methodName = "stopDependentServices";
        Map<String, ServiceSet> deps = this.serviceStateHandler.getServicesForJob(id);
        if (deps == null) {
            this.logger.debug(methodName, id, new Object[]{"No dependent services to stop, returning."});
            return;
        }
        for (String dep : deps.keySet()) {
            this.logger.debug(methodName, id, new Object[]{"Looking up service", dep});
            ServiceSet sset = deps.get(dep);
            if (sset == null) {
                throw new IllegalStateException("Null service for " + dep);
            }
            int count = sset.dereference(id);
            this.logger.debug(methodName, id, new Object[]{"Ref count for", sset.getKey(), "goes down to", count});
            if (count != 0) continue;
            if (sset.isImplicit()) {
                this.logger.debug(methodName, id, new Object[]{"Removing unreferenced implicit service", dep, "refcount", count});
                this.serviceStateHandler.removeService(dep);
            }
            if (!sset.isRegistered() || !sset.isReferencedStart()) continue;
            if (sset.isAutostart()) {
                sset.setReferencedStart(false);
                continue;
            }
            this.logger.debug(methodName, id, new Object[]{"Stopping reference-started service", dep, "refcount", count});
            sset.lingeringStop();
        }
        this.serviceStateHandler.removeServicesForJob(id);
    }

    protected void handleDeletedJobs(Map<DuccId, IDuccWork> work) {
        String methodName = "handleCompletedJobs";
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            String[] deps = w.getServiceDependencies();
            if (deps == null) {
                this.logger.info(methodName, id, new Object[]{"No service dependencies, no updates made."});
                continue;
            }
            this.stopDependentServices(id);
            this.logger.info(methodName, id, new Object[]{"Deleted job from map"});
        }
        this.serviceMap.removeAll(work.keySet());
    }

    protected void handleModifiedJobs(Map<DuccId, IDuccWork> work) {
        String methodName = "handleModifiedJobs";
        for (DuccId id : work.keySet()) {
            DuccWorkJob j = (DuccWorkJob)work.get(id);
            String[] deps = j.getServiceDependencies();
            if (deps == null) {
                this.logger.info(methodName, id, new Object[]{"No service dependencies, no updates made."});
                continue;
            }
            ServiceDependency s = (ServiceDependency)this.serviceMap.get((Object)id);
            if (j.isFinished()) {
                this.stopDependentServices(id);
                s.setState(IService.ServiceState.NotAvailable);
                s.clearMessages();
                continue;
            }
            if (!j.isActive()) continue;
            this.resolveState(id, s);
        }
    }

    protected void handleNewServices(Map<DuccId, IDuccWork> work) {
        String methodName = "handleNewServices";
        HashMap<DuccId, ServiceDependency> updates = new HashMap<DuccId, ServiceDependency>();
        HashMap<String, ServiceSet> newservices = new HashMap<String, ServiceSet>();
        for (DuccId id : work.keySet()) {
            ServiceSet sset;
            String[] deps;
            ServiceDependency s;
            DuccWorkJob w;
            block13: {
                w = (DuccWorkJob)work.get(id);
                if (!w.isActive()) {
                    this.logger.info(methodName, id, new Object[]{"Bypassing inactive service, state=", w.getStateObject()});
                    continue;
                }
                s = new ServiceDependency();
                updates.put(id, s);
                String endpoint = w.getServiceEndpoint();
                if (endpoint == null) {
                    String msg = "No service endpoint.  Service cannot be validated.";
                    this.logger.warn(methodName, id, new Object[]{msg});
                    s.addMessage("null", msg);
                    s.setState(IService.ServiceState.NotAvailable);
                    continue;
                }
                deps = w.getServiceDependencies();
                sset = this.serviceStateHandler.getServiceByName(endpoint);
                if (sset == null) {
                    try {
                        sset = new ServiceSet(this.serviceManager.newId(), id, endpoint, deps);
                        sset.addImplementor(id, w.getJobState());
                        this.serviceStateHandler.putServiceByName(endpoint, sset);
                        break block13;
                    }
                    catch (Exception e) {
                        s.addMessage(endpoint, e.getMessage());
                        s.setState(IService.ServiceState.NotAvailable);
                        continue;
                    }
                }
                if (sset.isDeregistered()) {
                    s.addMessage(endpoint, "Duplicate endpoint: terminating deregistered service.");
                    s.setState(IService.ServiceState.NotAvailable);
                    continue;
                }
                if (sset.matches(id)) {
                    sset.addImplementor(id, w.getJobState());
                } else if (!sset.isRegistered()) {
                    sset.addImplementor(id, w.getJobState());
                    sset.promote();
                } else {
                    String msg = "Duplicate endpoint: Registered service.";
                    this.logger.warn(methodName, id, new Object[]{msg});
                    s.addMessage(endpoint, msg);
                    s.setState(IService.ServiceState.NotAvailable);
                    continue;
                }
            }
            if (deps == null) {
                this.logger.info(methodName, id, new Object[]{"Added service to map, no service dependencies. "});
                s.setState(IService.ServiceState.Available);
                sset.establish(id, w.getJobState());
                continue;
            }
            Map<String, ServiceSet> jobServices = this.resolveDependencies(w, s);
            for (ServiceSet depset : jobServices.values()) {
                depset.establish();
            }
            this.resolveState(id, s);
            sset.establish(id, w.getJobState());
            this.logger.info(methodName, id, new Object[]{"Added to map, with service dependencies,", s.getState()});
        }
        this.serviceStateHandler.recordNewServices(newservices);
        this.serviceMap.putAll(updates);
    }

    protected void handleDeletedServices(Map<DuccId, IDuccWork> work) {
        String methodName = "handleDeletedServices";
        for (DuccId id : work.keySet()) {
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            String endpoint = w.getServiceEndpoint();
            this.logger.info(methodName, id, new Object[]{"Deleted service:", endpoint});
            if (w.getServiceDependencies() == null) {
                this.logger.info(methodName, id, new Object[]{"No service dependencies to update on removal."});
            } else {
                this.stopDependentServices(id);
            }
            if (endpoint == null) {
                this.logger.warn(methodName, id, new Object[]{"Missing service endpoint, ignoring."});
                continue;
            }
            ServiceSet sset = this.serviceStateHandler.getServiceByName(endpoint);
            if (sset == null) continue;
            sset.removeImplementor(id);
        }
        this.serviceMap.removeAll(work.keySet());
    }

    protected void handleImplicitServices() {
        ArrayList<String> keys = this.serviceStateHandler.getServiceNames();
        for (String k : keys) {
            ServiceSet sset = this.serviceStateHandler.getServiceByName(k);
            if (!sset.isImplicit()) continue;
            sset.establish();
        }
    }

    protected void handleModifiedServices(Map<DuccId, IDuccWork> work) {
        String methodName = "handleModifiedServices";
        for (DuccId id : work.keySet()) {
            IDuccState.JobState state;
            DuccWorkJob w = (DuccWorkJob)work.get(id);
            String endpoint = w.getServiceEndpoint();
            if (endpoint == null) {
                this.logger.info(methodName, id, new Object[]{"Missing service endpoint, ignoring."});
                continue;
            }
            ServiceSet sset = this.serviceStateHandler.getServiceByName(endpoint);
            if (sset == null) {
                if (!w.isActive()) continue;
                this.logger.info(methodName, id, new Object[]{"Got update for active service instance", id.toString(), "but no ServiceSet! Job state:", w.getJobState()});
                continue;
            }
            if (!sset.containsImplementor(id)) {
                this.logger.info(methodName, id, new Object[]{"Bypassing removed service instance for", endpoint});
                continue;
            }
            ServiceDependency s = (ServiceDependency)this.serviceMap.get((Object)id);
            if (w.isFinished()) {
                this.stopDependentServices(id);
                s.setState(IService.ServiceState.NotAvailable);
            } else if (w.getServiceDependencies() != null) {
                this.resolveState(id, s);
            }
            if (w.isActive()) {
                state = w.getJobState();
                if (state == IDuccState.JobState.Running) {
                    sset.resetRunFailures();
                }
            } else {
                state = w.getJobState();
                if (state == IDuccState.JobState.Completed) {
                    sset.removeImplementor(id);
                    IDuccCompletionType.JobCompletionType jct = w.getCompletionType();
                    this.logger.info(methodName, id, new Object[]{"Removing stopped instance from maps: state[", state, "] completion[", jct, "]"});
                    switch (jct) {
                        case EndOfJob: 
                        case CanceledByUser: 
                        case CanceledByAdministrator: 
                        case Undefined: {
                            break;
                        }
                        default: {
                            this.logger.debug(methodName, id, new Object[]{"RECORDING FAILURE"});
                            if (sset.excessiveRunFailures()) {
                                this.logger.warn(methodName, null, new Object[]{"Process Failure: " + jct + " Maximum consecutive failures[" + sset.failure_run + "] max [" + sset.failure_max + "]"});
                                break;
                            }
                            sset.start();
                        }
                    }
                }
            }
            sset.establish(id, w.getJobState());
            if (sset.getServiceState() != IService.ServiceState.NotAvailable || sset.countReferences() != 0 || sset.countImplementors() != 0) continue;
            if (!sset.isRegistered()) {
                this.logger.debug(methodName, id, new Object[]{"Removing service", endpoint, "because it died and has no more references."});
                this.serviceStateHandler.removeService(endpoint);
            }
            this.serviceStateHandler.removeServicesForJob(id);
        }
    }

    void updateServiceQuery(IServiceDescription sd, ServiceSet sset) {
        block5: {
            block4: {
                if (!sset.isRegistered()) break block4;
                String[] deps = sset.getIndependentServices();
                if (deps == null) break block5;
                for (String dep : deps) {
                    ServiceSet independent = this.serviceStateHandler.getServiceByName(dep);
                    if (independent != null) {
                        sd.addDependency(dep, independent.getServiceState().decode());
                        continue;
                    }
                    sd.addDependency(dep, IService.ServiceState.NotAvailable.decode());
                }
                break block5;
            }
            Map<DuccId, IDuccState.JobState> implementors = sset.getImplementors();
            for (DuccId id : implementors.keySet()) {
                Map<String, ServiceSet> deps = this.serviceStateHandler.getServicesForJob(id);
                if (deps == null) continue;
                for (String s : deps.keySet()) {
                    ServiceSet depsvc = deps.get(s);
                    sd.addDependency(s, depsvc.getServiceState().decode());
                }
            }
        }
    }

    ServiceQueryReplyEvent query(ServiceQueryEvent ev) {
        long friendly = ev.getFriendly();
        String epname = ev.getEndpoint();
        ServiceQueryReplyEvent reply = new ServiceQueryReplyEvent();
        if (friendly == -1L && epname == null) {
            ArrayList<String> keys = this.serviceStateHandler.getServiceNames();
            for (String k : keys) {
                ServiceSet sset = this.serviceStateHandler.getServiceByName(k);
                if (k == null) continue;
                IServiceDescription sd = sset.query();
                this.updateServiceQuery(sd, sset);
                reply.addService(sd);
            }
        } else {
            ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname);
            if (sset == null) {
                reply.setMessage("Unknown");
                reply.setEndpoint(epname);
                reply.setId(friendly);
                reply.setReturnCode(false);
            } else {
                IServiceDescription sd = sset.query();
                this.updateServiceQuery(sd, sset);
                reply.addService(sd);
            }
        }
        return reply;
    }

    ServiceReplyEvent start(ServiceStartEvent ev) {
        String userout;
        String epname;
        long friendly = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname = ev.getEndpoint());
        if (sset == null) {
            return new ServiceReplyEvent(false, "Unknown", epname, friendly);
        }
        String userin = ev.getUser();
        if (!userin.equals(userout = sset.getUser()) && !this.serviceManager.isAdministrator(userin)) {
            return new ServiceReplyEvent(false, "Owned by " + userout, epname, friendly);
        }
        if (sset.isRegistered()) {
            int running = sset.countImplementors();
            int instances = ev.getInstances();
            int registered = sset.getNInstances();
            int wanted = 0;
            wanted = instances == -1 ? Math.max(0, registered - running) : instances;
            if (wanted == 0) {
                return new ServiceReplyEvent(true, "Already has instances[" + running + "] - no additional instances started", sset.getKey(), sset.getId().getFriendly());
            }
            this.pendingRequests.add(new ApiHandler(ev, this));
            return new ServiceReplyEvent(true, "New instances[" + wanted + "]", sset.getKey(), sset.getId().getFriendly());
        }
        return new ServiceReplyEvent(false, "Not registered", sset.getKey(), sset.getId().getFriendly());
    }

    void doStart(long friendly, String epname, int instances, boolean update) {
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname);
        int running = sset.countImplementors();
        int registered = sset.getNInstances();
        int wanted = 0;
        wanted = instances == -1 ? Math.max(0, registered - running) : instances;
        if (update) {
            sset.setNInstances(running + instances);
        }
        sset.resetRunFailures();
        for (int i = 0; i < wanted && sset.start(); ++i) {
        }
    }

    ServiceReplyEvent stop(ServiceStopEvent ev) {
        String userout;
        String epname;
        long friendly = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname = ev.getEndpoint());
        if (sset == null) {
            return new ServiceReplyEvent(false, "Unknown", epname, friendly);
        }
        String userin = ev.getUser();
        if (!userin.equals(userout = sset.getUser()) && !this.serviceManager.isAdministrator(userin)) {
            return new ServiceReplyEvent(false, "Owned by " + userout, epname, friendly);
        }
        if (sset.isRegistered()) {
            if (sset.isStopped()) {
                return new ServiceReplyEvent(false, "Already stopped", sset.getKey(), sset.getId().getFriendly());
            }
            this.pendingRequests.add(new ApiHandler(ev, this));
            return new ServiceReplyEvent(true, "Stopping", sset.getKey(), sset.getId().getFriendly());
        }
        return new ServiceReplyEvent(false, "Not registered", sset.getKey(), sset.getId().getFriendly());
    }

    void doStop(long friendly, String epname, int instances, boolean update) {
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname);
        int running = sset.countImplementors();
        int tolose = instances == -1 ? running : Math.min(instances, running);
        if (update) {
            sset.setNInstances(Math.max(0, running - instances));
        }
        if (tolose == running) {
            sset.stop();
        } else {
            sset.stop(tolose);
        }
    }

    ServiceReplyEvent register(DuccId id, String props_filename, String meta_filename, DuccProperties props, DuccProperties meta) {
        String methodName = "register";
        String error = null;
        boolean must_deregister = false;
        ServiceSet sset = null;
        try {
            sset = new ServiceSet(id, props_filename, meta_filename, props, meta);
        }
        catch (Throwable t) {
            error = t.getMessage();
            return new ServiceReplyEvent(false, t.getMessage(), "?", id.getFriendly());
        }
        String key = sset.getKey();
        ServiceSet sset0 = this.serviceStateHandler.getServiceByName(key);
        if (sset0 != null) {
            error = "Duplicate owned by: " + sset0.getUser();
        } else {
            CycleChecker cc;
            try {
                sset.saveServiceProperties();
            }
            catch (Exception e) {
                error = "Internal error; unable to store service descriptor. " + key;
                this.logger.error(methodName, id, (Throwable)e, new Object[0]);
                must_deregister = true;
            }
            try {
                if (!must_deregister) {
                    sset.saveMetaProperties();
                }
            }
            catch (Exception e) {
                error = "Internal error; unable to store service meta-descriptor. " + key;
                this.logger.error(methodName, id, (Throwable)e, new Object[0]);
                must_deregister = true;
            }
            if (!must_deregister && (cc = new CycleChecker(sset)).hasCycle()) {
                error = "Service dependencies contain a cycle with " + cc.getCycles();
                this.logger.error(methodName, id, new Object[]{error});
                must_deregister = true;
            }
        }
        if (error == null) {
            this.serviceStateHandler.putServiceByName(sset.getKey(), sset);
            return new ServiceReplyEvent(true, "Registered", key, id.getFriendly());
        }
        File mf = new File(meta_filename);
        mf.delete();
        File pf = new File(props_filename);
        pf.delete();
        return new ServiceReplyEvent(false, error, key, id.getFriendly());
    }

    public ServiceReplyEvent modify(ServiceModifyEvent ev) {
        String userout;
        String epname;
        long friendly = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname = ev.getEndpoint());
        if (sset == null) {
            return new ServiceReplyEvent(false, "Unknown", epname, friendly);
        }
        String userin = ev.getUser();
        if (!userin.equals(userout = sset.getUser()) && !this.serviceManager.isAdministrator(userin)) {
            return new ServiceReplyEvent(false, "Owned by " + userout, epname, friendly);
        }
        if (sset.isRegistered()) {
            this.pendingRequests.add(new ApiHandler(ev, this));
            return new ServiceReplyEvent(true, "Modifing", sset.getKey(), sset.getId().getFriendly());
        }
        return new ServiceReplyEvent(false, "Not registered", sset.getKey(), sset.getId().getFriendly());
    }

    void doModify(long friendly, String epname, int instances, IService.Trinary autostart, boolean activate) {
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname);
        if (instances > 0) {
            sset.setNInstances(instances);
            if (activate) {
                int running = sset.countImplementors();
                int diff = instances - running;
                if (diff > 0) {
                    while (diff-- > 0 && sset.start()) {
                    }
                } else if (diff < 0) {
                    sset.stop(-diff);
                }
            }
        }
        if (autostart != IService.Trinary.Unset) {
            sset.setAutostart(autostart.decode());
            if (activate) {
                sset.enforceAutostart();
            }
        }
    }

    public ServiceReplyEvent unregister(ServiceUnregisterEvent ev) {
        String userout;
        String epname;
        long friendly = ev.getFriendly();
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname = ev.getEndpoint());
        if (sset == null) {
            return new ServiceReplyEvent(false, "Unknown", epname, friendly);
        }
        String userin = ev.getUser();
        if (!userin.equals(userout = sset.getUser()) && !this.serviceManager.isAdministrator(userin)) {
            return new ServiceReplyEvent(false, "Owned by " + userout, epname, friendly);
        }
        if (sset.isRegistered()) {
            sset.deregister();
            this.pendingRequests.add(new ApiHandler(ev, this));
            return new ServiceReplyEvent(true, "Shutting down implementors", sset.getKey(), sset.getId().getFriendly());
        }
        return new ServiceReplyEvent(false, "Not registered", sset.getKey(), sset.getId().getFriendly());
    }

    void doUnregister(long friendly, String epname) {
        String methodName = "doUnregister";
        ServiceSet sset = this.serviceStateHandler.getServiceForApi(friendly, epname);
        if (sset.countImplementors() > 0) {
            this.logger.debug(methodName, sset.getId(), new Object[]{"Stopping implementors:", friendly, epname});
            sset.stop();
        } else if (sset.isPingOnly()) {
            this.logger.debug(methodName, sset.getId(), new Object[]{"Unregister ping-only setvice:", friendly, epname});
            sset.stop();
            this.serviceStateHandler.removeService(epname, friendly);
        } else {
            this.logger.debug(methodName, sset.getId(), new Object[]{"Removing from map:", friendly, epname});
            this.serviceStateHandler.removeService(epname, friendly);
        }
        sset.deleteProperties();
    }

    private void runSortTester(String propsfile) {
        int friendly = 1;
        DuccProperties props = new DuccProperties();
        try {
            props.load(propsfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        String svcnames = props.getStringProperty("services");
        String[] svcs = svcnames.split("\\s");
        ServiceSet[] allServices = new ServiceSet[svcs.length];
        int ndx = 0;
        for (String svc : svcs) {
            svc = svc.trim();
            String key = "UIMA-AS:" + svc + ":tcp://foo:123";
            ServiceSet dep = this.serviceStateHandler.getServiceByName(key);
            if (dep == null) {
                dep = new ServiceSet(new DuccId((long)friendly++), new DuccId(0L), key, null);
                this.serviceStateHandler.putServiceByName(key, dep);
                allServices[ndx++] = dep;
            }
            String depnames = props.getStringProperty("svc." + svc);
            String[] deps = depnames.split("\\s");
            ArrayList<String> subdeps = new ArrayList<String>();
            for (String subsvc : deps) {
                if ((subsvc = subsvc.trim()).equals("")) continue;
                String subkey = "UIMA-AS:" + subsvc + ":tcp://foo:123";
                ServiceSet subdep = this.serviceStateHandler.getServiceByName(subkey);
                if (subdep == null) {
                    subdep = new ServiceSet(new DuccId((long)friendly++), new DuccId(0L), subkey, null);
                    this.serviceStateHandler.putServiceByName(subkey, subdep);
                    allServices[ndx++] = subdep;
                }
                subdeps.add(subkey);
            }
            if (subdeps.size() <= 0) continue;
            dep.setIndependentServices(subdeps.toArray(new String[subdeps.size()]));
        }
        CycleChecker cc = new CycleChecker(allServices[0]);
        if (cc.hasCycle()) {
            System.out.println("Service dependencies contain a cycle with " + cc.getCycles());
        } else {
            System.out.println("No cycles detected");
        }
    }

    public static void main(String[] args) {
        ServiceHandler sh = new ServiceHandler(null);
        sh.runSortTester(args[0]);
    }

    class ServiceStateHandler {
        private Map<String, ServiceSet> servicesByName = new HashMap<String, ServiceSet>();
        private Map<Long, ServiceSet> servicesByFriendly = new HashMap<Long, ServiceSet>();
        private Map<DuccId, Map<String, ServiceSet>> servicesByJob = new HashMap<DuccId, Map<String, ServiceSet>>();

        ServiceStateHandler() {
        }

        synchronized ArrayList<String> getServiceNames() {
            ArrayList<String> answer = new ArrayList<String>();
            for (String k : this.servicesByName.keySet()) {
                answer.add(k);
            }
            return answer;
        }

        synchronized ServiceSet getServiceByName(String n) {
            return this.servicesByName.get(n);
        }

        synchronized ServiceSet getServiceByFriendly(long id) {
            return this.servicesByFriendly.get(id);
        }

        synchronized ServiceSet getServiceForApi(long id, String n) {
            if (n == null) {
                return this.getServiceByFriendly(id);
            }
            return this.getServiceByName(n);
        }

        synchronized List<ServiceSet> getRegisteredServices() {
            ArrayList<ServiceSet> answer = new ArrayList<ServiceSet>();
            for (ServiceSet sset : this.servicesByName.values()) {
                if (!sset.isRegistered()) continue;
                answer.add(sset);
            }
            return answer;
        }

        synchronized void putServiceByName(String n, ServiceSet s) {
            this.servicesByName.put(n, s);
            DuccId id = s.getId();
            if (id != null) {
                this.servicesByFriendly.put(id.getFriendly(), s);
            }
        }

        synchronized ServiceSet removeService(String n) {
            DuccId id;
            ServiceSet s = this.servicesByName.remove(n);
            if (s != null && (id = s.getId()) != null) {
                this.servicesByFriendly.remove(id.getFriendly());
            }
            return s;
        }

        synchronized void removeService(long id) {
            ServiceSet sset = this.servicesByFriendly.remove(id);
            if (sset != null) {
                String key = sset.getKey();
                this.servicesByName.remove(key);
            }
        }

        synchronized void removeService(String n, long id) {
            if (n == null) {
                this.removeService(id);
            } else {
                this.removeService(n);
            }
        }

        synchronized Map<String, ServiceSet> getServicesForJob(DuccId id) {
            return this.servicesByJob.get(id);
        }

        synchronized void putServiceForJob(DuccId id, ServiceSet s) {
            Map<String, ServiceSet> services = this.servicesByJob.get(id);
            if (services == null) {
                services = new HashMap<String, ServiceSet>();
                this.servicesByJob.put(id, services);
            }
            services.put(s.getKey(), s);
        }

        synchronized void removeServicesForJob(DuccId id) {
            this.servicesByJob.remove(id);
        }

        synchronized void recordNewServices(Map<String, ServiceSet> services) {
            this.servicesByName.putAll(services);
        }
    }

    class CycleChecker {
        ServiceSet sset;
        int edges = 0;
        List<String> cycles = null;

        CycleChecker(ServiceSet sset) {
            this.sset = sset;
        }

        boolean hasCycle() {
            String[] deps = this.sset.getIndependentServices();
            if (deps == null) {
                return false;
            }
            HashMap<String, ServiceSet> visited = new HashMap<String, ServiceSet>();
            this.clearEdges(this.sset, visited);
            ArrayList<ServiceSet> nodes = new ArrayList<ServiceSet>();
            nodes.addAll(visited.values());
            this.buildGraph(nodes);
            ArrayList<ServiceSet> sorted = new ArrayList<ServiceSet>();
            ArrayList<ServiceSet> current = new ArrayList<ServiceSet>();
            for (ServiceSet node : nodes) {
                if (node.hasPredecessor()) continue;
                current.add(node);
            }
            while (current.size() > 0) {
                ServiceSet next = (ServiceSet)current.remove(0);
                sorted.add(next);
                List<ServiceSet> successors = next.getSuccessors();
                for (ServiceSet succ : successors) {
                    next.removeSuccessor(succ);
                    succ.removePredecessor(next);
                    --this.edges;
                    if (succ.hasPredecessor()) continue;
                    current.add(succ);
                }
            }
            if (this.edges == 0) {
                return false;
            }
            this.cycles = new ArrayList<String>();
            for (ServiceSet node : nodes) {
                if (!node.hasSuccessor()) continue;
                for (ServiceSet succ : node.getSuccessors()) {
                    this.cycles.add(node.getKey() + " -> " + succ.getKey());
                }
            }
            return true;
        }

        String getCycles() {
            return this.cycles.toString();
        }

        void clearEdges(ServiceSet node, Map<String, ServiceSet> visited) {
            String key = node.getKey();
            node.clearEdges();
            if (visited.containsKey(key)) {
                return;
            }
            visited.put(node.getKey(), node);
            String[] deps = node.getIndependentServices();
            if (deps == null) {
                return;
            }
            for (String dep : deps) {
                ServiceSet sset = ServiceHandler.this.serviceStateHandler.getServiceByName(dep);
                if (sset == null) continue;
                this.clearEdges(sset, visited);
            }
        }

        void buildGraph(List<ServiceSet> nodes) {
            for (ServiceSet node : nodes) {
                String[] deps = node.getIndependentServices();
                if (deps == null) continue;
                for (String d : deps) {
                    ServiceSet outgoing = ServiceHandler.this.serviceStateHandler.getServiceByName(d);
                    if (outgoing == null) continue;
                    outgoing.setIncoming(node);
                    node.setOutgoing(outgoing);
                    ++this.edges;
                }
            }
        }
    }
}

