/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.uima.ducc.cli.AServicePing;
import org.apache.uima.ducc.cli.UimaAsPing;
import org.apache.uima.ducc.common.IServiceStatistics;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.sm.IServiceMeta;
import org.apache.uima.ducc.sm.ServiceManagerComponent;
import org.apache.uima.ducc.sm.ServiceSet;
import org.apache.uima.ducc.sm.SmConstants;

class PingDriver
implements IServiceMeta,
SmConstants {
    private static final long serialVersionUID = 1L;
    private DuccLogger logger = DuccLogger.getLogger((String)this.getClass().getName(), (String)"SM");
    String[] jvm_args;
    String endpoint;
    String ping_class;
    String ping_arguments;
    String classpath;
    boolean ping_ok;
    int missed_pings = 0;
    int errors = 0;
    int error_threshold = 5;
    ServiceSet sset;
    boolean test_mode = false;
    Process ping_main;
    StdioListener sin_listener = null;
    StdioListener ser_listener = null;
    PingThread pinger = null;
    int meta_ping_rate;
    int meta_ping_stability;
    String meta_ping_timeout;
    Thread ping_thread;
    boolean internal_ping = true;
    AServicePing internal_pinger = null;
    IServiceStatistics service_statistics = null;
    String user;
    String working_directory;
    String log_directory;
    boolean do_log = true;
    boolean shutdown = false;

    PingDriver(ServiceSet sset) {
        this.sset = sset;
        DuccProperties job_props = sset.getJobProperties();
        DuccProperties meta_props = sset.getMetaProperties();
        this.endpoint = meta_props.getStringProperty("endpoint");
        this.user = meta_props.getStringProperty("user");
        String jvm_args_str = job_props.getStringProperty("service_ping_jvm_args", "");
        this.ping_class = job_props.getStringProperty("service_ping_class", null);
        this.ping_arguments = job_props.getStringProperty("service_ping_arguments", null);
        if (this.ping_class == null || this.ping_class.equals(UimaAsPing.class.getName())) {
            this.internal_ping = true;
        } else {
            this.internal_ping = false;
            this.meta_ping_timeout = job_props.getStringProperty("service_ping_timeout");
            this.do_log = job_props.getBooleanProperty("service_ping_dolog", true);
            this.classpath = job_props.getStringProperty("service_ping_classpath", System.getProperty("java.class.path"));
            this.working_directory = job_props.getStringProperty("working_directory");
            this.log_directory = job_props.getStringProperty("log_directory");
        }
        jvm_args_str = jvm_args_str + " -Dducc.sm.meta.ping.timeout=" + this.meta_ping_timeout;
        jvm_args_str = jvm_args_str.trim();
        this.jvm_args = jvm_args_str.split("\\s+");
        this.meta_ping_rate = ServiceManagerComponent.meta_ping_rate;
        this.meta_ping_stability = ServiceManagerComponent.meta_ping_stability;
    }

    PingDriver(String props) {
        DuccProperties dp = new DuccProperties();
        try {
            dp.load(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.endpoint = dp.getStringProperty("endpoint");
        String jvm_args_str = dp.getStringProperty("service_ping_jvm_args", "");
        this.ping_class = dp.getStringProperty("service_ping_class");
        this.classpath = dp.getStringProperty("service_ping_classpath");
        this.jvm_args = jvm_args_str.split(" ");
        this.test_mode = true;
    }

    @Override
    public IServiceStatistics getServiceStatistics() {
        return this.service_statistics;
    }

    synchronized int getMetaPingRate() {
        return this.meta_ping_rate;
    }

    @Override
    public void run() {
        String methodName = "run";
        if (this.internal_ping) {
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Starting INTERNAL ping."});
            this.runAsThread();
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Ending INTERNAL ping."});
        } else {
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Starting EXTERNAL ping."});
            this.runAsProcess();
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Ending EXTERNAL ping."});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleStatistics(IServiceStatistics stats) {
        String methodName = "handleStatistics";
        this.service_statistics = stats;
        if (stats == null) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Service statics are null!"});
            ++this.errors;
        } else if (this.service_statistics.isAlive()) {
            PingDriver pingDriver = this;
            synchronized (pingDriver) {
                this.sset.setResponsive();
            }
            this.logger.info(methodName, this.sset.getId(), new Object[]{"Ping ok: ", this.endpoint, stats.toString()});
            this.missed_pings = 0;
        } else {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Missed_pings ", ++this.missed_pings, "endpoint", this.endpoint, stats.toString()});
            if (this.missed_pings > this.meta_ping_stability) {
                this.sset.setUnresponsive();
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Seting state to unresponsive, endpoint", this.endpoint});
            } else if (this.missed_pings > this.meta_ping_stability / 2) {
                this.sset.setWaiting();
                this.logger.info(methodName, this.sset.getId(), new Object[]{"Seting state to waiting, endpoint,", this.endpoint});
            }
        }
    }

    public void runAsThread() {
        String methodName = "runAsThread";
        this.internal_pinger = new UimaAsPing(this.logger);
        try {
            this.internal_pinger.init(this.ping_arguments, this.endpoint);
        }
        catch (Throwable t) {
            this.logger.warn(methodName, this.sset.getId(), t, new Object[0]);
            this.sset.pingExited();
        }
        while (!this.shutdown) {
            this.handleStatistics(this.internal_pinger.getStatistics());
            if (this.errors > this.error_threshold) {
                this.internal_pinger.stop();
                this.logger.warn(methodName, this.sset.getId(), new Object[]{"Ping exited because of excess errors: ", this.errors});
                this.sset.pingExited();
            }
            try {
                Thread.sleep(this.meta_ping_rate);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void runAsProcess() {
        String methodName = "run";
        try {
            this.pinger = new PingThread();
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot start listen socket, pinger not started.", t});
            this.sset.setUnresponsive();
            return;
        }
        int port = this.pinger.getPort();
        this.ping_thread = new Thread(this.pinger);
        this.ping_thread.start();
        ArrayList<String> arglist = new ArrayList<String>();
        if (!this.test_mode) {
            arglist.add(System.getProperty("ducc.agent.launcher.ducc_spawn_path"));
            arglist.add("-u");
            arglist.add(this.user);
            arglist.add("-w");
            arglist.add(this.working_directory);
            if (this.do_log) {
                arglist.add("-f");
                arglist.add(this.log_directory + "/services/ping/" + this.sset.getId());
            }
            arglist.add("--");
        }
        arglist.add(System.getProperty("ducc.jvm"));
        for (String s : this.jvm_args) {
            arglist.add(s);
        }
        arglist.add("-cp");
        arglist.add(System.getProperty("java.class.path") + ":" + this.classpath);
        arglist.add("org.apache.uima.ducc.sm.ServicePingMain");
        arglist.add("--class");
        arglist.add(this.ping_class);
        arglist.add("--endpoint");
        arglist.add(this.endpoint);
        arglist.add("--port");
        if (this.ping_arguments != null) {
            arglist.add("--arguments");
            arglist.add(this.ping_arguments);
        }
        arglist.add(Integer.toString(port));
        int i = 0;
        for (String s : arglist) {
            this.logger.debug(methodName, this.sset.getId(), new Object[]{"Args[", i++, "]:  ", s});
        }
        ProcessBuilder pb = new ProcessBuilder(arglist);
        InputStream stdout = null;
        InputStream stderr = null;
        try {
            this.ping_main = pb.start();
            stdout = this.ping_main.getInputStream();
            stderr = this.ping_main.getErrorStream();
            this.sin_listener = new StdioListener(1, stdout);
            this.ser_listener = new StdioListener(2, stderr);
            Thread sol = new Thread(this.sin_listener);
            Thread sel = new Thread(this.ser_listener);
            sol.start();
            sel.start();
        }
        catch (Throwable t) {
            this.logger.error(methodName, this.sset.getId(), new Object[]{"Cannot establish ping process:", t});
            this.sset.setUnresponsive();
            return;
        }
        while (true) {
            try {
                int rc = this.ping_main.waitFor();
                this.logger.debug(methodName, this.sset.getId(), new Object[]{"Pinger returns rc ", rc});
                this.sset.pingExited();
            }
            catch (InterruptedException e2) {
                continue;
            }
            break;
        }
        this.pinger.stop();
        this.sin_listener.stop();
        this.ser_listener.stop();
    }

    @Override
    public void stop() {
        this.shutdown = true;
        if (!this.internal_ping) {
            if (this.pinger != null) {
                this.pinger.stop();
            }
            if (this.sin_listener != null) {
                this.sin_listener.stop();
            }
            if (this.ser_listener != null) {
                this.ser_listener.stop();
            }
            if (this.ping_main != null) {
                this.ping_main.destroy();
            }
        }
    }

    public static void main(String[] args) {
        PingDriver csm = new PingDriver(args[0]);
        csm.run();
    }

    class StdioListener
    implements Runnable {
        InputStream in;
        String tag;
        boolean done = false;

        StdioListener(int which, InputStream in) {
            this.in = in;
            switch (which) {
                case 1: {
                    this.tag = "STDOUT: ";
                    break;
                }
                case 2: {
                    this.tag = "STDERR: ";
                }
            }
        }

        void stop() {
            this.done = true;
        }

        @Override
        public void run() {
            if (this.done) {
                return;
            }
            String methodName = "StdioListener.run";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                String s;
                do {
                    s = br.readLine();
                    if (PingDriver.this.test_mode) {
                        System.out.println(this.tag + s);
                        continue;
                    }
                    PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{this.tag, s});
                } while (s != null);
                String msg = this.tag + "closed, listener returns";
                if (PingDriver.this.test_mode) {
                    System.out.println(msg);
                } else {
                    PingDriver.this.logger.info(methodName, PingDriver.this.sset.getId(), new Object[]{msg});
                }
                return;
            }
            catch (IOException e) {
                if (PingDriver.this.test_mode) {
                    e.printStackTrace();
                } else {
                    PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), (Throwable)e, new Object[0]);
                }
                return;
            }
        }
    }

    class PingThread
    implements Runnable {
        ServerSocket server = new ServerSocket(0);
        int port = this.server.getLocalPort();
        boolean done = false;

        PingThread() throws IOException {
        }

        int getPort() {
            return this.port;
        }

        synchronized void stop() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "PingThread.run()";
            try {
                Socket sock = this.server.accept();
                sock.setSoTimeout(5000);
                OutputStream out = sock.getOutputStream();
                InputStream in = sock.getInputStream();
                ObjectInputStream ois = new ObjectInputStream(in);
                PingDriver.this.ping_ok = false;
                while (true) {
                    PingThread pingThread = this;
                    synchronized (pingThread) {
                        if (this.done) {
                            try {
                                PingDriver.this.logger.trace(methodName, PingDriver.this.sset.getId(), new Object[]{"PingDriver: ping QUIT"});
                                out.write(81);
                                out.flush();
                            }
                            catch (IOException e1) {
                                PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), (Throwable)e1, new Object[0]);
                                ++PingDriver.this.errors;
                            }
                            ois.close();
                            out.close();
                            in.close();
                            return;
                        }
                    }
                    if (PingDriver.this.errors > PingDriver.this.error_threshold) {
                        this.stop();
                    }
                    try {
                        PingDriver.this.logger.trace(methodName, PingDriver.this.sset.getId(), new Object[]{"PingDriver: ping OUT"});
                        out.write(80);
                        out.flush();
                    }
                    catch (IOException e1) {
                        PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), (Throwable)e1, new Object[0]);
                        ++PingDriver.this.errors;
                    }
                    PingDriver.this.handleStatistics((IServiceStatistics)ois.readObject());
                    try {
                        Thread.sleep(PingDriver.this.meta_ping_rate);
                    }
                    catch (InterruptedException e) {}
                }
            }
            catch (IOException e) {
                PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), new Object[]{"Error receiving ping", e});
                ++PingDriver.this.errors;
            }
            catch (ClassNotFoundException e) {
                PingDriver.this.logger.error(methodName, PingDriver.this.sset.getId(), new Object[]{"Input garbled:", e});
                ++PingDriver.this.errors;
            }
        }
    }
}

