/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sm;

import org.apache.uima.ducc.cli.IUiOptions;
import org.apache.uima.ducc.sm.ServiceHandler;
import org.apache.uima.ducc.sm.SmConstants;
import org.apache.uima.ducc.transport.event.ServiceModifyEvent;
import org.apache.uima.ducc.transport.event.ServiceStartEvent;
import org.apache.uima.ducc.transport.event.ServiceStopEvent;
import org.apache.uima.ducc.transport.event.ServiceUnregisterEvent;
import org.apache.uima.ducc.transport.event.sm.IService;

class ApiHandler
implements SmConstants,
Runnable {
    private static final long serialVersionUID = 1L;
    IUiOptions.UiOption cmd;
    ServiceHandler serviceHandler;
    long friendly;
    String endpoint;
    int instances;
    IService.Trinary autostart;
    boolean update;
    boolean activate;

    ApiHandler(ServiceUnregisterEvent event, ServiceHandler serviceHandler) {
        this.cmd = IUiOptions.UiOption.Unregister;
        this.friendly = event.getFriendly();
        this.endpoint = event.getEndpoint();
        this.serviceHandler = serviceHandler;
    }

    ApiHandler(ServiceStartEvent event, ServiceHandler serviceHandler) {
        this.cmd = IUiOptions.UiOption.Start;
        this.friendly = event.getFriendly();
        this.endpoint = event.getEndpoint();
        this.instances = event.getInstances();
        this.update = event.getUpdate();
        this.serviceHandler = serviceHandler;
    }

    ApiHandler(ServiceStopEvent event, ServiceHandler serviceHandler) {
        this.cmd = IUiOptions.UiOption.Stop;
        this.friendly = event.getFriendly();
        this.endpoint = event.getEndpoint();
        this.instances = event.getInstances();
        this.update = event.getUpdate();
        this.serviceHandler = serviceHandler;
    }

    ApiHandler(ServiceModifyEvent event, ServiceHandler serviceHandler) {
        this.cmd = IUiOptions.UiOption.Modify;
        this.friendly = event.getFriendly();
        this.endpoint = event.getEndpoint();
        this.instances = event.getInstances();
        this.autostart = event.getAutostart();
        this.activate = event.getActivate();
        this.serviceHandler = serviceHandler;
    }

    @Override
    public void run() {
        switch (this.cmd) {
            case Start: {
                this.serviceHandler.doStart(this.friendly, this.endpoint, this.instances, this.update);
                break;
            }
            case Stop: {
                this.serviceHandler.doStop(this.friendly, this.endpoint, this.instances, this.update);
                break;
            }
            case Unregister: {
                this.serviceHandler.doUnregister(this.friendly, this.endpoint);
                break;
            }
            case Modify: {
                this.serviceHandler.doModify(this.friendly, this.endpoint, this.instances, this.autostart, this.activate);
            }
        }
    }
}

