/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.Utils;

public class NodeStatus {
    private static String dir_home = Utils.findDuccHome();
    private static String dir_resources = "resources";
    private static String ducc_properties_filename = dir_home + File.separator + dir_resources + File.separator + "nodes.offline";
    private static NodeStatus instance = new NodeStatus();
    private SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
    private Properties properties = new Properties();

    public static NodeStatus getInstance() {
        return instance;
    }

    public NodeStatus() {
        this.load();
    }

    private String normalize(String nodeName) {
        String retVal = nodeName;
        if (nodeName != null) {
            retVal = nodeName.trim();
        }
        return retVal;
    }

    private void load() {
        try {
            File file = new File(ducc_properties_filename);
            FileInputStream fis = new FileInputStream(file);
            this.properties.load(fis);
            fis.close();
        }
        catch (Throwable t) {
            this.handle(t);
        }
    }

    private void store() {
        try {
            File file = new File(ducc_properties_filename);
            FileOutputStream fos = new FileOutputStream(file);
            this.properties.store(fos, "");
            fos.close();
        }
        catch (Throwable t) {
            this.handle(t);
        }
    }

    public boolean isOffline(String nodeName) {
        boolean retVal = false;
        String name = this.normalize(nodeName);
        if (name != null) {
            this.load();
            retVal = this.properties.containsKey(name);
        }
        return retVal;
    }

    public boolean varyOffline(String nodeName) {
        boolean retVal = false;
        String name = this.normalize(nodeName);
        if (nodeName != null) {
            this.load();
            Date date = new Date(System.currentTimeMillis());
            this.properties.put(name, "" + this.sdf.format(date));
            this.store();
        }
        return retVal;
    }

    public boolean varyOnline(String nodeName) {
        boolean retVal = false;
        String name = this.normalize(nodeName);
        if (nodeName != null) {
            this.load();
            this.properties.remove(name);
            this.store();
        }
        return retVal;
    }

    private void handle(Throwable t) {
        t.printStackTrace();
    }

    private static void _query(String nodeName) {
        NodeStatus nodeStatus = NodeStatus.getInstance();
        String state = "offline";
        if (!nodeStatus.isOffline(nodeName)) {
            state = "!offline";
        }
        System.out.println(nodeName + "=" + state);
    }

    private static void _offline(String nodeName) {
        NodeStatus nodeStatus = NodeStatus.getInstance();
        nodeStatus.varyOffline(nodeName);
    }

    private static void _online(String nodeName) {
        NodeStatus nodeStatus = NodeStatus.getInstance();
        nodeStatus.varyOnline(nodeName);
    }

    public static void main(String[] args) {
        NodeStatus._offline("node9999");
        NodeStatus._online("node8888");
        NodeStatus._offline("node7777");
        NodeStatus._online("node7777");
        NodeStatus._query("node7777");
        NodeStatus._query("node8888");
        NodeStatus._query("node9999");
        NodeStatus._query("node0000");
    }
}

