/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.admin.event.RmQueriedMachine;
import org.apache.uima.ducc.common.admin.event.RmQueriedShare;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.Share;

public class Machine
implements SchedConstants {
    private static DuccLogger logger = DuccLogger.getLogger(Machine.class, (String)"RM");
    private String id;
    private int hbcounter = 0;
    private long memory;
    private int share_order = 0;
    private NodePool nodepool;
    private int virtual_share_order = 0;
    private int shares_left = 0;
    private int blacklisted_shares = 0;
    private Map<DuccId, Share> blacklistedWork = new HashMap<DuccId, Share>();
    Node node;
    private HashMap<Share, Share> activeShares = new HashMap();

    public Machine(Node node) {
        this.node = node;
        this.memory = node.getNodeMetrics().getNodeMemory().getMemTotal();
        this.id = node.getNodeIdentity().getName();
    }

    public Node key() {
        return this.node;
    }

    public synchronized void blacklist(DuccId jobid, DuccId procid, int nshares) {
        String methodName = "blacklist";
        if (!this.blacklistedWork.containsKey(procid)) {
            if (nshares == -1) {
                nshares = this.share_order;
            }
            Share s = new Share(procid, this, jobid, nshares);
            this.blacklistedWork.put(procid, s);
            this.shares_left -= nshares;
            this.blacklisted_shares += nshares;
            if (this.shares_left < 0) {
                try {
                    throw new IllegalStateException("shares_left went negative");
                }
                catch (Exception e) {
                    logger.error(methodName, null, (Throwable)e, new Object[]{"shares went negative on", this.id, "share", procid.toString(), "nshares", nshares, "shares_left", this.shares_left, "share_order", this.share_order});
                }
            }
        }
        logger.info(methodName, null, new Object[]{this.id, procid.toString(), procid.getUUID(), "procs", this.blacklistedWork.size(), "shares left", this.shares_left, "/", this.share_order});
    }

    public synchronized void whitelist(DuccId procid) {
        String methodName = "whitelist";
        if (this.blacklistedWork.containsKey(procid)) {
            Share s = this.blacklistedWork.remove(procid);
            int nshares = s.getShareOrder();
            this.shares_left += nshares;
            this.blacklisted_shares -= nshares;
            if (this.shares_left > this.share_order) {
                try {
                    throw new IllegalStateException("shares_left exceeds share_order");
                }
                catch (Exception e) {
                    logger.error(methodName, null, (Throwable)e, new Object[]{"shares left exceeds share_order on", this.id, "share", procid.toString(), "nshares", nshares, "shares_left", this.shares_left, "share_order", this.share_order});
                }
            }
        }
        logger.info(methodName, null, new Object[]{this.id, procid.toString(), procid.getUUID(), "procs", this.blacklistedWork.size(), "shares left", this.shares_left, "/", this.share_order});
    }

    public synchronized boolean isBlacklisted() {
        return this.blacklistedWork.size() > 0;
    }

    public synchronized void heartbeat_down() {
        this.hbcounter = 0;
    }

    public synchronized void heartbeat_up() {
        ++this.hbcounter;
    }

    public synchronized int get_heartbeat() {
        return this.hbcounter;
    }

    public NodeIdentity getNodeIdentity() {
        return this.node.getNodeIdentity();
    }

    public void setNodepool(NodePool np) {
        this.nodepool = np;
    }

    public NodePool getNodepool() {
        return this.nodepool;
    }

    public boolean isFree() {
        return this.activeShares.size() == 0 && this.virtual_share_order == this.share_order && !this.isBlacklisted();
    }

    public boolean isFreeable() {
        boolean answer = true;
        if (this.isBlacklisted()) {
            return false;
        }
        for (Share s : this.activeShares.values()) {
            if (!s.isFixed()) continue;
            return false;
        }
        return answer;
    }

    public int countProcesses() {
        return this.activeShares.size();
    }

    public void assignShare(Share s) {
        this.activeShares.put(s, s);
        this.shares_left -= s.getShareOrder();
    }

    HashMap<Share, Share> getActiveShares() {
        return this.activeShares;
    }

    public Node getNode() {
        return this.node;
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.node.getNodeIdentity().getIp();
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getMemory() {
        return this.memory;
    }

    public void setMemory(long memory) {
        this.memory = memory;
    }

    public int getNodepoolDepth() {
        return this.nodepool.getDepth();
    }

    public int getShareOrder() {
        return this.share_order;
    }

    public int getVirtualShareOrder() {
        return this.virtual_share_order;
    }

    public void setShareOrder(int o) {
        this.shares_left = this.share_order = o;
        this.resetVirtualShareOrder();
    }

    public void setVirtualShareOrder(int o) {
        this.virtual_share_order = o;
    }

    public void resetVirtualShareOrder() {
        this.virtual_share_order = this.share_order - this.blacklisted_shares;
    }

    public void removeShare(Share s) {
        this.activeShares.remove(s);
        this.nodepool.removeShare(s);
        this.shares_left += s.getShareOrder();
    }

    public int countFreeShares(int order) {
        int in_use = 0;
        for (Share s : this.activeShares.values()) {
            in_use += s.getShareOrder();
        }
        return (this.share_order - in_use - this.blacklisted_shares) / order;
    }

    public int countFreeShares() {
        return this.shares_left;
    }

    public int countFreedUpShares() {
        int cnt = this.shares_left;
        for (Share s : this.activeShares.values()) {
            if (!s.isEvicted()) continue;
            cnt += s.getShareOrder();
        }
        return cnt;
    }

    RmQueriedMachine queryMachine() {
        RmQueriedShare rqs;
        RmQueriedMachine ret = new RmQueriedMachine(this.id, this.nodepool.getId(), this.memory, this.share_order, this.isBlacklisted());
        for (Share s : this.activeShares.values()) {
            rqs = new RmQueriedShare(s.getJob().getId().getFriendly(), s.getId().getFriendly(), s.getShareOrder(), s.getInitializationTime(), s.getInvestment());
            rqs.setFixed(s.isFixed());
            rqs.setPurged(s.isPurged());
            rqs.setEvicted(s.isEvicted());
            rqs.setInitialized(s.isInitialized());
            ret.addShare(rqs);
        }
        for (Share s : this.blacklistedWork.values()) {
            rqs = new RmQueriedShare(s.getBlJobId().getFriendly(), s.getId().getFriendly(), s.getShareOrder(), s.getInitializationTime(), s.getInvestment());
            rqs.setBlacklisted();
            ret.addShare(rqs);
        }
        return ret;
    }

    RmQueriedMachine queryOfflineMachine() {
        RmQueriedMachine ret = this.queryMachine();
        ret.setOffline();
        return ret;
    }

    RmQueriedMachine queryUnresponsiveMachine() {
        RmQueriedMachine ret = this.queryMachine();
        ret.setUnresponsive();
        return ret;
    }

    public int getInvestment() {
        int answer = 0;
        for (Share s : this.activeShares.values()) {
            answer = (int)((long)answer + s.getInvestment());
        }
        return answer;
    }

    public static String getDashes() {
        return String.format("%20s %12s %5s %13s %13s %11s %s", "--------------------", "------------", "-----", "-------------", "-------------", "-----------", "------ ...");
    }

    public static String getHeader() {
        return String.format("%20s %12s %5s %13s %13s %11s %s", "Name", "Blacklisted", "Order", "Active Shares", "Unused Shares", "Memory (MB)", "Jobs");
    }

    public boolean matches(String s) {
        String name = this.getNodeIdentity().getName();
        if (s.equals(name)) {
            return true;
        }
        int ndx1 = s.indexOf(".");
        int ndx2 = name.indexOf(".");
        if (ndx1 > 0 && ndx2 > 0) {
            return false;
        }
        if (ndx1 == -1) {
            return s.equals(name.substring(0, ndx2));
        }
        return s.substring(0, ndx1).equals(name);
    }

    public int hashCode() {
        return this.getNodeIdentity().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Machine m = (Machine)o;
        return this.getNodeIdentity().equals((Object)m.getNodeIdentity());
    }

    public String toString() {
        int qshares = 0;
        int unused = this.share_order;
        String jobs = "<none>";
        if (this.activeShares.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (Share s : this.activeShares.values()) {
                qshares += s.getShareOrder();
                buf.append(s.getJob().getId());
                buf.append(" ");
            }
            jobs = buf.toString();
            unused = this.share_order - qshares;
        }
        return String.format("%20s %12s %5d %13d %13d %11d %s", this.id, this.isBlacklisted(), this.share_order, qshares, unused, this.memory / 1024L, jobs);
    }
}

