/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.HashMap;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.RmJob;

public class SchedulingUpdate {
    private HashMap<IRmJob, IRmJob> shrunken = new HashMap();
    private HashMap<IRmJob, IRmJob> expanded = new HashMap();
    private HashMap<IRmJob, IRmJob> stable = new HashMap();
    private HashMap<IRmJob, IRmJob> dormant = new HashMap();
    private HashMap<IRmJob, IRmJob> reservations = new HashMap();
    private HashMap<IRmJob, IRmJob> refusals = new HashMap();

    void addShrunkenJob(IRmJob j) {
        this.shrunken.put(j, j);
    }

    void addExpandedJob(IRmJob j) {
        this.expanded.put(j, j);
    }

    void addDormantJob(IRmJob j) {
        this.dormant.put(j, j);
    }

    void addStableJob(IRmJob j) {
        this.stable.put(j, j);
    }

    void addReservation(IRmJob j) {
        this.reservations.put(j, j);
    }

    void refuse(IRmJob j, String reason) {
        j.refuse(reason);
        this.refusals.put(j, j);
    }

    HashMap<IRmJob, IRmJob> getRefusedJobs() {
        return this.refusals;
    }

    HashMap<IRmJob, IRmJob> getReservedJobs() {
        return this.reservations;
    }

    HashMap<IRmJob, IRmJob> getShrunkenJobs() {
        return this.shrunken;
    }

    HashMap<IRmJob, IRmJob> getExpandedJobs() {
        return this.expanded;
    }

    HashMap<IRmJob, IRmJob> getStableJobs() {
        return this.stable;
    }

    HashMap<IRmJob, IRmJob> getDormantJobs() {
        return this.dormant;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Expanded:\n");
        if (this.expanded.size() == 0) {
            sb.append("<none>\n");
        } else {
            sb.append("   ");
            sb.append(RmJob.getHeader());
            sb.append("\n");
            for (IRmJob j : this.expanded.values()) {
                sb.append("   ");
                sb.append(j.toString());
                sb.append("\n");
            }
        }
        sb.append("\nShrunken:\n");
        if (this.shrunken.size() == 0) {
            sb.append("   <none>\n");
        } else {
            sb.append("   ");
            sb.append(RmJob.getHeader());
            sb.append("\n");
            for (IRmJob j : this.shrunken.values()) {
                sb.append("   ");
                sb.append(j.toString());
                sb.append("\n");
            }
        }
        sb.append("\nStable:\n");
        if (this.stable.size() == 0) {
            sb.append("   <none>\n");
        } else {
            sb.append("   ");
            sb.append(RmJob.getHeader());
            sb.append("\n");
            for (IRmJob j : this.stable.values()) {
                sb.append("   ");
                sb.append(j.toString());
                sb.append("\n");
            }
        }
        sb.append("\nDormant:\n");
        if (this.dormant.size() == 0) {
            sb.append("   <none>\n");
        } else {
            sb.append("   ");
            sb.append(RmJob.getHeader());
            sb.append("\n");
            for (IRmJob j : this.dormant.values()) {
                sb.append("   ");
                sb.append(j.toString());
                sb.append("\n");
            }
        }
        sb.append("\nReserved:\n");
        if (this.reservations.size() == 0) {
            sb.append("   <none>\n");
        } else {
            sb.append("   ");
            sb.append(RmJob.getHeader());
            sb.append("\n");
            for (IRmJob j : this.reservations.values()) {
                sb.append("   ");
                sb.append(j.toString());
                sb.append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

