/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeConfiguration;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.admin.event.RmAdminQLoadReply;
import org.apache.uima.ducc.common.admin.event.RmAdminQOccupancyReply;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.common.utils.Version;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.rm.scheduler.IJobManager;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.IScheduler;
import org.apache.uima.ducc.rm.scheduler.ISchedulerMain;
import org.apache.uima.ducc.rm.scheduler.JobManagerUpdate;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.RmJob;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedInternalError;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.SchedulingUpdate;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.rm.scheduler.User;

public class Scheduler
implements ISchedulerMain,
SchedConstants {
    IJobManager jobManager;
    static DuccLogger logger = DuccLogger.getLogger(Scheduler.class, (String)"RM");
    boolean done = false;
    String ducc_home;
    NodePool[] nodepools;
    int max_order = 0;
    Map<DuccId, Share> busyShares = new HashMap<DuccId, Share>();
    Map<DuccId, Pair<IRmJob, Share>> vacatedShares = new HashMap<DuccId, Pair<IRmJob, Share>>();
    List<IRmJob> incomingJobs = new ArrayList<IRmJob>();
    List<IRmJob> recoveredJobs = new ArrayList<IRmJob>();
    List<IRmJob> completedJobs = new ArrayList<IRmJob>();
    List<IRmJob> initializedJobs = new ArrayList<IRmJob>();
    Map<Node, Node> deadNodes = new HashMap<Node, Node>();
    Map<String, NodePool> nodepoolsByNode = new HashMap<String, NodePool>();
    Map<String, String> shortToLongNode = new HashMap<String, String>();
    Map<String, User> users = new HashMap<String, User>();
    Map<DuccId, IRmJob> allJobs = new HashMap<DuccId, IRmJob>();
    Map<ResourceClass, ResourceClass> resourceClasses = new HashMap<ResourceClass, ResourceClass>();
    Map<String, ResourceClass> resourceClassesByName = new HashMap<String, ResourceClass>();
    String defaultFairShareName = null;
    String defaultReserveName = null;
    int defaultNThreads = 1;
    int defaultNTasks = 10;
    int defaultMemory = 16;
    String schedImplName;
    IScheduler[] schedulers;
    long share_quantum = 16L;
    long share_free_dram = 0L;
    long dramOverride = 0L;
    int pending_evictions = 0;
    int pending_expansions = 0;
    SchedConstants.EvictionPolicy evictionPolicy = SchedConstants.EvictionPolicy.SHRINK_BY_MACHINE;
    int nodeStability = 3;
    boolean stability = false;
    private static DuccIdFactory idFactory;
    static final int rmversion_major = 1;
    static final int rmversion_minor = 1;
    static final int rmversion_ptf = 0;
    static final String rmversion_string;
    boolean initialized = false;
    private int total_arrivals = 0;

    @Override
    public synchronized void init() throws Exception {
        String methodName = "init";
        DuccLogger.setUnthreaded();
        String ep = SystemPropertyResolver.getStringProperty((String)"ducc.rm.eviction.policy", (String)"SHRINK_BY_MACHINE");
        this.evictionPolicy = SchedConstants.EvictionPolicy.valueOf(ep);
        this.share_quantum = SystemPropertyResolver.getLongProperty((String)"ducc.rm.share.quantum", (long)this.share_quantum) * 1024L * 1024L;
        this.share_free_dram = SystemPropertyResolver.getLongProperty((String)"ducc.rm.reserved.dram", (long)this.share_free_dram) * 1024L * 1024L;
        this.ducc_home = SystemPropertyResolver.getStringProperty((String)"DUCC_HOME");
        this.defaultNTasks = SystemPropertyResolver.getIntProperty((String)"ducc.rm.default.tasks", (int)10);
        this.defaultNThreads = SystemPropertyResolver.getIntProperty((String)"ducc.rm.default.threads", (int)1);
        this.defaultMemory = SystemPropertyResolver.getIntProperty((String)"ducc.rm.default.memory", (int)16);
        this.nodeStability = SystemPropertyResolver.getIntProperty((String)"ducc.rm.node.stability", (int)3);
        this.dramOverride = SystemPropertyResolver.getLongProperty((String)"ducc.rm.override.dram", (long)0L);
        if (this.dramOverride > 0L) {
            this.dramOverride *= 0x100000L;
        }
        idFactory = new DuccIdFactory(1L);
        String class_definitions = SystemPropertyResolver.getStringProperty((String)"ducc.rm.class.definitions", (String)"scheduler.classes");
        class_definitions = System.getProperty("DUCC_HOME") + "/resources/" + class_definitions;
        try {
            this.initClasses(class_definitions);
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
            throw e;
        }
        logger.info(methodName, null, new Object[]{"Scheduler running with share quantum           : ", this.share_quantum / 0x100000L, " GB"});
        logger.info(methodName, null, new Object[]{"                       reserved DRAM           : ", this.share_free_dram / 0x100000L, " GB"});
        logger.info(methodName, null, new Object[]{"                       DRAM override           : ", this.dramOverride / 0x100000L, " GB"});
        logger.info(methodName, null, new Object[]{"                       scheduler               : ", this.schedImplName});
        logger.info(methodName, null, new Object[]{"                       default threads         : ", this.defaultNThreads});
        logger.info(methodName, null, new Object[]{"                       default tasks           : ", this.defaultNTasks});
        logger.info(methodName, null, new Object[]{"                       default memory          : ", this.defaultMemory});
        logger.info(methodName, null, new Object[]{"                       default fairshare class : ", this.defaultFairShareName});
        logger.info(methodName, null, new Object[]{"                       default reserve         : ", this.defaultReserveName});
        logger.info(methodName, null, new Object[]{"                       class definition file   : ", class_definitions});
        logger.info(methodName, null, new Object[]{"                       eviction policy         : ", this.evictionPolicy});
        logger.info(methodName, null, new Object[]{"                       use prediction          : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.prediction", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       prediction fudge factor : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.prediction.fudge", (int)10000)});
        logger.info(methodName, null, new Object[]{"                       node stability          : ", this.nodeStability});
        logger.info(methodName, null, new Object[]{"                       init stability          : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.init.stability")});
        logger.info(methodName, null, new Object[]{"                       fast recovery           : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.fast.recovery", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       RM publish rate         : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.state.publish.rate", (int)60)});
        logger.info(methodName, null, new Object[]{"                       metrics update rate     : ", SystemPropertyResolver.getIntProperty((String)"ducc.agent.node.metrics.publish.rate", (int)60000)});
        logger.info(methodName, null, new Object[]{"                       initialization cap      : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.initialization.cap")});
        logger.info(methodName, null, new Object[]{"                       expand by doubling      : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.expand.by.doubling", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       fragmentation threshold : ", SystemPropertyResolver.getIntProperty((String)"ducc.rm.fragmentation.threshold", (int)2)});
        logger.info(methodName, null, new Object[]{"                       do defragmentation      : ", SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.defragmentation", (boolean)true)});
        logger.info(methodName, null, new Object[]{"                       DUCC home               : ", System.getProperty("DUCC_HOME")});
        logger.info(methodName, null, new Object[]{"                       ActiveMQ URL            : ", SystemPropertyResolver.getStringProperty((String)"ducc.broker.url")});
        logger.info(methodName, null, new Object[]{"                       JVM                     : ", System.getProperty("java.vendor") + " " + System.getProperty("java.version")});
        logger.info(methodName, null, new Object[]{"                       JAVA_HOME               : ", System.getProperty("java.home")});
        logger.info(methodName, null, new Object[]{"                       JVM Path                : ", System.getProperty("ducc.jvm")});
        logger.info(methodName, null, new Object[]{"                       JMX URL                 : ", System.getProperty("ducc.jmx.url")});
        logger.info(methodName, null, new Object[]{"                       OS Architecture         : ", System.getProperty("os.arch")});
        logger.info(methodName, null, new Object[]{"                       OS Name                 : ", System.getProperty("os.name")});
        logger.info(methodName, null, new Object[]{"                       DUCC Version            : ", Version.version()});
        logger.info(methodName, null, new Object[]{"                       RM Version              : ", "1.1.0"});
        this.initialized = true;
    }

    @Override
    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public Machine getMachine(Node n) {
        return this.getMachine(n.getNodeIdentity());
    }

    @Override
    public Machine getMachine(NodeIdentity ni) {
        NodePool nodepool = this.getNodepoolByName(ni);
        return nodepool.getMachine(ni);
    }

    public void setJobManager(IJobManager jobmanager) {
        this.jobManager = jobmanager;
    }

    @Override
    public String getDefaultFairShareName() {
        return this.defaultFairShareName;
    }

    @Override
    public String getDefaultReserveName() {
        return this.defaultReserveName;
    }

    @Override
    public int getDefaultNThreads() {
        return this.defaultNThreads;
    }

    @Override
    public int getDefaultNTasks() {
        return this.defaultNTasks;
    }

    @Override
    public int getDefaultMemory() {
        return this.defaultMemory;
    }

    @Override
    public ResourceClass getResourceClass(String name) {
        return this.resourceClassesByName.get(name);
    }

    @Override
    public IRmJob getJob(DuccId id) {
        return this.allJobs.get(id);
    }

    @Override
    public Share getShare(DuccId id) {
        return this.busyShares.get(id);
    }

    int calcShareOrder(long mem) {
        mem = mem * 1024L * 1024L;
        int share_order = (int)(mem / this.share_quantum);
        if (mem % this.share_quantum > 0L) {
            ++share_order;
        }
        return share_order;
    }

    void getClassesForNodepool(DuccProperties dp, Map<ResourceClass, ResourceClass> ret) {
        List children;
        List class_set = (List)dp.get((Object)"classes");
        if (class_set != null) {
            for (DuccProperties cl : class_set) {
                ResourceClass rc = this.resourceClassesByName.get(cl.getStringProperty("name"));
                ret.put(rc, rc);
            }
        }
        if ((children = (List)dp.get((Object)"children")) != null) {
            for (DuccProperties child : children) {
                this.getClassesForNodepool(child, ret);
            }
        }
    }

    void mapNodesToNodepool(Map<String, String> nodes, NodePool pool) {
        if (nodes == null) {
            return;
        }
        for (String s : nodes.keySet()) {
            this.updateNodepoolsByNode(s, pool);
        }
    }

    void createSubpools(NodePool parent, List<DuccProperties> children) {
        if (children == null) {
            return;
        }
        for (DuccProperties dp : children) {
            String id = dp.getStringProperty("name");
            Map nodes = (Map)dp.get((Object)"nodes");
            NodePool child = parent.createSubpool(id, nodes, 0);
            this.mapNodesToNodepool(nodes, child);
            List grandkids = (List)dp.get((Object)"children");
            this.createSubpools(child, grandkids);
        }
    }

    void initClasses(String filename) {
        String methodName = "initClasses";
        String me = Scheduler.class.getName() + ".Config";
        DuccLogger initLogger = new DuccLogger(me, "RM");
        NodeConfiguration nc = new NodeConfiguration(filename, initLogger);
        try {
            nc.readConfiguration();
        }
        catch (Throwable e) {
            logger.error(methodName, null, e, new Object[0]);
            logger.error(methodName, null, new Object[]{"Scheduler exits: unable to read configuration."});
            System.exit(1);
        }
        nc.printConfiguration();
        DuccProperties[] nps = nc.getToplevelNodepools();
        Map cls = nc.getClasses();
        this.nodepools = new NodePool[nps.length];
        this.schedulers = new IScheduler[nps.length];
        logger.info(methodName, null, new Object[]{"Classes:"});
        logger.info(methodName, null, new Object[]{ResourceClass.getHeader()});
        logger.info(methodName, null, new Object[]{ResourceClass.getDashes()});
        for (DuccProperties props : cls.values()) {
            ResourceClass rc = new ResourceClass(props);
            this.resourceClasses.put(rc, rc);
            this.resourceClassesByName.put(rc.getName(), rc);
            logger.info(methodName, null, new Object[]{rc.toString()});
        }
        DuccProperties dc = nc.getDefaultFairShareClass();
        if (dc != null) {
            this.defaultFairShareName = dc.getProperty("name");
        }
        if ((dc = nc.getDefaultReserveClass()) != null) {
            this.defaultReserveName = dc.getProperty("name");
        }
        try {
            this.schedImplName = SystemPropertyResolver.getStringProperty((String)"ducc.rm.scheduler", (String)"org.apache.uima.ducc.rm.ClassBasedScheduler");
            Class<?> cl = Class.forName(this.schedImplName);
            for (int i = 0; i < nps.length; ++i) {
                this.schedulers[i] = (IScheduler)cl.newInstance();
                this.schedulers[i].setEvictionPolicy(this.evictionPolicy);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SchedulingException(null, "Cannot find class " + this.schedImplName);
        }
        catch (InstantiationException e) {
            throw new SchedulingException(null, "Cannot instantiate class " + this.schedImplName);
        }
        catch (IllegalAccessException e) {
            throw new SchedulingException(null, "Cannot instantiate class " + this.schedImplName + ": can't access constructor.");
        }
        for (int i = 0; i < nps.length; ++i) {
            DuccProperties np = nps[i];
            String id = np.getStringProperty("name");
            Map nodes = (Map)np.get((Object)"nodes");
            this.nodepools[i] = new NodePool(null, id, nodes, this.evictionPolicy, 0, 0);
            this.schedulers[i].setNodePool(this.nodepools[i]);
            this.mapNodesToNodepool(nodes, this.nodepools[i]);
            logger.info(methodName, null, new Object[]{"Created top-level nodepool", id});
            List children = (List)np.get((Object)"children");
            this.createSubpools(this.nodepools[i], children);
            HashMap<ResourceClass, ResourceClass> classesForNp = new HashMap<ResourceClass, ResourceClass>();
            this.getClassesForNodepool(np, classesForNp);
            this.schedulers[i].setClasses(classesForNp);
        }
    }

    private JobManagerUpdate dispatch(SchedulingUpdate upd, JobManagerUpdate jmu) {
        HashMap<Share, Share> sharesN;
        HashMap<Share, Share> sharesE;
        String methodName = "dispatch";
        this.pending_evictions = 0;
        this.pending_expansions = 0;
        HashMap<IRmJob, IRmJob> jobs = upd.getShrunkenJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{">>>>>>>>>> SHRINK"});
            sharesE = j.getAssignedShares();
            HashMap<Share, Share> sharesR = j.getPendingRemoves();
            logger.trace(methodName, j.getId(), new Object[]{"removing", sharesR.size(), "of existing", sharesE.size(), "shares."});
            this.pending_evictions += sharesR.size() * j.getShareOrder();
            for (Share s : sharesE.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    current", s.toString()});
            }
            for (Share s : sharesR.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    remove ", s.toString()});
            }
            logger.trace(methodName, j.getId(), new Object[]{">>>>>>>>>>"});
            jmu.removeShares(j, sharesR);
        }
        jobs = upd.getExpandedJobs();
        for (IRmJob j : jobs.values()) {
            sharesE = j.getAssignedShares();
            sharesN = j.getPendingShares();
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<  EXPAND"});
            logger.trace(methodName, j.getId(), new Object[]{"adding", sharesN.size(), "new shares to existing", sharesE.size(), "shares."});
            this.pending_expansions += sharesN.size() * j.getShareOrder();
            for (Share s : sharesE.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    existing ", s.toString()});
            }
            for (Share s : sharesN.values()) {
                logger.trace(methodName, j.getId(), new Object[]{"    expanding", s.toString()});
            }
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<"});
            sharesN = j.promoteShares();
            if (sharesN.size() == 0) {
                throw new SchedulingException(j.getId(), "Trying to execute expanded job but no pending machines.");
            }
            for (Share s : sharesN.values()) {
                this.busyShares.put(s.getId(), s);
            }
            jmu.addShares(j, sharesN);
        }
        jobs = upd.getStableJobs();
        for (IRmJob j : jobs.values()) {
            if (j.countNShares() < 0) {
                throw new SchedulingException(j.getId(), "Share count went negative " + j.countNShares());
            }
            logger.trace(methodName, j.getId(), new Object[]{".......... STABLE with ", j.countNShares(), " shares."});
        }
        jobs = upd.getDormantJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{".......... DORMANT"});
        }
        jobs = upd.getReservedJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<  RESERVE"});
            sharesE = j.getAssignedShares();
            sharesN = j.getPendingShares();
            if (sharesE.size() == j.countInstances()) {
                logger.trace(methodName, j.getId(), new Object[]{"reserve_stable", sharesE.size(), "machines"});
            } else if (sharesN.size() == j.countInstances()) {
                logger.trace(methodName, j.getId(), new Object[]{"reserve_adding", sharesN.size(), "machines"});
                for (Share s : sharesN.values()) {
                    logger.trace(methodName, j.getId(), new Object[]{"    reserve_expanding ", s.toString()});
                }
                jmu.addShares(j, sharesN);
                j.promoteShares();
            } else {
                logger.trace(methodName, j.getId(), new Object[]{"reserve_pending", j.countInstances(), "machines"});
            }
            logger.trace(methodName, j.getId(), new Object[]{"<<<<<<<<<<"});
        }
        jmu.setAllJobs((HashMap)this.allJobs);
        jobs = upd.getRefusedJobs();
        for (IRmJob j : jobs.values()) {
            logger.trace(methodName, j.getId(), new Object[]{".......... REFUSED"});
        }
        return jmu;
    }

    @Override
    public synchronized boolean ready() {
        return this.stability;
    }

    @Override
    public synchronized void start() {
        this.stability = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDeadNodes() {
        String methodName = "handleDeadNodes";
        if (!this.isInitialized()) {
            return;
        }
        HashMap<Node, Node> nodeUpdates = new HashMap<Node, Node>();
        Object object = this.deadNodes;
        synchronized (object) {
            nodeUpdates.putAll(this.deadNodes);
            this.deadNodes.clear();
        }
        object = this;
        synchronized (object) {
            for (Node n : nodeUpdates.values()) {
                Machine m = this.getMachine(n);
                if (m == null) continue;
                logger.warn(methodName, null, new Object[]{"***Purging machine***", m.getId(), "due to missed heartbeats. THreshold:", this.nodeStability});
                NodePool np = m.getNodepool();
                np.nodeLeaves(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public JobManagerUpdate schedule() {
        String methodName = "schedule";
        if (!this.ready()) {
            return null;
        }
        if (!this.isInitialized()) {
            return null;
        }
        logger.info("nodeArrives", null, new Object[]{"Total arrivals:", this.total_arrivals});
        this.handleDeadNodes();
        this.resetNodepools();
        SchedulingUpdate upd = new SchedulingUpdate();
        JobManagerUpdate jmu = new JobManagerUpdate();
        ArrayList<IRmJob> jobsToRecover = new ArrayList<IRmJob>();
        List<IRmJob> list = this.recoveredJobs;
        synchronized (list) {
            jobsToRecover.addAll(this.recoveredJobs);
            this.recoveredJobs.clear();
        }
        ArrayList<IRmJob> newJobs = new ArrayList<IRmJob>();
        List<IRmJob> list2 = this.incomingJobs;
        synchronized (list2) {
            newJobs.addAll(this.incomingJobs);
            this.incomingJobs.clear();
        }
        ArrayList<IRmJob> doneJobs = new ArrayList<IRmJob>();
        List<IRmJob> list3 = this.completedJobs;
        synchronized (list3) {
            doneJobs.addAll(this.completedJobs);
            this.completedJobs.clear();
        }
        ArrayList<Pair<IRmJob, Share>> doneShares = new ArrayList<Pair<IRmJob, Share>>();
        Object object = this.vacatedShares;
        synchronized (object) {
            doneShares.addAll(this.vacatedShares.values());
            this.vacatedShares.clear();
        }
        object = this;
        synchronized (object) {
            void var10_22;
            for (IRmJob iRmJob : jobsToRecover) {
                this.processRecovery(iRmJob);
            }
            for (Pair pair : doneShares) {
                this.processCompletion((IRmJob)pair.first(), (Share)pair.second());
            }
            for (IRmJob iRmJob : doneJobs) {
                this.processCompletion(iRmJob);
            }
            if (newJobs.size() > 0) {
                logger.info(methodName, null, new Object[]{"Jobs arrive:"});
                logger.info(methodName, null, new Object[]{"submit", RmJob.getHeader()});
            }
            for (IRmJob iRmJob : newJobs) {
                String user;
                User u;
                if (iRmJob.isRefused()) {
                    logger.info(methodName, iRmJob.getId(), new Object[]{"Bypassing previously refused job."});
                    upd.refuse(iRmJob, iRmJob.getRefusalReason());
                }
                if ((u = this.users.get(user = iRmJob.getUserName())) == null) {
                    u = new User(user);
                    this.users.put(user, u);
                }
                iRmJob.setUser(u);
                int share_order = this.calcShareOrder(iRmJob.getMemory());
                iRmJob.setShareOrder(share_order);
                String clid = iRmJob.getClassName();
                ResourceClass prclass = this.resourceClassesByName.get(clid);
                u.addJob(iRmJob);
                this.allJobs.put(iRmJob.getId(), iRmJob);
                if (prclass == null) {
                    upd.refuse(iRmJob, "Cannot find priority class " + clid + " for job");
                    continue;
                }
                if (share_order > this.max_order) {
                    upd.refuse(iRmJob, "Memory requested " + iRmJob.getMemory() + "GB exceeds the capacity of any machine in the cluster.");
                    continue;
                }
                if (prclass.getPolicy() != SchedConstants.Policy.RESERVE && prclass.getPolicy() != SchedConstants.Policy.FIXED_SHARE && iRmJob.isReservation()) {
                    upd.refuse(iRmJob, "Class " + prclass.getName() + " is policy " + (Object)((Object)prclass.getPolicy()) + " but the work is submitted as a reservation.");
                    continue;
                }
                prclass.addJob(iRmJob);
                iRmJob.setResourceClass(prclass);
                logger.info(methodName, iRmJob.getId(), new Object[]{"submit", iRmJob.toString()});
            }
            logger.info(methodName, null, new Object[]{"Scheduling " + newJobs.size(), " new jobs.  Existing jobs: " + this.allJobs.size()});
            boolean bl = false;
            while (var10_22 < this.schedulers.length) {
                logger.info(methodName, null, new Object[]{"Run scheduler", (int)var10_22, "with top-level nodepool", this.nodepools[var10_22].getId()});
                this.schedulers[var10_22].schedule(upd);
                ++var10_22;
            }
            logger.info(methodName, null, new Object[]{"--------------- Scheduler returns ---------------"});
            logger.info(methodName, null, new Object[]{"\n", upd.toString()});
            logger.info(methodName, null, new Object[]{"------------------------------------------------"});
            this.dispatch(upd, jmu);
            return jmu;
        }
    }

    public synchronized void shutdown() {
        this.done = true;
    }

    void updateNodepoolsByNode(String longname, NodePool np) {
        String methodName = "updateNodepoolsByNode";
        String shortname = longname;
        int ndx = longname.indexOf(".");
        logger.info(methodName, null, new Object[]{"Map", longname, "to", np.getId()});
        this.nodepoolsByNode.put(longname, np);
        if (ndx >= 0) {
            shortname = longname.substring(0, ndx);
            this.nodepoolsByNode.put(shortname, np);
            this.shortToLongNode.put(shortname, longname);
            logger.info(methodName, null, new Object[]{"Map", shortname, "to", np.getId()});
        }
    }

    NodePool getNodepoolByName(NodeIdentity ni) {
        NodePool np = this.nodepoolsByNode.get(ni.getName());
        if (np == null) {
            np = this.nodepoolsByNode.get(ni.getIp());
        }
        if (np == null) {
            np = this.nodepools[0];
            this.updateNodepoolsByNode(ni.getName(), np);
        }
        return np;
    }

    @Override
    public synchronized void nodeArrives(Node node) {
        ++this.total_arrivals;
        NodePool np = this.getNodepoolByName(node.getNodeIdentity());
        Machine m = np.getMachine(node);
        int share_order = 0;
        if (m == null) {
            long allocatable_mem = node.getNodeMetrics().getNodeMemory().getMemTotal() - this.share_free_dram;
            if (this.dramOverride > 0L) {
                allocatable_mem = this.dramOverride;
            }
            share_order = (int)(allocatable_mem / this.share_quantum);
        } else {
            share_order = m.getShareOrder();
        }
        this.max_order = Math.max(share_order, this.max_order);
        m = np.nodeArrives(node, share_order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDeath(Map<Node, Node> nodes) {
        Map<Node, Node> map = this.deadNodes;
        synchronized (map) {
            this.deadNodes.putAll(nodes);
        }
    }

    @Override
    public synchronized String varyon(String[] nodes) {
        String methodName = "varyon";
        StringBuffer reply = new StringBuffer();
        for (String n : nodes) {
            NodePool np;
            if (this.shortToLongNode.containsKey(n)) {
                n = this.shortToLongNode.get(n);
            }
            if ((np = this.nodepoolsByNode.get(n)) == null) {
                reply.append("No nodepool found for node ");
                reply.append(n);
                reply.append("\n");
                continue;
            }
            String repl = np.varyon(n);
            logger.info(methodName, null, new Object[]{repl});
            reply.append(repl);
            reply.append("\n");
        }
        return reply.toString();
    }

    @Override
    public synchronized String varyoff(String[] nodes) {
        String methodName = "varyoff";
        StringBuffer reply = new StringBuffer();
        for (String n : nodes) {
            NodePool np;
            if (this.shortToLongNode.containsKey(n)) {
                n = this.shortToLongNode.get(n);
            }
            if ((np = this.nodepoolsByNode.get(n)) == null) {
                reply.append("No nodepool found for node ");
                reply.append(n);
                reply.append("\n");
                continue;
            }
            String repl = np.varyoff(n);
            logger.info(methodName, null, new Object[]{repl});
            reply.append(repl);
            reply.append("\n");
        }
        return reply.toString();
    }

    @Override
    public synchronized RmAdminQLoadReply queryLoad() {
        RmAdminQLoadReply reply = new RmAdminQLoadReply();
        int online = 0;
        int dead = 0;
        int offline = 0;
        int free = 0;
        int shares_available = 0;
        int shares_free = 0;
        int[] onlineMachines = NodePool.makeArray();
        int[] freeMachines = NodePool.makeArray();
        int[] virtualMachines = NodePool.makeArray();
        for (NodePool np : this.nodepools) {
            online += np.countMachines();
            dead += np.countUnresponsiveMachines();
            offline += np.countOfflineMachines();
            free += np.countAllFreeMachines();
            shares_available += np.countTotalShares();
            shares_free += np.countQShares();
            np.getOnlineByOrder(onlineMachines);
            for (int i = 1; i < freeMachines.length; ++i) {
                int n = i;
                freeMachines[n] = freeMachines[n] + np.countFreeMachines(i, true);
            }
            int[] t = np.cloneVMachinesByOrder();
            for (int i = 1; i < virtualMachines.length; ++i) {
                int n = i;
                virtualMachines[n] = virtualMachines[n] + t[i];
            }
        }
        int[] demanded = NodePool.makeArray();
        int[] awarded = NodePool.makeArray();
        for (IRmJob j : this.allJobs.values()) {
            int o;
            int n = o = j.getShareOrder();
            demanded[n] = demanded[n] + j.queryDemand();
            int n2 = o;
            awarded[n2] = awarded[n2] + j.countNShares();
        }
        reply.setNodesOnline(online);
        reply.setNodesDead(dead);
        reply.setNodesOffline(offline);
        reply.setNodesFree(free);
        reply.setSharesAvailable(shares_available);
        reply.setSharesFree(shares_free);
        reply.setPendingExpansions(this.pending_expansions);
        reply.setPendingEvictions(this.pending_evictions);
        reply.setSharesDemanded(demanded);
        reply.setSharesAwarded(awarded);
        reply.setMachinesOnline(onlineMachines);
        reply.setMachinesFree(freeMachines);
        reply.setMachinesVirtual(virtualMachines);
        return reply;
    }

    @Override
    public synchronized RmAdminQOccupancyReply queryOccupancy() {
        RmAdminQOccupancyReply ret = new RmAdminQOccupancyReply();
        for (NodePool np : this.nodepools) {
            Collection<Machine> machs = np.getAllMachines().values();
            for (Machine m : machs) {
                ret.addMachine(m.queryMachine());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalNewWork(IRmJob job) {
        List<IRmJob> list = this.incomingJobs;
        synchronized (list) {
            this.incomingJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalInitialized(IRmJob job) {
        List<IRmJob> list = this.initializedJobs;
        synchronized (list) {
            this.initializedJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalRecovery(IRmJob job) {
        List<IRmJob> list = this.recoveredJobs;
        synchronized (list) {
            this.recoveredJobs.add(job);
        }
    }

    public void jobCancelled(DuccId id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalCompletion(DuccId id) {
        String methodName = "signalCompletion";
        List<IRmJob> list = this.completedJobs;
        synchronized (list) {
            try {
                IRmJob job = this.allJobs.get(id);
                if (job == null) {
                    logger.warn(methodName, id, new Object[]{"Job completion signal: early termination; nothing to complete."});
                    return;
                }
                logger.info(methodName, id, new Object[]{"Job completion signal."});
                this.completedJobs.add(job);
            }
            catch (Throwable t) {
                logger.warn(methodName, id, t, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalCompletion(IRmJob job, Share share) {
        String methodName = "signalCompletion";
        Map<DuccId, Pair<IRmJob, Share>> map = this.vacatedShares;
        synchronized (map) {
            logger.info(methodName, job.getId(), new Object[]{"Job vacate signal share: ", share.toString()});
            this.vacatedShares.put(share.getId(), (Pair<IRmJob, Share>)new Pair((Object)job, (Object)share));
        }
    }

    private synchronized void processCompletion(IRmJob job) {
        ResourceClass rc;
        String methodName = "processCompletion";
        logger.info(methodName, job.getId(), new Object[]{"Job completes."});
        IRmJob j = this.allJobs.remove(job.getId());
        if (j == null) {
            logger.info(methodName, job.getId(), new Object[]{"Job is not in run list!"});
            return;
        }
        j.markComplete();
        User user = this.users.get(j.getUserName());
        if (user.remove(job) == 0) {
            this.users.remove(user.getName());
        }
        if ((rc = job.getResourceClass()) != null) {
            rc.removeJob(j);
        } else if (!j.isRefused()) {
            throw new SchedInternalError(j.getId(), "Job exits from class " + job.getClassName() + " but we cannot find the priority class definition.");
        }
        HashMap<Share, Share> shares = job.getAssignedShares();
        for (Share s : shares.values()) {
            this.purgeShare(s, job);
        }
        job.removeAllShares();
    }

    private synchronized void processCompletion(IRmJob job, Share share) {
        String methodName = "processCompletion";
        logger.debug(methodName, job.getId(), new Object[]{"Job vacates share ", share.toString()});
        job.removeShare(share);
        this.purgeShare(share, job);
    }

    public void resetNodepools() {
        for (NodePool np : this.nodepools) {
            np.reset(NodePool.getMaxOrder());
        }
    }

    public synchronized void processRecovery(IRmJob j) {
        String methodName = "processRecovery";
        int share_order = this.calcShareOrder(j.getMemory());
        ResourceClass rc = this.resourceClassesByName.get(j.getClassName());
        j.setShareOrder(share_order);
        j.setResourceClass(rc);
        HashMap<Share, Share> shares = j.getRecoveredShares();
        StringBuffer sharenames = new StringBuffer();
        for (Share s : shares.values()) {
            sharenames.append(s.toString());
            sharenames.append(" ");
            switch (rc.getPolicy()) {
                case FAIR_SHARE: {
                    s.setShareOrder(share_order);
                    break;
                }
                case FIXED_SHARE: {
                    logger.info(methodName, j.getId(), new Object[]{"Set fixed bit for FIXED job"});
                    s.setShareOrder(share_order);
                    s.setFixed();
                    j.markComplete();
                    break;
                }
                case RESERVE: {
                    logger.info(methodName, j.getId(), new Object[]{"Set fixed bit for RESERVE job"});
                    s.setFixed();
                    j.markComplete();
                }
            }
            Machine m = s.getMachine();
            NodePool np = m.getNodepool();
            np.connectShare(s, m, j, s.getShareOrder());
            this.busyShares.put(s.getId(), s);
        }
        String username = j.getUserName();
        User user = this.users.get(username);
        if (user == null) {
            user = new User(username);
            this.users.put(username, user);
            logger.info(methodName, j.getId(), new Object[]{"&&&&&&&&&&&&&&&& new user", user.toString(), "-------------------"});
        }
        j.setUser(user);
        user.addJob(j);
        j.promoteShares();
        j.clearRecoveredShares();
        String clid = j.getClassName();
        ResourceClass prclass = this.resourceClassesByName.get(clid);
        this.allJobs.put(j.getId(), j);
        prclass.addJob(j);
        j.setResourceClass(prclass);
        logger.info(methodName, j.getId(), new Object[]{"Recovered job:", j.toString()});
        logger.info(methodName, j.getId(), new Object[]{"Recovered shares:", sharenames.toString()});
    }

    private void purgeShare(Share s, IRmJob j) {
        this.busyShares.remove(s.getId());
        Machine m = s.getMachine();
        m.removeShare(s);
    }

    public static synchronized DuccId newId() {
        return idFactory.next();
    }

    public static synchronized DuccId newId(long id) {
        return idFactory.next(id);
    }

    @Override
    public void queryMachines() {
        for (NodePool np : this.nodepools) {
            np.queryMachines();
        }
    }

    static {
        rmversion_string = null;
    }

    class MachineByOrderSorter
    implements Comparator<Machine> {
        MachineByOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            if (m1.equals(m2)) {
                return 0;
            }
            if (m1.getShareOrder() == m2.getShareOrder()) {
                return m1.getId().compareTo(m2.getId());
            }
            return m1.getShareOrder() - m2.getShareOrder();
        }
    }
}

