/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.rm.scheduler.IEntity;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.User;

public class ResourceClass
implements SchedConstants,
IEntity {
    private String id;
    private SchedConstants.Policy policy;
    private int priority;
    private int share_weight;
    private int min_shares;
    private int max_processes = 0;
    private int max_machines = 0;
    private int absolute_cap;
    private double percent_cap;
    private int true_cap;
    private int pure_fair_share;
    private HashMap<IRmJob, IRmJob> allJobs = new HashMap();
    private HashMap<Integer, HashMap<IRmJob, IRmJob>> jobsByOrder = new HashMap();
    private HashMap<User, HashMap<IRmJob, IRmJob>> jobsByUser = new HashMap();
    private int max_job_order = 0;
    private boolean subpool_counted = false;
    private String nodepoolName = null;
    private boolean enforce_memory = true;
    private boolean expand_by_doubling = SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.expand.by.doubling", (boolean)true);
    private int initialization_cap = SystemPropertyResolver.getIntProperty((String)"ducc.rm.initialization.cap", (int)2);
    private long prediction_fudge = SystemPropertyResolver.getIntProperty((String)"ducc.rm.prediction.fudge", (int)60000);
    private boolean use_prediction = SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.prediction", (boolean)true);
    private int[] given_by_order = null;
    private int[] wanted_by_order = null;
    private static Comparator<IEntity> apportionmentSorter = new ApportionmentSorterCl();
    private static String formatString = "%12s %11s %4s %5s %5s %5s %6s %6s %7s %6s %6s %7s %5s %7s %s";

    public ResourceClass(DuccProperties props) {
        this.id = props.getStringProperty("name");
        this.policy = SchedConstants.Policy.valueOf(props.getStringProperty("policy"));
        this.priority = props.getIntProperty("priority");
        this.min_shares = 0;
        if (this.policy == SchedConstants.Policy.RESERVE) {
            this.max_machines = props.getIntProperty("max-machines");
            this.enforce_memory = props.getBooleanProperty("enforce", true);
        }
        if (this.policy != SchedConstants.Policy.RESERVE) {
            this.max_processes = props.getIntProperty("max-processes");
        }
        if (this.max_processes <= 0) {
            this.max_processes = Integer.MAX_VALUE;
        }
        if (this.max_machines <= 0) {
            this.max_machines = Integer.MAX_VALUE;
        }
        this.absolute_cap = Integer.MAX_VALUE;
        this.percent_cap = 1.0;
        String cap = props.getStringProperty("cap");
        if (cap.endsWith("%")) {
            int t = Integer.parseInt(cap.substring(0, cap.length() - 1));
            this.percent_cap = (double)t * 1.0 / 100.0;
        } else {
            this.absolute_cap = Integer.parseInt(cap);
            if (this.absolute_cap == 0) {
                this.absolute_cap = Integer.MAX_VALUE;
            }
        }
        if (this.policy == SchedConstants.Policy.FAIR_SHARE) {
            this.share_weight = props.getIntProperty("weight");
            this.expand_by_doubling = props.containsKey((Object)"expand-by-doubling") ? props.getBooleanProperty("expand-by-doubling", true) : SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.expand.by.doubling", (boolean)true);
            this.initialization_cap = props.containsKey((Object)"initialization-cap") ? props.getIntProperty("initialization-cap") : SystemPropertyResolver.getIntProperty((String)"ducc.rm.initialization.cap", (int)2);
            this.use_prediction = props.containsKey((Object)"use-prediction") ? props.getBooleanProperty("use-prediction", true) : SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.prediction", (boolean)true);
            this.prediction_fudge = props.containsKey((Object)"prediction-fudge") ? props.getLongProperty("prediction-fudge") : SystemPropertyResolver.getLongProperty((String)"ducc.rm.prediction.fudge", (long)60000L);
        }
        this.nodepoolName = props.getStringProperty("nodepool");
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    String getNodepoolName() {
        return this.nodepoolName;
    }

    public void setPureFairShare(int pfs) {
        this.pure_fair_share = pfs;
    }

    public int getPureFairShare() {
        return this.pure_fair_share;
    }

    public boolean isExpandByDoubling() {
        return this.expand_by_doubling;
    }

    public void setExpandByDoubling(boolean ebd) {
        this.expand_by_doubling = ebd;
    }

    public int getInitializationCap() {
        return this.initialization_cap;
    }

    public void setInitializationCap(int c) {
        this.initialization_cap = c;
    }

    public boolean isUsePrediction() {
        return this.use_prediction;
    }

    public long getPredictionFudge() {
        return this.prediction_fudge;
    }

    public boolean enforceMemory() {
        return this.enforce_memory;
    }

    public SchedConstants.Policy getPolicy() {
        return this.policy;
    }

    public void setTrueCap(int cap) {
        this.true_cap = cap;
    }

    public int getTrueCap() {
        return this.true_cap;
    }

    public double getPercentCap() {
        return this.percent_cap;
    }

    public int getAbsoluteCap() {
        return this.absolute_cap;
    }

    public int getMaxProcesses() {
        return this.max_processes;
    }

    public int getMinShares() {
        return this.min_shares;
    }

    public int getMaxMachines() {
        return this.max_machines;
    }

    void setPolicy(SchedConstants.Policy p) {
        this.policy = p;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public int getShareWeight() {
        return this.share_weight;
    }

    public int getEffectiveWeight(int order) {
        for (int o = order; o > 0; --o) {
            if (!this.jobsByOrder.containsKey(o) || this.jobsByOrder.get(o).size() <= 0) continue;
            return this.share_weight;
        }
        return 0;
    }

    void updateNodepool(NodePool np) {
        if (this.given_by_order == null) {
            return;
        }
        for (int o = NodePool.getMaxOrder(); o > 0; --o) {
            np.countOutNSharesByOrder(o, this.given_by_order[o]);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void clearShares() {
        this.given_by_order = null;
        this.subpool_counted = false;
    }

    public void markSubpoolCounted() {
        this.subpool_counted = true;
    }

    void addJob(IRmJob j) {
        this.allJobs.put(j, j);
        int order = j.getShareOrder();
        HashMap<IRmJob, IRmJob> jbo = this.jobsByOrder.get(order);
        if (jbo == null) {
            jbo = new HashMap();
            this.jobsByOrder.put(order, jbo);
            this.max_job_order = Math.max(this.max_job_order, order);
        }
        jbo.put(j, j);
        User u = j.getUser();
        jbo = this.jobsByUser.get(u);
        if (jbo == null) {
            jbo = new HashMap();
            this.jobsByUser.put(u, jbo);
        }
        jbo.put(j, j);
    }

    void removeJob(IRmJob j) {
        if (!this.allJobs.containsKey(j)) {
            if (j.isRefused()) {
                return;
            }
            throw new SchedulingException(j.getId(), "Priority class " + this.getName() + " cannot find job to remove.");
        }
        this.allJobs.remove(j);
        int order = j.getShareOrder();
        HashMap<IRmJob, IRmJob> jbo = this.jobsByOrder.get(order);
        jbo.remove(j);
        if (jbo.size() == 0) {
            this.jobsByOrder.remove(order);
            for (int o = order - 1; o > 0; --o) {
                if (!this.jobsByOrder.containsKey(o)) continue;
                this.max_job_order = o;
                break;
            }
        }
        User u = j.getUser();
        jbo = this.jobsByUser.get(u);
        jbo.remove(j);
        if (jbo.size() == 0) {
            this.jobsByUser.remove(u);
        }
    }

    int countJobs() {
        return this.allJobs.size();
    }

    private int countNSharesWanted(int order) {
        int K = 0;
        HashMap<IRmJob, IRmJob> jobs = this.jobsByOrder.get(order);
        if (jobs == null) {
            return 0;
        }
        for (IRmJob j : jobs.values()) {
            K += j.getJobCap();
        }
        return K;
    }

    @Override
    public void initWantedByOrder(ResourceClass unused) {
        int ord = NodePool.getMaxOrder();
        this.wanted_by_order = NodePool.makeArray();
        for (int o = ord; o > 0; --o) {
            this.wanted_by_order[o] = this.countNSharesWanted(o);
            this.wanted_by_order[0] = this.wanted_by_order[0] + this.wanted_by_order[o];
        }
    }

    @Override
    public int[] getWantedByOrder() {
        return this.wanted_by_order;
    }

    @Override
    public int[] getGivenByOrder() {
        return this.given_by_order;
    }

    @Override
    public void setGivenByOrder(int[] gbo) {
        if (this.given_by_order == null) {
            this.given_by_order = gbo;
        }
    }

    @Override
    public int calculateCap(int order, int basis) {
        int perccap = Integer.MAX_VALUE;
        int absolute = this.getAbsoluteCap();
        double percent = this.getPercentCap();
        if (percent < 1.0) {
            double b = basis;
            perccap = (int)Math.round(b *= percent);
        } else {
            perccap = basis;
        }
        int cap = Math.min(absolute, perccap) / order;
        if (this.given_by_order != null && this.subpool_counted) {
            cap = Math.min(cap, this.given_by_order[order]);
        }
        return cap;
    }

    public boolean hasSharesGiven() {
        return this.given_by_order != null && this.given_by_order[0] > 0;
    }

    private int countActiveShares() {
        int sum = 0;
        for (IRmJob j : this.allJobs.values()) {
            sum += j.countNShares() * j.getShareOrder();
        }
        return sum;
    }

    HashMap<IRmJob, IRmJob> getAllJobs() {
        return this.allJobs;
    }

    HashMap<Integer, HashMap<IRmJob, IRmJob>> getAllJobsByOrder() {
        return this.jobsByOrder;
    }

    HashMap<User, HashMap<IRmJob, IRmJob>> getAllJobsByUser() {
        return this.jobsByUser;
    }

    ArrayList<IRmJob> getAllJobsSorted(Comparator<IRmJob> sorter) {
        ArrayList<IRmJob> answer = new ArrayList<IRmJob>();
        answer.addAll(this.allJobs.values());
        Collections.sort(answer, sorter);
        return answer;
    }

    int getMaxJobOrder() {
        return this.max_job_order;
    }

    int makeReadable(int i) {
        return i == Integer.MAX_VALUE ? -1 : i;
    }

    public static String getDashes() {
        return String.format(formatString, "------------", "-----------", "----", "-----", "-----", "-----", "------", "------", "-------", "------", "------", "-------", "-----", "-------", "--------");
    }

    public static String getHeader() {
        return String.format(formatString, "Class Name", "Policy", "Prio", "Wgt", "MinSh", "MaxSh", "AbsCap", "PctCap", "InitCap", "Dbling", "Prdct", "PFudge", "Shr", "Enforce", "Nodepool");
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("%12s %11s %4d %5d %5d %5d %6d %6d %7d %6s %6s %7d %5d %7s %s", this.id, this.policy.toString(), this.priority, this.share_weight, this.makeReadable(this.min_shares), this.makeReadable(this.max_processes), this.makeReadable(this.absolute_cap), (int)(this.percent_cap * 100.0), this.initialization_cap, this.expand_by_doubling, this.use_prediction, this.prediction_fudge, this.countActiveShares(), this.enforce_memory, this.nodepoolName);
    }

    public String toStringWithHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append(ResourceClass.getHeader());
        buf.append("\n");
        buf.append(this.toString());
        return buf.toString();
    }

    @Override
    public Comparator<IEntity> getApportionmentSorter() {
        return apportionmentSorter;
    }

    private static class ApportionmentSorterCl
    implements Comparator<IEntity> {
        private ApportionmentSorterCl() {
        }

        @Override
        public int compare(IEntity e1, IEntity e2) {
            int w2;
            if (e1 == e2) {
                return 0;
            }
            int w1 = e1.getShareWeight();
            if (w1 == (w2 = e2.getShareWeight())) {
                return e1.getName().compareTo(e2.getName());
            }
            return w2 - w1;
        }
    }
}

