/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.SystemPropertyResolver;
import org.apache.uima.ducc.rm.scheduler.IEntity;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.IScheduler;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.NodePool;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedInternalError;
import org.apache.uima.ducc.rm.scheduler.SchedulingException;
import org.apache.uima.ducc.rm.scheduler.SchedulingUpdate;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.rm.scheduler.User;

public class NodepoolScheduler
implements IScheduler,
SchedConstants {
    DuccLogger logger = DuccLogger.getLogger(NodepoolScheduler.class, (String)"RM");
    Map<ResourceClass, ResourceClass> resourceClasses;
    Map<IRmJob, IRmJob> needyJobs = new TreeMap<IRmJob, IRmJob>(new JobByTimeSorter());
    NodePool globalNodepool;
    Object[] classes;
    SchedulingUpdate schedulingUpdate;
    SchedConstants.EvictionPolicy evictionPolicy = SchedConstants.EvictionPolicy.SHRINK_BY_MACHINE;
    int fragmentationThreshold = SystemPropertyResolver.getIntProperty((String)"ducc.rm.fragmentation.threshold", (int)this.fragmentationThreshold);
    boolean do_defragmentation = SystemPropertyResolver.getBooleanProperty((String)"ducc.rm.defragmentation", (boolean)this.do_defragmentation);
    private static int stop_here_dx = 0;
    static int stophere = 0;

    NodepoolScheduler() {
    }

    @Override
    public void setClasses(Map<ResourceClass, ResourceClass> prclasses) {
        this.resourceClasses = prclasses;
        HashMap sorter = new HashMap();
        for (ResourceClass pcl : prclasses.values()) {
            ResourceClass prev;
            ArrayList<ResourceClass> cl = (ArrayList<ResourceClass>)sorter.get(pcl.getPriority());
            if (cl == null) {
                cl = new ArrayList<ResourceClass>();
                sorter.put(pcl.getPriority(), cl);
            }
            if (cl.size() > 0 && (prev = (ResourceClass)cl.get(0)).getPolicy() != pcl.getPolicy()) {
                throw new SchedulingException(null, "Scheduling policy must match for same-priority classes: class " + prev.getName() + " : " + pcl.getName());
            }
            cl.add(pcl);
        }
        ArrayList keys = new ArrayList();
        keys.addAll(sorter.keySet());
        Collections.sort(keys);
        this.classes = new Object[sorter.size()];
        int ndx = 0;
        for (Integer k : keys) {
            this.classes[ndx++] = sorter.get(k);
        }
    }

    @Override
    public void setNodePool(NodePool np) {
        this.globalNodepool = np;
    }

    @Override
    public void setEvictionPolicy(SchedConstants.EvictionPolicy ep) {
        this.evictionPolicy = ep;
    }

    private int calcCaps(int absolute, double percent, int basis) {
        int perccap = Integer.MAX_VALUE;
        if (percent < 1.0) {
            double b = basis;
            perccap = (int)Math.round(b *= percent);
        } else {
            perccap = basis;
        }
        return Math.min(absolute, perccap);
    }

    private void reworknShares(int[] vshares, int[] nshares) {
        int len = vshares.length;
        System.arraycopy(vshares, 0, nshares, 0, len);
        for (int o = 1; o < len; ++o) {
            for (int p = o + 1; p < len; ++p) {
                if (nshares[p] == 0) continue;
                int n = o;
                nshares[n] = nshares[n] + p / o * nshares[p];
            }
        }
    }

    void doShareSplits(int[] vmach, long count, int order) {
        block0: for (int o = order; o < vmach.length; ++o) {
            while (vmach[o] > 0) {
                int given = o / order;
                int residual = o % order;
                if (count >= (long)given) {
                    count -= (long)given;
                    if (residual > 0) {
                        int n = residual;
                        vmach[n] = vmach[n] + 1;
                    }
                } else {
                    int leftover;
                    int n = leftover = o - (int)count * order;
                    vmach[n] = vmach[n] + 1;
                    count = 0L;
                }
                int n = o;
                vmach[n] = vmach[n] - 1;
                if (count != 0L) continue;
                break block0;
            }
        }
    }

    void removeSharesByOrder(int[] vmach, int[] nshares, long count, int order) {
        if (count == 0L) {
            return;
        }
        int f = 1;
        while (f * order < vmach.length) {
            int fo = f * order;
            if (vmach[fo] > 0) {
                long available = vmach[fo] * f;
                long given = Math.min(count, available);
                int remaining = (int)(available - given);
                vmach[fo] = remaining * order / fo;
                int residual = remaining * order % fo;
                if (residual > 0) {
                    int n = residual;
                    vmach[n] = vmach[n] + 1;
                }
                count -= given;
            }
            if (count == 0L) break;
            ++f;
        }
        if (count > 0L) {
            this.doShareSplits(vmach, count, order);
        }
        this.reworknShares(vmach, nshares);
    }

    String nSharesToString(int shares, int order) {
        return String.format("%dQ%d", shares, shares * order);
    }

    String qSharesToString(int shares, int order) {
        String o = null;
        o = order == 0 ? "-" : Integer.toString(shares / order);
        return String.format("%sQ%d", o, shares);
    }

    NodePool getNodepool(ResourceClass rc) {
        String id = rc.getNodepoolName();
        if (id == null) {
            return this.globalNodepool;
        }
        return this.globalNodepool.getSubpool(id);
    }

    int calculateMaxJobOrder(ArrayList<ResourceClass> rcs) {
        int max = 0;
        for (ResourceClass rc : rcs) {
            HashMap<Integer, HashMap<IRmJob, IRmJob>> jobs = rc.getAllJobsByOrder();
            for (int i : jobs.keySet()) {
                max = Math.max(max, i);
            }
        }
        return max;
    }

    private String fmtArray(int[] array) {
        Object[] vals = new Object[array.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append("%3s ");
            vals[i] = Integer.toString(array[i]);
        }
        return String.format(sb.toString(), vals);
    }

    protected void apportion_qshares(List<IEntity> entities, int[] vshares, int total_shares, String descr) {
        String methodName = "apportion_qshares";
        boolean shares_given = false;
        int maxorder = NodePool.getMaxOrder();
        int[] nshares = NodePool.makeArray();
        if (entities.size() == 0) {
            return;
        }
        Collections.sort(entities, entities.get(0).getApportionmentSorter());
        this.reworknShares(vshares, nshares);
        ArrayList<IEntity> working = new ArrayList<IEntity>();
        working.addAll(entities);
        HashMap<IEntity, int[]> given_by_order = new HashMap<IEntity, int[]>();
        HashMap<IEntity, Integer> deserved = new HashMap<IEntity, Integer>();
        StringBuffer enames = null;
        StringBuffer eweights = null;
        this.logger.info(methodName, null, new Object[]{descr, "RmCounter Start"});
        this.logger.info(methodName, null, new Object[]{descr, "maxorder = ", NodePool.getMaxOrder()});
        enames = new StringBuffer();
        eweights = new StringBuffer();
        for (IEntity e : working) {
            int[] gbo = NodePool.makeArray();
            e.setGivenByOrder(gbo);
            given_by_order.put(e, gbo);
            deserved.put(e, 0);
            enames.append(e.getName());
            enames.append(" ");
            eweights.append(Integer.toString(e.getShareWeight()));
            eweights.append(" ");
        }
        this.logger.info(methodName, null, new Object[]{descr, "entity_names = ", enames.toString()});
        this.logger.info(methodName, null, new Object[]{descr, "weights      = ", eweights.toString()});
        for (IEntity e : working) {
            this.logger.info(methodName, null, new Object[]{descr, "wantedby." + e.getName() + " = ", this.fmtArray(e.getWantedByOrder())});
        }
        this.logger.info(methodName, null, new Object[]{descr, "vmachines =", this.fmtArray(vshares)});
        this.logger.info(methodName, null, new Object[]{descr, "RmCounter End"});
        int pass = 0;
        do {
            this.logger.trace(methodName, null, new Object[]{descr, "----------------------- Pass", pass++, "------------------------------"});
            this.logger.trace(methodName, null, new Object[]{descr, "vshares", this.fmtArray(vshares)});
            this.logger.trace(methodName, null, new Object[]{descr, "nshares", this.fmtArray(nshares)});
            shares_given = false;
            HashMap<IEntity, Integer> given_per_round = new HashMap<IEntity, Integer>();
            int allweights = 0;
            for (IEntity e : working) {
                allweights += e.getShareWeight();
                given_per_round.put(e, 0);
            }
            int all_qshares = nshares[1];
            for (IEntity e : working) {
                int base_fs = (int)Math.floor((double)nshares[1] * ((double)e.getShareWeight() / (double)allweights));
                double d_base_fs = (double)nshares[1] * ((double)e.getShareWeight() / (double)allweights);
                deserved.put(e, base_fs);
                all_qshares -= base_fs;
                this.logger.trace(methodName, null, new Object[]{descr, e.getName(), "Wanted  :", this.fmtArray(e.getWantedByOrder())});
                this.logger.trace(methodName, null, new Object[]{descr, e.getName(), "deserved:", base_fs, d_base_fs});
            }
            this.logger.trace(methodName, null, new Object[]{descr, "Leftover after giving deserved:" + all_qshares});
            if (all_qshares > 0) {
                for (IEntity e : working) {
                    deserved.put(e, (Integer)deserved.get(e) + 1);
                    if (--all_qshares != 0) continue;
                    break;
                }
            }
            for (IEntity e : working) {
                this.logger.trace(methodName, null, new Object[]{descr, String.format("Final deserved by %15s: int[%3d] (after bonus)", e.getName(), deserved.get(e))});
            }
            for (int o = maxorder; o > 0; --o) {
                int total_taken = 0;
                if (nshares[o] == 0) {
                    this.logger.trace(methodName, null, new Object[]{descr, "O " + o + " no shares to give, moving on."});
                    continue;
                }
                for (IEntity e : working) {
                    int[] wbo = e.getWantedByOrder();
                    int[] gbo = (int[])given_by_order.get(e);
                    if (wbo[o] == 0) {
                        this.logger.trace(methodName, null, new Object[]{descr, "O", o, "Entity", e.getName(), "nothing wanted at this order, moving on."});
                        continue;
                    }
                    double dgiven = (double)nshares[o] * ((double)e.getShareWeight() / (double)allweights) * (double)o;
                    int des = (Integer)deserved.get(e);
                    int gpr = (Integer)given_per_round.get(e);
                    int mpr = Math.max(0, des - gpr);
                    int tgiven = Math.min(mpr, (int)Math.floor(dgiven));
                    int cap = e.calculateCap(o, total_shares);
                    this.logger.trace(methodName, null, new Object[]{descr, "O", o, ":", e.getName(), "Before caps, given", tgiven, "cap", cap});
                    int given = tgiven / o;
                    int rgiven = tgiven % o;
                    if (rgiven > 0 && given == 0) {
                        ++given;
                        given = Math.min(given, nshares[o]);
                    }
                    if (given + gbo[0] > cap) {
                        given = Math.max(0, cap - gbo[0]);
                    }
                    int taken = Math.min(given, wbo[o]);
                    taken = Math.min(taken, nshares[o] - total_taken);
                    this.logger.trace(methodName, null, new Object[]{descr, "O", o, ":", e.getName(), "After  caps,", " dgiven Q[", dgiven, "] given N[", given, "] taken N[", taken, "]"});
                    int n = o;
                    gbo[n] = gbo[n] + taken;
                    gbo[0] = gbo[0] + taken;
                    int n2 = o;
                    wbo[n2] = wbo[n2] - taken;
                    wbo[0] = wbo[0] - taken;
                    total_taken += taken;
                    given_per_round.put(e, (Integer)given_per_round.get(e) + taken * o);
                }
                if (total_taken > 0) {
                    shares_given = true;
                }
                this.removeSharesByOrder(vshares, nshares, total_taken, o);
                for (IEntity e : working) {
                    int gpr;
                    int des = (Integer)deserved.get(e);
                    int got_all = Math.max(0, des - (gpr = ((Integer)given_per_round.get(e)).intValue()));
                    if (got_all != 0) continue;
                    allweights -= e.getShareWeight();
                }
                if (allweights <= 0) break;
            }
            Iterator iter = working.iterator();
            while (iter.hasNext()) {
                IEntity e = (IEntity)iter.next();
                if (e.getWantedByOrder()[0] != 0) continue;
                iter.remove();
            }
            iter = working.iterator();
            while (iter.hasNext()) {
                IEntity e = (IEntity)iter.next();
                int[] wbo = e.getWantedByOrder();
                boolean purge = true;
                for (int o = maxorder; o > 0; --o) {
                    if (wbo[o] <= 0 || nshares[o] <= 0) continue;
                    purge = false;
                    break;
                }
                if (!purge) continue;
                iter.remove();
            }
            if (!this.logger.isTrace()) continue;
            this.logger.trace(methodName, null, new Object[]{descr, "Survivors at end of pass:"});
            for (IEntity e : working) {
                this.logger.trace(methodName, null, new Object[]{descr, e.toString()});
            }
        } while (shares_given);
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, null, new Object[]{descr, "Final before bonus:"});
            for (IEntity e : entities) {
                int[] gbo = e.getGivenByOrder();
                this.logger.trace(methodName, null, new Object[]{descr, String.format("%12s %s", e.getName(), this.fmtArray(gbo))});
            }
        }
        boolean given = true;
        while (nshares[1] > 0 && given) {
            given = false;
            for (IEntity e : entities) {
                int[] wbo = e.getWantedByOrder();
                int[] gbo = e.getGivenByOrder();
                for (int o = maxorder; o > 0; --o) {
                    int canuse = wbo[o] - gbo[o];
                    if (canuse <= 0 || vshares[o] <= 0) continue;
                    int n = o;
                    gbo[n] = gbo[n] + 1;
                    canuse = wbo[o] - gbo[o];
                    this.removeSharesByOrder(vshares, nshares, 1L, o);
                    given = true;
                }
            }
        }
        this.logger.debug(methodName, null, new Object[]{descr, "Final apportionment:"});
        for (IEntity e : entities) {
            int[] gbo = e.getGivenByOrder();
            this.logger.debug(methodName, null, new Object[]{descr, String.format("%12s gbo%s", e.getName(), this.fmtArray(gbo))});
        }
        this.logger.debug(methodName, null, new Object[]{descr, "vshares", this.fmtArray(vshares)});
        this.logger.debug(methodName, null, new Object[]{descr, "nshares", this.fmtArray(nshares)});
    }

    protected void countClassShares(NodePool np, ArrayList<ResourceClass> rcs) {
        String methodName = "countClassShares";
        this.logger.debug(methodName, null, new Object[]{"Counting for nodepool", np.getId()});
        int[] vshares = np.cloneVMachinesByOrder();
        int total_shares = np.countTotalShares();
        ArrayList<IEntity> l = new ArrayList<IEntity>();
        l.addAll(rcs);
        for (IEntity e : l) {
            e.initWantedByOrder((ResourceClass)e);
        }
        this.apportion_qshares(l, vshares, total_shares, methodName);
        int sum_of_weights = 0;
        for (ResourceClass rc : rcs) {
            rc.markSubpoolCounted();
            sum_of_weights += rc.getShareWeight();
        }
        for (ResourceClass rc : rcs) {
            int fair_share = (int)Math.floor((double)total_shares * ((double)rc.getShareWeight() / (double)sum_of_weights));
            rc.setPureFairShare(fair_share);
        }
    }

    protected boolean countUserShares(ResourceClass rc) {
        String methodName = "countUserShares";
        HashMap<IRmJob, IRmJob> allJobs = rc.getAllJobs();
        if (allJobs.size() == 0) {
            return false;
        }
        int[] vshares = rc.getGivenByOrder();
        HashMap<User, User> users = new HashMap<User, User>();
        for (IRmJob j : allJobs.values()) {
            User u = j.getUser();
            if (users.containsKey(u)) continue;
            u.initWantedByOrder(rc);
            users.put(u, u);
        }
        ArrayList<IEntity> l = new ArrayList<IEntity>();
        l.addAll(users.values());
        this.apportion_qshares(l, vshares, 0, methodName);
        int pure_share = rc.getPureFairShare();
        int fs = (int)Math.floor((double)pure_share / (double)users.size());
        for (User u : users.values()) {
            u.setPureFairShare(fs);
        }
        return true;
    }

    private void countJobShares(ResourceClass rc) {
        String methodName = "countJobShares";
        HashMap<User, HashMap<IRmJob, IRmJob>> userJobs = rc.getAllJobsByUser();
        for (User u : userJobs.keySet()) {
            HashMap<IRmJob, IRmJob> jobs = userJobs.get(u);
            if (jobs.size() == 0) continue;
            int[] vshares = u.getGivenByOrder();
            ArrayList<IEntity> l = new ArrayList<IEntity>();
            l.addAll(jobs.values());
            for (IEntity e : l) {
                e.initWantedByOrder(rc);
            }
            this.apportion_qshares(l, vshares, 0, methodName);
            int pure_share = u.getPureFairShare();
            int fs = (int)Math.floor((double)pure_share / (double)jobs.size());
            for (IRmJob j : jobs.values()) {
                j.setPureFairShare(fs);
            }
        }
    }

    protected void traverseNodepoolsForCounts(NodePool np, ArrayList<ResourceClass> rcs) {
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool subpool : subpools) {
            ArrayList<ResourceClass> cls = new ArrayList<ResourceClass>();
            String npn = subpool.getId();
            int njobs = 0;
            for (ResourceClass rc : rcs) {
                String rcnpn = rc.getNodepoolName();
                if (rcnpn == null || !rc.getNodepoolName().equals(npn)) continue;
                cls.add(rc);
                njobs += rc.countJobs();
            }
            if (njobs <= 0) continue;
            this.traverseNodepoolsForCounts(subpool, cls);
        }
        this.countClassShares(np, rcs);
    }

    protected void updateNodepools(NodePool np, ArrayList<ResourceClass> rcs) {
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool subpool : subpools) {
            ArrayList<ResourceClass> cls = new ArrayList<ResourceClass>();
            String npn = subpool.getId();
            int njobs = 0;
            for (ResourceClass rc : rcs) {
                String rcnpn = rc.getNodepoolName();
                if (rcnpn == null || !rc.getNodepoolName().equals(npn)) continue;
                cls.add(rc);
                njobs += rc.countJobs();
            }
            if (njobs <= 0) continue;
            this.updateNodepools(subpool, cls);
        }
        if (np == this.globalNodepool) {
            ArrayList<ResourceClass> tmp = new ArrayList<ResourceClass>();
            for (ResourceClass rc : rcs) {
                if (!rc.getNodepoolName().equals(this.globalNodepool.getId())) continue;
                tmp.add(rc);
            }
            rcs = tmp;
        }
        for (ResourceClass rc : rcs) {
            if (rc.countJobs() == 0) continue;
            rc.updateNodepool(np);
        }
    }

    private void howMuchFairShare(ArrayList<ResourceClass> rcs) {
        String methodName = "howMuchFairShare";
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, null, new Object[]{"Scheduling FAIR SHARE for these classes:"});
            this.logger.trace(methodName, null, new Object[]{"   ", ResourceClass.getHeader()});
            this.logger.trace(methodName, null, new Object[]{"   ", ResourceClass.getDashes()});
            for (ResourceClass pc : rcs) {
                this.logger.trace(methodName, null, new Object[]{"   ", pc.toString()});
            }
        }
        ArrayList<ResourceClass> eligible = new ArrayList<ResourceClass>();
        Collections.sort(rcs, new ClassByWeightSorter());
        for (ResourceClass rc : rcs) {
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            this.logger.info(methodName, null, new Object[]{"Schedule class", rc.getName()});
            rc.clearShares();
            if (jobs.size() == 0) {
                this.logger.info(methodName, null, new Object[]{"No jobs to schedule in class ", rc.getName()});
                continue;
            }
            eligible.add(rc);
            for (IRmJob j : jobs.values()) {
                this.logger.info(methodName, j.getId(), new Object[]{"Scheduling job in class ", rc.getName(), ":", j.toString()});
            }
        }
        if (eligible.size() == 0) {
            return;
        }
        this.traverseNodepoolsForCounts(this.globalNodepool, eligible);
        this.updateNodepools(this.globalNodepool, eligible);
        for (ResourceClass rc : rcs) {
            if (!rc.hasSharesGiven()) {
                for (IRmJob j : rc.getAllJobs().values()) {
                    j.clearShares();
                }
                continue;
            }
            if (!this.countUserShares(rc)) continue;
            this.countJobShares(rc);
        }
    }

    protected boolean jobInClass(ArrayList<ResourceClass> rcs, IRmJob j) {
        for (ResourceClass rc : rcs) {
            if (j.getResourceClass() != rc) continue;
            return true;
        }
        return false;
    }

    protected void expandNeedyJobs(NodePool np, ArrayList<ResourceClass> rcs) {
        ResourceClass rc;
        String methodName = "expandNeedyJobs";
        if (this.needyJobs.size() == 0) {
            return;
        }
        this.logger.trace(methodName, null, new Object[]{"Enter: needyJobs.size =", this.needyJobs.size()});
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool subpool : subpools) {
            this.expandNeedyJobs(subpool, rcs);
        }
        ArrayList<IRmJob> fair_share_jobs = new ArrayList<IRmJob>();
        ArrayList<IRmJob> fixed_share_jobs = new ArrayList<IRmJob>();
        ArrayList<IRmJob> reservations = new ArrayList<IRmJob>();
        ArrayList<IRmJob> removeList = new ArrayList<IRmJob>();
        for (IRmJob j : this.needyJobs.values()) {
            if (j.isCompleted()) {
                removeList.add(j);
                continue;
            }
            rc = j.getResourceClass();
            if (rc == null) {
                removeList.add(j);
                continue;
            }
            if (!this.jobInClass(rcs, j) || this.getNodepool(rc) != np) continue;
            switch (rc.getPolicy()) {
                case FAIR_SHARE: {
                    fair_share_jobs.add(j);
                    break;
                }
                case FIXED_SHARE: {
                    fixed_share_jobs.add(j);
                    break;
                }
                case RESERVE: {
                    reservations.add(j);
                }
            }
            removeList.add(j);
        }
        for (IRmJob j : removeList) {
            this.needyJobs.remove(j);
        }
        Collections.sort(reservations, new JobByTimeSorter());
        this.logger.debug(methodName, null, new Object[]{"NP[", np.getId(), "Expand needy reservations.", this.listJobSet(reservations)});
        for (IRmJob j : reservations) {
            rc = j.getResourceClass();
            np.allocateForReservation(j, rc);
        }
        Collections.sort(fixed_share_jobs, new JobByTimeSorter());
        this.logger.debug(methodName, null, new Object[]{"NP[", np.getId(), "Expand needy fixed.", this.listJobSet(fixed_share_jobs)});
        for (IRmJob j : fixed_share_jobs) {
            if (np.findShares(j) <= 0) continue;
            for (Share s : j.getPendingShares().values()) {
                s.setFixed();
                this.logger.info(methodName, j.getId(), new Object[]{"Assign:", s});
            }
        }
        Collections.sort(fair_share_jobs, new JobByTimeSorter());
        this.logger.debug(methodName, null, new Object[]{"NP[", np.getId(), "Expand needy jobs.", this.listJobSet(fair_share_jobs)});
        np.doExpansion(fair_share_jobs);
        this.logger.trace(methodName, null, new Object[]{"Exit : needyJobs.size =", this.needyJobs.size()});
    }

    protected void traverseNodepoolsForExpansion(NodePool np, ArrayList<ResourceClass> rcs) {
        String methodName = "traverseNodepoolsForExpansion";
        List<NodePool> subpools = np.getChildrenAscending();
        for (NodePool subpool : subpools) {
            this.traverseNodepoolsForExpansion(subpool, rcs);
        }
        this.logger.info(methodName, null, new Object[]{"--- stop_here_dx", stop_here_dx});
        if (stop_here_dx == 13) {
            boolean stophere = true;
        }
        ++stop_here_dx;
        ArrayList<ResourceClass> cls = new ArrayList<ResourceClass>();
        String npn = np.getId();
        int njobs = 0;
        for (ResourceClass rc : rcs) {
            String rcnpn = rc.getNodepoolName();
            if (rcnpn == null || !rc.getNodepoolName().equals(npn)) continue;
            cls.add(rc);
            njobs += rc.countJobs();
        }
        if (njobs == 0) {
            return;
        }
        ArrayList<IRmJob> jobs = new ArrayList<IRmJob>();
        for (ResourceClass rc : cls) {
            jobs.addAll(rc.getAllJobs().values());
        }
        Collections.sort(jobs, new JobByTimeSorter());
        np.doExpansion(jobs);
    }

    protected void whatOfFairShare(ArrayList<ResourceClass> rcs) {
        String methodName = "whatOfFairShare";
        ArrayList<ResourceClass> eligible = new ArrayList<ResourceClass>();
        Collections.sort(rcs, new ClassByWeightSorter());
        for (ResourceClass rc : rcs) {
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            this.logger.info(methodName, null, new Object[]{"Schedule class", rc.getName()});
            if (jobs.size() == 0) {
                this.logger.info(methodName, null, new Object[]{"No jobs to schedule in class ", rc.getName()});
                continue;
            }
            eligible.add(rc);
            for (IRmJob j : jobs.values()) {
                this.logger.info(methodName, j.getId(), new Object[]{"Scheduling job in class ", rc.getName(), ":", j.countNSharesGiven(), "shares given, order", j.getShareOrder()});
            }
        }
        if (eligible.size() == 0) {
            return;
        }
        this.logger.trace(methodName, null, new Object[]{"Machine occupancy before expansion", stophere++});
        if (stophere == 7) {
            boolean stophere = true;
        }
        this.traverseNodepoolsForExpansion(this.globalNodepool, eligible);
    }

    protected void howMuchFixed(ArrayList<ResourceClass> rcs) {
        Cloneable jobs;
        String methodName = "howMuchFixedShare";
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, null, new Object[]{"Scheduling FIXED SHARE for these classes:"});
            this.logger.trace(methodName, null, new Object[]{"   ", ResourceClass.getHeader()});
            this.logger.trace(methodName, null, new Object[]{"   ", ResourceClass.getDashes()});
            for (ResourceClass pc : rcs) {
                this.logger.trace(methodName, null, new Object[]{"   ", pc.toString()});
            }
        }
        int total_jobs = 0;
        for (ResourceClass rc : rcs) {
            jobs = rc.getAllJobs();
            total_jobs += ((HashMap)jobs).size();
            if (((HashMap)jobs).size() == 0) {
                this.logger.info(methodName, null, new Object[]{"No jobs to schedule in class ", rc.getName()});
                continue;
            }
            StringBuffer buf = new StringBuffer();
            for (IRmJob j : ((HashMap)jobs).values()) {
                buf.append(" ");
                buf.append(j.getId());
            }
            this.logger.info(methodName, null, new Object[]{"Scheduling jobs in class:", rc.getName(), buf.toString()});
        }
        if (total_jobs == 0) {
            return;
        }
        for (ResourceClass rc : rcs) {
            jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            int shares_given_out = 0;
            Iterator<Object> i$ = ((ArrayList)jobs).iterator();
            while (i$.hasNext()) {
                IRmJob j = (IRmJob)i$.next();
                shares_given_out += j.countNShares() * j.getShareOrder();
                j.clearShares();
            }
            NodePool np = this.getNodepool(rc);
            int classcap = 0;
            classcap = this.calcCaps(rc.getAbsoluteCap(), rc.getPercentCap(), np.countTotalShares());
            Iterator i$2 = ((ArrayList)jobs).iterator();
            while (i$2.hasNext()) {
                IRmJob j = (IRmJob)i$2.next();
                int n_instances = j.countInstances();
                if (j.countNShares() > 0) {
                    this.logger.info(methodName, j.getId(), new Object[]{"[stable]", "requested", n_instances, "assigned", j.countNShares(), "processes, ", j.countNShares() * j.getShareOrder(), "QS"});
                    int[] gbo = NodePool.makeArray();
                    gbo[j.getShareOrder()] = j.countNShares();
                    j.setGivenByOrder(gbo);
                    continue;
                }
                if (j.isCompleted()) continue;
                int order = j.getShareOrder();
                if (np.countLocalShares() < n_instances) {
                    this.schedulingUpdate.refuse(j, "1 Job refused because insufficient resources are availble. Available for class " + rc.getName() + ": " + np.countLocalShares() + "requested:" + n_instances);
                    this.logger.warn(methodName, j.getId(), new Object[]{"1 Cannot accept Fixed Share job nodepool " + np.getId() + " has insufficient nodes left. Available[" + np.countLocalShares() + "] requested[" + n_instances + "]"});
                    continue;
                }
                if (np.countNSharesByOrder(order) < n_instances) {
                    this.schedulingUpdate.refuse(j, "2 Job refused because insufficient resources are availble.");
                    this.logger.warn(methodName, j.getId(), new Object[]{"2 Cannot accept Fixed Share job, insufficient shares available. Available[" + np.countNSharesByOrder(order) + "] requested[" + n_instances + "]"});
                    continue;
                }
                if ((shares_given_out += n_instances * order) > classcap) {
                    this.schedulingUpdate.refuse(j, "3 Job refused because class cap of " + classcap + " is exceeded.");
                    continue;
                }
                if (rc.getMaxProcesses() < n_instances) {
                    this.schedulingUpdate.refuse(j, "3 Job refused because class max of " + rc.getMaxProcesses() + " is exceeded.");
                    continue;
                }
                this.logger.info(methodName, j.getId(), new Object[]{"+++++ nodepool", np.getId(), "class", rc.getName(), "order", order, "shares", this.nSharesToString(n_instances, order)});
                int[] gbo = NodePool.makeArray();
                gbo[order] = n_instances;
                j.setGivenByOrder(gbo);
                np.countOutNSharesByOrder(order, n_instances);
            }
        }
    }

    protected void whatOfFixedShare(ArrayList<ResourceClass> rcs) {
        String methodName = "whatOfFixedShare";
        for (ResourceClass rc : rcs) {
            ArrayList<IRmJob> jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            NodePool np = this.getNodepool(rc);
            for (IRmJob j : jobs) {
                if (j.countNShares() > 0 || j.isCompleted()) continue;
                int order = j.getShareOrder();
                int count = j.countNSharesGiven();
                int avail = np.countNSharesByOrder(order);
                if (avail < count) continue;
                if (np.findShares(j) != count) {
                    throw new SchedInternalError(j.getId(), "Can't get enough shares but counts say there should be plenty.");
                }
                for (Share s : j.getPendingShares().values()) {
                    s.setFixed();
                }
                this.logger.info(methodName, j.getId(), new Object[]{"Assign:", this.nSharesToString(count, j.getShareOrder())});
            }
        }
    }

    private void howMuchReserve(ArrayList<ResourceClass> rcs) {
        String methodName = "howMuchToreserve";
        if (this.logger.isTrace()) {
            this.logger.trace(methodName, null, new Object[]{"Calculating counts for RESERVATION for these classes:"});
            this.logger.trace(methodName, null, new Object[]{"   ", ResourceClass.getHeader()});
            this.logger.trace(methodName, null, new Object[]{"   ", ResourceClass.getDashes()});
            for (ResourceClass pc : rcs) {
                this.logger.trace(methodName, null, new Object[]{"   ", pc.toString()});
            }
        }
        for (ResourceClass rc : rcs) {
            ArrayList<IRmJob> jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            int machines_given_out = 0;
            NodePool np = this.getNodepool(rc);
            Iterator<IRmJob> jlist = jobs.iterator();
            while (jlist.hasNext()) {
                IRmJob j = jlist.next();
                if (np == null) {
                    this.schedulingUpdate.refuse(j, "Reservation refused because insufficient resources are available.");
                    this.logger.warn(methodName, j.getId(), new Object[]{"Job scheduled to class " + rc.getName() + " but associated nodepool has no resources"});
                    continue;
                }
                j.setReservation();
                int nshares = j.countNShares();
                if (nshares > 0) {
                    int[] gbo = NodePool.makeArray();
                    gbo[j.getShareOrder()] = j.countNShares();
                    j.setGivenByOrder(gbo);
                    machines_given_out += nshares;
                    jlist.remove();
                    continue;
                }
                if (!j.isCompleted()) continue;
                jlist.remove();
            }
            if (np == null) {
                return;
            }
            for (IRmJob j : jobs) {
                this.logger.info(methodName, j.getId(), new Object[]{"Scheduling (reserve) job in class ", rc.getName()});
                if (j.countNShares() > 0) {
                    this.logger.info(methodName, j.getId(), new Object[]{"Already scheduled with ", j.countInstances(), "shares"});
                    continue;
                }
                int order = j.getShareOrder();
                int nrequested = j.countInstances();
                if (np.countLocalMachines() == 0) {
                    this.schedulingUpdate.refuse(j, "Reservation refused because insufficient resources are available.");
                    this.logger.warn(methodName, j.getId(), new Object[]{"Job asks for " + nrequested + " reserved machines but reservable resources are exhausted for nodepool " + np.getId()});
                    continue;
                }
                if (rc.getMaxMachines() < nrequested) {
                    this.schedulingUpdate.refuse(j, "Reservation refused because class max of " + rc.getMaxMachines() + "is exceeded.");
                    continue;
                }
                int classcap = this.calcCaps(rc.getAbsoluteCap(), rc.getPercentCap(), np.countLocalMachines());
                if (machines_given_out + nrequested > classcap) {
                    this.schedulingUpdate.refuse(j, "Reservation refused because class cap of " + classcap + " is exceeded.");
                    this.logger.warn(methodName, j.getId(), new Object[]{"Job asks for " + nrequested + " reserved machines but total machines for class '" + rc.getName() + "' exceeds class cap of " + classcap});
                    continue;
                }
                this.logger.info(methodName, j.getId(), new Object[]{"Job is granted " + nrequested + " machines for reservation."});
                int[] gbo = NodePool.makeArray();
                gbo[order] = nrequested;
                j.setGivenByOrder(gbo);
                machines_given_out += nrequested;
                int given = 0;
                given = rc.enforceMemory() ? np.countFreeableMachines(j, true) : np.countFreeableMachines(j, false);
                if (given != 0) continue;
                this.schedulingUpdate.refuse(j, "Reservation is refused because insufficient resources are available.");
                if (rc.enforceMemory()) {
                    this.logger.warn(methodName, j.getId(), new Object[]{"Reservation refused: asks for " + nrequested + " reserved machines with exactly " + j.getShareOrder() + " shares but there are insufficient freeable machines."});
                    continue;
                }
                this.logger.warn(methodName, j.getId(), new Object[]{"Reservation refused: ask for " + nrequested + " reserved machines with at least " + j.getShareOrder() + " shares but there are insufficient freeable machines."});
            }
        }
    }

    private void whatOfReserve(ArrayList<ResourceClass> rcs) {
        String methodName = "whatOfToReserve";
        for (ResourceClass rc : rcs) {
            NodePool np = this.getNodepool(rc);
            ArrayList<IRmJob> jobs = rc.getAllJobsSorted(new JobByTimeSorter());
            for (IRmJob j : jobs) {
                if (j.isRefused() || j.countNShares() > 0 || j.isCompleted()) continue;
                try {
                    np.allocateForReservation(j, rc);
                }
                catch (Exception e) {
                    this.logger.error(methodName, j.getId(), new Object[]{"Reservation issues:", e});
                }
            }
        }
    }

    protected void accountForNonPreemptable() {
        block5: for (ResourceClass rc : this.resourceClasses.values()) {
            switch (rc.getPolicy()) {
                case FAIR_SHARE: {
                    break;
                }
                case FIXED_SHARE: {
                    HashMap<Share, Share> shares;
                    NodePool np = this.getNodepool(rc);
                    HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
                    for (IRmJob j : jobs.values()) {
                        if (j.countNShares() <= 0) continue;
                        shares = j.getAssignedShares();
                        np.accountForShares(shares);
                    }
                    continue block5;
                }
                case RESERVE: {
                    HashMap<Share, Share> shares;
                    NodePool np = this.getNodepool(rc);
                    HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
                    for (IRmJob j : jobs.values()) {
                        if (j.countNShares() <= 0) continue;
                        shares = j.getAssignedShares();
                        np.accountForShares(shares);
                    }
                    break;
                }
            }
        }
    }

    protected void accountForFairShare() {
        for (ResourceClass rc : this.resourceClasses.values()) {
            if (rc.getPolicy() != SchedConstants.Policy.FAIR_SHARE) continue;
            NodePool np = this.getNodepool(rc);
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            for (IRmJob j : jobs.values()) {
                HashMap<Share, Share> shares = j.getAssignedShares();
                np.accountForShares(shares);
            }
        }
    }

    protected void findHowMuch(ArrayList<ResourceClass> rcs) {
        switch (rcs.get(0).getPolicy()) {
            case FAIR_SHARE: {
                this.howMuchFairShare(rcs);
                break;
            }
            case FIXED_SHARE: {
                this.howMuchFixed(rcs);
                break;
            }
            case RESERVE: {
                this.howMuchReserve(rcs);
            }
        }
    }

    protected void doEvictions(NodePool nodepool) {
        String methodName = "doEvictions";
        for (NodePool np : nodepool.getChildrenDescending()) {
            this.doEvictions(np);
        }
        int[] neededByOrder = NodePool.makeArray();
        int total_needed = 0;
        for (ResourceClass cl : this.resourceClasses.values()) {
            if (!cl.getNodepoolName().equals(nodepool.getId()) || cl.getAllJobs().size() <= 0) continue;
            HashMap<IRmJob, IRmJob> jobs = cl.getAllJobs();
            String npn = cl.getNodepoolName();
            this.logger.info(methodName, null, new Object[]{String.format("%12s %7s %7s %6s %5s", npn, "Counted", "Current", "Needed", "Order")});
            for (IRmJob j : jobs.values()) {
                int counted = j.countNSharesGiven();
                int current = j.countNShares();
                int needed = counted - current;
                int order = j.getShareOrder();
                this.logger.info(methodName, j.getId(), new Object[]{String.format("%12s %7d %7d %6d %5d", npn, counted, current, needed, order)});
                needed = Math.abs(needed);
                int n = order;
                neededByOrder[n] = neededByOrder[n] + needed;
                total_needed += needed;
            }
        }
        this.logger.debug(methodName, null, new Object[]{nodepool.getId(), "NeededByOrder before any eviction:", Arrays.toString(neededByOrder)});
        if (nodepool.countOccupiedShares() > 0 && total_needed > 0) {
            nodepool.doEvictionsByMachine(neededByOrder, false);
        }
    }

    boolean compatibleNodepools(Share candidate, IRmJob needy) {
        Machine m = candidate.getMachine();
        ResourceClass nrc = needy.getResourceClass();
        NodePool np = this.getNodepool(nrc);
        return np.containsMachine(m);
    }

    boolean compatibleNodepools(IRmJob potential, IRmJob needy) {
        NodePool pp;
        ResourceClass prc = potential.getResourceClass();
        ResourceClass nrc = needy.getResourceClass();
        NodePool np = this.getNodepool(nrc);
        return np.containsSubpool(pp = this.getNodepool(prc)) || pp.containsSubpool(np);
    }

    String listJobSet(Map<IRmJob, IRmJob> jobs) {
        if (jobs.size() == 0) {
            return "NONE";
        }
        StringBuffer sb = new StringBuffer("[");
        for (IRmJob j : jobs.keySet()) {
            sb.append(j.getId());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    String listJobSet(List<IRmJob> jobs) {
        if (jobs.size() == 0) {
            return "NONE";
        }
        StringBuffer sb = new StringBuffer("[");
        for (IRmJob j : jobs) {
            sb.append(j.getId());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    boolean clearShare(Share s, IRmJob nj) {
        String methodName = "clearShare";
        IRmJob rich_j = s.getJob();
        if (s.isPending()) {
            if (s.getShareOrder() == nj.getShareOrder()) {
                this.logger.debug(methodName, nj.getId(), new Object[]{"Reassign expanded share", s.toString(), "from", rich_j.getId()});
                s.reassignJob(nj);
                rich_j.cancelPending(s);
                nj.assignShare(s);
                return false;
            }
            this.logger.debug(methodName, nj.getId(), new Object[]{"Canceling expansion share", s.toString(), "from", rich_j.getId()});
            rich_j.cancelPending(s);
            Machine m = s.getMachine();
            m.removeShare(s);
            return true;
        }
        this.logger.debug(methodName, nj.getId(), new Object[]{"Donate", s.toString(), "from", rich_j.getId()});
        rich_j.shrinkByOne(s);
        return false;
    }

    int takeFromTheRich(IRmJob nj, int needed, TreeMap<User, User> users_by_wealth, HashMap<User, TreeMap<IRmJob, IRmJob>> jobs_by_user) {
        String methodName = "takeFromTheRich";
        HashMap<IRmJob, IRmJob> candidateJobs = new HashMap<IRmJob, IRmJob>();
        TreeMap<Machine, Machine> eligibleMachines = new TreeMap<Machine, Machine>(new EligibleMachineSorter());
        for (TreeMap<IRmJob, IRmJob> jobs : jobs_by_user.values()) {
            candidateJobs.putAll(jobs);
        }
        int given = 0;
        int orderNeeded = nj.getShareOrder();
        ResourceClass cl = nj.getResourceClass();
        String npname = cl.getNodepoolName();
        NodePool np = this.globalNodepool.getSubpool(npname);
        HashMap<Node, Machine> machines = np.getAllMachines();
        for (Machine m : machines.values()) {
            if (m.getShareOrder() < orderNeeded) {
                this.logger.trace(methodName, nj.getId(), new Object[]{"Bypass ", m.getId(), ": too small for request of order", orderNeeded});
                continue;
            }
            if (nj.isReservation() && m.getShareOrder() != orderNeeded) {
                this.logger.trace(methodName, nj.getId(), new Object[]{"Bypass ", m.getId(), ": reservation requires exact match for order", orderNeeded});
                continue;
            }
            HashMap<Share, Share> as = m.getActiveShares();
            int g = m.getVirtualShareOrder();
            for (Share s : as.values()) {
                IRmJob j = s.getJob();
                if (!s.isForceable() || !candidateJobs.containsKey(j)) continue;
                g += j.getShareOrder();
            }
            if (g >= orderNeeded) {
                this.logger.trace(methodName, nj.getId(), new Object[]{"Candidate machine:", m.getId()});
                eligibleMachines.put(m, m);
                continue;
            }
            this.logger.trace(methodName, nj.getId(), new Object[]{"Not a candidate, insufficient rich jobs:", m.getId()});
        }
        if (nj.isReservation() && eligibleMachines.size() < needed) {
            this.logger.info(methodName, nj.getId(), new Object[]{"Found insufficient machines (", eligibleMachines.size(), "for reservation. Not clearing."});
            return 0;
        }
        this.logger.info(methodName, nj.getId(), new Object[]{"Found", eligibleMachines.size(), "machines to be searched in this order:"});
        StringBuffer buf = new StringBuffer();
        for (Machine m : eligibleMachines.keySet()) {
            buf.append(m.getId());
            buf.append(" ");
        }
        this.logger.info(methodName, nj.getId(), new Object[]{"Eligible machines:", buf.toString()});
        int given_per_round = 0;
        do {
            int g = 0;
            given_per_round = 0;
            block5: for (Machine m : eligibleMachines.keySet()) {
                User u;
                IRmJob j;
                ArrayList<Share> sh = new ArrayList<Share>();
                sh.addAll(m.getActiveShares().values());
                Collections.sort(sh, new ShareByWealthSorter());
                g = m.getVirtualShareOrder();
                ArrayList<Share> potentialShares = new ArrayList<Share>();
                for (Share s : sh) {
                    TreeMap<IRmJob, IRmJob> potentialJobs;
                    j = s.getJob();
                    u = j.getUser();
                    if (s.isForceable() && (potentialJobs = jobs_by_user.get(u)) != null && potentialJobs.containsKey(j)) {
                        g += s.getShareOrder();
                        if (s.getShareOrder() == orderNeeded) {
                            potentialShares.add(0, s);
                        } else {
                            potentialShares.add(s);
                        }
                    }
                    if (g < orderNeeded) continue;
                    break;
                }
                if (g < orderNeeded) continue;
                this.logger.debug(methodName, nj.getId(), new Object[]{"Clearing shares: g[", g, "], orderNeeded[", orderNeeded, "]"});
                g = m.getVirtualShareOrder();
                for (Share s : potentialShares) {
                    j = s.getJob();
                    u = j.getUser();
                    ++given_per_round;
                    this.clearShare(s, nj);
                    u.subtractWealth(s.getShareOrder());
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Clearing share", s, "order[", s.getShareOrder(), "]: g[", g += s.getShareOrder(), "], orderNeeded[", orderNeeded, "]"});
                    if (g < orderNeeded) continue;
                    break block5;
                }
            }
            if (given_per_round > 0) {
                HashMap<Machine, Machine> tmp = new HashMap<Machine, Machine>();
                tmp.putAll(eligibleMachines);
                eligibleMachines.clear();
                for (Machine m : tmp.keySet()) {
                    eligibleMachines.put(m, m);
                }
                this.logger.debug(methodName, nj.getId(), new Object[]{"LOOPEND: given[", given += g / orderNeeded, "] g[", g, "] orderNeeded[", orderNeeded, "]"});
            }
            this.logger.debug(methodName, nj.getId(), new Object[]{"Given_per_round", given_per_round, "given", given, "needed", needed});
        } while (given_per_round > 0 && given < needed);
        return given;
    }

    void doFinalEvictions(HashMap<IRmJob, Integer> needy) {
        String methodName = "doFinalEvictions";
        for (IRmJob j : needy.keySet()) {
            this.logger.debug(methodName, j.getId(), new Object[]{"Will attempt to have space made for", needy.get(j), "processes"});
        }
        for (IRmJob nj : needy.keySet()) {
            TreeMap<IRmJob, IRmJob> candidates = new TreeMap<IRmJob, IRmJob>(new FragmentationSorter());
            for (ResourceClass rc : this.resourceClasses.values()) {
                if (rc.getPolicy() == SchedConstants.Policy.RESERVE || rc.getPolicy() == SchedConstants.Policy.FIXED_SHARE) continue;
                HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
                for (IRmJob j : jobs.values()) {
                    int nshares = j.countNShares();
                    int qshares = nshares * j.getShareOrder();
                    if (nj.isReservation() && nj.getSchedulingPriority() <= j.getSchedulingPriority()) {
                        if (nshares == 0) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because it has no share."});
                            continue;
                        }
                        this.logger.debug(methodName, nj.getId(), new Object[]{"Reservation priority override on candidate selection."});
                    } else {
                        if (needy.containsKey(j)) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because it's needy."});
                            continue;
                        }
                        if (!j.isInitialized()) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because it's not initialized yet."});
                            continue;
                        }
                        if (j.getSchedulingPriority() < nj.getSchedulingPriority()) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because it has better priority."});
                            continue;
                        }
                        if (!this.compatibleNodepools(j, nj)) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because of incompatible nodepools."});
                            continue;
                        }
                        if (nshares < this.fragmentationThreshold) {
                            this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is not a candidate because not enough processes[", nshares, "] qshares[", qshares, "]"});
                            continue;
                        }
                    }
                    this.logger.debug(methodName, nj.getId(), new Object[]{"Job", j.getId(), "is a candidate with processes[", nshares, "] qshares[", qshares, "]"});
                    candidates.put(j, j);
                }
            }
            HashMap<User, Integer> shares_by_user = new HashMap<User, Integer>();
            HashMap<User, TreeMap<IRmJob, IRmJob>> jobs_by_user = new HashMap<User, TreeMap<IRmJob, IRmJob>>();
            for (IRmJob j : candidates.values()) {
                User u = j.getUser();
                if (shares_by_user.get(u) == null) {
                    shares_by_user.put(u, 0);
                }
                shares_by_user.put(u, (Integer)shares_by_user.get(u) + j.countNShares() * j.getShareOrder());
                TreeMap<IRmJob, IRmJob> ujobs = (TreeMap<IRmJob, IRmJob>)jobs_by_user.get(u);
                if (ujobs == null) {
                    ujobs = new TreeMap<IRmJob, IRmJob>(new JobByShareSorter());
                    jobs_by_user.put(u, ujobs);
                }
                ujobs.put(j, j);
            }
            TreeMap<User, User> users_by_wealth = new TreeMap<User, User>(new UserByWealthSorter());
            for (User u : shares_by_user.keySet()) {
                u.setShareWealth((Integer)shares_by_user.get(u));
                users_by_wealth.put(u, u);
            }
            int needed = needy.get(nj);
            this.logger.debug(methodName, nj.getId(), new Object[]{"Needy job looking for", needed, "more processes of O[", nj.getShareOrder(), "]"});
            needed -= this.takeFromTheRich(nj, needed, users_by_wealth, jobs_by_user);
            if (needed <= 0) {
                this.logger.info(methodName, nj.getId(), new Object[]{"Satisfied needs of job by taking from the rich."});
                continue;
            }
            this.logger.info(methodName, nj.getId(), new Object[]{"Could not get enough from the rich. Asked for", needy.get(nj), "still needing", needed});
        }
    }

    void getNodepools(NodePool top, List<NodePool> nodepools) {
        for (NodePool np : top.getChildren().values()) {
            this.getNodepools(np, nodepools);
        }
        nodepools.add(top);
    }

    void detectFragmentation(HashMap<IRmJob, Integer> needed_by_job) {
        int[] nmach;
        String id;
        int npi;
        Map jobmap;
        String methodName = "detectFragmentation";
        if (this.logger.isDebug()) {
            this.logger.debug(methodName, null, new Object[]{"vMachines:", this.fmtArray(this.globalNodepool.cloneVMachinesByOrder())});
        }
        ArrayList<NodePool> poollist = new ArrayList<NodePool>();
        this.getNodepools(this.globalNodepool, poollist);
        NodePool[] allPools = poollist.toArray(new NodePool[poollist.size()]);
        if (this.logger.isDebug()) {
            StringBuffer sb = new StringBuffer("Nodepools:");
            for (NodePool np : allPools) {
                sb.append(np.getId());
                sb.append(" ");
            }
            this.logger.debug(methodName, null, new Object[]{sb.toString()});
        }
        HashMap<String, int[]> vshares = new HashMap<String, int[]>();
        HashMap<String, int[]> nshares = new HashMap<String, int[]>();
        HashMap jobs = new HashMap();
        for (int npi2 = 0; npi2 < allPools.length; ++npi2) {
            NodePool np;
            np = allPools[npi2];
            String id2 = np.getId();
            int[] vmach = NodePool.makeArray();
            int[] nmach2 = NodePool.makeArray();
            jobmap = new HashMap();
            vshares.put(id2, vmach);
            nshares.put(id2, nmach2);
            jobs.put(id2, jobmap);
        }
        boolean must_defrag = false;
        String headerfmt = "%12s %10s %6s %4s %7s %6s %2s";
        String datafmt = "%12s %10s %6d %4d %7d %6d %2d";
        for (ResourceClass rc : this.resourceClasses.values()) {
            HashMap<IRmJob, IRmJob> allJobs = rc.getAllJobs();
            String npn = rc.getNodepoolName();
            Map jobmap2 = (Map)jobs.get(npn);
            if (allJobs.size() == 0) continue;
            this.logger.info(methodName, null, new Object[]{String.format(headerfmt, "Nodepool", "User", "PureFS", "NSh", "Counted", "Needed", "O"), "Class:", rc.getName()});
            for (IRmJob j : allJobs.values()) {
                if (j.isRefused()) continue;
                int counted = 0;
                switch (rc.getPolicy()) {
                    case FAIR_SHARE: {
                        counted = j.countNSharesGiven();
                        break;
                    }
                    default: {
                        counted = j.countInstances();
                    }
                }
                int current = j.countNShares();
                int needed = counted - current;
                int order = j.getShareOrder();
                if (j.getSchedulingPolicy() == SchedConstants.Policy.FAIR_SHARE) {
                    if (current >= this.fragmentationThreshold) {
                        needed = 0;
                    } else if (needed < 0) {
                        needed = 0;
                    } else if (needed > 0) {
                        needed = Math.min(needed, this.fragmentationThreshold);
                        jobmap2.put(j, needed);
                        must_defrag = true;
                    }
                } else {
                    if (j.isCompleted()) continue;
                    if (needed > 0) {
                        jobmap2.put(j, needed);
                        must_defrag = true;
                    }
                }
                this.logger.info(methodName, j.getId(), new Object[]{String.format(datafmt, npn, j.getUser().getName(), j.getPureFairShare(), current, counted, needed, order), needed > 0 ? "POTENTIALLY NEEDY" : ""});
            }
        }
        if (!must_defrag) {
            return;
        }
        for (npi = 0; npi < allPools.length; ++npi) {
            NodePool np = allPools[npi];
            HashMap<Node, Machine> machs = np.getAllMachinesForPool();
            for (Machine m : machs.values()) {
                int free = m.countFreedUpShares();
                if (free == 0) continue;
                this.logger.trace(methodName, null, new Object[]{"Freed shares", free, "on machine", m.getId()});
                for (NodePool npj = np; npj != null; npj = npj.getParent()) {
                    String id_j = npj.getId();
                    int[] vmach_j = (int[])vshares.get(id_j);
                    this.logger.trace(methodName, null, new Object[]{"Update v before: NP[", id_j, "] v:", this.fmtArray(vmach_j)});
                    int n = free;
                    vmach_j[n] = vmach_j[n] + 1;
                    this.logger.trace(methodName, null, new Object[]{"Update v after : NP[", id_j, "] v:", this.fmtArray(vmach_j)});
                }
            }
        }
        for (npi = 0; npi < allPools.length; ++npi) {
            id = allPools[npi].getId();
            int[] vmach = (int[])vshares.get(id);
            nmach = (int[])nshares.get(id);
            this.reworknShares(vmach, nmach);
            if (!this.logger.isInfo()) continue;
            this.logger.info(methodName, null, new Object[]{"NP", id, "After check: virtual    free Space", this.fmtArray(vmach)});
            this.logger.info(methodName, null, new Object[]{"NP", id, "After check: cumulative free Space", this.fmtArray(nmach)});
        }
        for (npi = 0; npi < allPools.length; ++npi) {
            id = allPools[npi].getId();
            jobmap = (Map)jobs.get(id);
            if (jobmap.size() == 0) continue;
            nmach = (int[])nshares.get(id);
            for (IRmJob j : jobmap.keySet()) {
                int needed = (Integer)jobmap.get(j);
                int order = j.getShareOrder();
                int available = nmach[order];
                int to_remove = 0;
                this.needyJobs.put(j, j);
                if (available >= needed) {
                    to_remove = needed = 0;
                } else {
                    to_remove = available;
                    needed -= to_remove;
                }
                if (to_remove > 0) {
                    NodePool np;
                    for (NodePool npj = np = allPools[npi]; npj != null; npj = npj.getParent()) {
                        String id_j = npj.getId();
                        int[] vmach_j = (int[])vshares.get(id_j);
                        int[] nmach_j = (int[])nshares.get(id_j);
                        this.removeSharesByOrder(vmach_j, nmach_j, to_remove, order);
                    }
                }
                if (needed <= 0) continue;
                needed_by_job.put(j, needed);
                this.logger.info(methodName, j.getId(), new Object[]{String.format("NP: %10s User: %10s Pure fs: %3d needed %3d O[%d] %s", id, j.getUser().getName(), j.getPureFairShare(), needed, order, "ACTUALLY NEEDY")});
            }
        }
    }

    void insureFullEviction() {
        String methodName = "insureFullEviction";
        int jobcount = 0;
        for (ResourceClass rc : this.resourceClasses.values()) {
            if (rc.getPolicy() == SchedConstants.Policy.RESERVE) continue;
            jobcount += rc.countJobs();
        }
        if (jobcount == 0) {
            return;
        }
        HashMap<IRmJob, Integer> needy = new HashMap<IRmJob, Integer>();
        this.detectFragmentation(needy);
        if (needy.size() == 0) {
            this.logger.info(methodName, null, new Object[]{"No needy jobs, defragmentation bypassed."});
            return;
        }
        this.logger.info(methodName, null, new Object[]{"NEEDY JOBS DETECTED"});
        this.doFinalEvictions(needy);
    }

    protected void findWhatOf(ArrayList<ResourceClass> rcs) {
        switch (rcs.get(0).getPolicy()) {
            case FAIR_SHARE: {
                this.whatOfFairShare(rcs);
                break;
            }
            case FIXED_SHARE: {
                this.whatOfFixedShare(rcs);
                break;
            }
            case RESERVE: {
                this.whatOfReserve(rcs);
            }
        }
    }

    void setSchedulingUpdate(ArrayList<ResourceClass> rcs) {
        for (ResourceClass rc : rcs) {
            HashMap<IRmJob, IRmJob> jobs = rc.getAllJobs();
            for (IRmJob j : jobs.values()) {
                if (j.isRefused()) continue;
                if (j.isExpanded()) {
                    this.schedulingUpdate.addExpandedJob(j);
                }
                if (j.isShrunken()) {
                    this.schedulingUpdate.addShrunkenJob(j);
                }
                if (j.isStable() && !j.isReservation()) {
                    this.schedulingUpdate.addStableJob(j);
                }
                if (j.isDormant()) {
                    this.schedulingUpdate.addDormantJob(j);
                }
                if (!j.isReservation()) continue;
                this.schedulingUpdate.addReservation(j);
            }
        }
    }

    private void resetNodepools() {
        int maxorder = 0;
        for (ResourceClass rc : this.resourceClasses.values()) {
            maxorder = Math.max(maxorder, rc.getMaxJobOrder());
        }
        this.globalNodepool.reset(maxorder);
    }

    @Override
    public void schedule(SchedulingUpdate upd) {
        ArrayList rcs;
        int i;
        String methodName = "schedule";
        int jobcount = 0;
        for (ResourceClass rc : this.resourceClasses.values()) {
            HashMap<IRmJob, IRmJob> allJobs = rc.getAllJobs();
            jobcount += allJobs.size();
            for (IRmJob j : allJobs.values()) {
                j.initJobCap();
            }
        }
        if (jobcount == 0) {
            this.logger.info(methodName, null, new Object[]{"No jobs to schedule under nodepool", this.globalNodepool.getId()});
            return;
        }
        this.logger.info(methodName, null, new Object[]{"Machine occupancy before schedule"});
        this.globalNodepool.queryMachines();
        this.schedulingUpdate = upd;
        this.resetNodepools();
        this.accountForNonPreemptable();
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.findHowMuch(rcs);
        }
        this.resetNodepools();
        this.accountForNonPreemptable();
        this.accountForFairShare();
        if (this.logger.isTrace()) {
            this.globalNodepool.queryMachines();
        }
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.expandNeedyJobs(this.globalNodepool, rcs);
        }
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.findWhatOf(rcs);
        }
        this.doEvictions(this.globalNodepool);
        if (this.do_defragmentation) {
            this.insureFullEviction();
        }
        for (i = 0; i < this.classes.length; ++i) {
            rcs = (ArrayList)this.classes[i];
            this.setSchedulingUpdate(rcs);
        }
        this.globalNodepool.resetPreemptables();
    }

    private static class ShareByWealthSorter
    implements Comparator<Share> {
        private ShareByWealthSorter() {
        }

        @Override
        public int compare(Share s1, Share s2) {
            if (s1.equals(s2)) {
                return 0;
            }
            int s1wealth = 0;
            int s2wealth = 0;
            IRmJob j1 = s1.getJob();
            User u1 = j1.getUser();
            s1wealth = u1.getShareWealth();
            IRmJob j2 = s2.getJob();
            User u2 = j2.getUser();
            s2wealth = u2.getShareWealth();
            return s2wealth - s1wealth;
        }
    }

    private static class EligibleMachineSorter
    implements Comparator<Machine> {
        private EligibleMachineSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            long m2mem;
            if (m1.equals(m2)) {
                return 0;
            }
            int m1wealth = 0;
            int m2wealth = 0;
            HashMap<Share, Share> sh1 = m1.getActiveShares();
            for (Share s : sh1.values()) {
                IRmJob j = s.getJob();
                User u = j.getUser();
                m1wealth = Math.max(m1wealth, u.getShareWealth());
            }
            HashMap<Share, Share> sh2 = m2.getActiveShares();
            for (Share s : sh2.values()) {
                IRmJob j = s.getJob();
                User u = j.getUser();
                m2wealth = Math.max(m2wealth, u.getShareWealth());
            }
            if (m1wealth != m2wealth) {
                return m2wealth - m1wealth;
            }
            long m1mem = m1.getMemory();
            if (m1mem == (m2mem = m2.getMemory())) {
                return -1;
            }
            return (int)(m2mem - m1mem);
        }
    }

    private static class FragmentationSorter
    implements Comparator<IRmJob> {
        private FragmentationSorter() {
        }

        @Override
        public int compare(IRmJob j1, IRmJob j2) {
            int o2;
            if (j1.equals(j2)) {
                return 0;
            }
            int p1 = j1.getPureFairShare();
            int p2 = j2.getPureFairShare();
            int c1 = j1.countNShares() * j1.getShareOrder();
            int c2 = j2.countNShares() * j2.getShareOrder();
            int o1 = Math.max(0, c1 - p1);
            if (o1 < (o2 = Math.max(0, c2 - p2))) {
                return 1;
            }
            if (o1 > o2) {
                return -1;
            }
            if (c1 < c2) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return -1;
        }
    }

    private static class JobByShareSorter
    implements Comparator<IRmJob> {
        private JobByShareSorter() {
        }

        @Override
        public int compare(IRmJob j1, IRmJob j2) {
            int s2;
            if (j1.equals(j2)) {
                return 0;
            }
            int s1 = j1.countNShares() * j1.getShareOrder();
            if (s1 == (s2 = j2.countNShares() * j2.getShareOrder())) {
                return -1;
            }
            return s2 - s1;
        }
    }

    private static class UserByWealthSorter
    implements Comparator<User> {
        private UserByWealthSorter() {
        }

        @Override
        public int compare(User u1, User u2) {
            int w2;
            if (u1.equals(u2)) {
                return 0;
            }
            int w1 = u1.getShareWealth();
            if (w1 == (w2 = u2.getShareWealth())) {
                return -1;
            }
            return w2 - w1;
        }
    }

    private static class ClassByWeightSorter
    implements Comparator<ResourceClass> {
        private ClassByWeightSorter() {
        }

        @Override
        public int compare(ResourceClass r1, ResourceClass r2) {
            if (r1 == r2) {
                return 0;
            }
            return r2.getShareWeight() - r1.getShareWeight();
        }
    }

    private static class JobByTimeSorter
    implements Comparator<IRmJob> {
        private JobByTimeSorter() {
        }

        @Override
        public int compare(IRmJob j1, IRmJob j2) {
            if (j1.equals(j2)) {
                return 0;
            }
            if (j1.getTimestamp() == j2.getTimestamp()) {
                return j2.getShareOrder() - j1.getShareOrder();
            }
            return (int)(j1.getTimestamp() - j2.getTimestamp());
        }
    }
}

