/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.sd.task;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.ducc.ps.net.iface.IMetaMetaTask;
import org.apache.uima.ducc.ps.net.iface.IMetaTask;
import org.apache.uima.ducc.ps.net.iface.IMetaTaskTransaction;
import org.apache.uima.ducc.ps.net.impl.MetaMetaTask;
import org.apache.uima.ducc.ps.net.impl.MetaTask;
import org.apache.uima.ducc.ps.sd.DuccServiceDriver;
import org.apache.uima.ducc.ps.sd.task.MessageBuffer;
import org.apache.uima.ducc.ps.sd.task.Standardize;
import org.apache.uima.ducc.ps.sd.task.WiTaskConsumer;
import org.apache.uima.ducc.ps.sd.task.error.TaskProtocolException;
import org.apache.uima.ducc.ps.sd.task.iface.ITask;
import org.apache.uima.ducc.ps.sd.task.iface.TaskAllocatorCallbackListener;
import org.apache.uima.ducc.ps.sd.task.iface.TaskConsumer;
import org.apache.uima.ducc.ps.sd.task.iface.TaskProtocolHandler;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class DuccServiceTaskProtocolHandler
implements TaskProtocolHandler {
    Logger logger = UIMAFramework.getLogger(DuccServiceTaskProtocolHandler.class);
    private volatile boolean running = true;
    private static AtomicInteger atomicCounter = new AtomicInteger(0);

    public DuccServiceTaskProtocolHandler(TaskAllocatorCallbackListener taskAllocator) {
    }

    @Override
    public String initialize(Properties props) throws TaskProtocolException {
        return null;
    }

    @Override
    public void handle(IMetaTaskTransaction wi) throws TaskProtocolException {
        this.handleMetaTaskTransation(wi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMetaTaskTransation(IMetaTaskTransaction trans) {
        try {
            trans.setResponseHints(new ArrayList<IMetaTaskTransaction.Hint>());
            WiTaskConsumer taskConsumer = new WiTaskConsumer(trans);
            MessageBuffer mb = new MessageBuffer();
            mb.append(Standardize.Label.remote.get() + ((Object)taskConsumer).toString());
            mb.append(Standardize.Label.type.get() + (Object)((Object)trans.getType()));
            IMetaTaskTransaction.Type type = trans.getType();
            switch (type) {
                case Get: {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "---- Driver handling GET Request - Requestor:" + ((Object)taskConsumer).toString());
                    }
                    this.handleMetaTaskTransationGet(trans, taskConsumer);
                    break;
                }
                case Ack: {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "---- Driver handling ACK Request - Requestor:" + ((Object)taskConsumer).toString());
                    }
                    this.handleMetaTaskTransationAck(trans, taskConsumer);
                    break;
                }
                case End: {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "---- Driver handling END Request - Requestor:" + ((Object)taskConsumer).toString());
                    }
                    this.handleMetaTaskTransationEnd(trans, taskConsumer);
                    break;
                }
                case InvestmentReset: {
                    break;
                }
            }
            IMetaTask metaCas = trans.getMetaTask();
            if (metaCas != null) {
                metaCas.setPerformanceMetrics(null);
                metaCas.setUserSpaceException(null);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error", (Throwable)e);
        }
    }

    @Override
    public String start() throws Exception {
        this.running = true;
        return null;
    }

    @Override
    public void stop() throws Exception {
        this.running = false;
    }

    private void handleMetaTaskTransationGet(IMetaTaskTransaction trans, TaskConsumer taskConsumer) {
        IMetaMetaTask mmc = this.getMetaMetaTask(taskConsumer);
        trans.setMetaTask(mmc.getMetaCas());
    }

    private IMetaTask getMetaTask(String serializedCas) {
        if (serializedCas == null) {
            return null;
        }
        return new MetaTask(atomicCounter.incrementAndGet(), "", serializedCas);
    }

    private synchronized IMetaMetaTask getMetaMetaTask(TaskConsumer taskConsumer) {
        MetaMetaTask mmc = new MetaMetaTask();
        DuccServiceDriver sd = DuccServiceDriver.getInstance();
        TaskAllocatorCallbackListener taskAllocator = sd.getTaskAllocator();
        ITask task = taskAllocator.getTask(taskConsumer);
        if (task != null && !task.isEmpty()) {
            IMetaTask metaTask = this.getMetaTask(task.asString());
            mmc.setMetaCas(metaTask);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Returning TASK with appdata:" + task.getMetadata() + " to the service");
            }
            mmc.getMetaCas().setAppData(task.getMetadata());
        }
        return mmc;
    }

    private void handleMetaTaskTransationAck(IMetaTaskTransaction trans, TaskConsumer taskConsumer) {
    }

    private void handleMetaTaskTransationEnd(IMetaTaskTransaction trans, TaskConsumer taskConsumer) {
        DuccServiceDriver sd = DuccServiceDriver.getInstance();
        TaskAllocatorCallbackListener taskAllocator = sd.getTaskAllocator();
        if (trans.getMetaTask().getUserSpaceException() != null) {
            String exceptionAsString = (String)trans.getMetaTask().getUserSpaceException();
            taskAllocator.onTaskFailure(taskConsumer, trans.getMetaTask().getAppData(), exceptionAsString);
        } else {
            String m = trans.getMetaTask().getPerformanceMetrics();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "handleMetaTaskTransationEnd()........... appdata:" + trans.getMetaTask().getAppData());
            }
            taskAllocator.onTaskSuccess(taskConsumer, trans.getMetaTask().getAppData(), m);
        }
    }

    public static void main(String[] args) {
    }
}

