/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.pm;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.boot.DuccDaemonRuntimeProperties;
import org.apache.uima.ducc.common.component.AbstractDuccComponent;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.IDuccId;
import org.apache.uima.ducc.pm.ProcessManager;
import org.apache.uima.ducc.pm.helper.DuccWorkHelper;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DaemonDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.DuccJobsStateEvent;
import org.apache.uima.ducc.transport.event.PmStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.DuccJobDeployment;
import org.apache.uima.ducc.transport.event.common.DuccUserReservation;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkPop;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccUnits;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.ProcessMemoryAssignment;

public class ProcessManagerComponent
extends AbstractDuccComponent
implements ProcessManager {
    private static final String[] jobHeaderArray = new String[]{"DuccId", "ProcessType", "PID", "ProcessState", "ResourceState", "NodeIP", "NodeName", "DeallocationType", "JMX Url"};
    private static final String jobHeaderFormat = "%1$-15s|%2$-20s|%3$-10s|%4$-15s|%5$-15s|%6$-13s|%7$-45s|%8$-25s|%9$-45s";
    private static String header;
    private static String tbl;
    public static DuccLogger logger;
    private static DuccWorkHelper dwHelper;
    private DuccEventDispatcher eventDispatcher;
    private int shareQuantum;
    private int fudgeFactor = 5;
    String stateChangeEndpoint;

    public ProcessManagerComponent(CamelContext context, DuccEventDispatcher eventDispatcher) {
        super("ProcessManager", context);
        this.eventDispatcher = eventDispatcher;
        if (System.getProperty("ducc.rm.share.quantum") != null && System.getProperty("ducc.rm.share.quantum").trim().length() > 0) {
            this.shareQuantum = Integer.parseInt(System.getProperty("ducc.rm.share.quantum").trim());
        }
        if (System.getProperty("ducc.agent.share.size.fudge.factor") != null && System.getProperty("ducc.agent.share.size.fudge.factor").trim().length() > 0) {
            this.fudgeFactor = Integer.parseInt(System.getProperty("ducc.agent.share.size.fudge.factor").trim());
        }
        header = String.format(jobHeaderFormat, jobHeaderArray[0], jobHeaderArray[1], jobHeaderArray[2], jobHeaderArray[3], jobHeaderArray[4], jobHeaderArray[5], jobHeaderArray[6], jobHeaderArray[7], jobHeaderArray[8] + "\n");
        dwHelper = new DuccWorkHelper();
    }

    private void stateChange(DuccEvent.EventType eventType) {
        String methodName = "stateChange";
        try {
            IDuccLoggerComponents.Daemon daemon = IDuccLoggerComponents.Daemon.ProcessManager;
            NodeIdentity nodeIdentity = new NodeIdentity();
            DaemonDuccEvent ev = new DaemonDuccEvent(daemon, eventType, nodeIdentity);
            this.eventDispatcher.dispatch(this.stateChangeEndpoint, (DuccEvent)ev, "");
            logger.info(methodName, null, new Object[]{this.stateChangeEndpoint, eventType.name(), nodeIdentity.getName()});
        }
        catch (Exception e) {
            logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
    }

    public void start(DuccService service) throws Exception {
        super.start(service, null);
        DuccDaemonRuntimeProperties.getInstance().boot(DuccDaemonRuntimeProperties.DaemonName.ProcessManager, this.getProcessJmxUrl());
        logger.info("start", null, new Object[]{"--PM started - jmx URL:" + super.getProcessJmxUrl()});
        this.stateChange(DuccEvent.EventType.BOOT);
    }

    public void stop() throws Exception {
        this.stateChange(DuccEvent.EventType.SHUTDOWN);
        super.stop();
    }

    public void setstateChangeEndpoint(String stateChangeEndpoint) {
        this.stateChangeEndpoint = stateChangeEndpoint;
    }

    public DuccLogger getLogger() {
        return logger;
    }

    private long normalizeMemory(String processMemoryAssignment, IDuccUnits.MemoryUnits units) {
        long normalizedProcessMemoryRequirements = Long.parseLong(processMemoryAssignment);
        if (units.equals((Object)IDuccUnits.MemoryUnits.KB)) {
            normalizedProcessMemoryRequirements = (int)normalizedProcessMemoryRequirements / 0x100000;
        } else if (units.equals((Object)IDuccUnits.MemoryUnits.MB)) {
            normalizedProcessMemoryRequirements = (int)normalizedProcessMemoryRequirements / 1024;
        } else if (!units.equals((Object)IDuccUnits.MemoryUnits.GB) && units.equals((Object)IDuccUnits.MemoryUnits.TB)) {
            normalizedProcessMemoryRequirements = (int)normalizedProcessMemoryRequirements * 1024;
        }
        return normalizedProcessMemoryRequirements;
    }

    private int getShares(long normalizedProcessMemoryRequirements) {
        int shares = (int)normalizedProcessMemoryRequirements / this.shareQuantum;
        if (normalizedProcessMemoryRequirements % (long)this.shareQuantum > 0L) {
            ++shares;
        }
        return shares;
    }

    private String getCmdLine(ICommandLine iCommandLine) {
        String[] commandLine;
        StringBuffer sb = new StringBuffer();
        if (iCommandLine != null && (commandLine = iCommandLine.getCommandLine()) != null) {
            for (String item : commandLine) {
                sb.append(item);
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    @Override
    public void dispatchStateUpdateToAgents(Map<DuccId, IDuccWork> workMap, long sequence) {
        String methodName = "dispatchStateUpdateToAgents";
        try {
            if (logger.isDebug()) {
                this.dumpState(workMap);
            }
            ArrayList<DuccJobDeployment> jobDeploymentList = new ArrayList<DuccJobDeployment>();
            ArrayList<DuccUserReservation> reservationList = new ArrayList<DuccUserReservation>();
            for (Map.Entry<DuccId, IDuccWork> entry : workMap.entrySet()) {
                String userId;
                if (entry.getValue() instanceof DuccWorkJob) {
                    DuccWorkJob dcj = (DuccWorkJob)entry.getValue();
                    ArrayList jobProcessList = new ArrayList();
                    long normalizedProcessMemoryRequirements = this.normalizeMemory(dcj.getSchedulingInfo().getMemorySizeRequested(), dcj.getSchedulingInfo().getMemoryUnits());
                    int shares = this.getShares(normalizedProcessMemoryRequirements);
                    long processAdjustedMemorySize = shares * this.shareQuantum * 1024;
                    ProcessMemoryAssignment pma = new ProcessMemoryAssignment();
                    pma.setShares(shares);
                    pma.setNormalizedMemoryInMBs(processAdjustedMemorySize);
                    for (Map.Entry jpProcess : dcj.getProcessMap().getMap().entrySet()) {
                        jobProcessList.add(jpProcess.getValue());
                    }
                    processAdjustedMemorySize = (long)((double)processAdjustedMemorySize + (double)processAdjustedMemorySize * ((double)this.fudgeFactor / 100.0));
                    pma.setMaxMemoryWithFudge(processAdjustedMemorySize);
                    logger.debug(methodName, dcj.getDuccId(), new Object[]{"--------------- User Requested Memory For Process:" + dcj.getSchedulingInfo().getMemorySizeRequested() + dcj.getSchedulingInfo().getMemoryUnits() + " PM Calculated Memory Assignment of:" + processAdjustedMemorySize});
                    ICommandLine driverCmdLine = null;
                    ICommandLine processCmdLine = null;
                    IDuccProcess driverProcess = null;
                    IDuccWork dw = null;
                    switch (dcj.getDuccType()) {
                        case Job: {
                            logger.debug(methodName, dcj.getDuccId(), new Object[]{"case: Job"});
                            dw = dwHelper.fetch(dcj.getDuccId());
                            if (dw == null) {
                                logger.info(methodName, dcj.getDuccId(), new Object[]{"The OR did not provide commndline spec and other details required to launch processes for the Job. Received value of NULL from the OR"});
                                driverProcess = (IDuccProcess)((Map.Entry)dcj.getDriver().getProcessMap().entrySet().iterator().next()).getValue();
                                break;
                            }
                            IDuccWorkJob job = (IDuccWorkJob)dw;
                            DuccWorkPopDriver driver = job.getDriver();
                            if (driver != null) {
                                driverCmdLine = driver.getCommandLine();
                                driverProcess = (IDuccProcess)((Map.Entry)driver.getProcessMap().entrySet().iterator().next()).getValue();
                            }
                            processCmdLine = job.getCommandLine();
                            break;
                        }
                        case Service: {
                            logger.debug(methodName, dcj.getDuccId(), new Object[]{"case: Service"});
                            dw = dwHelper.fetch(dcj.getDuccId());
                            if (dw == null) {
                                logger.info(methodName, dcj.getDuccId(), new Object[]{"The OR did not provide commndline spec and other details required to launch Service processes. Received value of NULL from the OR."});
                                break;
                            }
                            IDuccWorkJob service = (IDuccWorkJob)dw;
                            processCmdLine = service.getCommandLine();
                            processCmdLine.addOption("-Dducc.deploy.components=service");
                            break;
                        }
                        default: {
                            logger.debug(methodName, dcj.getDuccId(), new Object[]{"case: default"});
                            dw = dwHelper.fetch(dcj.getDuccId());
                            if (dw == null) {
                                logger.info(methodName, dcj.getDuccId(), new Object[]{"The OR did not provide commndline spec and other details required to launch processes. Received value of NULL from the OR."});
                                break;
                            }
                            if (!(dw instanceof IDuccWorkExecutable)) break;
                            IDuccWorkExecutable dwe = (IDuccWorkExecutable)dw;
                            processCmdLine = dwe.getCommandLine();
                        }
                    }
                    String dText = "n/a";
                    if (driverCmdLine != null) {
                        dText = this.getCmdLine(driverCmdLine);
                    }
                    logger.trace(methodName, dcj.getDuccId(), new Object[]{"driver: " + dText});
                    String pText = "n/a";
                    if (processCmdLine != null) {
                        pText = this.getCmdLine(processCmdLine);
                    }
                    logger.trace(methodName, dcj.getDuccId(), new Object[]{"process: " + pText});
                    jobDeploymentList.add(new DuccJobDeployment(dcj.getDuccId(), driverCmdLine, processCmdLine, dcj.getStandardInfo(), driverProcess, pma, jobProcessList));
                    continue;
                }
                if (!(entry.getValue() instanceof DuccWorkReservation) || "System".equals(userId = ((DuccWorkReservation)entry.getValue()).getStandardInfo().getUser())) continue;
                IDuccReservationMap reservationMap = ((DuccWorkReservation)entry.getValue()).getReservationMap();
                reservationList.add(new DuccUserReservation(userId, (IDuccId)((DuccWorkReservation)entry.getValue()).getDuccId(), reservationMap));
                logger.debug(methodName, null, new Object[]{"---------------  Added reservation for user:" + userId});
            }
            logger.debug(methodName, null, new Object[]{"---- PM Dispatching DuccJobsStateEvent request to Agent(s) - State Map Size:" + jobDeploymentList.size() + " Reservation List:" + reservationList.size()});
            DuccJobsStateEvent ev = new DuccJobsStateEvent(DuccEvent.EventType.PM_STATE, jobDeploymentList, reservationList);
            ev.setSequence(sequence);
            this.eventDispatcher.dispatch((DuccEvent)ev);
            logger.debug(methodName, null, new Object[]{"+++++ PM Dispatched State To Agent(s)"});
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
    }

    private String formatProcess(IDuccProcess process) {
        return String.format(jobHeaderFormat, String.valueOf(process.getDuccId().getFriendly()), process.getProcessType().toString(), process.getPID() == null ? "" : process.getPID(), process.getProcessState().toString(), process.getResourceState().toString(), process.getNodeIdentity().getIp(), process.getNodeIdentity().getName(), process.getProcessDeallocationType().toString(), process.getProcessJmxUrl() == null ? "N/A" : process.getProcessJmxUrl());
    }

    private void dumpState(Map<DuccId, IDuccWork> workMap) {
        String methodName = "dumpState";
        try {
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<DuccId, IDuccWork> job : workMap.entrySet()) {
                IDuccWork duccWork = job.getValue();
                if (duccWork instanceof DuccWorkJob) {
                    DuccWorkJob duccWorkJob = (DuccWorkJob)duccWork;
                    sb.append("\n").append(tbl).append("\nJob ID: ").append(duccWorkJob.getDuccId().getFriendly()).append("\tJobState: ").append(duccWorkJob.getStateObject()).append("\tJobSubmittedBy: ").append(duccWorkJob.getStandardInfo().getUser()).append("\n\n").append(header).append(tbl).append("\n");
                    DuccWorkPopDriver driver = duccWorkJob.getDriver();
                    if (driver != null) {
                        IDuccProcess driverProcess = (IDuccProcess)((Map.Entry)driver.getProcessMap().entrySet().iterator().next()).getValue();
                        sb.append(this.formatProcess(driverProcess));
                    }
                    for (Map.Entry process : ((DuccWorkJob)job.getValue()).getProcessMap().entrySet()) {
                        sb.append("\n").append(this.formatProcess((IDuccProcess)process.getValue()));
                    }
                    sb.append("\n").append(tbl).append("\n");
                    logger.debug(methodName, null, new Object[]{sb.toString()});
                    continue;
                }
                if (job.getValue() instanceof DuccWorkReservation || job.getValue() instanceof DuccWorkPop) continue;
                logger.info(methodName, job.getKey(), new Object[]{"Not a WorkJob but " + job.getClass().getName()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLogLevel(String clz, String level) {
        logger.info("setLogLevel", null, new Object[]{"--------- Changing Log Level to:" + level + " For class:" + clz});
        super.setLogLevel(clz, level);
    }

    public void setLogLevel(String level) {
        logger.info("setLogLevel", null, new Object[]{"--------- Changing Log Level to:" + level + " For class:" + this.getClass().getCanonicalName()});
        super.setLogLevel(this.getClass().getCanonicalName(), level);
    }

    public String getLogLevel() {
        return super.getLogLevel();
    }

    public void logAtTraceLevel(String toLog, String methodName) {
        if (logger.isTrace()) {
            logger.trace(methodName, null, new Object[]{"--------- " + toLog});
        }
    }

    @Override
    public PmStateDuccEvent getState() {
        String methodName = "PmStateDuccEvent";
        logger.trace(methodName, null, new Object[]{""});
        return new PmStateDuccEvent();
    }

    static {
        tbl = String.format("%1$-158s", " ").replace(" ", "-");
        logger = new DuccLogger(ProcessManagerComponent.class, "ProcessManager");
        dwHelper = null;
    }
}

