/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sampleapps;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.ducc.sampleapps.DuccDocumentInfo;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public class DuccCasCM
extends JCasMultiplier_ImplBase {
    private String inputFileName;
    private String outputFileName;
    private FileInputStream fis;
    private ZipInputStream zis;
    private ZipEntry nextEntry;
    private Workitem wi;
    private int docInWI;
    private boolean readingXmiFormat;
    private TypeSystem inputTS;
    private Logger logger;

    public boolean hasNext() throws AnalysisEngineProcessException {
        try {
            this.nextEntry = this.zis.getNextEntry();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        return this.nextEntry != null;
    }

    public AbstractCas next() throws AnalysisEngineProcessException {
        DuccDocumentInfo di;
        JCas newcas = this.getEmptyJCas();
        if (0 == this.docInWI) {
            if (this.nextEntry.getName().equals("typesystem.xml")) {
                this.getTypesystem();
                this.readingXmiFormat = false;
            } else {
                this.readingXmiFormat = true;
            }
        } else if (this.nextEntry.getName().equals("typesystem.xml")) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("typesystem.xml entry found in the middle of input zipfile " + this.inputFileName));
        }
        byte[] buff = new byte[10000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesread;
            while (-1 != (bytesread = this.zis.read(buff))) {
                baos.write(buff, 0, bytesread);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            if (this.readingXmiFormat) {
                XmiCasDeserializer.deserialize((InputStream)bis, (CAS)newcas.getCas());
            } else {
                Serialization.deserializeCAS((CAS)newcas.getCas(), (InputStream)bis, (TypeSystem)this.inputTS, null);
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        FSIterator fsit = newcas.getIndexRepository().getAllIndexedFS(newcas.getCasType(DuccDocumentInfo.type));
        if (fsit.hasNext()) {
            di = (DuccDocumentInfo)((Object)fsit.next());
        } else {
            di = new DuccDocumentInfo(newcas);
            di.addToIndexes();
        }
        di.setInputfile(this.inputFileName);
        di.setOutputfile(this.outputFileName);
        di.setDocseq(this.docInWI++);
        return newcas;
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        FSIterator fsit = jcas.getIndexRepository().getAllIndexedFS(jcas.getCasType(Workitem.type));
        if (!fsit.hasNext()) {
            throw new AnalysisEngineProcessException((Throwable)new RuntimeException("No workitem FS in CAS"));
        }
        this.wi = (Workitem)fsit.next();
        this.logger.log(Level.INFO, "DuccCasCM: inputs " + this.wi.getInputspec() + " outputs " + this.wi.getOutputspec());
        try {
            this.openInputFile(this.wi);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.logger = aContext.getLogger();
    }

    private void openInputFile(Workitem wi) throws IOException {
        this.inputFileName = wi.getInputspec();
        this.outputFileName = wi.getOutputspec();
        this.fis = new FileInputStream(new File(this.inputFileName));
        this.zis = new ZipInputStream(new BufferedInputStream(this.fis, 102400));
        this.docInWI = 0;
    }

    private void getTypesystem() throws AnalysisEngineProcessException {
        byte[] buff = new byte[10000];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesread;
            while (-1 != (bytesread = this.zis.read(buff))) {
                baos.write(buff, 0, bytesread);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            XMLParser xmlParser = UIMAFramework.getXMLParser();
            TypeSystemDescription tsDesc = xmlParser.parseTypeSystemDescription(new XMLInputSource((InputStream)bis, null));
            this.inputTS = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, null).getTypeSystem();
            this.nextEntry = this.zis.getNextEntry();
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

