/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.test.randomsleep;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FixedSleepCR
extends CollectionReader_ImplBase {
    private volatile Logger logger;
    private volatile ArrayList<Long> workitems;
    private volatile int index = 0;
    private volatile String error_rate = "0";
    private volatile String logdir = "None";
    private volatile String jobid;
    PrintStream jdmark;
    static int get_next_counter = 0;

    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.logger = this.getLogger();
        this.logger.log(Level.INFO, "initialize");
        this.jobid = System.getenv("JobId");
        this.logdir = this.jobid + ".output";
        this.logger.log(Level.INFO, " ****** BB Working directory: " + System.getProperty("user.dir"));
        this.logger.log(Level.INFO, " ****** BB jobid: " + this.logdir);
        String jobfile = (String)this.getConfigParameterValue("jobfile");
        this.logger.log(Level.INFO, " ****** BB jobfile: " + jobfile);
        String comp = (String)this.getConfigParameterValue("compression");
        this.logger.log(Level.INFO, " ****** BB compression " + comp);
        this.error_rate = (String)this.getConfigParameterValue("error_rate");
        this.logger.log(Level.INFO, " ****** BB error_rate " + this.error_rate);
        Map<String, String> env = System.getenv();
        for (String k : env.keySet()) {
            System.out.println(String.format("Environment[%s] = %s", k, env.get(k)));
        }
        File workingdir = new File(System.getProperty("user.dir"));
        File[] files = workingdir.listFiles();
        System.out.println("Working directory is " + workingdir.toString());
        for (File f : files) {
            System.out.println("File: " + f.toString());
        }
        long compression = Long.parseLong(comp);
        this.workitems = new ArrayList();
        String times = "5000";
        try {
            FileReader fr = new FileReader(jobfile);
            Properties props = new Properties();
            props.load(fr);
            times = props.getProperty("elapsed");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringTokenizer st = new StringTokenizer(times);
        int ndx = 0;
        while (st.hasMoreTokens()) {
            long elapsed = Long.parseLong(st.nextToken());
            long compressed = 0L;
            if (compression > 0L) {
                compressed = elapsed / compression;
            }
            this.workitems.add(compressed);
            this.logger.log(Level.INFO, " ****** Adding work item of duration " + elapsed + " ms compressed to " + compressed + " ms as work item " + ndx++);
        }
        File f = new File(this.logdir);
        if (f.mkdirs()) {
            String jdmarker = this.logdir + "/jd.marker";
            try {
                this.jdmark = new PrintStream(jdmarker);
                this.jdmark.println("" + System.currentTimeMillis() + " " + this.jobid + " " + jobfile + " " + this.workitems.size() + " work items.");
                this.logger.log(Level.INFO, "Created jdmarker file: " + jdmarker);
            }
            catch (FileNotFoundException e) {
                this.logger.log(Level.INFO, " !!!!!! Can't open file: " + jdmarker + ". user.dir = ", (Object)System.getProperty("user.dir"));
            }
        } else {
            this.logger.log(Level.INFO, " !!!!!! Can't create log directory " + f.toString());
            this.logdir = "None";
        }
    }

    public synchronized void getNext(CAS cas) throws IOException, CollectionException {
        this.logger.log(Level.INFO, " ****** getNext[" + this.index + "]: " + this.workitems.get(this.index) + " getNext invocation " + get_next_counter++);
        String parm = "" + this.workitems.get(this.index) + " " + (this.index + 1) + " " + this.workitems.size() + " " + this.error_rate + " " + this.logdir;
        if (this.jdmark != null) {
            this.jdmark.println("" + System.currentTimeMillis() + " " + parm);
        }
        this.logger.log(Level.INFO, "getNext");
        cas.reset();
        cas.setSofaDataString(parm, "text");
        ++this.index;
    }

    public void destroy() {
        this.logger.log(Level.INFO, "destroy");
        if (this.jdmark != null) {
            this.jdmark.println("" + System.currentTimeMillis() + " " + this.jobid + " JD is destroyed");
            this.jdmark.close();
        }
    }

    public void close() throws IOException {
        this.logger.log(Level.INFO, "close");
        if (this.jdmark != null) {
            this.jdmark.println("" + System.currentTimeMillis() + " " + this.jobid + " JD is closed");
            this.jdmark.close();
        }
    }

    public Progress[] getProgress() {
        this.logger.log(Level.INFO, "getProgress");
        ProgressImpl[] retVal = new ProgressImpl[]{new ProgressImpl(this.index, this.workitems.size(), "WorkItems")};
        return retVal;
    }

    public boolean hasNext() throws IOException, CollectionException {
        boolean answer;
        this.logger.log(Level.INFO, "hasNext");
        boolean bl = answer = this.index < this.workitems.size();
        if (!answer) {
            if (this.jdmark == null) {
                this.logger.log(Level.INFO, "ALERT jdmarker is null and should not be. Bypassing final closing message.");
            } else {
                this.jdmark.println("" + System.currentTimeMillis() + " " + this.jobid + " No more work, hasNext returns " + answer);
                this.jdmark.close();
                this.jdmark = null;
                this.logger.log(Level.INFO, "getNext() returns false, JDMARKER is closed.");
            }
        }
        return answer;
    }
}

