/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sampleapps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class DuccJobCasCR
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTSPEC = "InputSpec";
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final String PARAM_IGNOREPREVIOUS = "IgnorePreviousOutput";
    public static final String PARAM_SENDTOLAST = "SendToLast";
    public static final String PARAM_SENDTOALL = "SendToAll";
    private ArrayList<WorkItem> mWorkList;
    private String mInputdirectory;
    private String mOutputdirectory;
    private Boolean mIgnorePrevious;
    private int mCurrentIndex;
    private Boolean mSendToLast;
    private Boolean mSendToAll;
    private int mPreviouslyDone;
    private Logger logger;

    public void initialize() throws ResourceInitializationException {
        this.logger = this.getUimaContext().getLogger();
        String inputSpec = ((String)this.getConfigParameterValue(PARAM_INPUTSPEC)).trim();
        this.mOutputdirectory = ((String)this.getConfigParameterValue(PARAM_OUTPUTDIR)).trim();
        this.mIgnorePrevious = (Boolean)this.getConfigParameterValue(PARAM_IGNOREPREVIOUS);
        this.mSendToLast = (Boolean)this.getConfigParameterValue(PARAM_SENDTOLAST);
        this.mSendToAll = (Boolean)this.getConfigParameterValue(PARAM_SENDTOALL);
        if (null == this.mIgnorePrevious) {
            this.mIgnorePrevious = Boolean.FALSE;
        }
        if (null == this.mSendToLast) {
            this.mSendToLast = Boolean.FALSE;
        }
        if (null == this.mSendToAll) {
            this.mSendToAll = Boolean.FALSE;
        }
        this.mCurrentIndex = 0;
        this.mPreviouslyDone = 0;
        this.mInputdirectory = inputSpec;
        File inDirectory = new File(this.mInputdirectory);
        if (!inDirectory.exists() || !inDirectory.isDirectory()) {
            throw new ResourceInitializationException((Throwable)new RuntimeException(this.mInputdirectory + " is not a directory"));
        }
        File outDirectory = new File(this.mOutputdirectory);
        if (outDirectory.exists() && !outDirectory.isDirectory()) {
            throw new ResourceInitializationException((Throwable)new RuntimeException("Specified output directory " + this.mOutputdirectory + " is a file"));
        }
        this.logger.log(Level.INFO, "Processing \".zip files in" + this.mInputdirectory);
        if (null != this.mIgnorePrevious && this.mIgnorePrevious.booleanValue()) {
            this.logger.log(Level.INFO, "Overwriting previous outfiles");
        }
        this.mWorkList = new ArrayList();
        this.addFilesFromDir(inDirectory, "zip");
        if (0 < this.mPreviouslyDone) {
            this.logger.log(Level.INFO, "Preserving " + this.mPreviouslyDone + " output files in " + this.mOutputdirectory);
        }
        this.logger.log(Level.INFO, "Processing " + this.mWorkList.size() + " output files in " + this.mOutputdirectory);
    }

    private void addFilesFromDir(File dir, String ext) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String outfilename;
            if (files[i].isDirectory() || !(outfilename = files[i].getAbsolutePath()).endsWith("." + ext)) continue;
            outfilename = outfilename.substring(this.mInputdirectory.length());
            outfilename = this.mOutputdirectory + outfilename;
            File outFile = new File(outfilename);
            if (!this.mIgnorePrevious.booleanValue() && outFile.exists()) {
                ++this.mPreviouslyDone;
            }
            if (!this.mIgnorePrevious.booleanValue() && outFile.exists()) continue;
            this.mWorkList.add(new WorkItem(files[i].getAbsolutePath(), outfilename));
            this.logger.log(Level.FINE, "adding " + outfilename);
        }
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mWorkList.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        try {
            JCas jcas = aCAS.getJCas();
            Workitem wi = new Workitem(jcas);
            wi.setInputspec(this.mWorkList.get((int)this.mCurrentIndex).filename);
            wi.setOutputspec(this.mWorkList.get((int)this.mCurrentIndex).outname);
            wi.setSendToLast(this.mSendToLast.booleanValue());
            wi.setSendToAll(this.mSendToAll.booleanValue());
            wi.addToIndexes();
            this.logger.log(Level.INFO, "Sending " + wi.getInputspec());
            ++this.mCurrentIndex;
            jcas.setDocumentText(wi.getInputspec());
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mWorkList.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mWorkList.size();
    }

    class WorkItem {
        String filename;
        String outname;

        public WorkItem(String absolutePathIn, String absolutePathOut) {
            this.filename = absolutePathIn;
            this.outname = absolutePathOut;
        }
    }
}

