/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.sampleapps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.ducc.Workitem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class DuccJobTextCR
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final String PARAM_IGNOREPREVIOUS = "IgnorePreviousOutput";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_BLOCKSIZE = "BlockSize";
    public static final String PARAM_SENDTOLAST = "SendToLast";
    public static final String PARAM_SENDTOALL = "SendToAll";
    private ArrayList<WorkItem> mWorkList;
    private String mInputdirectory;
    private String mOutputdirectory;
    private Boolean mIgnorePrevious;
    private String mEncoding;
    private String mLanguage;
    private int mBlocksize;
    private int mCurrentIndex;
    private Boolean mSendToLast;
    private Boolean mSendToAll;
    private int mPreviouslyDone;
    private Logger logger;

    public void initialize() throws ResourceInitializationException {
        this.logger = this.getUimaContext().getLogger();
        this.mInputdirectory = ((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim();
        this.mOutputdirectory = ((String)this.getConfigParameterValue(PARAM_OUTPUTDIR)).trim();
        this.mIgnorePrevious = (Boolean)this.getConfigParameterValue(PARAM_IGNOREPREVIOUS);
        this.mEncoding = (String)this.getConfigParameterValue(PARAM_ENCODING);
        this.mLanguage = (String)this.getConfigParameterValue(PARAM_LANGUAGE);
        this.mSendToLast = (Boolean)this.getConfigParameterValue(PARAM_SENDTOLAST);
        this.mSendToAll = (Boolean)this.getConfigParameterValue(PARAM_SENDTOALL);
        if (null == this.mIgnorePrevious) {
            this.mIgnorePrevious = Boolean.FALSE;
        }
        if (null == this.mSendToLast) {
            this.mSendToLast = Boolean.FALSE;
        }
        if (null == this.mSendToAll) {
            this.mSendToAll = Boolean.FALSE;
        }
        this.mCurrentIndex = 0;
        this.mPreviouslyDone = 0;
        File inDirectory = new File(this.mInputdirectory);
        if (!inDirectory.exists() || !inDirectory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), inDirectory.getPath()});
        }
        File outDirectory = new File(this.mOutputdirectory);
        if (outDirectory.exists() && !outDirectory.isDirectory()) {
            throw new ResourceInitializationException((Throwable)new RuntimeException("Specified output directory " + this.mOutputdirectory + " is a file"));
        }
        this.mBlocksize = 0;
        this.logger.log(Level.INFO, "Processing input files from " + this.mInputdirectory);
        if (null != this.getConfigParameterValue(PARAM_BLOCKSIZE)) {
            this.mBlocksize = (Integer)this.getConfigParameterValue(PARAM_BLOCKSIZE);
            this.logger.log(Level.INFO, "Using blocksize " + this.mBlocksize);
        }
        if (null != this.mIgnorePrevious && this.mIgnorePrevious.booleanValue()) {
            this.logger.log(Level.INFO, "Overwriting previous outfiles");
        }
        this.mWorkList = new ArrayList();
        this.addFilesFromDir(inDirectory);
        if (0 < this.mPreviouslyDone) {
            this.logger.log(Level.INFO, "Preserving " + this.mPreviouslyDone + " output files in " + this.mOutputdirectory);
        }
        this.logger.log(Level.INFO, "Processing " + this.mWorkList.size() + " output files in " + this.mOutputdirectory);
    }

    private void addFilesFromDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) continue;
            String outfilename = files[i].getAbsolutePath();
            outfilename = outfilename.substring(this.mInputdirectory.length());
            outfilename = this.mOutputdirectory + outfilename;
            if (this.mBlocksize == 0) {
                File outFile = new File(outfilename + "_processed.zip");
                if (!this.mIgnorePrevious.booleanValue() && outFile.exists()) {
                    ++this.mPreviouslyDone;
                }
                if (!this.mIgnorePrevious.booleanValue() && outFile.exists()) continue;
                this.mWorkList.add(new WorkItem(files[i].getAbsolutePath(), outfilename + "_processed.zip", 0, files[i].length(), 0L, true));
                this.logger.log(Level.FINE, "adding " + outfilename);
                continue;
            }
            long fsize = files[i].length();
            long offset = 0L;
            int j = 0;
            while (fsize > 0L) {
                String outfilechunk = outfilename + "_" + j;
                long length = fsize < (long)this.mBlocksize ? fsize : (long)this.mBlocksize;
                File outFile = new File(outfilechunk + "_processed.zip");
                if (!this.mIgnorePrevious.booleanValue() && outFile.exists()) {
                    ++this.mPreviouslyDone;
                }
                if (this.mIgnorePrevious.booleanValue() || !outFile.exists()) {
                    this.mWorkList.add(new WorkItem(files[i].getAbsolutePath(), outfilechunk + "_processed.zip", j, length, offset, fsize == length));
                    this.logger.log(Level.FINE, "adding " + outfilechunk);
                }
                ++j;
                fsize -= length;
                offset += length;
            }
        }
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mWorkList.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        try {
            JCas jcas = aCAS.getJCas();
            Workitem wi = new Workitem(jcas);
            wi.setInputspec(this.mWorkList.get((int)this.mCurrentIndex).filename);
            wi.setOutputspec(this.mWorkList.get((int)this.mCurrentIndex).outname);
            wi.setBlockindex(this.mWorkList.get((int)this.mCurrentIndex).index);
            wi.setBlocksize(this.mBlocksize);
            wi.setBytelength(this.mWorkList.get((int)this.mCurrentIndex).length);
            if (null != this.mEncoding) {
                wi.setEncoding(this.mEncoding);
            }
            if (null != this.mLanguage) {
                wi.setLanguage(this.mLanguage);
            }
            wi.setSendToLast(this.mSendToLast.booleanValue());
            wi.setSendToAll(this.mSendToAll.booleanValue());
            wi.addToIndexes();
            wi.setLastBlock(this.mWorkList.get((int)this.mCurrentIndex).last);
            this.logger.log(Level.INFO, "Sending " + wi.getInputspec() + " index=" + wi.getBlockindex() + " last=" + wi.getLastBlock() + " length=" + wi.getBytelength());
            ++this.mCurrentIndex;
            jcas.setDocumentText(wi.getInputspec() + " index=" + wi.getBlockindex() + " length=" + wi.getBytelength());
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mWorkList.size(), "entities")};
    }

    public int getNumberOfDocuments() {
        return this.mWorkList.size();
    }

    class WorkItem {
        String filename;
        String outname;
        int index;
        int offset;
        int length;
        boolean last;

        public WorkItem(String absolutePathIn, String absolutePathOut, int i, long len, long off, boolean end) {
            this.filename = absolutePathIn;
            this.outname = absolutePathOut;
            this.index = i;
            this.length = (int)len;
            this.offset = (int)off;
            this.last = end;
        }
    }
}

