/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.db.DbHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;
import org.apache.uima.ducc.database.IDbOrchestratorProperties;

public class DbOrchestratorProperties
implements IDbOrchestratorProperties {
    private static String ORCHESTRATOR_PROPERTIES_TABLE = IDbOrchestratorProperties.DbOrchestratorProperties.TABLE_NAME.pname();
    private static String COL_NAME = IDbOrchestratorProperties.DbOrchestratorProperties.name.columnName();
    private static String COL_VALUE = IDbOrchestratorProperties.DbOrchestratorProperties.value.columnName();
    private DuccLogger logger = null;
    private DbManager dbManager = null;
    private DuccId jobid = null;

    public DbOrchestratorProperties(DuccLogger duccLogger) throws Exception {
        this.init(duccLogger);
    }

    private boolean init(String[] dburls) throws Exception {
        String methodName = "init";
        boolean ret = false;
        while (true) {
            try {
                this.dbManager = new DbManager(dburls, this.logger);
                this.dbManager.init();
                ret = true;
            }
            catch (NoHostAvailableException e) {
                this.logger.error(methodName, null, new Object[]{"Cannot contact database.  Retrying in 5 seconds."});
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error(methodName, null, new Object[]{"Errors contacting database.  No connetion made."});
                this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                ret = false;
            }
            break;
        }
        return ret;
    }

    protected static List<SimpleStatement> mkSchema() throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + ORCHESTRATOR_PROPERTIES_TABLE + " (");
        buf.append(DbUtil.mkSchema(IDbOrchestratorProperties.DbOrchestratorProperties.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        List<String> indexes = DbUtil.mkIndices(IDbOrchestratorProperties.DbOrchestratorProperties.values(), ORCHESTRATOR_PROPERTIES_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    @Override
    public void dbInit() throws Exception {
        String location = "dbInit";
        try {
            List<SimpleStatement> specificationsSchema = DbOrchestratorProperties.mkSchema();
            DbHandle h = this.dbManager.open();
            for (SimpleStatement s : specificationsSchema) {
                this.logger.info(location, this.jobid, new Object[]{"EXECUTE STATEMENT:" + s.toString()});
                h.execute(s);
            }
            this.initPublicationSeqNo();
            this.initDuccWorkSeqNo();
        }
        catch (Exception e) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void init(DuccLogger duccLogger) throws Exception {
        this.logger = duccLogger;
        String[] dbUrls = DbHelper.getHostList();
        this.init(dbUrls);
    }

    @Override
    public void upsert(String name, String value) throws Exception {
        String location = "upsert";
        try {
            String table = ORCHESTRATOR_PROPERTIES_TABLE;
            String c0 = COL_VALUE + "='" + value + "'";
            String c1 = COL_NAME + "='" + name + "'";
            String cql = "UPDATE " + table + " SET " + c0 + " WHERE " + c1;
            this.logger.debug(location, this.jobid, new Object[]{cql});
            DbHandle h = this.dbManager.open();
            h.execute(cql);
        }
        catch (Exception e) {
            DuccId duccid = null;
            String text = "name=" + name + " value=" + value;
            this.logger.error(location, duccid, new Object[]{text, e});
            throw e;
        }
    }

    private void insert(String name, String value) throws Exception {
        String location = "insert";
        try {
            String table = ORCHESTRATOR_PROPERTIES_TABLE;
            String c0 = COL_VALUE + "='" + value + "'";
            String c1 = COL_NAME + "='" + name + "'";
            String cql = "UPDATE " + table + " SET " + c0 + " WHERE " + c1;
            this.logger.debug(location, this.jobid, new Object[]{cql});
            DbHandle h = this.dbManager.open();
            h.execute(cql);
        }
        catch (Exception e) {
            DuccId duccid = null;
            String text = "name=" + name + " value=" + value;
            this.logger.error(location, duccid, new Object[]{text, e});
            throw e;
        }
    }

    @Override
    public String fetch(String name) throws Exception {
        String location = "fetch";
        String value = null;
        try {
            String table = ORCHESTRATOR_PROPERTIES_TABLE;
            String c1 = COL_NAME + "='" + name + "'";
            String cql = "SELECT * FROM " + table + " WHERE " + c1;
            this.logger.debug(location, this.jobid, new Object[]{cql});
            DbHandle h = this.dbManager.open();
            ResultSet rs = h.execute(cql);
            for (Row r : rs) {
                String colValue;
                value = colValue = r.getString(COL_VALUE);
            }
        }
        catch (Exception e) {
            DuccId duccid = null;
            String text = "name=" + name;
            this.logger.error(location, duccid, new Object[]{text, e});
            throw e;
        }
        return value;
    }

    private void initPublicationSeqNo() {
        String location = "initPublicationSeqNo";
        try {
            String value = this.fetch(keys.publication_seqno.name());
            Long.parseLong(value);
        }
        catch (Exception e) {
            try {
                long value = 0L;
                this.insert(keys.publication_seqno.name(), "" + value);
            }
            catch (Exception x) {
                this.logger.error(location, this.jobid, (Throwable)x, new Object[0]);
            }
        }
    }

    @Override
    public void setPublicationSeqNoIfLarger(long value) {
        long curr = value;
        long prev = this.getPublicationSeqNo();
        if (curr > prev) {
            this.setPublicationSeqNo(curr);
        }
    }

    @Override
    public void setPublicationSeqNo(long value) {
        String location = "setPublicationSeqNo";
        try {
            this.upsert(keys.publication_seqno.name(), "" + value);
        }
        catch (Exception e) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public long getPublicationSeqNo() {
        String location = "getPublicationSeqNo";
        long retVal = 0L;
        try {
            String value = this.fetch(keys.publication_seqno.name());
            retVal = Long.parseLong(value);
        }
        catch (Exception e) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    @Override
    public void setDuccWorkSeqNoIfLarger(long value) {
        String location = "setDuccWorkSeqNoIfLarger";
        long curr = value;
        long prev = this.getDuccWorkSeqNo();
        if (curr > prev) {
            this.setDuccWorkSeqNo(curr);
            this.logger.debug(location, this.jobid, new Object[]{curr});
        }
    }

    private void initDuccWorkSeqNo() {
        String location = "initDuccWorkSeqNo";
        long lval = 0L;
        try {
            String value = this.fetch(keys.duccwork_seqno.name());
            lval = Long.parseLong(value);
        }
        catch (Exception e) {
            try {
                long value = 0L;
                this.insert(keys.duccwork_seqno.name(), "" + value);
            }
            catch (Exception x) {
                this.logger.error(location, this.jobid, (Throwable)x, new Object[0]);
            }
        }
        this.logger.debug(location, this.jobid, new Object[]{lval});
    }

    @Override
    public void setDuccWorkSeqNo(long value) {
        String location = "setDuccWorkSeqNo";
        try {
            this.upsert(keys.duccwork_seqno.name(), "" + value);
        }
        catch (Exception e) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
        }
        this.logger.debug(location, this.jobid, new Object[]{value});
    }

    @Override
    public long getDuccWorkSeqNo() {
        String location = "getDuccWorkSeqNo";
        long retVal = 0L;
        try {
            String value = this.fetch(keys.duccwork_seqno.name());
            retVal = Long.parseLong(value);
        }
        catch (Exception e) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
        }
        this.logger.debug(location, this.jobid, new Object[]{retVal});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextPublicationSeqNo() {
        Class<IDbOrchestratorProperties.DbOrchestratorProperties> clazz = IDbOrchestratorProperties.DbOrchestratorProperties.class;
        synchronized (IDbOrchestratorProperties.DbOrchestratorProperties.class) {
            long retVal = this.getPublicationSeqNo() + 1L;
            this.setPublicationSeqNo(retVal);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextDuccWorkSeqNo() {
        String location = "getNextDuccWorkSeqNo";
        Class<IDbOrchestratorProperties.DbOrchestratorProperties> clazz = IDbOrchestratorProperties.DbOrchestratorProperties.class;
        synchronized (IDbOrchestratorProperties.DbOrchestratorProperties.class) {
            long retVal = this.getDuccWorkSeqNo() + 1L;
            this.setDuccWorkSeqNo(retVal);
            this.logger.debug(location, this.jobid, new Object[]{retVal});
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return retVal;
        }
    }

    public static enum keys {
        publication_seqno,
        duccwork_seqno;

    }
}

