/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.db.DbHelper;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.HistoryManagerDb;
import org.apache.uima.ducc.database.StateServicesDb;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;

public class DbLoader {
    DuccLogger logger = DuccLogger.getLogger(DbLoader.class, (String)"DBLOAD");
    String DUCC_HOME;
    String SVC_HISTORY_KEY = IStateServices.SvcRegProps.is_archived.columnName();
    String META_HISTORY_KEY = IStateServices.SvcMetaProps.is_archived.columnName();
    DbManager dbManager = null;
    boolean archive = true;
    HistoryManagerDb hmd = null;
    StateServicesDb ssd = null;
    String state_url = null;
    String jobHistory = "/history/jobs";
    String reservationHistory = "/history/reservations";
    String serviceHistory = "/history/services";
    String serviceRegistryHistory = "/history/services-registry";
    String serviceRegistry = "/state/services";
    String checkpointFile = "/state/orchestrator.ckpt";
    int nthreads = 10;
    AtomicInteger counter = new AtomicInteger(0);
    int joblimit = Integer.MAX_VALUE;
    int reservationlimit = Integer.MAX_VALUE;
    int servicelimit = Integer.MAX_VALUE;
    int registrylimit = Integer.MAX_VALUE;
    boolean dojobs = true;
    boolean doreservations = true;
    boolean doservices = true;
    boolean doregistry = true;
    boolean docheckpoint = true;
    boolean saveDetails = System.getenv("SAVE_DB_DETAILS") != null;
    long jobBytes = 0L;
    long resBytes = 0L;
    long svcBytes = 0L;
    long svcRegBytes = 0L;
    AtomicInteger skippedServices = new AtomicInteger(0);
    static PreparedStatement jobPrepare = null;
    PreparedStatement servicePrepare = null;
    static PreparedStatement reservationPrepare = null;

    public DbLoader(String from, String state_url, int nthreads) throws Exception {
        File f;
        this.state_url = state_url;
        this.DUCC_HOME = System.getProperty("DUCC_HOME");
        if (this.DUCC_HOME == null) {
            System.out.println("System property -DDUCC_HOME must be set.");
            System.exit(1);
        }
        if (System.getProperty("DONT_ARCHIVE") != null) {
            this.archive = false;
        }
        if (!(f = new File(from)).isDirectory()) {
            System.out.println("'from' must be a directory");
            System.exit(1);
        }
        this.jobHistory = from + this.jobHistory;
        this.reservationHistory = from + this.reservationHistory;
        this.serviceHistory = from + this.serviceHistory;
        this.serviceRegistryHistory = from + this.serviceRegistryHistory;
        this.serviceRegistry = from + this.serviceRegistry;
        this.checkpointFile = from + this.checkpointFile;
        this.nthreads = nthreads;
    }

    void closeStream(InputStream in) {
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadJobs() throws Exception {
        int i;
        String methodName = "loadJobs";
        this.logger.info(methodName, null, new Object[]{" -------------------- Load jobs ----------------"});
        System.out.println(" -------------------- Load jobs ----------------");
        File dir = new File(this.jobHistory);
        if (!dir.isDirectory()) {
            this.logger.info(methodName, null, new Object[]{"Cannot find job history; skipping load of jobs."});
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            this.logger.info(methodName, null, new Object[]{"No jobs to move to database."});
            return;
        }
        this.logger.info(methodName, null, new Object[]{"Reading", files.length, "jobs."});
        LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
        int max_to_load = this.joblimit;
        int nth = Math.min(this.nthreads, max_to_load);
        nth = Math.min(nth, files.length);
        JobLoader[] loader = new JobLoader[nth];
        Thread[] threads = new Thread[nth];
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i2 = 0; i2 < nth; ++i2) {
            loader[i2] = new JobLoader(queue, ids);
            threads[i2] = new Thread(loader[i2]);
            threads[i2].start();
        }
        int c = 0;
        for (File f : files) {
            String s = f.toString();
            if (s.endsWith(".dwj")) {
                this.logger.trace(methodName, null, new Object[]{"Loading file", c++, ":", f});
                queue.offer(f);
                this.counter.getAndIncrement();
                if (c < max_to_load) continue;
                break;
            }
            this.logger.info(methodName, null, new Object[]{"Can't find history file", f});
        }
        this.logger.info(methodName, null, new Object[]{"Waiting for the", nth, "threads to load the DB."});
        while ((c = this.counter.get()) != 0) {
            try {
                this.logger.trace(methodName, null, new Object[]{"Waiting for loads to finish, counter is", c, "(job)."});
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Interrupt thread (job)", i});
            threads[i].interrupt();
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Joining thread (job)", i});
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.archive) {
            File renameTo = new File(dir + ".archive");
            dir.renameTo(renameTo);
        }
    }

    public void loadReservations() throws Exception {
        int i;
        String methodName = "loadReservations";
        this.logger.info(methodName, null, new Object[]{" -------------------- Load reservations ----------------"});
        System.out.println(" -------------------- Load reservations ----------------");
        File dir = new File(this.reservationHistory);
        if (!dir.isDirectory()) {
            this.logger.info(methodName, null, new Object[]{"No reservation directory found; skipping database load of reservations."});
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            this.logger.info(methodName, null, new Object[]{"No reservation history files to convert."});
            return;
        }
        this.logger.info(methodName, null, new Object[]{"Reading", files.length, "reservation instances."});
        LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
        int max_to_load = this.reservationlimit;
        int nth = Math.min(this.nthreads, max_to_load);
        nth = Math.min(nth, files.length);
        ReservationLoader[] loader = new ReservationLoader[nth];
        Thread[] threads = new Thread[nth];
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i2 = 0; i2 < nth; ++i2) {
            loader[i2] = new ReservationLoader(queue, ids);
            threads[i2] = new Thread(loader[i2]);
            threads[i2].start();
        }
        int c = 0;
        for (File f : files) {
            String s = f.toString();
            if (s.endsWith(".dwr")) {
                this.logger.trace(methodName, null, new Object[]{"Loading file", c++, ":", f});
                queue.offer(f);
                this.counter.getAndIncrement();
                if (c < max_to_load) continue;
                break;
            }
            this.logger.info(methodName, null, new Object[]{"Can't find history file", f});
        }
        this.logger.info(methodName, null, new Object[]{"Waiting for the", nth, "threads to load the DB."});
        while ((c = this.counter.get()) != 0) {
            try {
                this.logger.trace(methodName, null, new Object[]{"Waiting for reservation loads to finish, counter is", c});
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Interrupt thread (reservations).", i});
            threads[i].interrupt();
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Joining thread (reservations).", i});
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.archive) {
            File renameTo = new File(dir + ".archive");
            dir.renameTo(renameTo);
        }
    }

    public void loadServices() throws Exception {
        int i;
        String methodName = "loadServices";
        this.logger.info(methodName, null, new Object[]{" -------------------- Load services ----------------"});
        System.out.println(" -------------------- Load AP/Service Instances ----------------");
        File dir = new File(this.serviceHistory);
        if (!dir.isDirectory()) {
            this.logger.info(methodName, null, new Object[]{"No service history directory found; skipping load of service history."});
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            this.logger.info(methodName, null, new Object[]{"No service history files to convert."});
            return;
        }
        this.logger.info(methodName, null, new Object[]{"Reading", files.length, "service instances."});
        LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
        int max_to_load = this.servicelimit;
        int nth = Math.min(this.nthreads, max_to_load);
        nth = Math.min(nth, files.length);
        ServiceLoader[] loader = new ServiceLoader[nth];
        Thread[] threads = new Thread[nth];
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i2 = 0; i2 < nth; ++i2) {
            loader[i2] = new ServiceLoader(queue, ids);
            threads[i2] = new Thread(loader[i2]);
            threads[i2].start();
        }
        int c = 0;
        for (File f : files) {
            String s = f.toString();
            if (s.endsWith(".dws")) {
                this.logger.trace(methodName, null, new Object[]{"Loading file", c++, ":", f});
                queue.offer(f);
                this.counter.getAndIncrement();
                if (c < max_to_load) continue;
                break;
            }
            this.logger.info(methodName, null, new Object[]{"Can't find history file", f});
        }
        this.logger.info(methodName, null, new Object[]{"Waiting for the", nth, "threads to load the DB."});
        while ((c = this.counter.get()) != 0) {
            try {
                this.logger.trace(methodName, null, new Object[]{"Waiting for loads to finish, counter is", c, "(service instances"});
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Interrupt thread (services).", i});
            threads[i].interrupt();
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Joining thread (services).", i});
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.archive) {
            File renameTo = new File(dir + ".archive");
            dir.renameTo(renameTo);
        }
    }

    public void loadServiceRegistry(String registry, boolean isHistory) {
        int i;
        String methodName = "loadServiceRegistry";
        this.logger.info(methodName, null, new Object[]{" -------------------- Load registry; isHistory", isHistory, " ----------------"});
        System.out.println(" -------------------- Load Service Registry " + (isHistory ? "(history)" : "(active registrations)") + "  ----------------");
        int c = 0;
        File dir = new File(registry);
        if (!dir.isDirectory()) {
            this.logger.error(methodName, null, new Object[]{registry, "is not a directory and cannot be loaded."});
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            if (isHistory) {
                this.logger.info(methodName, null, new Object[]{"Nothing in service registry history to move to database"});
            } else {
                this.logger.info(methodName, null, new Object[]{"Nothing in service registry to move to database"});
            }
            return;
        }
        LinkedBlockingQueue<Pair<String, Boolean>> queue = new LinkedBlockingQueue<Pair<String, Boolean>>();
        int max_to_load = this.registrylimit;
        int nth = Math.min(this.nthreads, max_to_load);
        nth = Math.min(nth, files.length);
        ServiceRegistrationLoader[] loader = new ServiceRegistrationLoader[nth];
        Thread[] threads = new Thread[nth];
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i2 = 0; i2 < nth; ++i2) {
            loader[i2] = new ServiceRegistrationLoader(queue, ids);
            threads[i2] = new Thread(loader[i2]);
            threads[i2].start();
        }
        this.logger.info(methodName, null, new Object[]{"Reading", files.length, "service files (2 per instance)."});
        for (File f : files) {
            String s = f.toString();
            if (!s.endsWith(".svc")) continue;
            int ndx = s.indexOf(".svc");
            String numeric = s.substring(0, ndx);
            queue.offer((Pair<String, Boolean>)new Pair((Object)numeric, (Object)isHistory));
            this.counter.getAndIncrement();
            if (++c >= max_to_load) break;
        }
        this.logger.info(methodName, null, new Object[]{"Waiting for the", nth, "threads to load the DB."});
        while ((c = this.counter.get()) != 0) {
            try {
                this.logger.trace(methodName, null, new Object[]{"Waiting for service registry loads to finish, counter is", c});
                Thread.sleep(1000L);
            }
            catch (Exception i2) {}
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Interrupt thread (service registry).", i});
            threads[i].interrupt();
        }
        for (i = 0; i < nth; ++i) {
            this.logger.trace(methodName, null, new Object[]{"Joining thread (service registry).", i});
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.archive) {
            File renameTo = new File(dir + ".archive");
            dir.renameTo(renameTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCheckpoint() throws Exception {
        String methodName = "loadCheckpoint";
        File f = new File(this.checkpointFile);
        if (!f.exists()) {
            this.logger.info(methodName, null, new Object[]{"No checkpoint file to convert."});
            return;
        }
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(this.checkpointFile);
            in = new ObjectInputStream(fis);
            Object xobj = in.readObject();
            Class<?> cl = xobj.getClass();
            Field p2jfield = cl.getDeclaredField("processToJobMap");
            p2jfield.setAccessible(true);
            ConcurrentHashMap p2jmap = (ConcurrentHashMap)p2jfield.get(xobj);
            Field wmField = cl.getDeclaredField("workMap");
            wmField.setAccessible(true);
            DuccWorkMap workMap = (DuccWorkMap)wmField.get(xobj);
            this.hmd.checkpoint(workMap, p2jmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (in != null) {
                in.close();
            }
        }
        if (this.archive) {
            File renameTo = new File(f + ".archive");
            f.renameTo(renameTo);
        }
    }

    void test() throws Exception {
        String methodName = "foo";
        DbHandle h = this.dbManager.open();
        SimpleStatement s = new SimpleStatement("SELECT * from " + HistoryManagerDb.JOB_HISTORY_TABLE + " limit 5000");
        this.logger.info(methodName, null, new Object[]{"Fetch size", s.getFetchSize()});
        s.setFetchSize(100);
        long now = System.currentTimeMillis();
        try {
            int counter = 0;
            int nbytes = 0;
            ResultSet rs = h.execute(s);
            for (Row r : rs) {
                ++counter;
                ByteBuffer b = r.getBytes("work");
                nbytes += b.array().length;
                this.logger.info(methodName, null, new Object[]{"found", r.getLong("ducc_id"), "of type", r.getString("type")});
            }
            this.logger.info(methodName, null, new Object[]{"Found", counter, "results. Total bytes", nbytes});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info(methodName, null, new Object[]{"Time to select:", System.currentTimeMillis() - now});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws Exception {
        String methodName = "run";
        long now = System.currentTimeMillis();
        boolean run_test = false;
        String[] dbUrls = DbHelper.getHostList();
        if (run_test) {
            try {
                this.dbManager = new DbManager(dbUrls, this.logger);
                this.dbManager.init();
                this.test();
                return;
            }
            finally {
                this.dbManager.shutdown();
            }
        }
        this.dbManager = new DbManager(dbUrls, this.logger);
        this.dbManager.init();
        try {
            this.hmd = new HistoryManagerDb();
            this.hmd.init(this.logger, this.dbManager);
            System.out.println("Temporarily dropping some indexes");
            ArrayList<SimpleStatement> drops = HistoryManagerDb.dropIndices();
            DbHandle h = this.dbManager.open();
            if (this.saveDetails) {
                for (SimpleStatement ss : drops) {
                    System.out.println(ss.getQueryString());
                    h.execute(ss);
                }
            }
            long nowt = System.currentTimeMillis();
            if (this.docheckpoint) {
                this.loadCheckpoint();
            }
            this.logger.info(methodName, null, new Object[]{"***** Time to load checkpoint A ****", System.currentTimeMillis() - nowt});
            nowt = System.currentTimeMillis();
            if (this.dojobs) {
                this.loadJobs();
            }
            this.logger.info(methodName, null, new Object[]{"**** Time to load jobs**** ", System.currentTimeMillis() - nowt, "Total bytes loaded:", this.jobBytes});
            nowt = System.currentTimeMillis();
            if (this.doreservations) {
                this.loadReservations();
            }
            this.logger.info(methodName, null, new Object[]{"**** Time to load reservations ****", System.currentTimeMillis() - nowt, "Total bytes loaded:", this.resBytes});
            nowt = System.currentTimeMillis();
            if (this.doservices) {
                this.loadServices();
            }
            this.logger.info(methodName, null, new Object[]{"**** Time to load services instances ****", System.currentTimeMillis() - nowt, "Total bytes loaded:", this.svcBytes});
            long totalSvcBytes = 0L;
            if (this.doregistry) {
                nowt = System.currentTimeMillis();
                this.ssd = new StateServicesDb();
                this.ssd.init(this.logger, this.dbManager);
                this.loadServiceRegistry(this.serviceRegistry, false);
                this.logger.info(methodName, null, new Object[]{"**** Time to load Service registry ****", System.currentTimeMillis() - nowt, "Total bytes loaded:", this.svcRegBytes});
                totalSvcBytes = this.svcRegBytes;
                this.svcRegBytes = 0L;
                nowt = System.currentTimeMillis();
                this.loadServiceRegistry(this.serviceRegistryHistory, true);
                this.logger.info(methodName, null, new Object[]{"**** Time to load Service history ****", System.currentTimeMillis() - nowt, "Total bytes loaded:", this.svcRegBytes});
                totalSvcBytes = this.svcRegBytes;
                this.logger.info(methodName, null, new Object[]{"**** Skipped services:", this.skippedServices});
            }
            nowt = System.currentTimeMillis();
            this.logger.info(methodName, null, new Object[]{"**** Total load time ****", System.currentTimeMillis() - now, "Total bytes loaded:", this.jobBytes + this.resBytes + this.svcBytes + totalSvcBytes});
            if (this.docheckpoint) {
                this.loadCheckpoint();
            }
            this.logger.info(methodName, null, new Object[]{"**** Time to reload checkpoint B ****", System.currentTimeMillis() - nowt});
            System.out.println("Restoring indexes");
            ArrayList<SimpleStatement> indices = HistoryManagerDb.createIndices();
            h = this.dbManager.open();
            if (this.saveDetails) {
                for (SimpleStatement ss : indices) {
                    System.out.println(ss.getQueryString());
                    h.execute(ss);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, null, (Throwable)e, new Object[0]);
        }
        finally {
            if (this.dbManager != null) {
                this.dbManager.shutdown();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: DbLoader from to <num-threads>");
            System.out.println("");
            System.out.println("Where:");
            System.out.println("   from      is the DUCC_HOME you wish to convert,");
            System.out.println("   to        is the datbase URL,");
            System.out.println("   nthreads  is the number of loader threads to run.");
            System.out.println(" ");
            System.exit(1);
        }
        int nthreads = 10;
        if (args.length > 2) {
            nthreads = Integer.valueOf(args[2]);
        }
        DbLoader dbl = null;
        try {
            dbl = new DbLoader(args[0], args[1], nthreads);
            dbl.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ServiceRegistrationLoader
    implements Runnable {
        BlockingQueue<Pair<String, Boolean>> queue;
        List<Long> ids;

        ServiceRegistrationLoader(BlockingQueue<Pair<String, Boolean>> queue, List<Long> ids) {
            this.queue = queue;
            this.ids = ids;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodName = "ServiceRegistrationLoader.run";
            while (true) {
                boolean isHistory;
                Pair<String, Boolean> p = null;
                String id = null;
                int nbytes = 0;
                try {
                    DbLoader.this.logger.trace(methodName, null, new Object[]{"About to take (service id)."});
                    p = this.queue.take();
                    id = (String)p.first();
                    isHistory = (Boolean)p.second();
                }
                catch (InterruptedException e) {
                    return;
                }
                DbLoader.this.logger.trace(methodName, null, new Object[]{id, "Took a service id"});
                FileInputStream svc_in = null;
                FileInputStream meta_in = null;
                try {
                    Properties svc_props = new Properties();
                    Properties meta_props = new Properties();
                    String svc_name = id + ".svc";
                    String meta_name = id + ".meta";
                    File svc_file = new File(svc_name);
                    File meta_file = new File(meta_name);
                    nbytes = (int)((long)nbytes + (svc_file.length() + meta_file.length()));
                    svc_in = new FileInputStream(svc_file);
                    meta_in = new FileInputStream(meta_file);
                    svc_props.load(svc_in);
                    meta_props.load(meta_in);
                    String sid = meta_props.getProperty(IStateServices.SvcMetaProps.numeric_id.pname());
                    if (sid == null) {
                        DbLoader.this.logger.error(methodName, null, new Object[]{"Cannot find service id in meta file for", id, "skipping load."});
                        DbLoader.this.skippedServices.getAndIncrement();
                    } else {
                        if (id.indexOf(sid) < 0) {
                            throw new IllegalStateException("Service id and internal id do not match.");
                        }
                        DuccId did = new DuccId(Long.parseLong(sid));
                        DbLoader.this.ssd.storeProperties(did, svc_props, meta_props);
                        if (isHistory) {
                            DbLoader.this.ssd.moveToHistory(did, svc_props, meta_props);
                        }
                        List<Long> list = this.ids;
                        synchronized (list) {
                            this.ids.add(did.getFriendly());
                            DbLoader.this.svcRegBytes += (long)nbytes;
                        }
                    }
                    DbLoader.this.closeStream(svc_in);
                    DbLoader.this.closeStream(meta_in);
                    DbLoader.this.counter.getAndDecrement();
                }
                catch (Exception e) {
                    DbLoader.this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                }
                finally {
                    DbLoader.this.closeStream(svc_in);
                    DbLoader.this.closeStream(meta_in);
                    DbLoader.this.counter.getAndDecrement();
                }
                continue;
                break;
            }
        }
    }

    class ReservationLoader
    implements Runnable {
        BlockingQueue<File> queue;
        List<Long> ids;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReservationLoader(BlockingQueue<File> queue, List<Long> ids) throws Exception {
            this.queue = queue;
            this.ids = ids;
            DbHandle h = DbLoader.this.dbManager.open();
            Class<ReservationLoader> clazz = ReservationLoader.class;
            synchronized (ReservationLoader.class) {
                if (reservationPrepare == null) {
                    reservationPrepare = h.prepare("INSERT INTO " + HistoryManagerDb.RES_HISTORY_TABLE + " (ducc_id, type, history, work) VALUES (?, ?, ?, ?);");
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String methodName = "ReservationLoader.run";
            while (true) {
                File f = null;
                long nbytes = 0L;
                long duccid = 0L;
                DuccId did = null;
                try {
                    f = this.queue.take();
                    Object fis = null;
                    InputStream in = null;
                    try {
                        long now = System.currentTimeMillis();
                        String s = f.getName();
                        int ndx = s.indexOf(".");
                        duccid = Long.parseLong(s.substring(0, ndx));
                        did = new DuccId(duccid);
                        nbytes = f.length();
                        if (nbytes > 0x1000000L) {
                            DbLoader.this.logger.warn(methodName, did, new Object[]{"Skipping outsized reservation", duccid, "length=", nbytes});
                            nbytes = 0L;
                            DbLoader.this.closeStream(in);
                            DbLoader.this.closeStream((InputStream)fis);
                            DbLoader.this.counter.getAndDecrement();
                            continue;
                        }
                        byte[] buf = new byte[(int)nbytes];
                        fis = new FileInputStream(f);
                        ((FileInputStream)fis).read(buf);
                        ByteBuffer bb = ByteBuffer.wrap(buf);
                        DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to read reservation", duccid, ":", System.currentTimeMillis() - now + " MS", "bytes:", nbytes});
                        DbLoader.this.logger.trace(methodName, did, new Object[]{"Reservation", duccid, "Store CQL:", reservationPrepare.getQueryString()});
                        long now1 = System.currentTimeMillis();
                        BoundStatement boundStatement = new BoundStatement(reservationPrepare);
                        BoundStatement bound = boundStatement.bind(new Object[]{duccid, "reservation", true, bb});
                        DbHandle h = DbLoader.this.dbManager.open();
                        try {
                            h.execute(bound);
                        }
                        catch (Exception e) {
                            DbLoader.this.logger.error(methodName, did, new Object[]{"Error:", e});
                        }
                        DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to store reservation", duccid, "- Database update:", System.currentTimeMillis() - now1 + " MS", "Total save time:", System.currentTimeMillis() - now + " MS"});
                        if (DbLoader.this.saveDetails) {
                            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                            ObjectInputStream ois = new ObjectInputStream(bais);
                            Object o = ois.readObject();
                            ois.close();
                            bais.close();
                            now = System.currentTimeMillis();
                            DbLoader.this.hmd.summarizeProcesses(h, (IDuccWork)o, "R");
                            DbLoader.this.hmd.summarizeReservation(h, (IDuccWork)o);
                            DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to store reservation summaries for job", duccid, ":", System.currentTimeMillis() - now});
                        }
                        DbLoader.this.closeStream(in);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        DbLoader.this.logger.error(methodName, did, (Throwable)e, new Object[0]);
                        continue;
                    }
                    DbLoader.this.closeStream((InputStream)fis);
                    DbLoader.this.counter.getAndDecrement();
                    continue;
                    finally {
                        DbLoader.this.closeStream(in);
                        DbLoader.this.closeStream((InputStream)fis);
                        DbLoader.this.counter.getAndDecrement();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    DbLoader.this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                    continue;
                }
                finally {
                    List<Long> list = this.ids;
                    synchronized (list) {
                        if (nbytes > 0L) {
                            this.ids.add(duccid);
                            DbLoader.this.resBytes += nbytes;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }

    class ServiceLoader
    implements Runnable {
        BlockingQueue<File> queue;
        List<Long> ids;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ServiceLoader(BlockingQueue<File> queue, List<Long> ids) throws Exception {
            this.queue = queue;
            this.ids = ids;
            DbHandle h = DbLoader.this.dbManager.open();
            Class<ServiceLoader> clazz = ServiceLoader.class;
            synchronized (ServiceLoader.class) {
                if (DbLoader.this.servicePrepare == null) {
                    DbLoader.this.servicePrepare = h.prepare("INSERT INTO " + HistoryManagerDb.SVC_HISTORY_TABLE + " (ducc_id, type, history, work) VALUES (?, ?, ?, ?);");
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String methodName = "ServiceLoader.run";
            while (true) {
                File f = null;
                long nbytes = 0L;
                long duccid = 0L;
                DuccId did = null;
                try {
                    InputStream in;
                    Object fis;
                    block40: {
                        block39: {
                            f = this.queue.take();
                            fis = null;
                            in = null;
                            try {
                                long now = System.currentTimeMillis();
                                String s = f.getName();
                                int ndx = s.indexOf(".");
                                duccid = Long.parseLong(s.substring(0, ndx));
                                did = new DuccId(duccid);
                                nbytes = f.length();
                                if (nbytes > 0x1000000L) {
                                    DbLoader.this.logger.warn(methodName, did, new Object[]{"Skipping outsized service", duccid, "length=", nbytes});
                                    nbytes = 0L;
                                    DbLoader.this.closeStream(in);
                                    DbLoader.this.closeStream((InputStream)fis);
                                    DbLoader.this.counter.getAndDecrement();
                                    continue;
                                }
                                byte[] buf = new byte[(int)nbytes];
                                fis = new FileInputStream(f);
                                ((FileInputStream)fis).read(buf);
                                ByteBuffer bb = ByteBuffer.wrap(buf);
                                DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to read service", duccid, ":", System.currentTimeMillis() - now + " MS", "bytes:", nbytes});
                                DbLoader.this.logger.trace(methodName, did, new Object[]{"Service", duccid, "Store CQL:", DbLoader.this.servicePrepare.getQueryString()});
                                long now1 = System.currentTimeMillis();
                                BoundStatement boundStatement = new BoundStatement(DbLoader.this.servicePrepare);
                                BoundStatement bound = boundStatement.bind(new Object[]{duccid, "service", true, bb});
                                DbHandle h = DbLoader.this.dbManager.open();
                                try {
                                    h.execute(bound);
                                }
                                catch (Exception e) {
                                    DbLoader.this.logger.error(methodName, did, new Object[]{"Error:", e});
                                }
                                DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to store service", duccid, "- Database update:", System.currentTimeMillis() - now1 + " MS", "Total save time:", System.currentTimeMillis() - now + " MS"});
                                ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                                ObjectInputStream ois = new ObjectInputStream(bais);
                                Object o = ois.readObject();
                                ois.close();
                                bais.close();
                                String type = null;
                                if (((IDuccWorkService)o).getServiceDeploymentType() == null) {
                                    DbLoader.this.logger.warn(methodName, did, new Object[]{"getServiceDeploymentType is null, not extracting details."});
                                    DbLoader.this.closeStream(in);
                                    break block39;
                                }
                                switch (((IDuccWorkService)o).getServiceDeploymentType()) {
                                    case uima: 
                                    case custom: {
                                        type = "S";
                                        break;
                                    }
                                    case other: {
                                        type = "A";
                                        break;
                                    }
                                    default: {
                                        type = "?";
                                    }
                                }
                                if (DbLoader.this.saveDetails) {
                                    now = System.currentTimeMillis();
                                    DbLoader.this.hmd.summarizeProcesses(h, (IDuccWork)o, type);
                                    long delta = System.currentTimeMillis() - now;
                                    DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to store AP/Service Instance summaries for job", duccid, ":", delta});
                                }
                                DbLoader.this.closeStream(in);
                                break block40;
                            }
                            catch (Exception e) {
                                DbLoader.this.logger.error(methodName, did, (Throwable)e, new Object[0]);
                                continue;
                            }
                        }
                        DbLoader.this.closeStream((InputStream)fis);
                        DbLoader.this.counter.getAndDecrement();
                        continue;
                    }
                    DbLoader.this.closeStream((InputStream)fis);
                    DbLoader.this.counter.getAndDecrement();
                    continue;
                    finally {
                        DbLoader.this.closeStream(in);
                        DbLoader.this.closeStream((InputStream)fis);
                        DbLoader.this.counter.getAndDecrement();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    DbLoader.this.logger.error(methodName, did, (Throwable)e, new Object[0]);
                    continue;
                }
                finally {
                    List<Long> list = this.ids;
                    synchronized (list) {
                        if (nbytes > 0L) {
                            this.ids.add(duccid);
                            DbLoader.this.svcBytes += nbytes;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }

    class JobLoader
    implements Runnable {
        BlockingQueue<File> queue;
        List<Long> ids;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JobLoader(BlockingQueue<File> queue, List<Long> ids) throws Exception {
            this.queue = queue;
            this.ids = ids;
            DbHandle h = DbLoader.this.dbManager.open();
            Class<JobLoader> clazz = JobLoader.class;
            synchronized (JobLoader.class) {
                if (jobPrepare == null) {
                    jobPrepare = h.prepare("INSERT INTO " + HistoryManagerDb.JOB_HISTORY_TABLE + " (ducc_id, type, history, work) VALUES (?, ?, ?, ?)");
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            String methodName = "JobLoader.run";
            while (true) {
                File f = null;
                long nbytes = 0L;
                long duccid = 0L;
                DuccId did = null;
                try {
                    f = this.queue.take();
                    Object fis = null;
                    try {
                        long now = System.currentTimeMillis();
                        String s = f.getName();
                        int ndx = s.indexOf(".");
                        duccid = Long.parseLong(s.substring(0, ndx));
                        did = new DuccId(duccid);
                        nbytes = f.length();
                        if (nbytes > 0x1000000L) {
                            DbLoader.this.logger.warn(methodName, did, new Object[]{"Skipping outsized job", duccid, "length=", nbytes});
                            nbytes = 0L;
                            DbLoader.this.closeStream((InputStream)fis);
                            DbLoader.this.counter.getAndDecrement();
                            continue;
                        }
                        byte[] buf = new byte[(int)nbytes];
                        fis = new FileInputStream(f);
                        ((FileInputStream)fis).read(buf);
                        ByteBuffer bb = ByteBuffer.wrap(buf);
                        DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to read job:", System.currentTimeMillis() - now + " MS", "bytes:", nbytes});
                        DbLoader.this.logger.trace(methodName, did, new Object[]{"Job", duccid, "Store CQL:", jobPrepare.getQueryString()});
                        long now1 = System.currentTimeMillis();
                        BoundStatement boundStatement = new BoundStatement(jobPrepare);
                        BoundStatement bound = boundStatement.bind(new Object[]{duccid, "job", true, bb});
                        DbHandle h = DbLoader.this.dbManager.open();
                        try {
                            h.execute(bound);
                        }
                        catch (Exception e) {
                            DbLoader.this.logger.error(methodName, did, new Object[]{"Error:", e});
                        }
                        DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to store job", duccid, "- Database update:", System.currentTimeMillis() - now1 + " MS", "Total save time:", System.currentTimeMillis() - now + " MS"});
                        if (DbLoader.this.saveDetails) {
                            List<Long> list = this.ids;
                            synchronized (list) {
                                ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                                ObjectInputStream ois = new ObjectInputStream(bais);
                                Object o = ois.readObject();
                                ois.close();
                                bais.close();
                                now = System.currentTimeMillis();
                                DbLoader.this.hmd.summarizeProcesses(h, (IDuccWork)o, "J");
                                DbLoader.this.hmd.summarizeJob(h, (IDuccWork)o, "J");
                                DbLoader.this.logger.trace(methodName, did, new Object[]{"Time to store process summaries for job", duccid, ":", System.currentTimeMillis() - now});
                            }
                        }
                        DbLoader.this.closeStream((InputStream)fis);
                    }
                    catch (Exception e) {
                        DbLoader.this.logger.error(methodName, did, (Throwable)e, new Object[0]);
                        continue;
                    }
                    DbLoader.this.counter.getAndDecrement();
                    continue;
                    finally {
                        DbLoader.this.closeStream((InputStream)fis);
                        DbLoader.this.counter.getAndDecrement();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    DbLoader.this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                    continue;
                }
                finally {
                    List<Long> list = this.ids;
                    synchronized (list) {
                        if (nbytes > 0L) {
                            this.ids.add(duccid);
                            DbLoader.this.jobBytes += nbytes;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }
}

