/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.persistence.IDbProperty;
import org.apache.uima.ducc.common.persistence.or.IDbDuccWorks;
import org.apache.uima.ducc.common.persistence.or.ITypedProperties;
import org.apache.uima.ducc.common.persistence.or.TypedProperties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;

public class DbDuccWorks
implements IDbDuccWorks {
    private static String DUCC_WORKS_TABLE = IDbDuccWorks.DbDuccWorks.TABLE_NAME.pname();
    private static String COL_TYPE = IDbDuccWorks.DbDuccWorks.type.columnName();
    private static String COL_DUCC_ID = IDbDuccWorks.DbDuccWorks.ducc_id.columnName();
    private static String COL_SPECIFICATION = IDbDuccWorks.DbDuccWorks.specification.columnName();
    private DuccLogger logger = null;
    private DbManager dbManager = null;
    private Gson gson = new Gson();
    private DuccId jobid = null;
    private String messageDbDisabled = "db disabled";
    private String dbHost = DuccPropertiesResolver.get((String)"ducc.database.host", (String)"?");

    public DbDuccWorks(DuccLogger duccLogger) throws Exception {
        this.init(duccLogger);
    }

    private boolean isDbDisabled() {
        boolean retVal = false;
        if (this.dbHost.equals("--disabled--")) {
            retVal = true;
        }
        return retVal;
    }

    private boolean init(String dburl) throws Exception {
        String methodName = "init";
        boolean ret = false;
        while (true) {
            try {
                this.dbManager = new DbManager(dburl, this.logger);
                this.dbManager.init();
                ret = true;
            }
            catch (NoHostAvailableException e) {
                this.logger.error(methodName, null, new Object[]{"Cannot contact database.  Retrying in 5 seconds."});
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error(methodName, null, new Object[]{"Errors contacting database.  No connetion made."});
                this.logger.error(methodName, null, (Throwable)e, new Object[0]);
                ret = false;
            }
            break;
        }
        return ret;
    }

    protected static List<SimpleStatement> mkSchema() throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + DUCC_WORKS_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IDbDuccWorks.DbDuccWorks.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        List<String> indexes = DbUtil.mkIndices((IDbProperty[])IDbDuccWorks.DbDuccWorks.values(), DUCC_WORKS_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    public void dbInit() throws Exception {
        String location = "dbInit";
        if (this.isDbDisabled()) {
            this.logger.debug(location, this.jobid, new Object[]{this.messageDbDisabled});
            return;
        }
        try {
            List<SimpleStatement> specificationsSchema = DbDuccWorks.mkSchema();
            DbHandle h = this.dbManager.open();
            for (SimpleStatement s : specificationsSchema) {
                this.logger.info(location, this.jobid, new Object[]{"EXECUTE STATEMENT:" + s.toString()});
                h.execute(s);
            }
        }
        catch (Exception e) {
            this.logger.error(location, this.jobid, (Throwable)e, new Object[0]);
            throw e;
        }
    }

    public void init(DuccLogger duccLogger) throws Exception {
        String location = "init";
        this.logger = duccLogger;
        if (this.isDbDisabled()) {
            this.logger.debug(location, this.jobid, new Object[]{this.messageDbDisabled});
            return;
        }
        String dbUrl = System.getProperty("ducc.database.host");
        this.init(dbUrl);
    }

    public void upsertSpecification(String type, long id, ITypedProperties properties) throws Exception {
        String location = "upsertSpecification";
        String gsonString = null;
        if (this.isDbDisabled()) {
            this.logger.debug(location, this.jobid, new Object[]{this.messageDbDisabled});
            return;
        }
        try {
            gsonString = this.gson.toJson((Object)properties);
            String table = DUCC_WORKS_TABLE;
            String c0 = COL_SPECIFICATION + "='" + gsonString + "'";
            String c1 = COL_TYPE + "='" + type + "'";
            String c2 = COL_DUCC_ID + "=" + id;
            String cql = "UPDATE " + table + " SET " + c0 + " WHERE " + c1 + " AND " + c2;
            this.logger.debug(location, this.jobid, new Object[]{cql});
            DbHandle h = this.dbManager.open();
            h.execute(cql);
        }
        catch (Exception e) {
            DuccId duccid = new DuccId(id);
            String text = "type=" + type + " gson=" + gsonString;
            this.logger.error(location, duccid, new Object[]{text, e});
            throw e;
        }
    }

    public ITypedProperties fetchSpecification(String type, long id) throws Exception {
        String location = "fetchSpecification";
        ITypedProperties properties = null;
        if (this.isDbDisabled()) {
            this.logger.debug(location, this.jobid, new Object[]{this.messageDbDisabled});
            return properties;
        }
        try {
            String table = DUCC_WORKS_TABLE;
            String c1 = COL_TYPE + "='" + type + "'";
            String c2 = COL_DUCC_ID + "=" + id;
            String cql = "SELECT * FROM " + table + " WHERE " + c1 + " AND " + c2;
            this.logger.debug(location, this.jobid, new Object[]{cql});
            DbHandle h = this.dbManager.open();
            ResultSet rs = h.execute(cql);
            for (Row r : rs) {
                String gsonString = r.getString(COL_SPECIFICATION);
                this.logger.debug(location, this.jobid, new Object[]{gsonString});
                properties = (ITypedProperties)this.gson.fromJson(gsonString, TypedProperties.class);
            }
        }
        catch (Exception e) {
            DuccId duccid = new DuccId(id);
            String text = "type=" + type;
            this.logger.error(location, duccid, new Object[]{text, e});
            throw e;
        }
        return properties;
    }
}

