/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbLoader;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.StateServicesDb;

public class DbVerify {
    DuccLogger logger = DuccLogger.getLogger(DbLoader.class, (String)"DBVERIFY");
    String DUCC_HOME = System.getProperty("DUCC_HOME");
    DbManager dbManager = null;
    long total_bytes = 0L;
    boolean verify_res = false;
    boolean verify_svc = false;
    boolean verify_job = false;

    public DbVerify() throws Exception {
        if (this.DUCC_HOME == null) {
            System.out.println("System proprety -DDUCC_HOME must be set.");
            System.exit(1);
        }
    }

    void verify(String table) throws Exception {
        String methodName = "verify";
        DbHandle h = this.dbManager.open();
        SimpleStatement s = new SimpleStatement("SELECT * from " + table);
        this.logger.info(methodName, null, new Object[]{"Fetch size", s.getFetchSize()});
        s.setFetchSize(100);
        long now = System.currentTimeMillis();
        int counter = 0;
        int nbytes = 0;
        try {
            ResultSet rs = h.execute(s);
            for (Row r : rs) {
                ++counter;
                ByteBuffer b = r.getBytes("work");
                byte[] bytes = b.array();
                nbytes += bytes.length;
                this.total_bytes += (long)bytes.length;
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object o = ois.readObject();
                ois.close();
                DuccId did = new DuccId(r.getLong("ducc_dbid"));
                this.logger.info(methodName, did, new Object[]{"found object class", o.getClass().getName(), "of type", r.getString("type"), "in table", table, "of size", bytes.length});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info(methodName, null, new Object[]{"Found", counter, "results. Total bytes", nbytes});
        this.logger.info(methodName, null, new Object[]{"Total time for", table, System.currentTimeMillis() - now});
    }

    void verifyServices() throws Exception {
        DuccId did;
        String methodName = "verify";
        int live = 0;
        int archived = 0;
        StateServicesDb sdb = new StateServicesDb();
        sdb.init(this.logger, this.dbManager);
        StateServicesDirectory ssd = sdb.fetchServices(true);
        Map svcmap = ssd.getMap();
        for (Long id : svcmap.keySet()) {
            did = new DuccId(id.longValue());
            ++archived;
            this.logger.info(methodName, did, new Object[]{"Found an archived service."});
        }
        ssd = sdb.fetchServices(false);
        svcmap = ssd.getMap();
        for (Long id : svcmap.keySet()) {
            did = new DuccId(id.longValue());
            this.logger.info(methodName, did, new Object[]{"Found a live service."});
            ++live;
        }
        this.logger.info(methodName, null, new Object[]{"Found", live, "live services and", archived, "archived services."});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws Exception {
        String methodName = "run";
        long now = System.currentTimeMillis();
        String state_url = "bluej538";
        try {
            this.dbManager = new DbManager(state_url, this.logger);
            this.dbManager.init();
            this.verifyServices();
            if (this.verify_res) {
                this.verify("ducc.res_history");
            }
            if (this.verify_svc) {
                this.verify("ducc.svc_history");
            }
            if (this.verify_job) {
                this.verify("ducc.job_history");
            }
        }
        finally {
            this.dbManager.shutdown();
        }
        this.logger.info(methodName, null, new Object[]{"Read", this.total_bytes, "bytes in", System.currentTimeMillis() - now, "MS"});
    }

    public static void main(String[] args) {
        DbVerify v = null;
        try {
            v = new DbVerify();
            v.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

