/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.container.sd.task;

import org.apache.uima.ducc.container.net.iface.IMetaCasRequester;
import org.apache.uima.ducc.container.sd.task.iface.TaskConsumer;

public class WiTaskConsumer
implements TaskConsumer {
    private static final long serialVersionUID = 1L;
    private String serviceType;
    private String host;
    private String pid;
    private String threadId;

    public WiTaskConsumer(IMetaCasRequester metaCasRequester) {
        this.serviceType = metaCasRequester.getRequesterProcessName();
        this.host = metaCasRequester.getRequesterNodeName();
        this.pid = String.valueOf(metaCasRequester.getRequesterProcessId());
        this.threadId = String.valueOf(metaCasRequester.getRequesterThreadId());
    }

    @Override
    public String getType() {
        return this.serviceType;
    }

    @Override
    public String getHostName() {
        return this.host;
    }

    @Override
    public String getPid() {
        return this.pid;
    }

    @Override
    public String getThreadId() {
        return this.threadId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.host != null) {
            sb.append(this.host);
            sb.append(".");
        }
        sb.append(this.pid);
        sb.append(".");
        sb.append(this.threadId);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String thisNodeName = this.host;
        Integer thisPid = new Integer(this.pid);
        Integer thisTid = new Integer(this.threadId);
        result = 31 * result + (thisNodeName == null ? 0 : thisNodeName.hashCode());
        result = 31 * result + (thisPid == null ? 0 : thisPid.hashCode());
        result = 31 * result + (thisTid == null ? 0 : thisTid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean retVal = false;
        try {
            if (obj != null) {
                if (this == obj) {
                    retVal = true;
                } else {
                    WiTaskConsumer that = (WiTaskConsumer)obj;
                    if (this.compareTo(that) == 0) {
                        retVal = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public int compareTo(Object o) {
        int retVal = 0;
        try {
            if (o != null) {
                WiTaskConsumer that = (WiTaskConsumer)o;
                if (retVal == 0) {
                    retVal = this.compareHost(that);
                }
                if (retVal == 0) {
                    retVal = this.comparePid(that);
                }
                if (retVal == 0) {
                    retVal = this.compareThreadId(that);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private int compareHost(WiTaskConsumer that) {
        int retVal = 0;
        String thisNodeName = this.getHostName();
        String thatNodeName = that.getHostName();
        if (thisNodeName != null && thatNodeName != null) {
            retVal = thisNodeName.compareTo(thatNodeName);
        }
        return retVal;
    }

    private int comparePid(WiTaskConsumer that) {
        int retVal = 0;
        Integer thisPid = new Integer(this.pid);
        Integer thatPid = new Integer(that.pid);
        retVal = thisPid.compareTo(thatPid);
        return retVal;
    }

    private int compareThreadId(WiTaskConsumer that) {
        int retVal = 0;
        Integer thisTid = new Integer(this.threadId);
        Integer thatTid = new Integer(that.threadId);
        retVal = thisTid.compareTo(thatTid);
        return retVal;
    }
}

